theory question_93_2
imports Main

begin
typedecl entity
typedecl event

consts
  Two :: "entity ⇒ bool"
  Lambs :: "entity ⇒ bool"
  Animals :: "entity ⇒ bool"
  Old :: "entity ⇒ bool"
  Woman :: "entity ⇒ bool"
  Broom :: "entity ⇒ bool"
  ChasingAway :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Instrument :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Two lambs are animals. *)
axiomatization where
  explanation_1: "∀x. Two x ∧ Lambs x ⟹ Animals x"

theorem hypothesis:
  (* Premise: Old woman chasing away two lambs with a broom. *)
  assumes asm: "Old x ∧ Woman x ∧ Lambs y ∧ Two y ∧ Broom z ∧ ChasingAway e ∧ Agent e x ∧ Patient e y ∧ Instrument e z"
  (* Hypothesis: There is a woman and some animals. *)
  shows "∃x y. Woman x ∧ Animals y"
proof -
  from asm have "Old x ∧ Woman x" by blast
  from asm have "Two y ∧ Lambs y" by blast
  from this have "Animals y" using explanation_1 by blast
  show ?thesis using `Woman x` `Animals y` by blast
qed

end
