theory question_19_7

imports Main

begin
typedecl entity
typedecl event

consts
  Person :: "entity ⇒ bool"
  Entity :: "entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"
  Look :: "entity ⇒ bool"
  Purple :: "entity ⇒ bool"
  Woman :: "entity ⇒ bool"
  OddLook :: "entity ⇒ bool"
  PurpleSweater :: "entity ⇒ bool"

(* Explanation 1: The look of a person wearing an entity is the look of the entity. *)
axiomatization where
  explanation_1: "∀x y. Person x ∧ Entity y ∧ Wearing x y ⟹ Look x ⟷ Look y"

(* Explanation 2: If an entity is purple and is worn by a person, then the person is wearing the entity. *)
axiomatization where
  explanation_2: "∀x y. Entity y ∧ Purple y ∧ Person x ∧ Wearing x y ⟹ Wearing x y"

theorem hypothesis:
  (* Hypothesis: A woman in a purple sweater has an odd look on her face. *)
  assumes asm:
  shows "∃x y. Woman x ∧ PurpleSweater y ∧ Wearing x y ∧ OddLook x"
proof -
  from asm have "Woman x ∧ PurpleSweater y ∧ Wearing x y ∧ OddLook x" by blast
  then show ?thesis using asm `Woman x` `PurpleSweater y` `Wearing x y` `OddLook x` by blast
qed

end
