theory question_30_6

imports Main

begin

typedecl entity
typedecl event
consts
  Human :: "entity ⇒ bool"
  Skateboard :: "entity ⇒ bool"
  DoingTricks :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A human is doing tricks on a skateboard. *)
axiomatization where
  explanation_1: "∃x y e. Human x ∧ Skateboard y ∧ DoingTricks e ∧ Agent e x ∧ On e y"

theorem hypothesis:
  (* Premise: A man is doing tricks on a skateboard. *)
  assumes asm: "Man x ∧ Skateboard y ∧ DoingTricks e ∧ Agent e x ∧ On e y"
  (* Hypothesis: A human is doing tricks. *)
  shows "∃x e. Human x ∧ DoingTricks e ∧ Agent e x"
proof -
  from asm have "Man x" by blast
  from this have "Human x" using explanation_1 by blast
  from asm have "DoingTricks e" by blast
  show ?thesis using `Human x` `DoingTricks e` by blast
qed

end
