theory question_71_0
imports Main

begin

typedecl entity
typedecl event

consts
  Chloroplasts_const :: "entity"
  Chlorophyll_const :: "entity"
  Chloroplasts :: "entity ⇒ bool"
  Contain :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Chlorophyll :: "entity ⇒ bool"
  Animals :: "entity ⇒ bool"
  Lack :: "event ⇒ bool"

(* Explanation 1: Chloroplasts contain the green pigment chlorophyll. *)
axiomatization where
  explanation_1: "∀x e. Chloroplasts x ∧ Contain e ∧ Agent e x ∧ Patient e Chlorophyll_const"

(* Explanation 2: Animals lack chloroplasts. *)
axiomatization where
  explanation_2: "∀x e. Animals x ∧ Lack e ∧ Agent e x ∧ Patient e Chloroplasts_const"  

theorem hypothesis:
  assumes asm: "Animals x"
  (* Hypothesis: Animals lack chlorophyll. *)
  shows "∃x e. Animals x ∧ Lack e ∧ Agent e x ∧ Patient e Chlorophyll_const"
proof -
  from asm have "Animals x" by simp
  then obtain e1 where e1: "Lack e1 ∧ Agent e1 x ∧ Patient e1 Chloroplasts_const" using explanation_2 by blast
  then have "Patient e1 Chlorophyll_const" using explanation_1 by blast
  have conclusion: "Lack e1 ∧ Agent e1 x ∧ Patient e1 Chlorophyll_const" using e1 by simp
  show ?thesis using asm conclusion by blast
qed

end
