theory question_66_8
imports Main
begin

typedecl entity
typedecl event

consts
  Sun :: "entity ⇒ bool"
  Star :: "entity ⇒ bool"
  Stars :: "entity ⇒ bool"
  Hottest :: "entity ⇒ bool"
  Hotter :: "entity ⇒ entity ⇒ bool"
  Earth :: "entity"
  Mars :: "entity"
  Moon :: "entity"

(* Explanation 1: The Sun is a kind of star. *)
axiomatization where
  explanation_1: "∀x. Sun x ⟶ Star x"

(* Explanation 2: The Sun is the hottest among stars. *)
axiomatization where
  explanation_2: "∀x. Sun x ∧ Stars x ⟶ Hottest x"

(* Explanation 3: The Sun being the hottest among stars implies it is hotter than the Earth, Mars, and the Moon. *)
axiomatization where
  explanation_3: "∀x. Sun x ∧ Stars x ∧ Hottest x ⟶ (Hotter x Earth ∧ Hotter x Mars ∧ Hotter x Moon)"

theorem hypothesis:
  assumes asm: "Sun x ∧ Stars x ∧ Earth x ∧ Mars x ∧ Moon x"
  (* Hypothesis: The Sun is the hottest among the Earth, Mars, and the Moon. *)
  shows "Hottest x"
proof -
  from asm have "Sun x" and "Stars x" by auto
  then have "Hottest x" using explanation_2 by blast
  then have "Hotter x Earth" and "Hotter x Mars" and "Hotter x Moon" using explanation_3 by blast
  then show ?thesis using asm by blast
qed

end
