theory question_65_4
imports Main

begin

typedecl entity
typedecl event

consts
  Closed :: "event ⇒ bool"
  Switch :: "entity ⇒ bool"
  SimpleSeriesCircuit :: "entity ⇒ bool"
  Flows :: "entity ⇒ bool"
  Through :: "entity ⇒ entity ⇒ bool"
  Can :: "event ⇒ bool"
  Reach :: "event ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  Interacts :: "event ⇒ bool"
  Filament :: "entity ⇒ bool"
  Interaction :: "event ⇒ bool"
  Electricity :: "entity ⇒ bool"
  Causes :: "event ⇒ bool"
  Emit :: "event ⇒ bool"
  Light :: "entity ⇒ bool"
  Emission :: "event ⇒ bool"
  Perceived :: "event ⇒ bool"
  ComingOn :: "event ⇒ bool"
  ResultsIn :: "event ⇒ bool"

(* Explanation 1: When a switch in a simple series circuit is closed, electricity flows through the circuit. *)
axiomatization where
  explanation_1: "∀e1 e2. Closed e1 ∧ Switch e2 ∧ SimpleSeriesCircuit e2 ∧ Flows e2 ⟶ (∃e1. ∃e2. Event e1 ∧ Event e2)"

(* Explanation 2: When electricity flows through a circuit, it can reach the light bulb. *)
axiomatization where
  explanation_2: "∀e1 e2. Flows e1 ∧ Through e1 Circuit ∧ Can e2 ∧ Reach e2 ∧ LightBulb e2 ⟶ (∃e1. ∃e2. Event e1 ∧ Event e2)"

(* Explanation 3: When electricity reaches the light bulb, it interacts with the filament. *)
axiomatization where
  explanation_3: "∀e1 e2. Reach e1 ∧ LightBulb e1 ∧ Interacts e2 ∧ Filament e2 ⟶ (∃e1. ∃e2. Event e1 ∧ Event e2)"

(* Explanation 4: The interaction between electricity and the filament causes the light bulb to emit light. *)
axiomatization where
  explanation_4: "∀e1 e2 e3. Interaction e1 ∧ Electricity e1 ∧ Filament e2 ∧ Causes e2 ∧ LightBulb e2 ∧ Emit e3 ∧ Light e3 ⟶ (∃e1. ∃e2. ∃e3. Event e1 ∧ Event e2 ∧ Event e3)"

(* Explanation 5: The emission of light from the light bulb is perceived as the light coming on. *)
axiomatization where
  explanation_5: "∀e1 e2 e3. Emission e1 ∧ Light e1 ∧ LightBulb e1 ∧ Perceived e2 ∧ ComingOn e3 ⟶ (∃e1. ∃e2. ∃e3. Event e1 ∧ Event e2 ∧ Event e3)"

(* Explanation 6: The emission of light from the light bulb results in the light coming on. *)
axiomatization where
  explanation_6: "∀e1 e2. Emission e1 ∧ Light e1 ∧ LightBulb e1 ∧ ResultsIn e2 ∧ ComingOn e2 ⟶ (∃e1. ∃e2. Event e1 ∧ Event e2)"

theorem hypothesis:
  (* Premise: when the switch in a simple series circuit is closed *)
  assumes asm: "Closed e ∧ Switch e ∧ SimpleSeriesCircuit e"
  (* Hypothesis: When electricity is flowing to the light bulb, the light comes on. *)
  shows "∃e1 e2. Flows e1 ∧ Through e1 LightBulb ∧ ComingOn e2 ∧  Event e1 ∧ Event e2 "
proof -
  from asm have "Flows e ∧ Through e LightBulb" using explanation_1 explanation_2 explanation_3 explanation_4 by blast
  then obtain e1 e2 where "ComingOn e2" using explanation_5 explanation_6 by blast
  then show ?thesis using `Flows e` `Through e LightBulb` `ComingOn e2` by blast
qed

end
