theory question_60_0
imports Main

begin
typedecl entity
typedecl event
consts
  Boy :: "entity ⇒ bool"
  KarateForm :: "entity ⇒ bool"
  Uniform :: "entity ⇒ bool"
  Poses :: "event ⇒ bool"
  In :: "entity ⇒ event ⇒ entity ⇒ bool"
  Shows :: "event ⇒ bool"

(* Explanation 1: A boy poses in karate form and uniform means the boy shows "his uniform. *)
axiomatization where
  explanation_1: "∀x y z e. Boy x ∧ KarateForm y ∧ Uniform z ∧ Poses e ∧ In x e y ∧ In x e z ⟶ Shows e"

theorem hypothesis:
  (* Premise: A boy poses in karate form and uniform. *)
  assumes asm: "Boy x ∧ KarateForm y ∧ Uniform z ∧ Poses e ∧ In x e y ∧ In x e z"
  (* Hypothesis: a boy shows "his uniform" *)
  shows "∃x y e. Boy x ∧ Uniform y ∧ Shows e ∧ Possessor e x y"
proof -
  from asm have "Boy x ∧ KarateForm y ∧ Uniform z ∧ Poses e ∧ In x e y ∧ In x e z" by blast
  then have "Shows e" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
