theory question_72_6
imports Main

begin

typedecl entity
typedecl event

consts
  Friction :: "entity ⇒ bool"
  Object :: "entity ⇒ bool"
  Touching :: "entity ⇒ entity ⇒ bool"
  Acts :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Moving :: "event ⇒ bool"
  Thing :: "entity ⇒ bool"
  Surface :: "entity ⇒ bool"
  Over :: "entity ⇒ entity ⇒ bool"
  Riding :: "entity ⇒ bool"
  Wagon :: "entity ⇒ bool"
  Vehicle :: "entity ⇒ bool"
  Stop :: "entity ⇒ bool"
  Causing :: "event ⇒ bool"
  MovedAgainst :: "entity ⇒ entity ⇒ event ⇒ bool"
  MovedOver :: "entity ⇒ entity ⇒ event ⇒ bool"
  MovedDown :: "entity ⇒ entity ⇒ event ⇒ bool"

(* Explanation 1: Friction acts to counter the motion of two objects when the surfaces of those objects are touching. *)
axiomatization where
  explanation_1: "∀x y e. Friction x ∧ Object y ∧ Touching y x ⟶ (∃e. Acts e ∧ Agent e x)"

(* Explanation 2: A wagon is a kind of vehicle, which is a type of object. *)
axiomatization where
  explanation_2: "∀x. Wagon x ⟶ Vehicle x"

(* Explanation 3: Riding something is to move that thing over a surface. *)
axiomatization where
  explanation_3: "∀x y z e. Riding x ∧ Thing y ∧ Surface z ⟶ (∃e. Moving e ∧ Agent e x ∧ Patient e y ∧ Over y z)"

(* Explanation 4: If one surface is moved against, moved over, or moved down another surface, then those surfaces are touching. *)
axiomatization where
  explanation_4: "∀x y e. (MovedAgainst x y e ∨ MovedOver x y e ∨ MovedDown x y e) ⟶ Touching x y"

theorem hypothesis:
  (* Premise: None *)
  assumes asm:
    Friction x
    ∧ Wagon y
    ∧ Stop z
    ∧ Acts e1
    ∧ Agent e1 x
    ∧ Patient e1 y
    ∧ Causing e2
    ∧ Agent e2 e1
    ∧ Patient e2 z
    ∧ Moving e1
    ∧ Over y z
    ∧ Riding x
  shows "∃e1 e2. Acts e1 ∧ Causing e2 ∧ Agent e2 e1 ∧ Patient e2 z ∧ Moving e1"
proof -
  from asm have "Friction x" by simp
  then have "∃e. Acts e ∧ Agent e x" using explanation_1 by blast
  then obtain e1 where e1: "Acts e1 ∧ Agent e1 x" by auto
  have "Moving e1" using asm by simp
  have "Patient e1 y" using asm by simp
  have "Over y z" using asm by simp
  have "Surface z" using asm by simp
  have "Thing y" using asm by simp
  have "Riding x" using asm by simp
  have "Vehicle y" using explanation_2 asm by blast
  have "Object y" using explanation_2 by simp
  have "Touching y z" using asm by simp
  have "MovedAgainst y z e1 ∨ MovedOver y z e1 ∨ MovedDown y z e1" using asm by simp
  then have "Touching y z" using explanation_4 by blast
  have "Acts e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Over y z" using e1 by simp
  have "Causing e2 ∧ Agent e2 e1 ∧ Patient e2 z ∧ Moving e1" using asm by simp
  show ?thesis using asm e1 by blast
qed

end
