theory question_76_0

imports Main

begin

typedecl entity
typedecl event

consts
  Organism :: "entity ⇒ bool"
  BecomesTooHot :: "entity ⇒ event ⇒ bool"
  Decomposers :: "entity ⇒ bool"
  CompletesCycle :: "entity ⇒ event ⇒ bool"

theorem hypothesis:
  assumes asm: "Organism x ∧ BecomesTooHot  x  e1 "
  (* Hypothesis: If an organism becomes too hot, then decomposers complete their cycle. *)
  shows "∃y. Decomposers y ∧ CompletesCycle  y  e2 "
proof -
  from asm have "Organism x ∧ BecomesTooHot x e1" by simp
  then obtain e2 where "CompletesCycle (`decomposer x`) e2"
    using explanation_2 by blast
  then have "Decomposers (`decomposer x`)" by simp
  show ?thesis using asm `decomposer x` by blast
qed

end
