theory question_73_0
imports Main

begin

typedecl entity
typedecl event

consts
  GroupOfPeople :: "entity ⇒ bool"
  People :: "entity ⇒ bool"
  Beach :: "entity"
  On :: "entity ⇒ entity ⇒ bool"
  Camera :: "entity ⇒ bool"
  With :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Group of people are people. *)
axiomatization where
  explanation_1: "∀x. GroupOfPeople x ⟶ People x"

theorem hypothesis:
  (* Premise: A group of people on the beach with cameras. *)
  assumes asm: "GroupOfPeople x ∧ On x Beach ∧ Camera z ∧ With x z"
  (* Hypothesis: People are on a beach. *)
  shows "∃x. People x ∧ On x Beach"
proof -
  from asm have "GroupOfPeople x" by blast
  then have "People x" using explanation_1 by blast
  from asm have "On x Beach" by blast
  then show ?thesis using `People x` `On x Beach` by blast
qed

end
