theory question_14_5
imports Main

begin

typedecl entity
typedecl event

consts
  Male :: "entity ⇒ bool"
  Man :: "entity ⇒ bool"
  Event :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Action :: "event ⇒ entity ⇒ entity ⇒ bool"  (* updated type for Action constant *)
  standing :: "entity ⇒ entity"

(* Explanation 1: A male is a man *)
axiomatization where
  explanation_1: "∀x. Male x ⟶ Man x"

theorem hypothesis:
  (* Hypothesis: A man is standing. *)
  shows "∃x e. Man x ∧ Event e ∧ Agent e x ∧ Action e  standing x"
proof -
  from asm have "Male x" by auto
  then have "Man x" using explanation_1 by auto
  from asm have "Event e" by auto
  from asm have "Agent e x" by auto
  from asm have "Action e standing x" by auto
  then show ?thesis using `Man x` `Event e` by blast
qed

end
