theory question_65_6

imports Main

begin

typedecl entity
typedecl event

consts
  SimpleSeriesCircuit :: "entity ⇒ bool"
  Switch :: "entity ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  Closed :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Connected :: "entity ⇒ entity ⇒ bool"
  Electricity :: "entity ⇒ bool"
  Flowing :: "event ⇒ bool"
  TurnsOn :: "event ⇒ bool"
  ComesOn :: "event ⇒ bool"

(* Explanation 1: In a simple series circuit, when the switch is closed, electricity flows to the connected light bulb. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. SimpleSeriesCircuit x ∧ Switch y ∧ LightBulb z ∧ Closed e1 ∧ Agent e1 y ∧ Connected x y ∧ Connected x z ∧ Flowing e2 ∧ Agent e2 x ∧ Patient e2 z"

(* Explanation 2: When electricity flows to a light bulb, the light bulb turns on and the light comes on. *)
axiomatization where
  explanation_2: "∀x y e1 e2 e3. Electricity x ∧ LightBulb y ∧ Flowing e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ (TurnsOn e2 ∧ Agent e2 y) ∧ ComesOn e3 ∧ Agent e3 y"

theorem hypothesis:
  (* Premise: when the switch in a simple series circuit is closed *)
  assumes asm: "SimpleSeriesCircuit x ∧ Switch y ∧ Closed e ∧ Agent e y ∧ In y  x "
  (* Hypothesis: When electricity is flowing to the light bulb, the light comes on. *)
  shows "∃x y e1 e2. Electricity x ∧ LightBulb y ∧ Flowing e1 ∧ Agent e1 x ∧ Patient e1 y ∧ ComesOn e2 ∧ Agent e2 y"
proof -
  {
    assume "SimpleSeriesCircuit x" "Switch y" "Closed e" "Agent e y" "Connected y x" "LightBulb z" "Connected x z"
    from explanation_1[OF this]
    have "Flowing e' ∧ Agent e' x ∧ Patient e' z" by blast
    then obtain e1 where "e1 = e'" by blast
    from explanation_2[OF this(1), OF this(3), OF this(6), OF this(7), OF this(8), OF this(9), OF this(10), OF this(11)]
    have "TurnsOn e2 ∧ Agent e2 z" "ComesOn e3 ∧ Agent e3 z" by blast
    then obtain e4 where "e4 = e2" by blast
    obtain e5 where "e5 = e3" by blast
    from this(1) this(3) this(6) this(7) this(8) this(9) this(10) this(11) this(12) this(13) this(14)
    have "Electricity x ∧ LightBulb z ∧ Flowing e1 ∧ Agent e1 x ∧ Patient e1 z ∧ ComesOn e5 ∧ Agent e5 z" by blast
  }
  then show ?thesis using asm by blast
qed

end
