theory question_85_8
imports Main

begin

typedecl entity
typedecl event

consts
  PacinianCorpuscles :: "entity ⇒ bool"
  PressureReceptors :: "entity ⇒ bool"
  SpecificTypeOf :: "entity ⇒ entity ⇒ bool"
  ShareAllLocationProperties :: "entity ⇒ entity ⇒ bool"
  MainlyFoundIn :: "entity ⇒ entity ⇒ bool"
  Skin :: "entity"

(* Explanation 1: Pacinian corpuscles are a specific type of pressure receptors. *)
axiomatization where
  explanation_1: "∀x p. PacinianCorpuscles x ⟶ PressureReceptors p ⟶ SpecificTypeOf x p"

(* Explanation 2: Pacinian corpuscles share all the location properties with pressure receptors. *)
axiomatization where
  explanation_2: "∀x y. PacinianCorpuscles x ∧ PressureReceptors y ⟶ ShareAllLocationProperties x y"

(* Explanation 3: Pressure receptors are mainly found in the skin. *)
axiomatization where
  explanation_3: "∀x. PressureReceptors x ⟶ MainlyFoundIn x Skin"

(* Explanation 4: If two entities share all the location properties, then they are mainly found in the same locations. *)
axiomatization where
  explanation_4: "∀x y. ShareAllLocationProperties x y ⟶ (MainlyFoundIn x z ⟷ MainlyFoundIn y z)"

(* Explanation 5: If an entity is a specific type of another entity, it shares all the location properties with that entity. *)
axiomatization where
  explanation_5: "∀x y. SpecificTypeOf x y ⟶ ShareAllLocationProperties x y"

theorem hypothesis:
  assumes asm: "PacinianCorpuscles x"
  (* Hypothesis: Pacinian corpuscles are found mainly in the skin. *)
  shows "MainlyFoundIn x Skin"
proof -
  from asm have "PacinianCorpuscles x" by simp
  then obtain p where p: "PressureReceptors p" and sp: "SpecificTypeOf x p" using explanation_1 by blast
  have "ShareAllLocationProperties x p" using sp explanation_5 by blast
  then have "MainlyFoundIn x z ⟷ MainlyFoundIn p z" using explanation_4 by blast
  then have "MainlyFoundIn x Skin" using p explanation_3 by blast
  show ?thesis using asm by blast
qed

end
