theory question_71_6

imports Main

begin

typedecl entity

consts
  Animals :: "entity ⇒ bool"
  Chloroplasts :: "entity ⇒ bool"
  Chlorophyll :: "entity ⇒ bool"

(* Explanation 1: Animals do not possess chloroplasts. *)
axiomatization where
  explanation_1: "∀x. Animals x ⟶ ¬Chloroplasts x"

(* Explanation 2: If an entity does not possess chloroplasts, it does not contain chlorophyll. *)
axiomatization where
  explanation_2: "∀x. ¬Chloroplasts x ⟶ ¬Chlorophyll x"

theorem hypothesis:
  assumes asm: "Animals x"
  (* Hypothesis: Animals lack chlorophyll. *)
  shows "¬Chlorophyll x"
proof -
  from asm have "Animals x" by simp
  then have "¬Chloroplasts x" using explanation_1 by blast
  then have "¬Chlorophyll x" using explanation_2 by blast
  show ?thesis using asm `Chlorophyll x` by blast
qed

end
