theory question_67_5
imports Main

begin
typedecl entity
typedecl event

consts
  OlderMale :: "entity ⇒ bool"
  Male :: "entity ⇒ bool"
  RiverBoatTour :: "event ⇒ bool"
  Event :: "event ⇒ bool"
  RiverBoat :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  InvolvedIn :: "entity ⇒ event ⇒ bool"
  SittingTogether :: "entity ⇒ entity ⇒ bool"
  Boat :: "entity ⇒ bool"

(* Explanation 1: An older male is a male. *)
axiomatization where
  explanation_1: "∀x. OlderMale x ⟶ Male x"

(* Explanation 2: A river boat tour is an event where entities are on a river boat. *)
axiomatization where
  explanation_2: "∀x. RiverBoatTour x ⟶ (∃e y z. Event e ∧ RiverBoat z ∧ On y z ∧ InvolvedIn y e ∧ InvolvedIn x e)"

theorem hypothesis:
  (* Premise: Two older males sitting together on a river boat tour. *)
  assumes asm: "OlderMale x ∧ OlderMale y ∧ RiverBoatTour e ∧ x ≠ y ∧ SittingTogether x y ∧ RiverBoat w ∧ InvolvedIn x e ∧ InvolvedIn y e ∧ On x w ∧ On y w"
  (* Hypothesis: Two males sitting together on a boat. *)
  shows "∃x y z. Male x ∧ Male y ∧ Boat z ∧ x ≠ y ∧ SittingTogether x y ∧ On x z ∧ On y z"
proof -
  have "Male x" using explanation_1 asm by blast
  have "Male y" using explanation_1 asm by blast
  have "Boat w" using explanation_2 asm by blast
  have "x ≠ y" using asm by blast
  have "SittingTogether x y" using asm by blast
  have "On x w" using asm by blast
  have "On y w" using asm by blast
  then show ?thesis using `Male x` `Male y` `Boat w` `x ≠ y` `SittingTogether x y` `On x w` `On y w` by blast
qed

end
