theory question_96_4
imports Main

begin
typedecl entity
typedecl event

consts
  People :: "entity ⇒ bool"
  Swim :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  GroupOfPeople :: "entity ⇒ bool"
  Swimming :: "event ⇒ bool"
  Children :: "entity ⇒ bool"
  Adults :: "entity ⇒ bool"
  Pool :: "entity ⇒ bool"
  Large :: "entity ⇒ bool"
  Staircase :: "entity ⇒ bool"
  Red :: "entity ⇒ bool"
  In :: "event ⇒ entity ⇒ bool"

(* Explanation 1: When people swim together, they form a group of people swimming. *)
axiomatization where
  explanation_1: "∀x e. People x ∧ Swim e ∧ Agent e x ⟶ (∃y e'. GroupOfPeople y ∧ Swimming e' ∧ Agent e' y)"

(* Explanation 2: Children and adults are considered as people. *)
axiomatization where  
  explanation_2: "∀x. (Children x ∨ Adults x) ⟶ People x"

theorem hypothesis:
  (* Premise: Children and adults swim in large pool with red staircase. *)
  assumes asm: " Children x ∨ Adults x  ∧ Pool y ∧ Large y ∧ Staircase z ∧ Red z ∧ Swim e ∧ Agent e x ∧ In e y"
  (* Hypothesis: A group of people are swimming. *)
  shows "∃x e. GroupOfPeople x ∧ Swimming e ∧ Agent e x"
proof -
  from asm have "Children x ∨ Adults x ∧ Swim e ∧ Agent e x" by blast
  then have "People x ∧ Swim e ∧ Agent e x" using explanation_2 by blast
  then show ?thesis using explanation_1 by blast
qed

end
