theory question_42_2

imports Main

begin
typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  Woman :: "entity ⇒ bool"
  People :: "entity ⇒ bool"
  Park :: "entity ⇒ bool"
  OutdoorLocation :: "entity ⇒ bool"
  ParkBench :: "entity ⇒ bool"
  Sit :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Behind :: "entity ⇒ entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  At :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A man and a woman are people. *)
axiomatization where
  explanation_1: "∀x y. Man x ∧ Woman y ⟶ People x ∧ People y"

(* Explanation 2: A park is an outdoor location. *)
axiomatization where  
  explanation_2: "∀x. Park x ⟶ OutdoorLocation x"

theorem hypothesis:
  (* Premise: A man and woman sit on a park bench with a set of newlyweds behind. *)
  assumes asm: "Man x ∧ Woman y ∧ ParkBench z ∧ Sit e ∧ Agent e x ∧ Agent e y ∧ Patient e z ∧ Behind x z ∧ Behind y z"
  (* Hypothesis: People outside. *)
  shows "∃x y. People x ∧ Outside y ∧ At x y"
proof -
  from asm have "Man x ∧ Woman y" by blast
  then have "People x ∧ People y" using explanation_1 by blast
  from asm have "Park z" by blast
  then have "OutdoorLocation z" using explanation_2 by blast
  then show ?thesis using `People x` `People y` `OutdoorLocation z` by blast
qed

end
