theory question_23_1

imports Main

begin

typedecl entity
typedecl event

consts
  Hurricanes :: "entity ⇒ bool"
  Tornadoes :: "entity ⇒ bool"
  HighWindSpeeds :: "event ⇒ bool"
  Has :: "event ⇒ entity ⇒ bool"
  Storms :: "entity ⇒ bool"

(* Explanation 1: A hurricane has high wind speeds. *)
axiomatization where
  explanation_1: "∀x e. Hurricanes x ⟶ (∃e. HighWindSpeeds e ∧ Has e x)"

(* Explanation 2: A tornado has high wind speeds. *)
axiomatization where
  explanation_2: "∀x e. Tornadoes x ⟶ (∃e. HighWindSpeeds e ∧ Has e x)"

(* Explanation 3: Hurricanes and tornadoes are both types of storms known for their high wind speeds. *)
axiomatization where
  explanation_3: "∀x. Hurricanes x ∨ Tornadoes x ⟶ Storms x ∧ (∃e. HighWindSpeeds e ∧ Has e x)"

theorem hypothesis:
  assumes asm: "Hurricanes x"
  (* Hypothesis: Both hurricanes and tornadoes always have high winds. *)
  shows "∃e. HighWindSpeeds e ∧ Has e x"
proof -
  from asm have "Hurricanes x" by simp
  then obtain e where e: "HighWindSpeeds e ∧ Has e x" using explanation_1 by blast
  then have "Storms x" using explanation_3 by blast
  have conclusion: "HighWindSpeeds e ∧ Has e x" using e by simp
  show ?thesis using conclusion by blast
qed

end
