theory question_14_0

imports Main

begin

typedecl entity
typedecl event

consts
  Animal :: "entity ⇒ bool"
  Divides :: "event ⇒ bool"
  IntoTwoParts :: "event ⇒ bool"
  Fission :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Isotope :: "entity ⇒ bool"
  Undergoing :: "event ⇒ bool"
  FissileIsotope :: "entity ⇒ bool"

(* Explanation 1: Fission takes place when an animal divides into two parts. *)
axiomatization where
  explanation_1: "∀x e. Animal x ∧ Divides e ∧ IntoTwoParts e ⟶ Fission e ∧ Agent e x"

(* Explanation 2: An isotope capable of undergoing fission is called a fissile isotope. *)
axiomatization where
  explanation_2: "∀x e. Isotope x ∧ Undergoing e ∧ Fission e ⟶ FissileIsotope x"

theorem hypothesis:
  assumes asm: "FissileIsotope x"
  (* Hypothesis: Fissile isotopes are capable of dividing into two parts. *)
  shows "∃x e. FissileIsotope x ∧ Dividing e ∧ CapableOf e ∧ Agent e x ∧ IntoTwoParts e"
proof -
  from asm have "FissileIsotope x" by simp
  then obtain e where e: "Undergoing e ∧ Fission e" using explanation_2 by blast
  then have "Dividing e ∧ CapableOf e ∧ Agent e x" using explanation_1 by blast
  have conclusion: "Undergoing e ∧ Fission e" using e by simp
  show ?thesis using conclusion `Dividing e ∧ CapableOf e ∧ Agent e x` by blast
qed

end
