theory question_89_2

imports Main

begin
typedecl entity
typedecl event

consts
  MountainBiking :: "entity ⇒ bool"
  Autumn :: "entity ⇒ bool"
  CommonActivity :: "entity ⇒ entity ⇒ bool"
  SuitableSeason :: "entity ⇒ entity ⇒ bool"
  Engaging :: "entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"
  PopularChoice :: "entity ⇒ bool"
  Enthusiast :: "entity ⇒ bool"
  PreferredTime :: "entity ⇒ entity ⇒ bool"
  Bicycling :: "entity ⇒ bool"
  Woods :: "entity ⇒ bool"
  EarlyFall :: "entity ⇒ bool"
  Forest :: "entity ⇒ bool"

(* Explanation 1: Mountain biking is a common activity during autumn. *)
axiomatization where
  explanation_1: "∀x y. MountainBiking x ∧ Autumn y ⟶ CommonActivity x y"

(* Explanation 2: Autumn is a season suitable for mountain biking. *)
axiomatization where
  explanation_2: "∀x y. Autumn x ∧ MountainBiking y ⟶ SuitableSeason x y"

(* Explanation 3: Engaging in mountain biking during autumn is a popular choice. *)
axiomatization where
  explanation_3: "∃x y z e. Engaging x ∧ MountainBiking y ∧ Autumn z ∧ In x y ∧ In x z ∧ PopularChoice x"

(* Explanation 4: Autumn is a preferred time for mountain biking enthusiasts. *)
axiomatization where
  explanation_4: "∀x y. Autumn x ∧ MountainBiking y ∧ Enthusiast y ⟶ PreferredTime x y"

theorem hypothesis:
  (* Premise: Mountain biking in a forest during the early fall. *)
  assumes asm: "MountainBiking x ∧ Forest y ∧ EarlyFall z ∧ In x y ∧ In x z"
  (* Hypothesis: Bicycling through the woods in the Autumn. *)
  shows "∃x y z e. Bicycling x ∧ Woods y ∧ Autumn z ∧ In x y ∧ In x z"
proof -
  from asm have "MountainBiking x ∧ Forest y ∧ EarlyFall z" by blast
  then have "Autumn z" using explanation_1 by blast
  then have "SuitableSeason z x" using explanation_2 by blast
  then have "PreferredTime z x" using explanation_4 by blast
  then have "Bicycling x ∧ Woods y ∧ Autumn z ∧ In x y ∧ In x z" using asm by blast
  then show ?thesis using `Bicycling x` `Woods y` `Autumn z` `In x y` `In x z` by blast
qed

end
