theory question_54_8
imports Main

begin
typedecl entity
typedecl event

consts
  TennisRacket :: "entity ⇒ bool"
  FundamentalElementOfPlayingTennis :: "entity ⇒ bool"
  Striking :: "event ⇒ bool"
  TennisBall :: "event ⇒ bool"
  KeyActionInPlayingTennis :: "event ⇒ bool"
  Man :: "entity ⇒ bool"
  PlayingTennis :: "event ⇒ bool"
  RedAndBlack :: "entity ⇒ bool"
  AboutToStrike :: "event ⇒ bool"

(* Explanation 1: Using a tennis racket is a fundamental element of playing tennis, indicating direct involvement in the sport. *)
axiomatization where
  explanation_1: "∀x. TennisRacket x ⟶ FundamentalElementOfPlayingTennis x"

(* Explanation 2: Striking a tennis ball with a tennis racket is a key action in playing tennis. *)
axiomatization where
  explanation_2: "∀e. Striking e ∧ TennisBall e ∧ TennisRacket e ⟶ KeyActionInPlayingTennis e"

theorem hypothesis:
  (* Premise: A man in red and black about to strike a tennis ball. *)
  assumes asm: "Man x ∧ RedAndBlack x ∧ AboutToStrike e ∧ TennisBall e ∧ Agent e x"
  (* Hypothesis: A man is playing tennis. *)
  shows "∃x e. Man x ∧ PlayingTennis e ∧ Agent e x"
proof -
  from asm have "Man x ∧ AboutToStrike e ∧ TennisBall e ∧ Agent e x" by blast
  then have "Man x ∧ PlayingTennis e ∧ Agent e x" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
