# Copyright (c) <anonymized for review>

from confidence.token import TokenConfidence
from confidence.sent import SentConfidence
from confidence.dropout import DropoutConfidence
from confidence.prompt_diff import PromptDiffConfidence


def get_confidence_by_name(name, args):
    NAME_TO_CLASS = dict(
        token=TokenConfidence,
        sent=SentConfidence,
        dropout=DropoutConfidence,
        prompt_diff=PromptDiffConfidence,
    )
    if name not in NAME_TO_CLASS:
        raise ValueError(f"Undefined confidence type: {name}")
    return NAME_TO_CLASS[name](args=args)
