# Contributing 
Welcome, and thank you for your interest in helping to improve and accelerate/ease the adoption of arg-classifier (Argumentative Proposition Classifier).

There are many ways in which you can contribute, beyond writing code. The goal of this document is to provide a high-level overview of how you can get involved, and hopefully not feel intimidated.

## Asking Questions and Providing Feedback
Have a question? Rather than emailing the author, open an issue.

The community will be eager to assist you. Your well-worded question will serve as a resource to others searching for help.

## Reporting Issues and Ideas
Have you identified an oversight or problem? Have a feature request? We want to hear about it! Here's how you can make reporting your issue as effective as possible.

> **Note:** If you already know what you want to change, feel free to just fork/clone the repo, change it, and submit a pull request. No need to add overhead by creating an issue!

### Look For an Existing Issue
Before you create a new issue, please do a search in [open issues](https://github.com/argrecsys/arg-classifier/issues) to see if the issue or feature request has already been filed.

If you cannot find an existing issue that describes your bug or feature, create a new issue using the guidelines below.

### Writing Good Bug Reports and Feature Requests
File a single issue per problem and feature request. Do not enumerate multiple bugs or feature requests in the same issue.

Below is some information you can provide. The more you can provide, the more likely someone will be successful at understanding and incorporating it. However be mindful of the cost/benefit for documenting vs simply implementing the change.

Please include the following with each issue:
- **Title** - Concise and clear to quickly identify the topic.
- **Problem** - Summary of the issue/idea/feature.
- **Possible Solution** - If a solution seems clear, share it as an option.
- **Examples** - "What was expected" vs "What actually ocurred". 
- **Context** - External factors that restrict possible solutions. (stuff that can't be changed)
    > Example: Please upgrade the vehicle from 30mph to 60mph. Context: budget is $5000.

# Thank You!
Your contributions to arg-classifier, large or small, make great projects like this possible. Thank you for taking the time to contribute!
