#!/bin/bash

set -f # disable glob
IFS=' ' # split on space characters

# Parse options
while getopts ":o:p:" OPT; do
	case $OPT in
		o ) OUTPUT_PATH=($OPTARG) ;; # Path to store fasttext embeddings

		p ) PYTHON_SCRIPT_PATH=($OPTARG) ;; # Path to the python script
	esac
done

for LANG in "ar" "de" "fa" "ru" "tr" "zh"
do
  ./download_fasttext_embeddings.sh -l $LANG -o $OUTPUT_PATH -p $PYTHON_SCRIPT_PATH
done
