export CUDA_VISIBLE_DEVICES=0
export GLUE_DIR=/home/LAB/chenty/workspace/public_dataset/GLUE
export TASK_NAME=STS-B
export MODEL_PATH=/home/LAB/chenty/workspace/public_models/bert-tiny/bert-tiny.pt
export CONFIG_NAME=/home/LAB/chenty/workspace/public_models/bert-tiny/bert_config_relu.json
export CKPT_PATH=/home/LAB/chenty/workspace/personal/MSRA_project/encryption/unilm2-he/models/${TASK_NAME}_softmax_approximation/pytorch_model.bin
export OUTPUT_DIR=/home/LAB/chenty/workspace/personal/MSRA_project/encryption/unilm2-he/models/${TASK_NAME}_softmax_approximation_ln
export STEPS=90

python nlu_finetune/run_glue_HE.py \
  --config_name ${CONFIG_NAME} \
  --tokenizer_name unilm2-base-uncased \
  --model_name_or_path ${CKPT_PATH} \
  --task_name ${TASK_NAME} \
  --do_train \
  --do_eval \
  --app_ln_layer\
  --app_ln_loss \
  --data_dir ${GLUE_DIR}/${TASK_NAME} \
  --max_seq_length 128 \
  --per_gpu_train_batch_size 64 \
  --per_gpu_eval_batch_size 128 \
  --learning_rate 8e-4\
  --num_train_epochs 100.0 \
  --save_steps 30000 \
  --logging_steps ${STEPS} \
  --overwrite_output_dir \
  --output_dir ${OUTPUT_DIR} 
