import collections

def numMatchingSubseq(S, words):
        """
        :type S: str
        :type words: List[str]
        :rtype: int
        """
        waiting = collections.defaultdict(list)
        for word in words:
            waiting[word[0]].append(iter(word[1:]))
        for c in S:
            for it in waiting.pop(c, ()):
                waiting[next(it, None)].append(it)
        return len(waiting[None])

def parse_actions_text(text, action_token='[ACT]', skip_empty=False):
    """
    Parse actions text into set
    """

    actions = text.split(action_token)
    if skip_empty:
        actions = [item for item in actions if not item == '']

    # Strip spaces around each words
    actions = [item.strip() for item in actions]

    return actions


def replace_newlines(text, replacement=' [SEP] '):
    """
    Replace multiple newlines with a replacement string
    """
    return re.sub(r'\n+', replacement, text)
