import os
import random

from pruner.utils.parser import Arguments
from pruner.utils.runs import Run

from pruner.evaluation.loaders import load_pruner
from pruner.training.batcher import load_data

from pruner.evaluation.pruning import evaluate

def main():
    random.seed(12345)

    parser = Arguments(description='Evaluation on pruner.')

    parser.add_model_parameters()
    parser.add_model_inference_parameters()

    parser.add_argument('--data', dest='data', default=None)

    args = parser.parse()

    with Run.context():
        args.pruner, args.checkpoint = load_pruner(args)

        args.data = load_data(args.data, rank=0, nranks=1)
        # data: List[Tuple(str, ndarray(float64)))] = The list of tuples of (passage, label)

        evaluate(args)


if __name__ == "__main__":
    main()
