MODEL_PATH=bert-base-uncased
TASK_NAME=RTE

python run_glue.py \
  --model_type bert \
  --model_name_or_path $MODEL_PATH \
  --task_name $TASK_NAME \
  --do_train \
  --do_eval \
  --do_lower_case \
  --data_dir ../data/$TASK_NAME/ \
  --max_seq_length 128 \
  --per_gpu_eval_batch_size 128 \
  --per_gpu_train_batch_size 16 \
  --learning_rate 5e-5 \
  --num_train_epochs 20.0 \
  --save_steps 100 \
  --logging_steps 100 \
  --output_dir ./model/$TASK_NAME/ \
  --evaluate_during_training \
  --overwrite_output_dir