import argparse
import os


def main(args):
    with open(os.path.join(args.input_dir, 'seq.in'), 'r') as uttf, open(os.path.join(args.input_dir, 'label'), 'r') as icf, open(os.path.join(args.input_dir, 'seq.out'), 'r') as nerf, open(os.path.join(args.input_dir, 'out.tsv'), 'w') as out:
        for utt, ic, ner in zip(uttf, icf, nerf):
            utt, ic, ner = utt.strip(), ic.strip(), ner.strip()
            utt = utt.split()
            ner = ner.split()
            ner = [tag.split('-')[1] if '-' in tag else 'other' for tag in ner]
            tokens_tags = ['{}|{}'.format(token, tag) for token, tag in zip(utt, ner)]
            out.write("snips\t" + ic + '\t' + ' '.join(tokens_tags) + '\n')


if __name__ == "__main__":
    parser = argparse.ArgumentParser(
        description='Run SNIPS preprocessing, will read the files "seg.in", "label" and "seq.out" files from the input '
                    'directory and create a "out.tsv" file in the input directory.')
    parser.add_argument('input_dir', help='Directory containing data files')
    args = parser.parse_args()
    main(args)
