/*
 * Decompiled with CFR 0.152.
 */
package timemlnormalizer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import nlp_files.XMLFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import timemlnormalizer.Tokenizer;
import utils_bk.FileUtils;
import xml_parsers.XmlAttribs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeML_Normalizer {
    public static void normalize(ArrayList<File[]> annotations) {
        block47: {
            try {
                File[] guide = annotations.get(0);
                for (int i = 0; i < guide.length; ++i) {
                    int a;
                    System.out.println("Normalizing " + guide[i].getName());
                    HashMap[] timex_map = new HashMap[annotations.size()];
                    HashMap[] event_map = new HashMap[annotations.size()];
                    HashMap[] mk_map = new HashMap[annotations.size()];
                    ArrayList<String> xmlFileString = new ArrayList<String>();
                    ArrayList<String[]> tokenFileStringArr = new ArrayList<String[]>();
                    int last_eid = 1;
                    int open_event = 0;
                    int last_tid = 1;
                    int[] open_timex = new int[annotations.size()];
                    int[] last_tid_local = new int[annotations.size()];
                    for (a = 0; a < annotations.size(); ++a) {
                        File annot = annotations.get(a)[i];
                        File ftdir = new File(annot.getCanonicalPath() + "-data");
                        if (ftdir.exists()) {
                            FileUtils.deleteRecursively((File)ftdir);
                        }
                        if (!ftdir.mkdirs()) {
                            throw new Exception("Directory not created...");
                        }
                        File workingfile = new File(ftdir + File.separator + annot.getName());
                        FileUtils.copyFileUtil((File)annot, (File)workingfile);
                        XMLFile xmlfile = new XMLFile();
                        xmlfile.loadFile(workingfile);
                        String plainfile = xmlfile.toPlain();
                        String output = Tokenizer.run(plainfile);
                        output = TimeML_Normalizer.merge_tok_n_tml(output, workingfile.getCanonicalPath());
                        tokenFileStringArr.add(FileUtils.readFileAsString((String)output, (String)"UTF-8").split("\\n"));
                        xmlFileString.add(FileUtils.readFileAsString((String)workingfile.getCanonicalPath(), (String)"UTF-8"));
                        event_map[a] = new HashMap();
                        timex_map[a] = new HashMap();
                        mk_map[a] = new HashMap();
                        open_timex[a] = 0;
                        last_tid_local[a] = 0;
                    }
                    for (int linen = 0; linen < ((String[])tokenFileStringArr.get(0)).length; ++linen) {
                        HashMap<String, String> attribs;
                        String[] pipesarr;
                        int a2;
                        open_event = 0;
                        String last_token = null;
                        for (a2 = 0; a2 < annotations.size(); ++a2) {
                            pipesarr = ((String[])tokenFileStringArr.get(a2))[linen].split("\\|");
                            if (last_token == null) {
                                last_token = pipesarr[0];
                            } else if (pipesarr[0].equals(last_token)) {
                                last_token = pipesarr[0];
                            } else {
                                throw new Exception("Tokens doesn't match at line: " + linen + " (" + last_token + ")");
                            }
                            attribs = XmlAttribs.parseAttrs(pipesarr[2]);
                            if (pipesarr[1].matches("B-EVENT")) {
                                if (open_event == 0) {
                                    open_event = last_eid++;
                                }
                                event_map[a2].put(attribs.get("eid"), "e" + open_event);
                            }
                            if (!pipesarr[1].equals("O") && !pipesarr[1].equals("B-TIMEX3")) continue;
                            open_timex[a2] = 0;
                        }
                        for (a2 = 0; a2 < annotations.size(); ++a2) {
                            pipesarr = ((String[])tokenFileStringArr.get(a2))[linen].split("\\|");
                            attribs = XmlAttribs.parseAttrs(pipesarr[2]);
                            if (!pipesarr[1].equals("B-TIMEX3")) continue;
                            open_timex[a2] = last_tid;
                            for (int at = 0; at < annotations.size(); ++at) {
                                if (a2 == at || open_timex[at] == 0 || last_tid_local[a2] >= open_timex[at]) continue;
                                open_timex[a2] = open_timex[at];
                                break;
                            }
                            last_tid_local[a2] = open_timex[a2];
                            if (open_timex[a2] == last_tid) {
                                ++last_tid;
                            }
                            timex_map[a2].put(attribs.get("tid"), "t" + open_timex[a2]);
                        }
                    }
                    for (a = 0; a < annotations.size(); ++a) {
                        Element element;
                        int s;
                        Element element2;
                        int s2;
                        NodeList text;
                        File ndir = new File(annotations.get(a)[i].getParent() + "-normalized");
                        if (!ndir.exists() && !ndir.mkdirs()) {
                            throw new Exception("Directory not created...");
                        }
                        String annotname = annotations.get(a)[i].getCanonicalPath().substring(0, annotations.get(a)[i].getCanonicalPath().lastIndexOf(File.separator));
                        annotname = annotname.substring(annotname.lastIndexOf(File.separator) + 1);
                        String tmp = (String)xmlFileString.get(a);
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        Document doc = db.parse(annotations.get(a)[i]);
                        doc.getDocumentElement().normalize();
                        String dctid = null;
                        Element dct = (Element)((Element)doc.getElementsByTagName("DCT").item(0)).getElementsByTagName("TIMEX3").item(0);
                        if (dct != null) {
                            dctid = dct.getAttribute("tid");
                            timex_map[a].put(dctid, "t0");
                            tmp = tmp.replaceAll("(<DCT><TIMEX3[^>]*tid=\")" + dct.getAttribute("tid") + "(\"[^>]*>)", "$1t0$2");
                        }
                        if ((text = doc.getElementsByTagName("TEXT")).getLength() > 1) {
                            throw new Exception("More than one TEXT tag found.");
                        }
                        Element TextElmnt = (Element)text.item(0);
                        NodeList current_node = TextElmnt.getElementsByTagName("EVENT");
                        for (s2 = 0; s2 < current_node.getLength(); ++s2) {
                            element2 = (Element)current_node.item(s2);
                            tmp = tmp.replaceAll("(<EVENT[^>]*eid=\")" + element2.getAttribute("eid") + "(\"[^>]*>)", "$1n" + (String)event_map[a].get(element2.getAttribute("eid")) + "$2");
                        }
                        tmp = tmp.replaceAll("(<EVENT[^>]*eid=\")n", "$1");
                        current_node = TextElmnt.getElementsByTagName("TIMEX3");
                        for (s2 = 0; s2 < current_node.getLength(); ++s2) {
                            element2 = (Element)current_node.item(s2);
                            if (timex_map[a].get(element2.getAttribute("tid")) != null) {
                                tmp = tmp.replaceAll("(<TIMEX3[^>]*tid=\")" + element2.getAttribute("tid") + "(\"[^>]*>)", "$1n" + (String)timex_map[a].get(element2.getAttribute("tid")) + "$2");
                                if (element2.hasAttribute("anchorTimeID")) {
                                    tmp = timex_map[a].get(element2.getAttribute("anchorTimeID")) != null ? tmp.replaceAll("(<TIMEX3[^>]*anchorTimeID=\")" + element2.getAttribute("anchorTimeID") + "(\"[^>]*>)", "$1n" + (String)timex_map[a].get(element2.getAttribute("anchorTimeID")) + "$2") : tmp.replaceAll("anchorTimeID=\"" + element2.getAttribute("anchorTimeID") + "\"", "");
                                }
                                if (element2.hasAttribute("beginPoint")) {
                                    tmp = timex_map[a].get(element2.getAttribute("beginPoint")) != null ? tmp.replaceAll("(<TIMEX3[^>]*beginPoint=\")" + element2.getAttribute("beginPoint") + "(\"[^>]*>)", "$1n" + (String)timex_map[a].get(element2.getAttribute("beginPoint")) + "$2") : tmp.replaceAll("beginPoint=\"" + element2.getAttribute("beginPoint") + "\"", "");
                                }
                                if (!element2.hasAttribute("endPoint")) continue;
                                if (timex_map[a].get(element2.getAttribute("endPoint")) != null) {
                                    tmp = tmp.replaceAll("(<TIMEX3[^>]*endPoint=\")" + element2.getAttribute("endPoint") + "(\"[^>]*>)", "$1n" + (String)timex_map[a].get(element2.getAttribute("endPoint")) + "$2");
                                    continue;
                                }
                                tmp = tmp.replaceAll("endPoint=\"" + element2.getAttribute("endPoint") + "\"", "");
                                continue;
                            }
                            tmp = tmp.replaceAll("<TIMEX3[^>]*tid=\"" + element2.getAttribute("tid") + "\"[^>]*>([^<]*)</TIMEX3>", "$1");
                            tmp = tmp.replaceAll("anchorTimeID=\"" + element2.getAttribute("tid") + "\"", "");
                            tmp = tmp.replaceAll("beginPoint=\"" + element2.getAttribute("tid") + "\"", "");
                            tmp = tmp.replaceAll("endPoint=\"" + element2.getAttribute("tid") + "\"", "");
                            tmp = tmp.replaceAll("<[TSA]LINK[^>]*=\"" + element2.getAttribute("tid") + "\"[^>]*>", "");
                        }
                        tmp = tmp.replaceAll("(<TIMEX3[^>]*tid=\")n", "$1");
                        tmp = tmp.replaceAll("(<TIMEX3[^>]*anchorTimeID=\")n", "$1");
                        tmp = tmp.replaceAll("(<TIMEX3[^>]*beginPoint=\")n", "$1");
                        tmp = tmp.replaceAll("(<TIMEX3[^>]*endPoint=\")n", "$1");
                        HashMap event_mk_index = new HashMap();
                        HashSet<String> mks_new_ids = new HashSet<String>();
                        current_node = null;
                        current_node = doc.getElementsByTagName("MAKEINSTANCE");
                        for (s = 0; s < current_node.getLength(); ++s) {
                            element = (Element)current_node.item(s);
                            String mapped_event = (String)event_map[a].get(element.getAttribute("eventID"));
                            if (!event_mk_index.containsKey(mapped_event)) {
                                ArrayList<String> mks = new ArrayList<String>();
                                if (mks_new_ids.contains(mapped_event.replaceFirst("e", "ei"))) {
                                    throw new Exception("Duplicated eiid in mks: " + mapped_event.replaceFirst("e", "ei") + "  " + annotations.get(a)[i]);
                                }
                                mks_new_ids.add(mapped_event.replaceFirst("e", "ei"));
                                mks.add(mapped_event.replaceFirst("e", "ei"));
                                event_mk_index.put(mapped_event, mks);
                                mk_map[a].put(element.getAttribute("eiid"), mapped_event.replaceFirst("e", "ei"));
                                tmp = tmp.replaceAll("(<MAKEINSTANCE[^>]*eiid=\"" + element.getAttribute("eiid") + "\"[^>]*[^>]*eventID=\")" + element.getAttribute("eventID") + "(\"[^>]*>)", "$1n" + mapped_event + "$2");
                                tmp = tmp.replaceAll("(<MAKEINSTANCE[^>]*[^>]*eventID=\")" + element.getAttribute("eventID") + "(\"[^>]*eiid=\"" + element.getAttribute("eiid") + "\"[^>]*>)", "$1n" + mapped_event + "$2");
                                tmp = tmp.replaceAll("(<MAKEINSTANCE[^>]*eiid=\")" + element.getAttribute("eiid") + "(\"[^>]*>)", "$1n" + mapped_event.replaceFirst("e", "ei") + "$2");
                                continue;
                            }
                            if (mks_new_ids.contains(mapped_event.replaceFirst("e", "ei"))) {
                                int num = 1000000 + Integer.parseInt(mapped_event.substring(1));
                                while (mks_new_ids.contains("ei" + num)) {
                                    ++num;
                                }
                                mks_new_ids.add("ei" + num);
                                ((ArrayList)event_mk_index.get(mapped_event)).add("ei" + num);
                                mk_map[a].put(element.getAttribute("eiid"), "ei" + num);
                                tmp = tmp.replaceAll("(<MAKEINSTANCE[^>]*eiid=\"" + element.getAttribute("eiid") + "\"[^>]*[^>]*eventID=\")" + element.getAttribute("eventID") + "(\"[^>]*>)", "$1n" + mapped_event + "$2");
                                tmp = tmp.replaceAll("(<MAKEINSTANCE[^>]*[^>]*eventID=\")" + element.getAttribute("eventID") + "(\"[^>]*eiid=\"" + element.getAttribute("eiid") + "\"[^>]*>)", "$1n" + mapped_event + "$2");
                                tmp = tmp.replaceAll("(<MAKEINSTANCE[^>]*eiid=\")" + element.getAttribute("eiid") + "(\"[^>]*>)", "$1nei" + num + "$2");
                                continue;
                            }
                            throw new Exception("Extrange");
                        }
                        tmp = tmp.replaceAll("(<MAKEINSTANCE[^>]*eiid=\")n", "$1");
                        tmp = tmp.replaceAll("(<MAKEINSTANCE[^>]*eventID=\")n", "$1");
                        current_node = doc.getElementsByTagName("TLINK");
                        for (s = 0; s < current_node.getLength(); ++s) {
                            element = (Element)current_node.item(s);
                            String relType = element.getAttribute("relType");
                            if (relType.matches("(DURING|DURING_INV|IDENTITY)")) {
                                relType = "SIMULTANEOUS";
                            }
                            String entity1 = null;
                            String entity2 = null;
                            if (element.hasAttribute("eventInstanceID") && element.hasAttribute("relatedToEventInstance")) {
                                if (!mk_map[a].containsKey(element.getAttribute("eventInstanceID"))) {
                                    throw new Exception("Event instance not found it file: " + element.getAttribute("eventInstanceID"));
                                }
                                if (!mk_map[a].containsKey(element.getAttribute("relatedToEventInstance"))) {
                                    throw new Exception("Event instance not found it file: " + element.getAttribute("relatedToEventInstance"));
                                }
                                entity1 = (String)mk_map[a].get(element.getAttribute("eventInstanceID"));
                                entity2 = (String)mk_map[a].get(element.getAttribute("relatedToEventInstance"));
                                if (Integer.parseInt(entity1.substring(2)) > Integer.parseInt(entity2.substring(2))) {
                                    entity1 = entity2;
                                    entity2 = (String)mk_map[a].get(element.getAttribute("eventInstanceID"));
                                    relType = TimeML_Normalizer.reverseRelationCategory(relType);
                                }
                                tmp = tmp.replaceAll("(<TLINK[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*eventInstanceID=\")" + element.getAttribute("eventInstanceID") + "(\"[^>]*>)", "$1" + entity1 + "$2");
                                tmp = tmp.replaceAll("(<TLINK[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*relatedToEventInstance=\")" + element.getAttribute("relatedToEventInstance") + "(\"[^>]*>)", "$1" + entity2 + "$2");
                                tmp = tmp.replaceAll("(<TLINK[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*relType=\")" + element.getAttribute("relType") + "(\"[^>]*>)", "$1" + relType + "$2");
                                tmp = tmp.replaceAll("(<TLINK[^>]*eventInstanceID=\")" + element.getAttribute("eventInstanceID") + "(\"[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*>)", "$1" + entity1 + "$2");
                                tmp = tmp.replaceAll("(<TLINK[^>]*relatedToEventInstance=\")" + element.getAttribute("relatedToEventInstance") + "(\"[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*>)", "$1" + entity2 + "$2");
                                tmp = tmp.replaceAll("(<TLINK[^>]*relType=\")" + element.getAttribute("relType") + "(\"[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*>)", "$1" + relType + "$2");
                            }
                            if (element.hasAttribute("eventInstanceID") && element.hasAttribute("relatedToTime")) {
                                if (!mk_map[a].containsKey(element.getAttribute("eventInstanceID"))) {
                                    throw new Exception("Event instance not found in file: " + element.getAttribute("eventInstanceID"));
                                }
                                if (!timex_map[a].containsKey(element.getAttribute("relatedToTime"))) {
                                    throw new Exception("Timex not found in file: " + element.getAttribute("relatedToTime"));
                                }
                                entity1 = (String)mk_map[a].get(element.getAttribute("eventInstanceID"));
                                entity2 = (String)timex_map[a].get(element.getAttribute("relatedToTime"));
                                tmp = tmp.replaceAll("(<TLINK[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*eventInstanceID=\")" + element.getAttribute("eventInstanceID") + "(\"[^>]*>)", "$1" + entity1 + "$2");
                                tmp = tmp.replaceAll("(<TLINK[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*relatedToTime=\")" + element.getAttribute("relatedToTime") + "(\"[^>]*>)", "$1" + entity2 + "$2");
                                tmp = tmp.replaceAll("(<TLINK[^>]*eventInstanceID=\")" + element.getAttribute("eventInstanceID") + "(\"[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*>)", "$1" + entity1 + "$2");
                                tmp = tmp.replaceAll("(<TLINK[^>]*relatedToTime=\")" + element.getAttribute("relatedToTime") + "(\"[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*>)", "$1" + entity2 + "$2");
                            }
                            if (element.hasAttribute("timeID") && element.hasAttribute("relatedToEventInstance")) {
                                if (!mk_map[a].containsKey(element.getAttribute("relatedToEventInstance"))) {
                                    throw new Exception("Event instance not found it file: " + element.getAttribute("relatedToEventInstance"));
                                }
                                if (!timex_map[a].containsKey(element.getAttribute("timeID"))) {
                                    throw new Exception("Timex not found it file: " + element.getAttribute("timeID"));
                                }
                                entity1 = (String)mk_map[a].get(element.getAttribute("relatedToEventInstance"));
                                entity2 = (String)timex_map[a].get(element.getAttribute("timeID"));
                                relType = TimeML_Normalizer.reverseRelationCategory(relType);
                                tmp = tmp.replaceAll("(<TLINK[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*)timeID=\"" + element.getAttribute("timeID") + "(\"[^>]*>)", "$1eventInstanceID=\"" + entity1 + "$2");
                                tmp = tmp.replaceAll("(<TLINK[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*)relatedToEventInstance=\"" + element.getAttribute("relatedToEventInstance") + "(\"[^>]*>)", "$1relatedToTime=\"" + entity2 + "$2");
                                tmp = tmp.replaceAll("(<TLINK[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*relType=\")" + element.getAttribute("relType") + "(\"[^>]*>)", "$1" + relType + "$2");
                                tmp = tmp.replaceAll("(<TLINK[^>]*)timeID=\"" + element.getAttribute("timeID") + "(\"[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*>)", "$1eventInstanceID=\"" + entity1 + "$2");
                                tmp = tmp.replaceAll("(<TLINK[^>]*)relatedToEventInstance=\"" + element.getAttribute("relatedToEventInstance") + "(\"[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*>)", "$1relatedToTime=\"" + entity2 + "$2");
                                tmp = tmp.replaceAll("(<TLINK[^>]*relType=\")" + element.getAttribute("relType") + "(\"[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*>)", "$1" + relType + "$2");
                            }
                            if (!element.hasAttribute("timeID") || !element.hasAttribute("relatedToTime")) continue;
                            if (!timex_map[a].containsKey(element.getAttribute("relatedToTime"))) {
                                throw new Exception("Timex instance not found it file: " + element.getAttribute("relatedToTime"));
                            }
                            if (!timex_map[a].containsKey(element.getAttribute("timeID"))) {
                                throw new Exception("Timex not found it file: " + element.getAttribute("timeID") + " - " + element.getAttribute("lid"));
                            }
                            entity1 = (String)timex_map[a].get(element.getAttribute("timeID"));
                            entity2 = (String)timex_map[a].get(element.getAttribute("relatedToTime"));
                            if (Integer.parseInt(entity1.substring(1)) > Integer.parseInt(entity2.substring(1))) {
                                entity1 = entity2;
                                entity2 = (String)timex_map[a].get(element.getAttribute("timeID"));
                                relType = TimeML_Normalizer.reverseRelationCategory(relType);
                            }
                            tmp = tmp.replaceAll("(<TLINK[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*timeID=\")" + element.getAttribute("timeID") + "(\"[^>]*>)", "$1" + entity1 + "$2");
                            tmp = tmp.replaceAll("(<TLINK[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*relatedToTime=\")" + element.getAttribute("relatedToTime") + "(\"[^>]*>)", "$1" + entity2 + "$2");
                            tmp = tmp.replaceAll("(<TLINK[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*relType=\")" + element.getAttribute("relType") + "(\"[^>]*>)", "$1" + relType + "$2");
                            tmp = tmp.replaceAll("(<TLINK[^>]*timeID=\")" + element.getAttribute("timeID") + "(\"[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*>)", "$1" + entity1 + "$2");
                            tmp = tmp.replaceAll("(<TLINK[^>]*relatedToTime=\")" + element.getAttribute("relatedToTime") + "(\"[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*>)", "$1" + entity2 + "$2");
                            tmp = tmp.replaceAll("(<TLINK[^>]*relType=\")" + element.getAttribute("relType") + "(\"[^>]*lid=\"" + element.getAttribute("lid") + "\"[^>]*>)", "$1" + relType + "$2");
                        }
                        tmp = tmp.replaceAll("<[ASR]LINK.*", "");
                        FileUtils.writeFileFromString((String)tmp, (String)(ndir + File.separator + annotations.get(a)[i].getName()));
                        File annot = annotations.get(a)[i];
                        File ftdir = new File(annot.getCanonicalPath() + "-data");
                        if (!ftdir.exists()) continue;
                        FileUtils.deleteRecursively((File)ftdir);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Errors found (TimeML_Normalizer):\n\t" + e.toString() + "\n");
                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) break block47;
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String merge_tok_n_tml(String tokfile, String tmlfile) {
        String outputfile = tokfile + "-IOB2";
        try {
            BufferedWriter outfile = new BufferedWriter(new FileWriter(outputfile));
            boolean hasRoot_tag = false;
            char cxml = '\u0000';
            String tag = "";
            String attribs = "-";
            String inTag = "";
            String inAttribs = "-";
            int BIO = 79;
            BufferedReader xmlreader = new BufferedReader(new FileReader(tmlfile));
            BufferedReader pipesreader = new BufferedReader(new FileReader(tokfile));
            try {
                String line;
                while (true) {
                    if ((cxml = (char)xmlreader.read()) == '\uffffffff') {
                        throw new Exception("Premature end of model file");
                    }
                    if (cxml != '<') continue;
                    cxml = (char)xmlreader.read();
                    if (cxml == '\uffffffff') {
                        throw new Exception("Premature end of model file");
                    }
                    do {
                        tag = tag + cxml;
                        cxml = (char)xmlreader.read();
                        if (cxml != '\uffffffff') continue;
                        throw new Exception("Premature end of model file");
                    } while (cxml != '>');
                    if (tag.equalsIgnoreCase("TEXT")) break;
                    tag = "";
                }
                hasRoot_tag = true;
                if (!hasRoot_tag) {
                    throw new Exception("Root tag TEXT not found");
                }
                tag = "";
                cxml = '\u0000';
                while ((line = pipesreader.readLine()) != null) {
                    if (line.length() < 1) {
                        throw new Exception("Malformed tokens file: empty line.");
                    }
                    boolean interTokenTag = false;
                    boolean findtokenIter = false;
                    boolean delayed_closing = false;
                    int prevxmlchar = 120;
                    for (int cn = 0; cn < line.length(); ++cn) {
                        char cpipes = line.charAt(cn);
                        prevxmlchar = cxml;
                        cxml = (char)xmlreader.read();
                        if (cxml == '\uffffffff') {
                            throw new Exception("Premature end of model file");
                        }
                        if (Character.toLowerCase(cpipes) == Character.toLowerCase(cxml)) continue;
                        if (cxml == ' ' || cxml == '\n' || cxml == '\r' || cxml == '\t') {
                            --cn;
                            continue;
                        }
                        if (cxml == '<') {
                            if (cn != 0) {
                                interTokenTag = true;
                            }
                            --cn;
                            while ((cxml = (char)xmlreader.read()) != '\uffff' && cxml != '>') {
                                tag = tag + cxml;
                            }
                            if ((tag = tag.trim()).indexOf(32) != -1) {
                                attribs = tag.substring(tag.indexOf(32) + 1);
                                tag = tag.substring(0, tag.indexOf(32));
                            }
                            if (tag.matches("(?i)(EVENT|TIMEX3)")) {
                                findtokenIter = true;
                                if (interTokenTag) {
                                    System.err.println("Inter-token (" + cn + ") tag: " + line);
                                }
                                if (!inTag.equals("")) {
                                    if (!inTag.equals(tag)) {
                                        throw new Exception("Nested tags (" + tag + "/" + inTag + ") consider manual correction: " + line);
                                    }
                                    System.err.println("Warning - using last tag in the token: " + tag);
                                }
                                inTag = tag;
                                inAttribs = attribs;
                                tag = "";
                                attribs = "-";
                                BIO = 66;
                            } else {
                                interTokenTag = false;
                            }
                            if (tag.matches("/.*")) {
                                String check = inTag;
                                if (tag.matches("/(?i)" + check)) {
                                    if (findtokenIter) {
                                        if (cn >= 0) {
                                            System.err.println("Inter Token end of tag (" + inTag + ") cn=" + cn + " " + line);
                                            delayed_closing = true;
                                        } else {
                                            BIO = 79;
                                            inTag = "";
                                            inAttribs = "-";
                                            findtokenIter = false;
                                            interTokenTag = false;
                                        }
                                    } else {
                                        BIO = 79;
                                        inTag = "";
                                    }
                                }
                            }
                            if (tag.matches("/(?i)TEXT")) {
                                System.err.println("closing TEXT=TEXT");
                            }
                            tag = "";
                            attribs = "-";
                            continue;
                        }
                        if (cxml == '&' || prevxmlchar == 38 && cxml == 'a') {
                            --cn;
                            while ((cxml = (char)xmlreader.read()) != '\uffff' && cxml != ';') {
                                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) continue;
                                System.err.println("Reading XML escaped char in: " + line);
                            }
                            continue;
                        }
                        throw new Exception("Distinct chars cxml(" + cxml + ") cpipes(" + cpipes + ")");
                    }
                    outfile.write(line + "|" + (char)BIO);
                    if (BIO != 79) {
                        outfile.write("-" + inTag);
                    }
                    outfile.write("|" + inAttribs + "\n");
                    if (BIO == 66) {
                        BIO = 73;
                        inAttribs = "-";
                    }
                    if (!delayed_closing) continue;
                    BIO = 79;
                    inTag = "";
                    inAttribs = "-";
                    findtokenIter = false;
                    interTokenTag = false;
                    delayed_closing = false;
                }
            }
            finally {
                if (pipesreader != null) {
                    pipesreader.close();
                }
                if (xmlreader != null) {
                    xmlreader.close();
                }
                if (outfile != null) {
                    outfile.close();
                }
            }
        }
        catch (Exception e) {
            System.err.println("Errors found (TimeML_Normalizer):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            return null;
        }
        return outputfile;
    }

    public static String reverseRelationCategory(String rel) {
        try {
            if (rel.equals("BEFORE")) {
                return "AFTER";
            }
            if (rel.equals("AFTER")) {
                return "BEFORE";
            }
            if (rel.equals("IBEFORE")) {
                return "IAFTER";
            }
            if (rel.equals("IAFTER")) {
                return "IBEFORE";
            }
            if (rel.equals("DURING")) {
                return "DURING_INV";
            }
            if (rel.equals("DURING_INV")) {
                return "DURING";
            }
            if (rel.equals("BEGINS")) {
                return "BEGUN_BY";
            }
            if (rel.equals("BEGUN_BY")) {
                return "BEGINS";
            }
            if (rel.equals("ENDS")) {
                return "ENDED_BY";
            }
            if (rel.equals("ENDED_BY")) {
                return "ENDS";
            }
            if (rel.equals("OVERLAPS")) {
                return "OVERLAPPED_BY";
            }
            if (rel.equals("OVERLAPPED_BY")) {
                return "OVERLAPS";
            }
            if (rel.equals("INCLUDES")) {
                return "IS_INCLUDED";
            }
            if (rel.equals("IS_INCLUDED")) {
                return "INCLUDES";
            }
            if (rel.equals("IDENTITY") || rel.equals("SIMULTANEOUS")) {
                return "SIMULTANEOUS";
            }
            throw new Exception("Unknow relation: " + rel);
        }
        catch (Exception e) {
            System.err.println("Errors found (TimeML_Normalizer):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            return null;
        }
    }
}

