import argparse

import init

parser = argparse.ArgumentParser(description='Get information about your current HITs.')
parser.add_argument('-s', '--sandbox', help='Do on the sandbox', action='store_true')
parser.add_argument('--hits', help='HITs to get info on', nargs="+", default=[])
args = parser.parse_args()

client = init.get_client(args.sandbox)

hits = client.list_hits(MaxResults=100)
for hit in hits['HITs']:
    if len(args.hits) > 0 and hit['HITId'] not in args.hits:
        continue
    for field, value in hit.items():
        print(field, value)
    print()
