import React, { Component } from 'react';
import { withTracker } from 'meteor/react-meteor-data';

import TextDoc from './TextDoc.jsx';
import { gup } from '../util/gup.js';

export class Instructions extends Component {
  markDone(message) {
    this.setState({
      message: message,
    });
  }

  render() {
    const inst = gup("instructions");
    if (inst != "") {
      const text = {
        "_id" : "example-text1-1",
        "tokens" : [
          {"_id": 0, "text": "How"},
          {"_id": 1, "text": "can"},
          {"_id": 2, "text": "I"},
          {"_id": 3, "text": "view"},
          {"_id": 4, "text": "my"},
          {"_id": 5, "text": "auto"},
          {"_id": 6, "text": "loan"},
          {"_id": 7, "text": "?"},
          {"_id": 8, "text": "\n"},
          {"_id": 9, "text": "If"},
          {"_id": 10, "text": "you"},
          {"_id": 11, "text": "haven't"},
          {"_id": 12, "text": "already"},
          {"_id": 13, "text": ","},
          {"_id": 14, "text": "sign"},
          {"_id": 15, "text": "up"},
          {"_id": 16, "text": "for"},
          {"_id": 17, "text": "online"},
          {"_id": 18, "text": "banking"},
          {"_id": 19, "text": "."},
          {"_id": 20, "text": "Once"},
          {"_id": 21, "text": "you"},
          {"_id": 22, "text": "enroll"},
          {"_id": 23, "text": ","},
          {"_id": 24, "text": "you"},
          {"_id": 25, "text": "can"},
          {"_id": 26, "text": "manage"},
          {"_id": 27, "text": "your"},
          {"_id": 28, "text": "auto"},
          {"_id": 29, "text": "loan"},
          {"_id": 30, "text": "account"},
          {"_id": 31, "text": "with"},
          {"_id": 32, "text": "anytime"},
          {"_id": 33, "text": ","},
          {"_id": 34, "text": "anywhere"},
          {"_id": 35, "text": "convenience"},
          {"_id": 36, "text": "."}
        ] };
      if (inst == "conditionals") {
        const annotation = {
          "_id" : "example-ann1-1",
          "user" : "server",
          "text_id" : "example-text1-1",
          "clusters" : [
            { "_id" : "mention-1-1-0",
              "mentions" : [ { "start" : 9, "end" : 18 } ],
              "color" : "blue" },
          ] };
        return (
          <div className="instructions">
            <p>
              Highlight sections of the text below that say what must happen before some action. For example:
            </p>
            <TextDoc
              className="example-textdoc"
              text={text}
              clusters={annotation.clusters}
              checks={annotation.checks}
              key={annotation._id}
              ann_id={annotation._id}
              labels={annotation.labels}
              ui={this.props.ui}
              readOnly={true}
              validate={this.markDone}
            />
            <p>
              To create a label, click and drag with your mouse.
            </p>
            <p>
              To remove a label, hold the alt key (or option key) and click inside the label.
            </p>
          </div>
        );
      } else if (inst == "actions") {
        const annotation = {
          "_id" : "example-ann1-1",
          "user" : "server",
          "text_id" : "example-text1-1",
          "clusters" : [
            { "_id" : "mention-1-1-0",
              "mentions" : [ { "start" : 14, "end" : 18 } ],
              "color" : "#45b3e0" },
            { "_id" : "mention-1-1-0",
              "mentions" : [ { "start" : 26, "end" : 30 } ],
              "color" : "#45b3e0" },
          ] };
        return (
          <div className="instructions">
            <p>
              Label parts of the text below that specify <b>an action</b>. For example:
            </p>
            <TextDoc
              className="example-textdoc"
              text={text}
              clusters={annotation.clusters}
              checks={annotation.checks}
              key={annotation._id}
              ann_id={annotation._id}
              labels={annotation.labels}
              ui={this.props.ui}
              readOnly={true}
              validate={this.markDone}
            />
            <p>
              To create a label, click and drag with your mouse.
            </p>
            <p>
              To remove a label, hold the alt key (or option key) and click inside the label.
            </p>
          </div>
        );
      } else if (inst == "conditionals-from-actions") {
        const annotation = {
          "_id" : "example-ann1-1",
          "user" : "server",
          "text_id" : "example-text1-1",
          "clusters" : [
            { "_id" : "mention-1-1-0",
              "mentions" : [ { "start" : 20, "end" : 22 } ],
              "color" : "#45b3e0" },
            { "_id" : "mention-1-1-1",
              "mentions" : [ { "start" : 26, "end" : 30 } ],
              "color" : "#45b3e0" },
          ] };
        return (
          <div className="instructions">
            <p>
              Label parts of the text below that specify <b>a requirement</b> to be able to take the highlighted action. For example:
            </p>
            <TextDoc
              className="example-textdoc"
              text={text}
              clusters={annotation.clusters}
              checks={annotation.checks}
              key={annotation._id}
              ann_id={annotation._id}
              labels={annotation.labels}
              focusMention={{ "start" : 26, "end" : 30 }}
              ui={this.props.ui}
              readOnly={true}
              validate={this.markDone}
            />
            <p>
              To create a label, click and drag with your mouse.
            </p>
            <p>
              To remove a label, hold the alt key (or option key) and click inside the label.
            </p>
          </div>
        );
      }
    }
    
    if (this.props.ui == 'mentions') {
      return (
        <div className="instructions">
          <p>Select all names in the text below.</p>
          <p>To label a word, click on it. To label two or more words, click and drag. To remove a label, click on the circle in the bottom-right corner. Once a name is selected, click on the category it belongs to:</p>
          <ul>
            <li>Person, e.g. 'Steve Jobs'</li>
            <li>Location, e.g. 'Detroit'</li>
            <li>Org, for organizations, e.g. 'Apple'</li>
            <li>Misc, for names that don't fit in the above categories, e.g. 'iPhone XR' or 'World War 2'</li>
          </ul>
        </div>
      );
    } else if (this.props.ui == 'full') {
      return (
        <div className="instructions">
          <h3>Consent Form</h3>
          <p>Since you are enrolling in this research study through the Amazon Mechanical Turk (MTurk) site, we need to let you know that information gathered through Amazon MTurk is not completely anonymous. Any work performed on Amazon MTurk can potentially be linked to information about you on your Amazon public profile page, depending on the settings you have for your Amazon profile. Any linking of data by MTurk to your ID is outside of the control of the researcher for this study. We will not be accessing any identifiable information about you that you may have put on your Amazon public profile page. We will store your MTurk worker ID separately from the other information you provide to us. Amazon Mechanical Turk has privacy policies of its own outlined for you in Amazon's privacy agreement. If you have concerns about how your information will be used by Amazon, you should consult them directly.
          </p>
          <p>This project is partially funded by the Defense Advanced Research Projects Agency (DARPA) and representatives of the Department of Defense are authorized to review research records for this project.
          </p>
          <h3>Task Overview</h3>
          <p>
            In this task you will be identifying conversations in chat logs.
          </p>
        </div>
      );
    } else if (this.props.ui == 'freq-ents') {
      const tokens = [ "Harry", "Potter", "was", "created", "by", "J.", "K.", "Rowling", "for", "seven", "books", "about", "the", "life", "of", "the", "orphan", ".", "He", "goes", "on", "adventures", "with", "his", "friends", "Ron", "and", "Hermione", "in", "which", "they", "save", "the", "world", "."];
      const raw_anno = [[0, 1, "Harry Potter"], [5, 7, ""], [9, 10, ""], [12, 16, ""], [12, 13, ""], [15, 16, "Harry Potter"], [18, 18, "Harry Potter"], [21, 21, ""], [23, 27, ""], [23, 23, "Harry Potter"], [25, 25, ""], [25, 27, ""], [27, 27, ""], [29, 29, ""], [30, 30, ""], [32, 33, ""]];
      const clusters = raw_anno.map((triple, mid) => {
        return {
          _id: "mention-"+ String(mid),
          mentions: [ { start: triple[0], end: triple[1], label: triple[2] } ],
          color: "",
        };
      });

      const text = {
        "_id" : "harry-potter-1",
        "tokens" : tokens.map((token, tid) => { return {_id: tid, text: token}; }),
      };
      const annotation = {
        "_id" : "harry-potter-ann1-1",
        "user" : "server",
        "text_id" : "harry-potter-1",
        "labels" : ["Harry Potter"],
        "checks" : [],
        "clusters" : clusters,
      };
      const label_text = this.props.labels.map(label => {
        if (label.includes("::")) {
          const parts = label.split("::");
          if (parts[0] != parts[1]) {
            label = parts[0] + "\n("+ parts[1] +")";
          } else {
            label = parts[0]
          }
        }
        return (
          <li key={label}>
            {label}
          </li>
        );
      });
      return (
        <div className="instructions">
          <h3>Task Instructions</h3>
          <p>
            In the text below this box, please label every time the following are mentioned:
          </p>
          <ul style={{whiteSpace: "pre-wrap"}}>
          {label_text}
          </ul>
          <p>
            Label when they are refered to by name (e.g., 'Hermione Granger'), using a pronoun (e.g., 'she') and in other ways (e.g., 'the student').
          </p>
          <ul>
            <li>Click on a label (the words in italics) to select it.</li>
            <li>If no label is appropriate, select nothing.</li>
            <li>To undo a label, click on it again.</li>
            <li>Only one label can be chosen for each box.</li>
            <li>When there is a smaller box inside a bigger box, consider how to label each box separately (they may have the same label, different labels, or one might have a label and the other might not).</li>
          </ul>
          <p>
            Sometimes it can be tricky to decide if something should be labeled or not, so don't worry if you are a little unsure.
            You do not need to search elsewhere to help work out the answers.
          </p>
          <p>
            For example, here is the correct way to label "Harry Potter" in a piece of text:
          </p>
            <TextDoc
              className="example-textdoc"
              text={text}
              clusters={annotation.clusters}
              checks={[]}
              key={annotation._id}
              ann_id={annotation._id}
              labelOptions={["Harry Potter"]}
              ui={this.props.ui}
              readOnly={true}
              validate={this.markDone}
              focusMention={null}
            />
          <h3>Consent Information</h3>
          <p>
            This HIT is for research by Dr. Jonathan K. Kummerfeld in Computer Science Engineering at the University of Michigan (Michigan, USA).
            I can be reached through MTurk or at <a href="mailto:jkummerf@umich.edu">jkummerf@umich.edu</a>.
            The project was approved as exempt by the <a href="https://research-compliance.umich.edu/irb-health-sciences-and-behavioral-sciences-hsbs">Michigan IRB</a> (<a href="irbhsbs@umich.edu">irbhsbs@umich.edu</a>), under study ID HUM00155689.
          </p>
          <p>
            Since you are enrolling in this research study through the Amazon Mechanical Turk (MTurk) site, we need to let you know that information gathered through Amazon MTurk is not completely anonymous. Any work performed on Amazon MTurk can potentially be linked to information about you on your Amazon public profile page, depending on the settings you have for your Amazon profile. Any linking of data by MTurk to your ID is outside of the control of the researcher for this study. We will not be accessing any identifiable information about you that you may have put on your Amazon public profile page. We will store your MTurk worker ID separately from the other information you provide to us. Amazon Mechanical Turk has privacy policies of its own outlined for you in Amazon's privacy agreement. If you have concerns about how your information will be used by Amazon, you should consult them directly.
          </p>
          <p>
            This project is partially funded by the Defense Advanced Research Projects Agency (DARPA) and representatives of the Department of Defense are authorized to review research records for this project.
          </p>
        </div>
      );
    } else if (this.props.ui.startsWith('link-to-one')) {
      return (
        <div className="instructions">
          <p>
            Click the boxes that contain references to the same thing as the text in the filled box.
          </p>
          <p>
            If you make a mistake, click the box again to deselect it.
          </p>
        </div>
      );
    } else if (this.props.ui.startsWith("check")) {
      const errors0 = (
        <p>
          A reference can be incorrect in several ways:
        </p>
      );
      const errors1 = (
        <ul>
          <li>Too long - Includes extra words.</li>
          <li>Too short - Misses words that are a key part of the reference.</li>
          <li>Invalid - Is not a reference to something at all.</li>
        </ul>
      );

      if (this.props.ui.startsWith('check-mentions')) {
        return (
          <div className="instructions">
            <p>
              Check the references to things in the text below.
            </p>
            {errors0}
            {errors1}
          </div>
        );
      } else if (this.props.ui.startsWith('check-mentions-include')) {
        return (
          <div className="instructions">
            <p>Select all names in the text below.</p>
            <p>To label a word, click on it. To label two or more words, click and drag. To remove a label, click on the circle in the bottom-right corner. Once a name is selected, click on the category it belongs to:</p>
            <ul>
              <li>Person, e.g. 'Steve Jobs'</li>
              <li>Location, e.g. 'Detroit'</li>
              <li>Org, for organizations, e.g. 'Apple'</li>
              <li>Misc, for names that don't fit in the above categories, e.g. 'iPhone XR' or 'World War 2'</li>
            </ul>
            <p>Some names have been suggested by a computer. They may not be correct. Click on suggestions that are correct to add them, correcting the category if necessary. Also label any missing names. If a suggestion is not a name you may ignore it.</p>
          </div>
        );
      } else if (this.props.ui.startsWith('check-mentions-exclude')) {
        return (
          <div className="instructions">
            <p>Select all names in the text below.</p>
            <p>To label a word, click on it. To label two or more words, click and drag. To remove a label, click on the circle in the bottom-right corner. Once a name is selected, click on the category it belongs to:</p>
            <ul>
              <li>Person, e.g. 'Steve Jobs'</li>
              <li>Location, e.g. 'Detroit'</li>
              <li>Org, for organizations, e.g. 'Apple'</li>
              <li>Misc, for names that don't fit in the above categories, e.g. 'iPhone XR' or 'World War 2'</li>
            </ul>
            <p>Some names have been suggested by a computer. They may not be correct. Click on suggestions that are incorrect to remove them. If only the category is incorect, click the category and select the right option. Also label any names the computer missed. </p>
          </div>
        );
      }
    } else {
      return (
        <div className="instructions">
          <p>
            Instructions are Loading...
          </p>
        </div>
      );
    }
  }
}

export default InstructionContainer = withTracker(() => {
  return {
  };
})(Instructions);
