import tweepy
import pandas as pd
import re

def chunks(lst, n):
		"""Yield successive n-sized chunks from lst."""
		for i in range(0, len(lst), n):
				yield lst[i:i + n]

def replace_all(text: str, dic: dict):
	for i, j in dic.items():
		text = text.replace(i, j)
	return text

# replace chars
url_dict = {
	"\n": " ",
	"&amp;": "&",
	"&gt;": ">",
	"&lt;": "<"
}
# regex for removal of URLs in Tweets
regex = r"http\S+"

consumer_key = "consumer_key"
consumer_secret = "consumer_secret"
access_token = "access_token"
access_token_secret = "access_token_secret"
auth = tweepy.OAuthHandler(consumer_key, consumer_secret)
auth.set_access_token(access_token, access_token_secret)
api = tweepy.API(auth)

datasource = "student" # change to expert if required

if datasource == "student":
	inputpath = "./studentdata.csv"
	outputpath = "./studentdata_retrieved.tsv"
else:
	inputpath = "./expertdata.csv"
	outputpath = "./expertdata_retrieved.tsv"
df = pd.read_csv(inputpath, dtype=str)
#  read data 
id_list = list(df.id_str.values)
full_texts = ["" for i in range(len(id_list))]
error = 0
for chunk in chunks(id_list, 100):
	try:
		results = api.statuses_lookup(chunk, tweet_mode='extended')
		print(len(results))
	except Exception as e:
		print(e)
	for res in results:
		# get index of respective tweet ID
		id_idx = id_list.index(res._json["id_str"])
		# replace web symbols and remove URLs
		txt = re.sub(regex, '', res._json['full_text']).strip()
		txt = replace_all(txt, url_dict)
		full_texts[id_idx] = txt

df["full_text"] = full_texts
df.to_csv(outputpath, sep="\t", index=False) # replace output path with expertfile
