
(* #load "str.cmxa";; *)
(* #load "scripts/trees.ml";; *)

open Str
open String
open Trees


(* formatting exception *)
exception WrongFormat of string;;


let word_out = ref "- -";;
let mhmh_out = ref "- -";;
let mhhmh_out = ref "- -";;
let mhmmh_out = ref "- -";;
let mhhhmh_out = ref "- -";;

(* get dat items *)
let rec write_top_words = function
    (ChildList(Term(sP),ChildList(lchL,ChildList(lchR,End))),lpath) when string_match (regexp "\\(.*\\):\\(.*\\){\\(.*\\)}\\(\\^\\([LR]\\),\\([0-9]\\)\\)?") sP 0 ->
      let lP = matched_group 1 sP in
      let cP = matched_group 2 sP in
      let hP = matched_group 3 sP in
      let lpath = lpath^(string_before lP 1) in
      let (lL,cL,hL) = write_top_words (lchL,lpath) in
      let (lR,cR,hR) = write_top_words (lchR,lpath) in
      (lP,cP,hP);
  | (ChildList(Term(sP),ChildList(Term(_) as px,End)),lpath) when string_match (regexp "\\(.*\\):\\(.*\\){\\(.*\\)}\\(\\^\\([LR]\\),\\([0-9]\\)\\)?") sP 0 ->
      let l = matched_group 1 sP in
      let c = matched_group 2 sP in
      let h = matched_group 3 sP in
      let lpath = lpath^(string_before l 1)  in
      (*print_endline (u^" "^d^" "^l^" "^c^" "^h^" "^lpath);*)
      let (p,x,_) = write_top_words (px,lpath) in
      if (string_match (regexp "^mh*$") lpath 0 ) then
        word_out := c^" "^x
      else if (string_match (regexp "^mhmh*$") lpath 0) then
        mhmh_out := c^" "^x
      else if (string_match (regexp "^mhhmh*$") lpath 0) then
        mhhmh_out := c^" "^x
      else if (string_match (regexp "^mhmmh*$") lpath 0) then
        mhmmh_out := c^" "^x
      else if (string_match (regexp "^mhhhmh*$") lpath 0) then
        mhhhmh_out := c^" "^x;
      (l,c,h)
  | (ChildList(Term(sP),_   ),lpath) -> raise (WrongFormat sP)
  | (ChildList(lch,     End ),lpath) -> write_top_words(lch,lpath)
  | (ChildList(lchL,    lchR),lpath) -> raise (WrongFormat "unlabeled binary branch")
  | (Term(s),lpath) when string_match (regexp "\\(.*\\)#\\(.*\\)") s 0 ->
      (matched_group 1 s, matched_group 2 s, "")
  | (Term(s),lpath)                  -> raise (WrongFormat s)
  | (End,lpath)                      -> raise (WrongFormat "unexpected end");;


(* read loop *)
try
  while true do
    let s = input_line stdin in
    let r,t = tree_of_string s in
    let lpath = "" in
    let (l,c,h) = write_top_words (t,lpath) in
    print_endline (!word_out ^" "^(!mhmh_out)^" "^(!mhhmh_out)^" "^(!mhmmh_out)^" "^(!mhhhmh_out));
    ()
  done;
  None
with
  End_of_file -> None
;;



