///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "nl-cpt.h"
#include "nl-dtree.h"
#include "TextObsVars.h"

////////////////////////////////////////////////////////////////////////////////
//
//  Models
//
////////////////////////////////////////////////////////////////////////////////

class XModel {

 private:

  // Data members...
  //HModel                          modHgivLCI_as_LCHtoE;
  //RandAccCPT2DModel<C,P,Prob>     modCgivP;
  RandAccCPT3DModel<H,C,I,Prob>   modHgivCI;
  TrainableDTree2DModel<P,X,Prob> modPgivXdt;
  RandAccCPT2DModel<P,W,Prob>     modPgivW;
  HidVarCPT2DModel<P,C,Prob>      modPgivC;
  RandAccCPT1DModel<P,Prob>       modP;
  RandAccCPT1DModel<W,Prob>       modW;

 public:

  typedef X RandVarType;

  // Extraction methods...
  Prob getProb ( const X& x, const GI& gi ) const {
    return getProb ( x, gi.first.getC(), gi.second );
  }
  Prob getProb ( const X& x, const C& c, const I& i ) const {
    Prob pr=0.0;
////    const C& c = g.second.second;
//    const C& c = g.second; //g.getC();
    H h(x);
    W w(x);
    if ( h != H_UNK ) {
      pr = modHgivCI.getProb(h,c,i);
      //cerr<<" ***it's "<<g<<" and "<<h<<"\n";
////      pr += ( modHgivLCI_as_LCHtoE.get(g).contains(h)     ) ? modHgivLCI_as_LCHtoE.get(g).get(h    ).get(i,0) : Prob(0.0);
      //pr += ( modHgivLCI_as_LCHtoE.get(g).contains(H_UNK) ) ? modHgivLCI_as_LCHtoE.get(g).get(H_UNK).get(i,0) : Prob(0.0);
      //if ( pr > 0.0 ) cerr<<" >>H "<<x<<" "<<pr<<"\n";
    } else if ( w != W_UNK ) {
      //P::ArrayIterator<Prob> p; int aCtr=-1;
      //for (Prob pr=modPgivC.setIterProb(p,c,aCtr); pr!=LogProb(); pr = modPgivC.setIterProb(p,c,aCtr=0) )
      for ( P::ArrayIterator<Prob> p = modPgivC.begin(c); !p.end(); ++p ) {
        //pr += modPgivC.getProb(p,c) * modPgivW.getProb(p,w) * LogProb(-1000).toProb() * modHgivCI.getProb(H_UNK,c,i) / modP.getProb(p);
        pr += modPgivC.getProb(p,c) * modPgivW.getProb(p,w) * LogProb(-1000).toProb() / modP.getProb(p);
      }
      pr *= modHgivCI.getProb(h,c,i);
      ////      pr *= ( modHgivLCI_as_LCHtoE.get(g).contains(H_UNK) ) ? modHgivLCI_as_LCHtoE.get(g).get(H_UNK).get(i,0) : Prob(0.0);
      //if ( pr > 0.0 ) cerr<<" >>W "<<x<<" "<<pr<<"\n";
    } else {
      //P::ArrayIterator<Prob> p; int aCtr=-1;
      //for (Prob pr=modPgivC.setIterProb(p,c,aCtr); pr!=LogProb(); pr = modPgivC.setIterProb(p,c,aCtr=0) )
      for ( P::ArrayIterator<Prob> p = modPgivC.begin(c); !p.end(); ++p ) {
        //pr += modPgivC.getProb(p,c) * modPgivXdt.getProb(p,x) * LogProb(-1000).toProb() * modHgivCI.getProb(H_UNK,c,i) / modP.getProb(p);
        pr += modPgivC.getProb(p,c) * modPgivXdt.getProb(p,x) * LogProb(-1000).toProb() / modP.getProb(p);
      }
      pr *= modHgivCI.getProb(h,c,i);
      ////      pr *= ( modHgivLCI_as_LCHtoE.get(g).contains(H_UNK) ) ? modHgivLCI_as_LCHtoE.get(g).get(H_UNK).get(i,0) : Prob(0.0);
      //if ( pr > 0.0 ) cerr<<" >>X "<<x<<" "<<pr<<"\n";
    }
    //cout<<" "<<c<<" "<<h<<" "<<w<<" "<<pr<<"\n";
    return pr;
  }
  /*
  IndexedVector getVec ( const X& x, const G& g ) const {
    IndexedVector e;
    const C& c = g.second; //g.getC();
    H h(x);
    W w(x);
    if ( w != W_UNK ) {
      for ( P::ArrayIterator<Prob> p = modPgivC.begin(c); !p.end(); ++p ) {
        e = e + modPgivC.getProb(p,c) * modPgivW.getProb(p,w) * LogProb(-1000).toProb() / modP.getProb(p);
      }
      //e = e * modHgivCI.get(g).get(H_UNK);
    } else {
      for ( P::ArrayIterator<Prob> p = modPgivC.begin(c); !p.end(); ++p ) {
        e = e + modPgivC.getProb(p,c) * modPgivXdt.getProb(p,x) * LogProb(-1000).toProb() / modP.getProb(p);
      }
      //e = e * modHgivCI.get(g).get(H_UNK);
    }
    if ( h != H_UNK ) {
      //e = e + modHgivCI.get(g).get(h);
    }
    return e;
  }
  */
  LogProb getProb ( const X& x, const C& c ) const {
    return LogProb(1.0);
  }

  // Input/output methods...
  friend pair<StringInput,XModel*> operator>> ( StringInput si, XModel& m ) { return pair<StringInput,XModel*>(si,&m); }
  friend StringInput operator>> ( pair<StringInput,XModel*> si_m, const char* psD ) {
    StringInput si;
    return ( (si=si_m.first>>"H "   >>si_m.second->modHgivCI >>psD)!=NULL ||
             (si=si_m.first>>"Pc "  >>si_m.second->modPgivC  >>psD)!=NULL ||
             (si=si_m.first>>"W "   >>si_m.second->modW      >>psD)!=NULL ||
             (si=si_m.first>>"Pw "  >>si_m.second->modPgivW  >>psD)!=NULL ||
             (si=si_m.first>>"PwDT ">>si_m.second->modPgivXdt>>psD)!=NULL ||
             (si=si_m.first>>"P "   >>si_m.second->modP      >>psD)!=NULL ) ? si : StringInput(NULL);
  }
};

