// $Id: ChartTrellisPath.h 3360 2010-07-17 23:23:09Z hieuhoang1972 $
// vim:tabstop=2
/***********************************************************************
 Moses - factored phrase-based language decoder
 Copyright (C) 2010 Hieu Hoang
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ***********************************************************************/

#pragma once

#include "ChartTrellisNode.h"
#include "../../moses/src/ScoreComponentCollection.h"
#include "../../moses/src/Phrase.h"

namespace MosesChart
{
class Hypothesis;
class TrellisPathCollection;

class TrellisPath
{
	friend std::ostream& operator<<(std::ostream&, const TrellisPath&);

protected:
	// recursively point backwards
	TrellisNode *m_finalNode;
	const TrellisNode *m_prevNodeChanged;
	const TrellisPath *m_prevPath;

	Moses::ScoreComponentCollection	m_scoreBreakdown;
	float m_totalScore;

	// deviate by 1 hypo
	TrellisPath(const TrellisPath &origPath
						, const TrellisNode &soughtNode
						, const Hypothesis &replacementHypo
						, Moses::ScoreComponentCollection	&scoreChange);

	void CreateDeviantPaths(TrellisPathCollection &pathColl, const TrellisNode &soughtNode) const;

	const TrellisNode &GetFinalNode() const
	{ 
		assert (m_finalNode);
		return *m_finalNode;	
	}

public:
	TrellisPath(const Hypothesis *hypo);
	~TrellisPath();

	//! get score for this path throught trellis
	inline float GetTotalScore() const 
	{ return m_totalScore; }

	Moses::Phrase GetOutputPhrase() const;

	/** returns detailed component scores */
	inline const Moses::ScoreComponentCollection &GetScoreBreakdown() const
	{
		return m_scoreBreakdown;
	}

	void CreateDeviantPaths(TrellisPathCollection &pathColl) const;
};


}

