import json
import random


def read_json_file(file_path):
    """
    Read data from a JSON file at the specified path.

    Args:
        file_path (str): The path of the JSON file to be read.

    Returns:
        list: A list containing JSON objects read from the file.
    """
    data_list = []
    with open(file_path, 'r') as file:
        for line in file:
            if line.strip():
                data_list.append(json.loads(line))
    return data_list


def format_records(data):
    """
    Format raw data into a specific record format.

    Args:
        data (list): A list of raw data, each element is a dictionary.

    Returns:
        list: A list of formatted records, each record contains an id and conversation content.
    """
    records = []
    for idx, record in enumerate(data):
        formatted_record = {
            "id": str(idx),
            "conversations": [
                {"from": "human", "value": record["prompt"]},
                {"from": "gpt", "value": record["output"]}
            ]
        }
        records.append(formatted_record)
    return records


def write_json_file(data, file_path):
    """
    Write data to a JSON file.

    Args:
        data (list): The data to be written to the file.
        file_path (str): The path of the target JSON file.

    Returns:
        None
    """
    with open(file_path, 'w', encoding='utf-8') as file:
        json.dump(data, file, indent=2, ensure_ascii=False)


def trans_to_vicuna_format(args):
    """

    Args:
        args ():

    Returns:

    """
    try:
        input_data = read_json_file(args.input_file)
        formatted_data = format_records(input_data)
        random.shuffle(formatted_data)
        write_json_file(formatted_data, args.output_file)
    except Exception as e:
        print(f"Error occurred: {e}")
