from .playwright_based_crawl_new import get_raw_pages
from .import playwright_based_crawl_new

import asyncio
    
from typing import List, Dict

class Fetcher:
    def __init__(self):
        self.loop = asyncio.get_event_loop()

    
    def _pre_handle_urls(self, urls):
        """
        在处理URL之前，对URL进行一些预处理，包括：
            1. 如果URL不是以"http"开头的，则加上"http://"；
            2. 如果URL已经出现过，则跳过该URL；
            3. 将处理后的URL放入一个新列表中返回。
        
        Args:
            urls (list): URL列表，每个元素为str类型，代表一个URL。
        
        Returns:
            list: 一个新的URL列表，每个元素为str类型，代表一个URL，并且没有重复的URL。
        
        """
        urls_new = []
        for url in urls:
            if url in urls_new or "http://%s"%url in urls_new or "https://%s"%url in urls_new:
                continue
            if not url.startswith("http"):
                url = "http://%s" % url
            urls_new.append(url)
        return urls_new

    def fetch(self, urls):
        """
        执行一次爬取任务，返回一个字典，key为传入的URL列表中的每一个URL，value为对应的HTML内容。如果出现错误，则返回None。
        
        Args:
            urls (list[str]): URL列表，每个元素都是一个字符串，代表要爬取的网页地址。
        
        Returns:
            dict: 一个字典，key为传入的URL列表中的每一个URL，value为对应的HTML内容。如果出现错误，则返回None。
        
            示例：{
                    "https://www.baidu.com": "<!DOCTYPE html><html>...</html>",
                    "https://www.sina.com.cn": None
                }
        
        Raises:
            None
        
        """
        
        urls = self._pre_handle_urls(urls)
        
        self.loop.run_until_complete(get_raw_pages(urls, close_browser=True))
        responses = [playwright_based_crawl_new.results[url] for url in urls] 

        ret = dict()
        for url, resp in zip(urls, responses):
            if not resp[1]:
                pass
            else:
                ret[url] = resp[1]

        return ret
