import requests 
from time import sleep
from requests.exceptions import Timeout
import json 
import re
import traceback
from tqdm import tqdm
import os

def eval_python(code, testcase):
    local_var = {}
    exit_code = None
    try:
        function = ''
        if "```python" in code:
            function = code.split("```python")[1].split("```")[0] if "```" in code else code.strip(".")
        else:
            function = code.split("python```")[1].split("```")[0] if "```" in code else code.strip(".")
        function = function + "\n" + testcase
        # print(function)
        # print("-----------------------------------------------------------------------------------------------")
        # import library. Note that the library must be imported before the function is executed.
        import_lib = [i for i in function.split("\n") if i.startswith("import ") or i.startswith("from ")]
        LIBVAR = locals()
        exec("\n".join(import_lib), globals(), LIBVAR)
        GLOBALVAR = globals()
        GLOBALVAR.update(LIBVAR)

        exec("\n".join([function]), GLOBALVAR, local_var)
        exit_code = 0
        return {"exit_code": exit_code,"function": function, "input": testcase,"output":local_var["result"]}
    except KeyError as e:
        if str(e) == "'result'":
            exit_code = 0
            return {"exit_code": exit_code,"function": function,"input": testcase,"output":'<The test case does not return an output>'}
    except:
        exc_info=traceback.format_exc()
        error_line = None
        if "File \"<string>\"," in exc_info:
            pattern = r'File "<string>", line (\d+)'  
            match = re.search(pattern, exc_info)  
            
            if match:  
                line_number = match.group(1)  
                error_line=function.split("\n")[int(line_number)-1]

        # print("[KeyError]", "\n".join(traceback.format_exc().split("\n")[3:]))
        # print(f"Error line: {error_line}")
        # print(f"Code: {code}")
        exit_code = 1
        return {"exit_code": exit_code,"function": function,"input": testcase, 'output': None, "error":exc_info.strip().splitlines()[-1], "error_line": error_line}


if __name__ == "__main__":
    model_name = ""
    predict_path = f""
    data_path = ''
    output_dir = ""
    if not os.path.exists(output_dir):
        os.makedirs(output_dir)

    output_path = output_dir + ""
    test_idx = 10

    with open(data_path, "r") as input_file:
        data_lines = input_file.readlines()

    with open(predict_path, "r") as input_file, open(output_path, "a") as output_file:
        for i,line in tqdm(enumerate(input_file)):
            tests = ''
            data = json.loads(line)
            predict_code = data['predict']
            test_code = json.loads(data_lines[test_idx + i])
            tests += '\n'.join(test_code["test_list"])
            eval_data = eval_python(predict_code,tests)
            output_file.write(json.dumps(eval_data) + '\n')