
# prefix num and model size
  i=16
  size="base"

# server environment
  base_dir=" "

  data_dir="${base_dir}/path/to/data"
  output_path="${base_dir}/output/PGF_${size}/gqa/${i}/"
  oscar_base_model_path="${base_dir}/path/to/oscar/pre-trained/model/${size}/"

# output
  model_path="${output_path}/wandb/latest-run/files/best"
  eval_output_path="${output_path}/wandb/latest-run/files"

# input
  train_yaml="${data_dir}/train.yaml"
  test_yaml="${data_dir}/test.yaml"
  val_yaml="${data_dir}/val.yaml"
  label2ans_file="${data_dir}/trainval_testdev_all_label2ans.pkl"
  ans2label_file="${data_dir}/trainval_testdev_all_ans2label.pkl"

  seed=88
  random_id=$(cat /dev/urandom | tr -dc 'A-Z' | fold -w 2 | sed 1q)

# PT step
  torchrun \
  --nproc_per_node=8 \
  ./task/vqa/main.py \
  --cfg ./config/vqa/base_reproduce.yaml  \
  --data_dir ${data_dir} \
  --train_yaml ${train_yaml} \
  --test_yaml ${test_yaml} \
  --val_yaml ${val_yaml} \
  --label2ans_file ${label2ans_file} \
  --ans2label_file ${ans2label_file} \
  --name "PGF-${size}-16-pt-drop+shuffle_seed_${seed}_id_${random_id}" \
  --scheduler "plateau_linear" \
  --plateau_step_ratio 0.3 \
  --num_train_epochs 50 \
  --learning_rate 1e-04 \
  --max_grad_norm 1.0 \
  --prefix_drop_prob 0.05 \
  --prefix_shuffle_prob 0.15 \
  --per_gpu_train_batch_size 64 \
  --freeze_backbone True \
  --add_prefix True \
  --freeze_prefix False \
  --mlp_for_prefix True \
  --num_prefix 16 \
  --tag_sep_token False \
  --freeze_embedding True \
  --classifier mlp \
  --seed ${seed} \
  --model_name_or_path ${oscar_base_model_path} \
  --output_dir ${output_path} \

  torchrun \
  --nproc_per_node=8 \
  ./task/vqa/main.py \
  --cfg ./config/vqa/base_reproduce.yaml  \
  --data_dir ${data_dir} \
  --train_yaml ${train_yaml} \
  --test_yaml ${test_yaml} \
  --val_yaml ${val_yaml} \
  --label2ans_file ${label2ans_file} \
  --ans2label_file ${ans2label_file} \
  --do_train False \
  --do_test True \
  --add_prefix True \
  --num_prefix 16 \
  --tag_sep_token False \
  --eval_model_dir ${model_path} \
  --output_dir ${eval_output_path}

  seed=88
  random_id=$(cat /dev/urandom | tr -dc 'A-Z' | fold -w 2 | sed 1q)
  prefix_model=$(readlink -f ${model_path})

# Refining step
  torchrun \
  --nproc_per_node=8 \
  ./task/vqa/main.py \
  --cfg ./config/vqa/base_reproduce.yaml  \
  --data_dir ${data_dir} \
  --train_yaml ${train_yaml} \
  --test_yaml ${test_yaml} \
  --val_yaml ${val_yaml} \
  --label2ans_file ${label2ans_file} \
  --ans2label_file ${ans2label_file} \
  --name "PGF-${size}-16-from_trained_prefix_seed_${seed}_id_${random_id}" \
  --scheduler "plateau_linear" \
  --warmup_step_ratio 0.1 \
  --plateau_step_ratio 0.2 \
  --num_train_epochs 25 \
  --learning_rate 1e-05 \
  --max_grad_norm 1.0 \
  --prefix_drop_prob 0.05 \
  --prefix_shuffle_prob 0.15 \
  --per_gpu_train_batch_size 64 \
  --add_prefix True \
  --freeze_backbone False \
  --freeze_prefix False \
  --mlp_for_prefix True \
  --num_prefix 16 \
  --tag_sep_token False \
  --freeze_embedding True \
  --classifier mlp \
  --seed ${seed} \
  --model_name_or_path ${prefix_model} \
  --output_dir ${output_path} \

  torchrun \
  --nproc_per_node=8 \
  ./task/vqa/main.py \
  --cfg ./config/vqa/base_reproduce.yaml  \
  --data_dir ${data_dir} \
  --train_yaml ${train_yaml} \
  --test_yaml ${test_yaml} \
  --val_yaml ${val_yaml} \
  --label2ans_file ${label2ans_file} \
  --ans2label_file ${ans2label_file} \
  --do_train False \
  --do_test True \
  --add_prefix True \
  --num_prefix 16 \
  --tag_sep_token False \
  --eval_model_dir ${model_path} \
  --output_dir ${eval_output_path}



