import re
import os
import torch
import random
import numpy as np
import logging
import fasttext
from datetime import datetime


def set_logger():
    if not os.path.exists("logs"):
        os.makedirs("logs")

    now = datetime.now().strftime("%Y%m%d_%H%M%S")

    logging.basicConfig(
        filename=f"logs/{now}.log",
        filemode="w",
        level=logging.INFO,
        format="%(asctime)s %(levelname)s %(message)s",
        datefmt="%Y-%m-%d %H:%M:%S",
    )

    logger = logging.getLogger("logger")
    logger.setLevel(logging.DEBUG)

    fh = logging.FileHandler(filename=f"logs/{now}.log")
    fh.setLevel(logging.DEBUG)

    formatter = logging.Formatter(
        "%(asctime)s %(levelname)s %(message)s", "%Y-%m-%d %H:%M:%S"
    )
    fh.setFormatter(formatter)

    # add ch to logger
    logger.addHandler(fh)

    return logger


class LanguageDetector:
    def __init__(self):
        pretrained_lang_model = "./lid.176.bin"
        self.model = fasttext.load_model(pretrained_lang_model)

    def predict_lang(self, text):
        predictions = self.model.predict(text, k=1)
        return predictions
