/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.graph;

import edu.stanford.nlp.graph.ConnectedComponents;
import edu.stanford.nlp.graph.DijkstraShortestPath;
import edu.stanford.nlp.graph.Graph;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.MapFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class DirectedMultiGraph<V, E>
implements Graph<V, E> {
    final Map<V, Map<V, List<E>>> outgoingEdges;
    final Map<V, Map<V, List<E>>> incomingEdges;
    final MapFactory<V, Map<V, List<E>>> outerMapFactory;
    final MapFactory<V, List<E>> innerMapFactory;
    private static final long serialVersionUID = 609823567298345145L;

    public DirectedMultiGraph() {
        this(MapFactory.hashMapFactory(), MapFactory.hashMapFactory());
    }

    public DirectedMultiGraph(MapFactory<V, Map<V, List<E>>> outerMapFactory, MapFactory<V, List<E>> innerMapFactory) {
        this.outerMapFactory = outerMapFactory;
        this.innerMapFactory = innerMapFactory;
        this.outgoingEdges = outerMapFactory.newMap();
        this.incomingEdges = outerMapFactory.newMap();
    }

    public DirectedMultiGraph(DirectedMultiGraph<V, E> graph) {
        this(graph.outerMapFactory, graph.innerMapFactory);
        Map edgesCopy;
        for (Map.Entry<V, Map<V, List<E>>> map : graph.outgoingEdges.entrySet()) {
            edgesCopy = this.innerMapFactory.newMap();
            for (Map.Entry<V, List<E>> entry : map.getValue().entrySet()) {
                edgesCopy.put(entry.getKey(), Generics.newArrayList((Collection)entry.getValue()));
            }
            this.outgoingEdges.put(map.getKey(), edgesCopy);
        }
        for (Map.Entry<V, Map<V, List<E>>> map : graph.incomingEdges.entrySet()) {
            edgesCopy = this.innerMapFactory.newMap();
            for (Map.Entry<V, List<E>> entry : map.getValue().entrySet()) {
                edgesCopy.put(entry.getKey(), Generics.newArrayList((Collection)entry.getValue()));
            }
            this.incomingEdges.put(map.getKey(), edgesCopy);
        }
    }

    public int hashCode() {
        return ((Object)this.outgoingEdges).hashCode();
    }

    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (!(that instanceof DirectedMultiGraph)) {
            return false;
        }
        return ((Object)this.outgoingEdges).equals(((DirectedMultiGraph)that).outgoingEdges);
    }

    @Override
    public boolean addVertex(V v) {
        if (this.outgoingEdges.containsKey(v)) {
            return false;
        }
        this.outgoingEdges.put((Map<V, List<E>>)v, (Map<Map<V, List<E>>, List<E>>)this.innerMapFactory.newMap());
        this.incomingEdges.put((Map<V, List<E>>)v, (Map<Map<V, List<E>>, List<E>>)this.innerMapFactory.newMap());
        return true;
    }

    private Map<V, List<E>> getOutgoingEdgesMap(V v) {
        Map<V, List<E>> map = this.outgoingEdges.get(v);
        if (map == null) {
            map = this.innerMapFactory.newMap();
            this.outgoingEdges.put((Map<V, List<E>>)v, (Map<Map<V, List<E>>, List<E>>)map);
            this.incomingEdges.put((Map<V, List<E>>)v, (Map<Map<V, List<E>>, List<E>>)this.innerMapFactory.newMap());
        }
        return map;
    }

    private Map<V, List<E>> getIncomingEdgesMap(V v) {
        Map<V, List<E>> map = this.incomingEdges.get(v);
        if (map == null) {
            this.outgoingEdges.put((Map<V, List<E>>)v, (Map<Map<V, List<E>>, List<E>>)this.innerMapFactory.newMap());
            map = this.innerMapFactory.newMap();
            this.incomingEdges.put((Map<V, List<E>>)v, (Map<Map<V, List<E>>, List<E>>)map);
        }
        return map;
    }

    @Override
    public void add(V source, V dest, E data) {
        List<E> incomingList;
        Map<List<E>, List<E>> outgoingMap = this.getOutgoingEdgesMap(source);
        Map<List<E>, List<E>> incomingMap = this.getIncomingEdgesMap(dest);
        List<E> outgoingList = outgoingMap.get(dest);
        if (outgoingList == null) {
            outgoingList = new ArrayList();
            outgoingMap.put((List<E>)dest, outgoingList);
        }
        if ((incomingList = incomingMap.get(source)) == null) {
            incomingList = new ArrayList();
            incomingMap.put((List<E>)source, incomingList);
        }
        outgoingList.add(data);
        incomingList.add(data);
    }

    @Override
    public boolean removeEdges(V source, V dest) {
        if (!this.outgoingEdges.containsKey(source)) {
            return false;
        }
        if (!this.incomingEdges.containsKey(dest)) {
            return false;
        }
        if (!this.outgoingEdges.get(source).containsKey(dest)) {
            return false;
        }
        this.outgoingEdges.get(source).remove(dest);
        this.incomingEdges.get(dest).remove(source);
        return true;
    }

    @Override
    public boolean removeEdge(V source, V dest, E data) {
        boolean foundIn;
        if (!this.outgoingEdges.containsKey(source)) {
            return false;
        }
        if (!this.incomingEdges.containsKey(dest)) {
            return false;
        }
        if (!this.outgoingEdges.get(source).containsKey(dest)) {
            return false;
        }
        boolean foundOut = this.outgoingEdges.containsKey(source) && this.outgoingEdges.get(source).containsKey(dest) && this.outgoingEdges.get(source).get(dest).remove(data);
        boolean bl = foundIn = this.incomingEdges.containsKey(dest) && this.incomingEdges.get(dest).containsKey(source) && this.incomingEdges.get(dest).get(source).remove(data);
        if (foundOut && !foundIn) {
            throw new AssertionError((Object)"Edge found in outgoing but not incoming");
        }
        if (foundIn && !foundOut) {
            throw new AssertionError((Object)"Edge found in incoming but not outgoing");
        }
        if (this.outgoingEdges.containsKey(source) && (!this.outgoingEdges.get(source).containsKey(dest) || this.outgoingEdges.get(source).get(dest).size() == 0)) {
            this.outgoingEdges.get(source).remove(dest);
        }
        if (this.incomingEdges.containsKey(dest) && (!this.incomingEdges.get(dest).containsKey(source) || this.incomingEdges.get(dest).get(source).size() == 0)) {
            this.incomingEdges.get(dest).remove(source);
        }
        return foundOut;
    }

    @Override
    public boolean removeVertex(V vertex) {
        if (!this.outgoingEdges.containsKey(vertex)) {
            return false;
        }
        for (V other : this.outgoingEdges.get(vertex).keySet()) {
            this.incomingEdges.get(other).remove(vertex);
        }
        for (V other : this.incomingEdges.get(vertex).keySet()) {
            this.outgoingEdges.get(other).remove(vertex);
        }
        this.outgoingEdges.remove(vertex);
        this.incomingEdges.remove(vertex);
        return true;
    }

    @Override
    public boolean removeVertices(Collection<V> vertices) {
        boolean changed = false;
        for (V v : vertices) {
            if (!this.removeVertex(v)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public int getNumVertices() {
        return this.outgoingEdges.size();
    }

    @Override
    public List<E> getOutgoingEdges(V v) {
        if (!this.outgoingEdges.containsKey(v)) {
            return Collections.emptyList();
        }
        return CollectionUtils.flatten(this.outgoingEdges.get(v).values());
    }

    @Override
    public List<E> getIncomingEdges(V v) {
        if (!this.incomingEdges.containsKey(v)) {
            return Collections.emptyList();
        }
        return CollectionUtils.flatten(this.incomingEdges.get(v).values());
    }

    @Override
    public int getNumEdges() {
        int count = 0;
        for (Map.Entry<V, Map<V, List<E>>> sourceEntry : this.outgoingEdges.entrySet()) {
            for (Map.Entry<V, List<E>> destEntry : sourceEntry.getValue().entrySet()) {
                count += destEntry.getValue().size();
            }
        }
        return count;
    }

    @Override
    public Set<V> getParents(V vertex) {
        Map<V, List<E>> parentMap = this.incomingEdges.get(vertex);
        if (parentMap == null) {
            return null;
        }
        return Collections.unmodifiableSet(parentMap.keySet());
    }

    @Override
    public Set<V> getChildren(V vertex) {
        Map<V, List<E>> childMap = this.outgoingEdges.get(vertex);
        if (childMap == null) {
            return null;
        }
        return Collections.unmodifiableSet(childMap.keySet());
    }

    @Override
    public Set<V> getNeighbors(V v) {
        Set<V> children = this.getChildren(v);
        Set<V> parents = this.getParents(v);
        if (children == null && parents == null) {
            return null;
        }
        Set<V> neighbors = this.innerMapFactory.newSet();
        neighbors.addAll(children);
        neighbors.addAll(parents);
        return neighbors;
    }

    @Override
    public void clear() {
        this.incomingEdges.clear();
        this.outgoingEdges.clear();
    }

    @Override
    public boolean containsVertex(V v) {
        return this.outgoingEdges.containsKey(v);
    }

    @Override
    public boolean isEdge(V source, V dest) {
        Map<V, List<E>> childrenMap = this.outgoingEdges.get(source);
        if (childrenMap == null || childrenMap.isEmpty()) {
            return false;
        }
        List<E> edges = childrenMap.get(dest);
        if (edges == null || edges.isEmpty()) {
            return false;
        }
        return edges.size() > 0;
    }

    @Override
    public boolean isNeighbor(V source, V dest) {
        return this.isEdge(source, dest) || this.isEdge(dest, source);
    }

    @Override
    public Set<V> getAllVertices() {
        return Collections.unmodifiableSet(this.outgoingEdges.keySet());
    }

    @Override
    public List<E> getAllEdges() {
        ArrayList<E> edges = new ArrayList<E>();
        for (Map<V, List<E>> e : this.outgoingEdges.values()) {
            for (List<E> ee : e.values()) {
                edges.addAll(ee);
            }
        }
        return edges;
    }

    @Override
    public boolean isEmpty() {
        return this.outgoingEdges.isEmpty();
    }

    @Override
    public void removeZeroDegreeNodes() {
        ArrayList<V> toDelete = new ArrayList<V>();
        for (Object vertex : this.outgoingEdges.keySet()) {
            if (!this.outgoingEdges.get(vertex).isEmpty() || !this.incomingEdges.get(vertex).isEmpty()) continue;
            toDelete.add(vertex);
        }
        for (Object vertex : toDelete) {
            this.outgoingEdges.remove(vertex);
            this.incomingEdges.remove(vertex);
        }
    }

    @Override
    public List<E> getEdges(V source, V dest) {
        Map<V, List<E>> childrenMap = this.outgoingEdges.get(source);
        if (childrenMap == null) {
            return Collections.emptyList();
        }
        List<E> edges = childrenMap.get(dest);
        if (edges == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(edges);
    }

    public List<V> getShortestPath(V node1, V node2) {
        if (!this.outgoingEdges.containsKey(node1) || !this.outgoingEdges.containsKey(node2)) {
            return null;
        }
        return this.getShortestPath(node1, node2, false);
    }

    public List<E> getShortestPathEdges(V node1, V node2) {
        return this.convertPath(this.getShortestPath(node1, node2), false);
    }

    public List<V> getShortestPath(V node1, V node2, boolean directionSensitive) {
        if (!this.outgoingEdges.containsKey(node1) || !this.outgoingEdges.containsKey(node2)) {
            return null;
        }
        return DijkstraShortestPath.getShortestPath(this, node1, node2, directionSensitive);
    }

    public List<E> getShortestPathEdges(V node1, V node2, boolean directionSensitive) {
        return this.convertPath(this.getShortestPath(node1, node2, directionSensitive), directionSensitive);
    }

    public List<E> convertPath(List<V> nodes, boolean directionSensitive) {
        if (nodes == null) {
            return null;
        }
        if (nodes.size() <= 1) {
            return Collections.emptyList();
        }
        ArrayList<Object> path = new ArrayList<Object>();
        Iterator<V> nodeIterator = nodes.iterator();
        V previous = nodeIterator.next();
        while (nodeIterator.hasNext()) {
            V next = nodeIterator.next();
            Object connection = null;
            List<E> edges = this.getEdges(previous, next);
            if (edges.size() == 0 && !directionSensitive) {
                edges = this.getEdges(next, previous);
            }
            if (edges.size() <= 0) {
                throw new IllegalArgumentException("Path given with missing edge connection");
            }
            connection = edges.get(0);
            path.add(connection);
            previous = next;
        }
        return path;
    }

    @Override
    public int getInDegree(V vertex) {
        if (!this.containsVertex(vertex)) {
            return 0;
        }
        int result = 0;
        Map<V, List<E>> incoming = this.incomingEdges.get(vertex);
        for (List<E> edges : incoming.values()) {
            result += edges.size();
        }
        return result;
    }

    @Override
    public int getOutDegree(V vertex) {
        int result = 0;
        Map<V, List<E>> outgoing = this.outgoingEdges.get(vertex);
        if (outgoing == null) {
            return 0;
        }
        for (List<E> edges : outgoing.values()) {
            result += edges.size();
        }
        return result;
    }

    @Override
    public List<Set<V>> getConnectedComponents() {
        return ConnectedComponents.getConnectedComponents(this);
    }

    public Iterator<E> incomingEdgeIterator(V vertex) {
        return new EdgeIterator<V, E>(this.incomingEdges, vertex);
    }

    public Iterable<E> incomingEdgeIterable(final V vertex) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new EdgeIterator(DirectedMultiGraph.this.incomingEdges, vertex);
            }
        };
    }

    public Iterator<E> outgoingEdgeIterator(V vertex) {
        return new EdgeIterator<V, E>(this.outgoingEdges, vertex);
    }

    public Iterable<E> outgoingEdgeIterable(final V vertex) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new EdgeIterator(DirectedMultiGraph.this.outgoingEdges, vertex);
            }
        };
    }

    public Iterator<E> edgeIterator() {
        return new EdgeIterator(this);
    }

    public Iterable<E> edgeIterable() {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new EdgeIterator(DirectedMultiGraph.this);
            }
        };
    }

    public Map<V, List<E>> toMap() {
        Map<List<E>, List<E>> map = this.innerMapFactory.newMap();
        for (V vertex : this.getAllVertices()) {
            map.put((List<E>)vertex, this.getOutgoingEdges(vertex));
        }
        return map;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("{\n");
        s.append("Vertices:\n");
        for (V vertex : this.outgoingEdges.keySet()) {
            s.append("  ").append(vertex).append('\n');
        }
        s.append("Edges:\n");
        for (V source : this.outgoingEdges.keySet()) {
            for (V dest : this.outgoingEdges.get(source).keySet()) {
                for (E edge : this.outgoingEdges.get(source).get(dest)) {
                    s.append("  ").append(source).append(" -> ").append(dest).append(" : ").append(edge).append('\n');
                }
            }
        }
        s.append('}');
        return s.toString();
    }

    static class EdgeIterator<V, E>
    implements Iterator<E> {
        private Iterator<Map<V, List<E>>> vertexIterator;
        private Iterator<List<E>> connectionIterator;
        private Iterator<E> edgeIterator;
        private boolean hasNext = true;

        public EdgeIterator(DirectedMultiGraph<V, E> graph) {
            this.vertexIterator = graph.outgoingEdges.values().iterator();
        }

        public EdgeIterator(Map<V, Map<V, List<E>>> source, V startVertex) {
            Map<V, List<E>> neighbors = source.get(startVertex);
            if (neighbors == null) {
                return;
            }
            this.vertexIterator = null;
            this.connectionIterator = neighbors.values().iterator();
        }

        @Override
        public boolean hasNext() {
            this.primeIterator();
            return this.hasNext;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Graph edge iterator exhausted.");
            }
            return this.edgeIterator.next();
        }

        private void primeIterator() {
            if (this.edgeIterator != null && this.edgeIterator.hasNext()) {
                this.hasNext = true;
            } else if (this.connectionIterator != null && this.connectionIterator.hasNext()) {
                this.edgeIterator = this.connectionIterator.next().iterator();
                this.primeIterator();
            } else if (this.vertexIterator != null && this.vertexIterator.hasNext()) {
                this.connectionIterator = this.vertexIterator.next().values().iterator();
                this.primeIterator();
            } else {
                this.hasNext = false;
            }
        }

        @Override
        public void remove() {
            this.edgeIterator.remove();
        }
    }
}

