# Base - RL training
accelerate launch run_mm_cot_rl.py \
    --data_root data/ScienceQA/data \
    --caption_file data/instruct_captions.json \
    --user_msg rationale --img_type vit \
    --use_caption --use_generate --prompt_format QCM-E \
    --seed 42 \
    --model "declare-lab/flan-alpaca-base" \
    --model_type base \
    --base_model_dir ./models/mm-cot-base-rationale \
    --ref_model ./models/mm-cot-base-rationale \
    --k_actions 4 --train_split train \
    --continue_train False \
    --do_sample True \
    --bs 64 --output_len 512 \
    --rl_batch_size 8 \
    --init_kl_coef 0.0001 --top_k 50 \
    --rl_epochs 10 --lr 2e-5 --clip_range 0.2 --epochs 1 --ga_step 8 --gamma 1.0 --adv_normalization True

# Base - Generate predictions_ans_*.json (Use 1 NVIDIA A100 GPU)
CUDA_VISIBLE_DEVICES=0 python main.py \
    --data_root data/ScienceQA/data \
    --model "declare-lab/flan-alpaca-base" \
    --caption_file data/instruct_captions.json \
    --user_msg rationale --img_type vit \
    --bs 16 --eval_bs 8 --epoch 20 --lr 8e-5 --output_len 512 \
    --use_caption --use_generate --final_eval --prompt_format QCM-E \
    --output_dir experiments \
    --seed 42 \
    --evaluate_dir {}

# Large - RL training
accelerate launch run_mm_cot_rl.py \
    --data_root data/ScienceQA/data \
    --caption_file data/instruct_captions.json \
    --user_msg rationale --img_type vit \
    --use_caption --use_generate --prompt_format QCM-E \
    --seed 42 \
    --model "declare-lab/flan-alpaca-large" \
    --model_type base \
    --base_model_dir ./models/mm-cot-large-rationale \
    --ref_model ./models/mm-cot-large-rationale \
    --k_actions 4 --train_split train \
    --continue_train False \
    --do_sample True \
    --bs 32 --output_len 512 \
    --rl_batch_size 2 \
    --init_kl_coef 0.0001 --top_k 50 \
    --rl_epochs 5 --lr 2e-5 --clip_range 0.2 --epochs 1 --ga_step 16 --gamma 1.0 --adv_normalization False

# Large - Generate predictions_ans_*.json (Use 4 NVIDIA A100 GPU)
CUDA_VISIBLE_DEVICES=0,1,2,3 python main.py \
    --data_root data/ScienceQA/data \
    --model "declare-lab/flan-alpaca-large" \
    --caption_file data/instruct_captions.json \
    --user_msg rationale --img_type vit \
    --bs 2 --eval_bs 4 --epoch 50 --lr 5e-5 --output_len 512 \
    --use_caption --use_generate --prompt_format QCM-E \
    --output_dir experiments \
    --seed 42 \
    --evaluate_dir {}
