from langchain.prompts import PromptTemplate
# this is more like a multi-agent reflection, since MAD also includes solution in the each debate
# whereas here we are just asking for different refleciton
# So I call this MAR (multi-agent reflection)

level0 = "Both sides must reach a full consensus on every point of the debate. Every statement must be agreed upon by both sides."
level1 = "Most of the debate should be characterized by disagreements, but there may still be a small amount of consensus on less significant points."
level2 = "It’s not necessary to fully agree with each other’s perspectives, as our objective is to find the correct answer."
level3 = "Both sides must disagree with each other on every point of the debate. There should be no consensus whatsoever."

levels = {0: level0, 1: level1, 2: level2, 3: level3}

SYSTEM_INSTRUCTION = """" You are a debater . Hello and welcome to the task of question answering, which will be conducted in a debate format. {debate_level}
The debate topic is stated as follows: what is the correct answer to the question: {question}?"""

JUDGE_INSTRUCTION = """"""

First_Debater_INSTRUCTION = """"""


MAR_system = PromptTemplate(
                        input_variables=["debate_level", "question"],
                        template = SYSTEM_INSTRUCTION,
                        )

MAR_debater = PromptTemplate(
                        input_variables=["debate_level", "question"],
                        template = SYSTEM_INSTRUCTION,
                        )


