# Adapted from https://github.com/microsoft/jericho/blob/master/jericho/game_info.py

nine05 = {
    "name": "905",
    "rom": "905.z5",
    "seed": 0,
    "walkthrough": 'answer phone/stand up/s/remove watch/remove clothes/drop all/enter shower/take watch/wear watch/n/get all from table/open dresser/get clothes/wear clothes/e/open front door/s/unlock car/enter car/no/no/yes',
    "grammar" : "awake/awaken/wake;awake/awaken/wake up;bathe/shower/wash;carry/hold/take inventory;die/q/quit;disrobe/undress;get out/off/up;hear/listen;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/enter;l/look;leave/go/run/walk;nap/sleep;noscript/unscript;recording;recording off;recording on;replay;restart;restore;save;script/transcrip;script/transcrip off;script/transcrip on;smell/sniff;stand up;stand/exit/out/outside;wait/z;yes;no;answer OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;carry/hold/take off OBJ;carry/hold/take/get OBJ;close/shut OBJ;don/wear OBJ;drive OBJ;drop OBJ;eat OBJ;get in/into/on/onto OBJ;get off OBJ;get out of OBJ;go/run/walk to/into/in/inside/through OBJ;go/run/walk/enter OBJ;hear/listen OBJ;hear/listen to OBJ;knock on OBJ;l/look at OBJ;l/look inside/in/into/through/on OBJ;l/look under OBJ;leave into/in/inside/through OBJ;leave/exit/out/outside OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;lock OBJ;open OBJ;pick OBJ up;pick up OBJ;put OBJ down;put down OBJ;put on OBJ;read/examine/x OBJ;remove OBJ;search OBJ;sign OBJ;smell/sniff OBJ;stand on OBJ;taste OBJ;turn OBJ off;turn OBJ on;turn off OBJ;turn on OBJ;unlock OBJ;use OBJ;carry/hold/take/get OBJ from OBJ;insert OBJ in/into OBJ;l/look up OBJ in OBJ;open OBJ with OBJ;put OBJ in/inside/into OBJ;put OBJ on/onto OBJ;sign OBJ with OBJ;",
    "max_word_length" : 9
}

acorncourt = {
    "name": "acorncourt",
    "rom": "acorncourt.z5",
    "seed": 4,
    "walkthrough": 'point machine at tree/get ball/put ball in machine/turn on machine/turn off machine/fix bucket with acorn/fix bucket with acorn/fix bucket with acorn/fix bucket with acorn/turn crank/tie bucket to rope/turn crank/turn crank/look in bucket/get key/unlock gate/open gate',
    "minimal_actions": 'take key/look in bucket/take pail/unlock gate with key/turn crank/aim machine at tree/turn off machine/take balls from pail/take acorns/put balls in machine/turn on machine/open gate/fix bucket with acorn/tie bucket to rope',
    "grammar" : "awake/awaken/wake;awake/awaken/wake up;bother/curses/darn/drat;brief/normal;carry/hold/take inventory;damn/fuck/shit/sod;die/q/quit;dive/swim;exit/out/outside/stand;full/fullscore;full/fullscore score;hear/listen;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;leave/go/run/walk;long/verbose;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;pray;restart;restore;save;score;script;script off;script on;short/superbrie;sing;smell/sniff;sorry;stand up;think;verify;version;wait/z;wave;y/yes;adjust/set OBJ;aim/direct/point OBJ;aim/direct/point OBJ east;aim/direct/point OBJ west;attach/fasten/tie OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;carry/hold/take OBJ;carry/hold/take off OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;cross/enter/go/run/walk OBJ;damn/fuck/shit/sod OBJ;dig OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull/lift/raise OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;get/peel OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look under OBJ;leave OBJ;leave/go/run/walk into/in/inside/through OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;open/uncover/undo/unwrap OBJ;peel off OBJ;pick OBJ up;pick up OBJ;put OBJ down;put down OBJ;put on OBJ;read/check/describe/examine/watch/x OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;smell/sniff OBJ;squash/squeeze OBJ;stand on OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;taste OBJ;wave OBJ;adjust/set OBJ to OBJ;aim/direct/point OBJ at OBJ;answer/say/shout/speak OBJ to OBJ;ask OBJ about OBJ;ask OBJ for OBJ;attach/fasten/tie OBJ to OBJ;burn/light OBJ with OBJ;carry/hold/take OBJ off OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;consult OBJ about OBJ;consult OBJ on OBJ;dig OBJ with OBJ;discard/drop/throw OBJ at/against/on/onto OBJ;discard/drop/throw OBJ in/into/down OBJ;discard/drop/throw/put OBJ on/onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ to/into/on/onto OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;fix/plug/repair OBJ with OBJ;get OBJ from OBJ;insert OBJ in/into OBJ;l/look up OBJ in OBJ;lock OBJ with OBJ;put OBJ in/inside/into OBJ;read OBJ in OBJ;read about OBJ in OBJ;remove/carry/hold/take OBJ from OBJ;tell OBJ about OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

adventureland = {
    "name": "adventureland",
    "rom": "adventureland.z5",
    "seed": 4,
    # Walkthrough adapted from http://mirror.ifarchive.org/if-archive/solutions/jgunness.zip
    "walkthrough": 'E/N/GET AXE/D/GET OX/BUNYON/SWIM/S/W/W/GET OX/GET AXE/GET FRUIT/E/CLIMB TREE/GET KEYS/D/CHOP TREE/DROP AXE/GO STUMP/DROP FRUIT/DROP OX/GET LAMP/GET BOTTLE/D/GET RUBIES/U/DROP RUBIES/D/D/UNLOCK DOOR with keys/DROP KEYS/open door/D/LIGHT LAMP/D/S/GET BLADDER/N/D/D/GET FLINT/W/N/GET RUG/D/GET NET/U/U/AWAY/turn off LAMP/S/DROP FLINT/DROP BLADDER/take mud/N/E/GET FISH/S/W/GO STUMP/DROP FISH/DROP NET/U/GET FLINT/GET BLADDER/GET GAS/GO STUMP/DROP MUD/D/D/D/LIGHT LAMP/D/S/U/DROP BLADDER/LIGHT GAS/GO LEDGE/JUMP/say boo/GET MIRROR/E/GET CROWN/W/JUMP/W/D/N/U/U/U/U/DROP CROWN/D/D/D/D/S/U/GET BRICKS/D/N/D/D/W/N/D/throw bricks/GET FIRESTONE/U/U/AWAY/turn off lamp/E/W/S/GO STUMP/DROP FIRESTONE/DROP RUG/DROP MIRROR/GET MUD/D/D/D/LIGHT LAMP/D/N/GET HONEY/DRINK WATER/GET BEES/S/U/U/U/U/U/N/e/take water/w/take mud/go stump/d/d/d/d/n/drink water/get bees/s/u/u/u/u/drop bottle/take bottle/n/take mud/n/DROP BEES/GET EGGS/S/get oil/GO STUMP/DROP EGGS/DROP HONEY/turn off lamp/rub lamp/rub lamp',
    "minimal_actions": 'Light gas/Swim/Get bees/Drop firestone/Get crown/Get net/Drop fruit/Get mirror/Get lamp/Lamp off/Drop bladder/Get bottle/Get ox/Open door/Go west/Go north/Get rubies/Rub lamp/Drop keys/Go south/Drop net/Drop mirror/Go down/Drop rug/Drop bricks/Get eggs/Get flint/go down/Get bladder/Go hole/Cut tree/Get gas/Go hallway/Yell/Jump/Climb tree/Drop mud/Drink water/Catch fish/Get bricks/Get axe/Drop bees/Drop ox/Get mud/Drop honey/Drop fish/Get firestone/Drop bottle/Go up/Bunyon/get bottle/Light lamp/Get fruit/Get honey/Drop axe/Drop eggs/Drop flint/Get keys/Go east/Go throne/Away/Drop crown/Get rug/Drop rubies',
    "grammar" : "awake/awaken/wake;awake/awaken/wake up;away;bother/curses/darn/drat;brief/normal;bunyon;carry/get/hold/take inventory;carry/get/hold/take off;carry/get/hold/take out;close/cover/shut up;damn/fuck/shit/sod;die/q/quit;dive/swim;exit/out/outside/stand;full/fullscore;full/fullscore score;go/leave/run/walk;hear/listen;help;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;long/verbose;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;pray;restart;restore;save;score;script;script off;script on;short/superbrie;sing;smell/sniff;sorry;stand/carry/get/hold/take up;think;tsurris;verify;version;wait/z;wave;y/yes;adjust/set OBJ;attach/fasten/fix/tie OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;carry/get/hold/take OBJ;carry/get/hold/take off OBJ;chop/cut/prune/slice OBJ;chop/cut/prune/slice down OBJ;chop/cut/prune/slice up OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale over OBJ;climb/scale up OBJ;close/cover/shut OBJ;cross/enter/go/leave/run/walk OBJ;damn/fuck/shit/sod OBJ;dig OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;find OBJ;go/leave/run/walk through OBJ;go/leave/run/walk/carry/get/hold/take into OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;l/look at OBJ;l/look in OBJ;l/look inside OBJ;l/look into OBJ;l/look through OBJ;l/look under OBJ;lie/sit/go/leave/run/walk inside OBJ;lie/sit/go/leave/run/walk/carry/get/hold/take in OBJ;lie/sit/stand/carry/get/hold/take on OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;put OBJ down;put down OBJ;put on OBJ;read/check/describe/examine/watch/x OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;smell/sniff OBJ;squash/squeeze OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;taste OBJ;wave OBJ;adjust/set OBJ to OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;burn/light OBJ with OBJ;carry/get/hold/take OBJ off OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;dig OBJ with OBJ;discard/drop/throw OBJ against OBJ;discard/drop/throw OBJ at OBJ;discard/drop/throw OBJ down OBJ;discard/drop/throw/insert/put OBJ in OBJ;discard/drop/throw/insert/put OBJ into OBJ;discard/drop/throw/put OBJ on OBJ;discard/drop/throw/put OBJ onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ into OBJ;empty OBJ on OBJ;empty OBJ onto OBJ;empty OBJ to OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;lock OBJ with OBJ;put OBJ inside OBJ;remove/carry/get/hold/take OBJ from OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

advent = {
    "name": "advent",
    "rom": "advent.z5",
    "seed": 5,
    "walkthrough": 'E/GET ALL/W/S/S/S/UNLOCK GRATE WITH KEYS/OPEN GRATE/D/W/GET CAGE/W/LIGHT LAMP/W/W/GET BIRD/W/D/S/GET NUGGET/N/N/DROP BIRD/GET BIRD/N/DROP KEYS/GET SILVER/N/PLUGH/DROP SILVER/DROP NUGGET/DROP CAGE/DROP FOOD/PLUGH/S/S/SW/W/KILL DRAGON/YES/GET RUG/E/D/N/N/W/W/D/POUR WATER ON PLANT/U/E/E/NW/NW/N/W/DROP ALL/E/GET EMERALD/W/GET ALL/NW/S/GET VASE/SE/E/GET PILLOW/W/NE/E/U/E/U/N/PLUGH/DROP PILLOW/DROP RUG/DROP VASE/DROP EMERALD/FILL BOTTLE/GET FOOD/PLUGH/PLOVER/NE/GET PYRAMID/S/PLOVER/PLUGH/DROP PYRAMID/PLUGH/S/GET KEYS/D/W/D/W/W/W/W/D/POUR WATER ON BEANSTALK/U/E/D/FILL BOTTLE/U/W/D/CLIMB BEANSTALK/W/GET EGGS/WAIT/GET AXE/N/OIL DOOR/N/GET TRIDENT/W/D/DROP TRIDENT/SW/U/NE/GIVE EGGS/NE/NE/E/D/S/E/GIVE FOOD TO BEAR/UNLOCK CHAIN WITH KEYS/GET BEAR/GET CHAIN/W/W/N/NE/E/GET SPICES/W/S/W/W/SW/DROP BEAR/SW/SW/D/GET TRIDENT/SE/SE/NE/E/DROP KEYS/E/GET MAGAZINE/E/DROP MAGAZINE/W/U/N/OPEN CLAM WITH TRIDENT/D/D/GET PEARL/U/U/S/U/E/U/N/PLUGH/DROP TRIDENT/DROP CHAIN/DROP SPICES/DROP PEARL/PLUGH/S/D/W/D/W/W/W/W/D/CLIMB BEANSTALK/W/FEE/FIE/FOE/FOO/GET EGGS/S/E/U/E/E/NE/E/U/E/THROW AXE AT DWARF/U/N/PLUGH/DROP EGGS/PLUGH/S/S/S/GET JEWELRY/N/W/GET COINS/W/W/E/E/GET DIAMONDS/N/W/N/E/E/N/N/PLUGH/DROP DIAMONDS/DROP COINS/DROP JEWELRY/PLUGH/S/S/W/W/W/E/S/E/S/N/GET ALL/SE/N/D/E/E/GET ROD/XYZZY/DROP ALL/GET LAMP/PLUGH/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/SW/GET ALL/NE/DROP ALL/SW/BLAST',
    "minimal_actions": 'EXAMINE LAMP/TAKE VASE/NW/DROP PILLOW/WATER PLANT/N/TAKE BARS/NE/TAKE DIAMONDS/TAKE CAGE/OIL GATE/DROP CAGE/SAY PLOVER/THROW PENTACLE/DROP ELIXIR/TAKE PENTACLE/THROW BEAR/DOWN/SW/LOCK DOOR/S/OPEN CLAM/OPEN GRATE/DROP SPICES/EXAMINE GRATE/TAKE PILLOW/KILL DRAGON/DROP RUG/ON LAMP/TAKE BOTTLE/TAKE KEYS/TAKE ORB/DROP BARS/IN/TAKE RUG/CROSS BRIDGE/WAVE ROD/FEE/TAKE PEARL/OPEN CHAIN/FREE BIRD/SE/TAKE SCEPTRE/DROP COINS/DROP GAZETTE/FOO/FIE/DROP KEYS/TAKE BIRD/TAKE LAMP/TAKE ROD/DROP PYRAMID/TAKE COINS/DROP EGGS/TAKE DYNAMITE/DROP LAMP/FEED BEAR/SAY PLUGH/EXAMINE SANDWICHES/FILL BOTTLE/DROP CHAIN/YES/FOE/UP/DROP DYNAMITE/TAKE TRIDENT/DROP BOTTLE/SAY XYZZY/TAKE ELIXIR/TAKE SPICES/DROP TRIDENT/TAKE CHAIN/TAKE CROWN/DROP ROD/TAKE NUGGET/E/CLIMB PLANT/TAKE SANDWICHES/TAKE EMERALD/BLAST/DROP EMERALD/DROP NUGGET/TAKE BEAR/OFF LAMP/W/DROP VASE/TAKE PYRAMID/DROP DIAMONDS/TAKE GAZETTE/OUT/TAKE EGGS/DROP JEWELLERY/GIVE EGGS/TAKE JEWELLERY',
    "grammar" : "abracadab/foobar/frotz/hocus/open-ses/sesame/shazam;answer/say/shout/speak blast;answer/say/shout/speak fee;answer/say/shout/speak fie;answer/say/shout/speak foe;answer/say/shout/speak foo;answer/say/shout/speak plover;answer/say/shout/speak plugh;answer/say/shout/speak sesame/shazam/hocus/abracadab/foobar/open-ses/frotz;answer/say/shout/speak xyzzy;awake/awaken/wake;awake/awaken/wake up;blast;bother/curses/darn/drat;brief/normal;carry/hold/take inventory;damn/fuck/shit/sod;die/q/quit;dive/swim;fee;fie;foe;foo;full/fullscore;full/fullscore score;get out/off/up;hear/listen;help;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;leave/go/run/walk;long/verbose;nap/sleep;no;noscript/unscript;notify;notify off;notify on;nouns/pronouns;objects;off;on;places;plover;plugh;pray;recording;recording off;recording on;replay;restart;restore;save;score;script/transcrip;script/transcrip off;script/transcrip on;short/superbrie;sing;smell/sniff;sorry;stand up;stand/exit/out/outside;think;use;verify;version;wait/z;wave;xyzzy;y/yes;adjust/set OBJ;attach/fasten/fix/tie OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;capture/catch OBJ;carry/hold/take off OBJ;carry/hold/take/get OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;count OBJ;damn/fuck/shit/sod OBJ;dig OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;douse/pour oil on OBJ;douse/pour water on OBJ;douse/pour/empty OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;free/release OBJ;get in/into/on/onto OBJ;get off OBJ;go/run/walk/cross/enter OBJ;grease/lubricate/oil OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;kick OBJ;l/look at OBJ;l/look inside/in/into/through/on OBJ;l/look under OBJ;leave/exit/out/outside OBJ;leave/go/run/walk into/in/inside/through OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;put OBJ down;put down OBJ;put on OBJ;read/check/describe/examine/watch/x OBJ;rotate/screw/turn/twist/unscrew OBJ;rotate/screw/turn/twist/unscrew/switch OBJ off;rotate/screw/turn/twist/unscrew/switch OBJ on;rotate/screw/turn/twist/unscrew/switch on OBJ;rotate/screw/turn/twist/unscrew/switch/close/cover/shut off OBJ;search OBJ;smell/sniff OBJ;squash/squeeze OBJ;stand on OBJ;swing OBJ;swing on OBJ;switch OBJ;taste OBJ;water OBJ;wave OBJ;adjust/set OBJ to OBJ;answer/say/shout/speak OBJ to OBJ;ask OBJ about OBJ;ask OBJ for OBJ;ask that OBJ OBJ;attach/fasten/fix/tie OBJ to OBJ;blast OBJ with OBJ;burn/light OBJ with OBJ;capture/catch OBJ with OBJ;carry/hold/take OBJ off OBJ;carry/hold/take/remove/get OBJ from OBJ;clear/move/press/push/shift OBJ OBJ;consult OBJ about OBJ;consult OBJ on OBJ;dig OBJ with OBJ;discard/drop/throw OBJ at/against/on/onto OBJ;discard/drop/throw OBJ in/into/down OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ to/into/on/onto OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;force/jemmy/lever/prise/prize/pry OBJ apart/open with OBJ;force/jemmy/lever/prise/prize/pry apart/open OBJ with OBJ;insert OBJ in/into OBJ;l/look up OBJ in OBJ;lock OBJ with OBJ;put OBJ in/inside/into OBJ;put/discard/drop/throw OBJ on/onto OBJ;read OBJ in OBJ;read about OBJ in OBJ;tell OBJ about OBJ;tell/ask OBJ to OBJ;transfer/clear/move/press/push/shift OBJ to OBJ;unlock/force/jemmy/lever/prise/prize/pry/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

afflicted = {
    "name": "afflicted",
    "rom": "afflicted.z8",
    "seed": 0,
    "walkthrough": 'read paper/e/search grate/search window/knock on window/w/n/x tables/note tables/ask angela about affliction/e/search ice/take hand/n/note vomit/note sink/note dryer/s/note counter/note stools/w/n/n/w/open cauldron/take foot/e/n/open dish washer/take right foot/s/s/s/take lamp/turn on lamp/n/n/n/d/open crate/u/s/s/x prep table/x shelf/take tongs/s/s/e/take eyes with tongs/w/n/n/n/x chopper/note it/x blade/open cover/turn screw/reach in chopper/open kit/wear tourniquet/take all/s/s/u/take key/read book/read killing/read culture/d/n/n/n/d/put eyes in body/put entrails in body/u/n/open dumpster/take all/s/d/put all in crate/no/u/s/s/s/s/w/search window/break window/x opener/take opener/e/n/kill sofia with opener',
    "grammar" : "awake/awaken/wake;awake/awaken/wake up;bother/curses/darn/drat;carry/hold/take inventory;curse/damn/fuck/shit;disco/dance;exit/out/stand;get out/off/up;go/leave/run/walk;go/leave/run/walk through;go/leave/run/walk to bathroom;hints/hint;hints/hint off;hop/jump/skip;i/inv/inventory;info/about/help;l/look;listen;long/verbose;nap/sleep;no;normal/brief;notify;notify off;notify on;plugh/xyzzy;pronouns/nouns;q/quit;restart;restore;save;score;short/superbrie;sing;smell/sniff;solution/walkthru/walkthrou;sorry;stand up;think;transcrip/script;transcrip/script off;transcrip/script on;urinate/pee;use toilet;verify;version;wait/z;wave;y/yes;accuse OBJ;apply OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;burn/light OBJ;buy/purchase OBJ;carry/hold/take off OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;cross/enter/go/leave/run/walk OBJ;damn/fuck/shit OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;document/note OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;flush OBJ;get in/into/on/onto OBJ;get off OBJ;get/carry/hold/take OBJ;go/leave/run/walk into/in/inside/through OBJ;hear OBJ;inspect/check/describe/examine/watch/x OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look under OBJ;lick/taste OBJ;listen to OBJ;lock OBJ;pick OBJ up;pick up OBJ;play OBJ;put OBJ down;put OBJ on;put down OBJ;put on OBJ;put on OBJ;reach in OBJ;reach inside OBJ;reach into OBJ;read OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;sit on top of OBJ;sit on/in/inside OBJ;slap/kick/attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;smell/sniff OBJ;squash/squeeze OBJ;stand on OBJ;stroke/feel/touch OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;talk to OBJ;tap/knock OBJ;tap/knock on OBJ;uncover/open/unwrap OBJ;unlock OBJ;wave OBJ;adjust/set OBJ to OBJ;answer/say/shout/speak OBJ to OBJ;ask OBJ about OBJ;ask OBJ for OBJ;attach OBJ to OBJ;carry/hold/take OBJ off OBJ;consult OBJ on/about OBJ;discard/drop/throw OBJ at/against/on/onto OBJ;discard/drop/throw OBJ in/into/down OBJ;discard/drop/throw/put OBJ on/onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;fasten/fix/tie OBJ to OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;get/carry/hold/take OBJ with OBJ;insert OBJ in/into OBJ;l/look up OBJ in OBJ;lock OBJ with OBJ;open/unlock OBJ with OBJ;put OBJ in/inside/into OBJ;remove/get/carry/hold/take OBJ from OBJ;stab/attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ with OBJ;tell OBJ about OBJ;",
    "max_word_length" : 9
}

anchorhead = {
    "name": "anchor",
    "rom": "anchor.z8",
    "seed": 0,
    "walkthrough": 'Se/Push can against wall/Climb can/Up/West/Push play/East/Look up Verlac/West/Unlock Door/West/West/West/NW/West/Read book/Show keys to Michael/East/SE/East/South/South/East/South/SW/NW/Unlock door/North/Close door/Lock door/Up/North/Undress/Drop all/West/Bathe/East/Lie in bed/Sleep/Look/wait/wait/Get wallet/Open wallet/Get card/Leave bed/Dress/Get all/Wear coat/South/Down/West/Open cupboard/Pull lining/Read journal/North/Get flashlight/Open Cabinet/Get matches/Turn on flashlight/NW/Get broom/Unlock door/Down/South/Search crates/Get box/Drop cardboardbox/Wipe web/Drop broom/Get key/Put key on keyring/North/Up/SE/East/East/Look at paintings/Look at scene/South/Get album/Look up Wilhelm in album/Look up Eustacia in album/Look up Croseus in album/West/Up/East/North/Get volume/Look at bookshelf/Get Poe/Examine safe/turn dial to 47/turn dial to 11/ turn dial to 3/Look in safe/Get puzzle box and flute/South/South/Open jewelry box/Get silver locket/Push bed/Look in hole/Get pages/Read pages/North/West/Down/North/West/Unlock door/North/NW/Unlock crypt/Down/Examine coffin/Look up William on nameplate/Open William coffin/Get skull/Up/SE/South/Close door/Lock door/East/South/Unlock door/South/SE/NE/North/West/Get newspaper/Read newspaper/South/South/SE/Look up Edward in record/Look up Mordecai in record/Look up Elijah inrecord/Look up Heinrich in record/Look up Wilhelm in record/NW/SW/Look up Edward in record/Look up Mordecai in Record/Look up Elijah inrecord/Look up Heinrich in record/ Look up Wilhelm in record/NE/North/North/North/North/West/NW/West/North/Ring bell/Show card to librarian/Ask librarian for book/Open Historical/Get slip of paper/Read slip of paper/Drop historical/South/East/SE/East/North/Get Lantern/South/Look under table/Get flask/South/NW/Read wall/West/South/Look in displaycase/Ask proprietor about amulet/Give puzzle box to proprietor/Get puzzle box/North/East/SW/South/South/East/East/Give flask to bum/Ask bum about himself/Ask bum about brother/Ask bum about Anna/Ask bum about crypt/Tell bum about skull/Show skull to bum/Give amulet to bum/Put copper key on keyring/SE/Get tin/NW/West/South/SW/NW/North/ Close door/Up/East/North/East/Get letter opener/Look at screen/Remove ring/Look at ring/Wear ring/Type 0628 on laptop/Look at screen/West/South/Pull cord/Up/Push newspaper under door/Put letter opener in keyhole/Get newspaper/Get brass key/Put brass key on keyring/Unlock door/North/Search straw/Get gold locket/South/Down/West/North/West/Get towel/East/Undress/Drop all/Lie in bed/Sleep/sleep/sleep/sleep/Leave bed/Dress/Wear coat/Get all/South/East/North/East/Look at fireplace/Turn sphere/SW/West/Look in hole/East/Look in hole/NW/Look in hole/SW/SE/Put lens in telescope/Look in telescope/SE/East/Down/West/Down/North/West/NW/Down/East/Search wine rack/Turn c/Turn w/Turn h/Turn e/Turn m/North/North/North/NE/Down/Say ialdabaoloth/North/South/Up/SW/NW/East/Down/West/Down/South/SE/NE/South/South/Look at woods/West/SW/West/Get drawing paper/Get Hook/South/Lift plywood cover/Down/Search bones/Get Teddy/Up/North/East/South/Down/Hide under bones/Wait/Up/Up/North/East/NE/East/North/East/SE/Break padlock with hook/Down/Look at shape/Search shape/Put steel key on keyring/Look at furnace/Open hatch/West/ Put all in pocket/Jump onto riser/North/Get cloth/East/Read huge tome/East/Up/Up/Get rope/Down/West/West/South/Drop robe in shaft/Tie rope to railing/Down/Drop rope/Light flashlight/Get robe/get lantern/NW/North/North/Open tin/Put oil on hatch/Open hatch/Up/East/West/NW/East/Unlock drawer/Open drawer/Get all from drawer/Read letter/Put bronze key on keyring/West/West/West/North/West/North/Knock on door 11/Give teddy to woman/Look in overalls/Get long steel key/Put long steel key on keyring/West/South/South/Search thicket/Unlock hatch/get lantern/North/Light match/Light lantern/Put towel on valve/Turn wheel/North/North/Open hatch/Wait/Wait/North/Tie chain to me/Look at controls/Pull lever/Untie chain/North/Read notes/Get caliper/Get memo/Get Blueprint/Read blueprint/Get mirror 1/Put mirror 1 in caliper/Open tin/Rub oil on mirror 1/South/Down/Jump off equipment/South/South/South/South/NE/East/East/NE/East/Up/Down/wait/wait/Break door/Break door/Get glass/Look at window pane/Put glass in crack/Cut jacket with glass/Open closet/Wear coat/Get all from closet/South/South/Unlock west door/Open west door/West/Look in tear/Get torn square/Read torn square/Get needle/East/South/South/Down/Get lantern/Light match/Light lantern/North/North/Get magazine/Give magazine to madman/Get large key/Put large key on keyring/Unlock gate/North/North/North/Remove coat/Wear robe/East/Wait/wait/wait/wait/wait/Look/Put all in pocket/Get amulet/North/Give gold locket to creature/Hit creature with hook/North/West/North/East/NE/Unlock door/Open door/East/Up/Look at device/Get real mirror/put all in pocket/Wait/Give mirror 1 to Michael/Wait/Wait/Wait/Wait/Wait/Wait/Wait/Wait/Wait/Pick cuffs with needle/Free boy/West/SW/SW/West/West/North/Wait/South/East/South/East/South/South/Touch obelisk/Show ring to Michael/Show amulet to Michael/cover hole 3/cover hole 6/Play flute/wait/wait/Go north/Get test/Look at little window',
    "grammar" : "about/author/credit/credits/help/hint/hints/menu;awake/awaken/wake;awake/awaken/wake up;bathe/shower;bother/curses/darn/drat;brief/normal;chant/sing;crawl/go/run/walk to bed;crawl/go/run/walk to sleep;cry/scream/shout/shriek/yell;damn/fuck/shit/sod;describe off;describe on;die/q/quit;dive/swim;doze/nap/sleep;dress;exit/out/outside;fall asleep;fool/mess/play around;full/fullscore;full/fullscore score;get dressed;get out/off/down;get out/off/up;get undressed;hear/listen;hello/hi;hide;hop/jump/leap/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;ialdabaol;in/inside/cross/enter;l/look;l/look around;leave/crawl/go/run/walk;lie/sit;lie/sit down;long/verbose;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;play;pray;remember/think;restart;restore/resume;save;score;script/transcrip;script/transcrip off;script/transcrip on;short/superbrie;smell/sniff;sorry;speak;speak/answer/say ialdabaol;stand;stand/get up;swing;take inventory/inv/i;undress;verify;version;wait/z;wave;y/yes;adjust/set OBJ;ask for OBJ;attack/break/crack/destroy/fight/hit/kick/kill/murder/punch/scratch/smash/strike/swat/thump/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;bend/straighte OBJ;bite/chew/devour/eat OBJ;blow/breathe OBJ;blow/breathe OBJ up;blow/breathe in/into OBJ;blow/breathe out/on OBJ;blow/breathe up OBJ;blow/breathe/lay/place/put/stick OBJ out;bother/curses/darn/drat OBJ;burn/ignite/light OBJ;bury OBJ;buy/purchase OBJ;call/dial/phone/telephone OBJ;check/examine/inspect/watch/x OBJ;chop/cut/prune/rip/slice/tear OBJ;chuck/discard/drop/throw/toss OBJ;clean/dust/polish/rub/scrub/shine/smear/sweep/wipe OBJ;clear/move/press/push/rock/roll/shift/shove/slide OBJ;climb/scale OBJ;climb/scale down/up/over/on/onto OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;crawl/go/run/walk around/to/by/toward/towards/near/behind OBJ;crawl/go/run/walk close/closer to OBJ;crawl/go/run/walk down/up OBJ;crawl/go/run/walk into/in/inside/through/under OBJ;crease/fold/unfold OBJ;cross/enter/crawl/go/run/walk OBJ;damn/fuck/shit/sod OBJ;dangle/hang from/off/on OBJ;dangle/hang on to OBJ;dig OBJ;dig in OBJ;disrobe/doff/shed/remove OBJ;dive/swim/climb/scale in/into OBJ;don/wear OBJ;drag/haul/pull/yank OBJ;drag/haul/pull/yank on OBJ;draw/have OBJ;drink/gulp/imbibe/sip/swallow OBJ;dump/pour/spill OBJ;dump/pour/spill OBJ out;dump/pour/spill out OBJ;embrace/hug/kiss/smooch OBJ;empty OBJ out;empty out OBJ;exit/out/outside/leave OBJ;extinguis/snuff OBJ;feel/fondle/grope/touch/taste OBJ;find OBJ;flip/switch OBJ;flip/switch/rotate/screw/spin/turn/twist/unscrew OBJ off;flip/switch/rotate/screw/spin/turn/twist/unscrew OBJ on;flip/switch/rotate/screw/spin/turn/twist/unscrew on OBJ;flip/switch/rotate/screw/spin/turn/twist/unscrew/close/cover/shut off OBJ;fool/mess OBJ;fool/mess/play around with OBJ;fool/mess/play with OBJ;free/loosen/untie OBJ;get down from OBJ;get in/into/inside OBJ;get off OBJ;get off of OBJ;get on/onto OBJ;get under OBJ;get up from OBJ;get/carry/catch/grab/hold/hook/snag/take OBJ;grip/squash/squeeze OBJ;grip/squash/squeeze/leave through OBJ;hear/listen OBJ;hear/listen to OBJ;hello/hi OBJ;hide in/among/under/behind/inside OBJ;hop/jump/leap/skip in/on/onto/to/into OBJ;hop/jump/leap/skip off OBJ;hop/jump/leap/skip over OBJ;hop/jump/leap/skip/get out of OBJ;jiggle/rattle/shake OBJ;jimmy/pick lock with OBJ;knock/rap on/at OBJ;l/look at OBJ;l/look behind OBJ;l/look inside/in/into/through/on/out OBJ;l/look under OBJ;l/look up/for OBJ;latch/lock OBJ;lay/place/put/stick OBJ down;lay/place/put/stick OBJ on;lay/place/put/stick down OBJ;lay/place/put/stick finger/fingers on/over/in OBJ;lay/place/put/stick on OBJ;lay/place/put/stick out OBJ;lean on/against OBJ;let go of OBJ;lie/sit down in/on OBJ;lie/sit down on/at OBJ;lie/sit in/inside OBJ;lie/sit on/at OBJ;lift/raise OBJ;lift/raise/take finger/fingers from/off OBJ;lift/raise/take finger/fingers off of OBJ;lower OBJ;measure OBJ;open/uncover/unwrap OBJ;pack OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;play OBJ;play on OBJ;pray to OBJ;read OBJ;read about OBJ;remember/think OBJ;remember/think about OBJ;remove finger/fingers from OBJ;ring OBJ;rotate/screw/spin/turn/twist/unscrew OBJ;search OBJ;search for OBJ;set OBJ down;set down OBJ;set fire to OBJ;smell/sniff OBJ;stand on OBJ;swing OBJ;swing on OBJ;take OBJ off;take off OBJ;trip OBJ;type OBJ;unlock OBJ;unpack/empty OBJ;wave OBJ;wave at/to OBJ;affix/attach/fasten/fix/tie OBJ to/on/onto OBJ;answer/say OBJ to OBJ;ask OBJ for OBJ;attack/break/crack/destroy/fight/hit/kick/kill/murder/punch/scratch/smash/strike/swat/thump/wreck OBJ with OBJ;burn/ignite/light OBJ with OBJ;bury OBJ in/under OBJ;chop/cut/prune/rip/slice/tear OBJ with OBJ;chuck/discard/drop/throw/toss OBJ at/against/on/onto OBJ;chuck/discard/drop/throw/toss OBJ in/into/down OBJ;chuck/discard/drop/throw/toss/lay/place/put/stick OBJ on/onto OBJ;clean/dust/polish/rub/scrub/shine/smear/sweep/wipe OBJ on/onto OBJ;clean/dust/polish/rub/scrub/shine/smear/sweep/wipe OBJ with OBJ;clear/move/press/push/rock/roll/shift/shove/slide OBJ to/under/underneat/beneath/against/by/near OBJ;clear/move/press/push/rock/roll/shift/shove/slide OBJ with OBJ;clear/move/press/push/rock/roll/shift/shove/slide/drag/haul/pull/yank/lay/place/put/stick OBJ close/closer to OBJ;consult OBJ about OBJ;consult OBJ on OBJ;dig OBJ with OBJ;dig in OBJ with OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;drag/haul/pull/yank/lay/place/put/stick OBJ under/underneat/beneath OBJ;dump/pour/spill OBJ into/in/onto/on/over OBJ;feed/give/hand/offer/pay OBJ OBJ;feed/give/hand/offer/pay OBJ to OBJ;feed/give/hand/offer/pay over OBJ to OBJ;fill OBJ with OBJ;get/carry/catch/grab/hold/hook/snag/take OBJ with OBJ;hide OBJ in/under OBJ;insert OBJ in/into OBJ;jimmy/pick OBJ with OBJ;latch/lock OBJ with OBJ;lay/place/put/stick OBJ in/inside/into OBJ;lay/place/put/stick OBJ in/into/inside/between OBJ;lay/place/put/stick OBJ on/onto/across/over OBJ;measure OBJ with OBJ;rotate/screw/spin/turn/twist/unscrew/adjust/set OBJ to OBJ;set OBJ on OBJ;set OBJ on/across/over OBJ;set fire to OBJ with OBJ;speak OBJ to OBJ;unlock/open/uncover/unwrap OBJ with OBJ;unpack/remove/get/take OBJ from/off OBJ;wave OBJ at OBJ;",
    "max_word_length" : 9
}

awaken = {
    "name": "awaken",
    "rom": "awaken.z5",
    "seed": 0,
    "walkthrough": 'u/take limb/e/se/n/hit dog/nw/n/e/s/n/push railing/take section/n/n/n/read book/take book/n/search desk/take stopper/take ash/put ash on journal/read journal/move bookshelf/take old book/read old book/take robe/s/s/s/put ladder under trap/climb ladder/climb rope/tie rope to branch/d/tie rope to handle/d/take ladder/s/s/put ladder under tree/climb ladder/n/push bell/s/d/get ladder/n/n/put ladder under trap/climb ladder/n/take lantern/n/take green bottle/open green bottle',
    "grammar" : "about/help;awake/awaken/wake;awake/awaken/wake up;bother/curses/darn/drat;brief/normal;carry/hold/take inventory;clue/clues/hint/hints;clue/clues/hint/hints off;damn/fuck/shit/sod;die/q/quit;dive/swim;exit/out/outside/stand;full/fullscore;full/fullscore score;get out/off/up;hear/listen;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;leave/go/run/walk;long/verbose;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;pray;restart;restore;save;score;script/transcrip;script/transcrip off;script/transcrip on;short/superbrie;sing;smell/sniff;sorry;stand up;think;verify;version;wait/z;wave;xyzzy;y/yes;adjust/set OBJ;attach/fasten/fix/tie OBJ;attack/break/crack/destroy/fight/hit/kick/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;carry/hold/take off OBJ;check/describe/examine/watch/x OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;cross/enter/go/run/walk OBJ;damn/fuck/shit/sod OBJ;detach/untie OBJ;dig OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/pet/touch OBJ;fill OBJ;get in/into/on/onto OBJ;get off OBJ;get/carry/hold/take OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look under OBJ;leave OBJ;leave/go/run/walk into/in/inside/through OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;put OBJ down;put down OBJ;put on OBJ;read OBJ;ring OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;smell/sniff OBJ;squash/squeeze OBJ;stand on OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;taste OBJ;wave OBJ;adjust/set OBJ to OBJ;answer/say/shout/speak OBJ to OBJ;ask OBJ about OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;burn/light OBJ with OBJ;carry/hold/take OBJ off OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ on OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ with OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;consult OBJ about OBJ;consult OBJ on OBJ;detach/untie OBJ from OBJ;dig OBJ with OBJ;discard/drop/throw OBJ at/against/on/onto OBJ;discard/drop/throw OBJ in/into/down OBJ;discard/drop/throw/put OBJ on/onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ to/into/on/onto OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;insert OBJ in/into OBJ;l/look up OBJ in OBJ;lock OBJ with OBJ;put OBJ in/inside/into OBJ;put OBJ under/below/beneath/against OBJ;read OBJ in OBJ;read about OBJ in OBJ;remove/get/carry/hold/take OBJ from OBJ;tell OBJ about OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

balances = {
    "name": "balances",
    "rom": "balances.z5",
    "seed": 0,
    "walkthrough": 'search furniture/learn rezrov/rezrov box/get grimoire from box/examine grimoire/out/north/search oats/examine shiny scroll/gnusto shiny scroll/learn bozbar/bozbar horse/mount horse/north/learn yomin/yomin tortoise/learn bozbar/bozbar tortoise/get chewed scroll/northwest/take sapphire/examine sapphire/examine book/caskly chewed scroll/gnusto scroll/n/take carpet/s/learn rezrov/rezrov door/w/learn frotz/frotz coin/take cube/write cave on cube/take crumpled/gnusto crumpled/take gold coin from right pan/take bronze coin from left pan/put gold coin on right/put silver coin on left/e/se/s/learn urbzig/urbzig snake/take cube/write chasm on featureless cube/drop carpet/sit on carpet/stand/sit on carpet/stand/take carpet/e/listen/learn lobal/lobal me/listen/wait/wait/wait/wait/wait/wait/wait/wait/wait/wait/wait/wait/wait/take feather/w/nw/w/take silver/put bronze on left/put feather on left/e/se/drop carpet/sit on carpet/stand/take carpet/learn yomin/drop carpet/sit on carpet/learn yomin/learn yomin/learn yomin/stand/sit on carpet/stand/give silver to barker/yomin barker/take ticket 2306/yomin barker/take ticket 5802/give ticket 2306 to barker/give ticket 5802 to barker/write prize on featureless/sit on carpet/stand/take carpet/learn urbzig/learn lleps/lleps urbzig/drop toy/urbzig toy/learn urbzig/urbzig mace/take cube/write mace on featureless/e/learn frotz/frotz temple/clean podium/put chasm cube in bottom left socket/put cave cube in bottom right socket/put prize cube in top left socket/put mace cube in top right socket',
    "grammar" : "awake/awaken/wake;awake/awaken/wake up;bother/curses/darn/drat;brief/normal;c,cast;carry/get/hold/take inventory;carry/get/hold/take out/off/up;close/cover/shut up;damn/fuck/shit/sod;diagnose/health;die/q/quit;dive/swim;exit/out/outside/stand;full/fullscore;full/fullscore score;hear/listen;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;leave/go/run/walk;long/verbose;memory/spells;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;pray;restart;restore;save;score;script;script off;script on;short/superbrie;sing;smell/sniff;sorry;stand up;think;verify;version;wait/z;wave;y/yes;adjust/set OBJ;attach/fasten/fix/tie OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;c,cast OBJ;carry/get/hold/take OBJ;carry/get/hold/take in/into/on/onto OBJ;carry/get/hold/take off OBJ;cast OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;cross/enter/go/run/walk OBJ;damn/fuck/shit/sod OBJ;dig OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;flip/toss OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look under OBJ;leave OBJ;leave/go/run/walk into/in/inside/through OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;mount/ride/straddle OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;put OBJ down;put down OBJ;put on OBJ;read/check/describe/examine/watch/x OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;smell/sniff OBJ;squash/squeeze OBJ;stand on OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;taste OBJ;wave OBJ;adjust/set OBJ to OBJ;answer/say/shout/speak OBJ to OBJ;ask OBJ about OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;burn/light OBJ with OBJ;carry/get/hold/take OBJ from/off OBJ;cast OBJ at OBJ;cast OBJ on OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;consult OBJ about OBJ;consult OBJ on OBJ;dig OBJ with OBJ;discard/drop/throw OBJ at/against/on/onto OBJ;discard/drop/throw OBJ in/into/down OBJ;discard/drop/throw/put OBJ on/onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ to/into/on/onto OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;insert OBJ in/into OBJ;l/look up OBJ in OBJ;lock OBJ with OBJ;put OBJ in/inside/into OBJ;read OBJ in OBJ;read about OBJ in OBJ;remove OBJ from OBJ;tell OBJ about OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

ballyhoo = {
    "name": "ballyhoo",
    "rom": "ballyhoo.z3",
    "seed": 0,
    # Walkthrough adapted from http://www.the-spoiler.com/ADVENTURE/Infocom/ballyhoo.1.html
    "walkthrough": 's/help midget/w/take mask/s/w/hide behind president/listen to conversation/again/e/e/take pole/n/n/n/drop mask/u/e/e/e/e/e/e/take balloon/w/w/w/w/w/w/d/d/take all/s/s/w/s/untie balloon/inhale helium/guard, hello/s/w/wear clown mask/knock on door/s/take ash tray/close door/search ash/take scrap/search tray/go under wall/e/n/e/n/ne/search garbage/take ticket/punch out blue dot/sw/s/put ticket in slot/e/ask pitchman about dr nostrum/s/se/look into cage/take keys with pole/unlock door/open door/n/take bucket/s/nw/n/w/w/s/w/s/e/unlock compartment/open compartment/take whip/n/e/n/put ticket in slot/e/e/e/n/ne/take stool/nw/s/w/w/w/n/n/unlock cage/open cage/w/whip smooth lion/again/again/lift grate/throw meat in passage/e/w/lower grate/search stand/e/s/s/s/w/give case to harry/n/e/put ticket in slot/e/e/s/show case to jenny/give case to jenny/n/n/give ticket to rimshaw/rimshaw, hypnotise me/wait/wait/wait/wait/buy candy from hawker/give money to hawker/stand/e/u/e/d/e/u/e/d/s/stand in line/wait/wait/get out of long line/stand in short line/wait/wait/wait/get out of long line/yes/stand in long line/bite banana/drop banana/n/ask hawker about candy/u/w/d/w/u/w/d/w/stand/s/w/go under wall/search garbage/take bar/s/e/e/n/ne/show bar to tina/tina, hello/shake hands/nw/take radio/s/w/w/s/se/drop all except radio/n/take headphones/s/u/u/set radio to 1170/turn radio off/rewind tape/wait/play tape/wait/wait/rewind tape/turn radio on/record/wait/wait/wait/wait/d/d/rewind tape/turn radio off/take all/drop stool and bucket/nw/unlock cage/open cage/w/play tape/search straw/open trap door/take ribbon/e/close cage/se/take bucket/nw/n/w/w/s/w/touch wood with pole/take mousetrap/drop trap/e/wait/w/e/w/catch mouse with bucket/take mouse/e/n/e/put ticket in slot/e/s/show mouse to elephant/again/wait/sw/drop all/u/turn crank/look into wagon/knock on door/in/lock door/search desk/take spreadsheet/move desk/u/read spreadsheet/d/take all/w/ask harry about eddie smaldone/e/ne/se/slide ticket under front/e/take ticket/open secret panel/y/n/open secret panel/w/nw/n/w/s/ne/se/slide ticket under front/e/look under table/take suitcase/wait/w/drop all/u/u/wait/e/wait/take shaft/pull shaft/d/d/take all except key, whip, stool/nw/n/w/fill bucket with water/s/ne/n/pour water on detective/ask detective about chelsea/drop bucket/take note and card/read note/e/s/u/take all/u/n/w/w/w/s/w/s/e/show ribbon to chuckles/show scrap to chuckles/show note to chuckles/show spreadsheet/eddie,hello/show card to chuckles/search pocket/take veil/wear veil/wear dress/wear jacket/knock on door/e/close door/take crowbar/move moose/open door/w/w/open door with crowbar/s/take thumb/n/e/e/put thumb in hole/wait/take chelsea/w/n/e/ne/n/w/n/n/clap/roustabout, get net/take off veil/take off jacket/take off dress/drop all/w/take stand/e/drop stand/take radio/climb stand/u/turn radio on/drop radio/d/take pole/climb stand/u/u/take radio/e/e/e/w/w/w/w/drop radio and pole/d/s/s/s/e/call WPDL/w/n/n/n/climb stand/u/take all/e/e/e/e/e/wait/wait/wait',
    "grammar" : "answer/reply;applau/cheer/clap;balanc;bounce/dive/fall/jump/leap;brief;cheat;crouch/duck/hide;depart/exit/withdr;diagno;did/ok/okay/sure/y/yea/yes;didn'/no/nope/wrong;doze/nap/sleep/snooze;enter;gaze/l/look/squint/stare;go/procee/run/step/walk;hello/hi/howdy;help/hint/hints;hop/skip;howl/scream/shout/yell;invent/i;leave;q/quit;record;rest/sit/squat;restar;restor;rise/stand;save;score;script;smell/sniff/whiff;smile;stay/wait/z;super/superb;thank/thanks;unscri;verbos;versio;wave;what/what'/whats;where/wheres;who/whos;why;you;activa/start OBJ;adjust/tune OBJ;advanc OBJ;answer/reply OBJ;answer/reply to OBJ;applau/cheer OBJ;approa OBJ;arrest OBJ;assaul/attack/fight/hit/kill/murder/slap/strike OBJ;attach/fasten/secure/tie OBJ;awake/rouse/wake OBJ;awake/rouse/wake up OBJ;balanc OBJ;bet/wager OBJ;bite OBJ;board/embark OBJ;boost/lift/raise OBJ;bounce/dive/fall/jump/leap across OBJ;bounce/dive/fall/jump/leap down OBJ;bounce/dive/fall/jump/leap from OBJ;bounce/dive/fall/jump/leap off OBJ;bounce/dive/fall/jump/leap on OBJ;bounce/dive/fall/jump/leap out OBJ;bounce/dive/fall/jump/leap over OBJ;bounce/dive/fall/jump/leap up OBJ;break/damage/demoli/destro/peel/pop/smash/wreck OBJ;break/damage/demoli/destro/peel/pop/smash/wreck down OBJ;breath/inhale/suck OBJ;breath/inhale/suck in OBJ;bribe OBJ;buy/order/purcha OBJ;call OBJ;call out OBJ;call to OBJ;carry/get/grab/hold/take OBJ;carry/get/grab/hold/take down OBJ;carry/get/grab/hold/take off OBJ;carry/get/grab/hold/take out OBJ;chase/follow/pursue OBJ;cheat OBJ;cheat at OBJ;clap OBJ;clean/tidy/wash OBJ;clean/tidy/wash up OBJ;climb/crawl/creep/scale OBJ;climb/crawl/creep/scale down OBJ;climb/crawl/creep/scale off OBJ;climb/crawl/creep/scale out OBJ;climb/crawl/creep/scale over OBJ;climb/crawl/creep/scale up OBJ;climb/crawl/creep/scale/carry/get/grab/hold/take on OBJ;close/shut/unset OBJ;close/shut/unset off OBJ;compar/match OBJ;count OBJ;crack/snap/whip OBJ;cross/enter OBJ;crouch/duck/hide under OBJ;cut/perfor/slice OBJ;cut/perfor/slice/climb/crawl/creep/scale/carry/get/grab/hold/take in OBJ;debark/disemb OBJ;depart/exit/withdr OBJ;descen OBJ;descri/examin/inspec/observ/scour/see/study/watch OBJ;descri/examin/inspec/observ/scour/see/study/watch on OBJ;descri/examin/inspec/observ/scour/see/study/watch/gaze/l/look/squint/stare in OBJ;descri/examin/inspec/observ/scour/see/study/watch/gaze/l/look/squint/stare/frisk/rummag/search for OBJ;devour/eat/gobble/ingest OBJ;dial/phone/teleph OBJ;did not OBJ;did so OBJ;dig in OBJ;dig throug OBJ;dig with OBJ;doff/remove/shed OBJ;don/wear OBJ;draw/open/part/pry OBJ;draw/open/part/pry up OBJ;drink/guzzle/imbibe/quaff/sip/swallo/swill OBJ;drink/guzzle/imbibe/quaff/sip/swallo/swill from OBJ;drive OBJ;drop OBJ;eject OBJ;empty OBJ;empty out OBJ;exting OBJ;feed OBJ;feel/pat/pet/poke/rub/tap/tickle/touch OBJ;fill OBJ;find/seek OBJ;flick/flip/rotate/set/toggle/turn OBJ;flick/flip/rotate/set/toggle/turn around OBJ;flick/flip/rotate/set/toggle/turn off OBJ;flick/flip/rotate/set/toggle/turn on OBJ;free/unatta/unfast/unknot/untang/untie OBJ;frisk/rummag/search OBJ;frisk/rummag/search in OBJ;frisk/rummag/search throug OBJ;gaze/l/look/squint/stare OBJ;gaze/l/look/squint/stare around OBJ;gaze/l/look/squint/stare at OBJ;gaze/l/look/squint/stare behind OBJ;gaze/l/look/squint/stare down OBJ;gaze/l/look/squint/stare on OBJ;gaze/l/look/squint/stare out OBJ;gaze/l/look/squint/stare over OBJ;gaze/l/look/squint/stare throug OBJ;gaze/l/look/squint/stare to OBJ;gaze/l/look/squint/stare under OBJ;gaze/l/look/squint/stare up OBJ;go/bounce/dive/fall/jump/leap/procee/run/step/walk in OBJ;go/climb/crawl/creep/scale/bounce/dive/fall/jump/leap/procee/run/step/walk throug OBJ;go/climb/crawl/creep/scale/carry/get/grab/hold/take/procee/run/step/walk under OBJ;go/crouch/duck/hide/rise/stand/procee/run/step/walk behind OBJ;go/move/procee/run/step/walk around OBJ;go/procee/run/step/walk OBJ;go/procee/run/step/walk away OBJ;go/procee/run/step/walk down OBJ;go/procee/run/step/walk on OBJ;go/procee/run/step/walk out OBJ;go/procee/run/step/walk over OBJ;go/procee/run/step/walk to OBJ;go/procee/run/step/walk up OBJ;hang/insert/lay/place/put/stuff down OBJ;hang/insert/lay/place/put/stuff on OBJ;hang/insert/lay/place/put/stuff up OBJ;hear OBJ;hello/hi/howdy OBJ;help/hint/hints/save OBJ;howl/scream/shout/yell at OBJ;howl/scream/shout/yell to OBJ;hurl/throw/toss OBJ;hypnot/mesmer OBJ;jimmy/pick OBJ;jimmy/pick up OBJ;kick OBJ;kiss OBJ;knock/rap at OBJ;knock/rap down OBJ;knock/rap on OBJ;lean OBJ;lean to OBJ;leave OBJ;let go OBJ;lick/taste OBJ;lie/reclin down OBJ;lie/reclin in OBJ;lie/reclin on OBJ;light OBJ;listen to OBJ;lock OBJ;lower OBJ;make OBJ;move OBJ;move up OBJ;pass/pay OBJ;play OBJ;pole-/poleva/vault on OBJ;pole-/poleva/vault over OBJ;pour/spill/sprink OBJ;pour/spill/sprink out OBJ;press/pull/push/shove/boost/lift/raise up OBJ;press/pull/push/shove/move on OBJ;punch OBJ;punch out OBJ;reach OBJ;reach in OBJ;read/skim OBJ;record OBJ;record on OBJ;rest/sit/squat down OBJ;rest/sit/squat in OBJ;rest/sit/squat on OBJ;rewind OBJ;rise/stand in OBJ;rise/stand on OBJ;rise/stand/carry/get/grab/hold/take up OBJ;shake OBJ;sidewa/side- OBJ;slide/press/pull/push/shove OBJ;smell/sniff/whiff OBJ;smile at OBJ;speak/talk in OBJ;speak/talk to OBJ;spin/whirl OBJ;stay/wait/z for OBJ;stay/wait/z in OBJ;stay/wait/z on OBJ;stop OBJ;tame OBJ;tell/addres OBJ;thank/thanks OBJ;unlock OBJ;wave OBJ;wave at OBJ;wave to OBJ;what/what'/whats OBJ;where/wheres OBJ;who/whos OBJ;you OBJ;adjust/tune OBJ to OBJ;adjust/tune in OBJ to OBJ;ask/consul/query OBJ about OBJ;ask/consul/query OBJ for OBJ;ask/consul/query OBJ on OBJ;assaul/attack/fight/hit/kill/murder/slap/strike OBJ with OBJ;attach/fasten/secure/tie OBJ to OBJ;attach/fasten/secure/tie/hang/insert/lay/place/put/stuff OBJ around OBJ;balanc OBJ with OBJ;boost/lift/raise OBJ to OBJ;bounce/dive/fall/jump/leap over OBJ with OBJ;break/damage/demoli/destro/peel/pop/smash/wreck OBJ with OBJ;breath/inhale/suck in OBJ from OBJ;bribe OBJ with OBJ;buy/order/purcha OBJ from OBJ;captur/catch OBJ in OBJ;captur/catch OBJ with OBJ;carry/get/grab/hold/take OBJ in OBJ;carry/get/grab/hold/take OBJ off OBJ;carry/get/grab/hold/take OBJ out OBJ;carry/get/grab/hold/take OBJ with OBJ;compar/match OBJ to OBJ;compar/match OBJ with OBJ;cover OBJ with OBJ;crack/snap/whip OBJ at OBJ;crack/snap/whip OBJ on OBJ;crack/snap/whip OBJ over OBJ;crack/snap/whip OBJ with OBJ;cut/perfor/slice OBJ with OBJ;cut/perfor/slice throug OBJ with OBJ;descri/examin/inspec/observ/scour/see/study/watch OBJ throug OBJ;dial/phone/teleph/call OBJ on OBJ;dial/phone/teleph/call OBJ with OBJ;doff/remove/shed/carry/get/grab/hold/take OBJ from OBJ;donate/give/hand/offer/sell/send/feed/pass/pay OBJ OBJ;donate/give/hand/offer/sell/send/feed/pass/pay OBJ to OBJ;draw/open/part/pry OBJ with OBJ;drop OBJ down OBJ;drop/hang/insert/lay/place/put/stuff OBJ in OBJ;drop/hang/insert/lay/place/put/stuff OBJ on OBJ;drop/hang/insert/lay/place/put/stuff OBJ out OBJ;empty OBJ from OBJ;empty OBJ out OBJ;feel/pat/pet/poke/rub/tap/tickle/touch OBJ on OBJ;feel/pat/pet/poke/rub/tap/tickle/touch OBJ with OBJ;fill OBJ with OBJ;flick/flip/rotate/set/toggle/turn OBJ to OBJ;flick/flip/rotate/set/toggle/turn OBJ with OBJ;flick/flip/rotate/set/toggle/turn in OBJ to OBJ;free/unatta/unfast/unknot/untang/untie OBJ with OBJ;frisk/rummag/search OBJ for OBJ;gaze/l/look/squint/stare at OBJ throug OBJ;hang/insert/lay/place/put/stuff OBJ across OBJ;hang/insert/lay/place/put/stuff OBJ behind OBJ;hang/insert/lay/place/put/stuff OBJ down OBJ;hang/insert/lay/place/put/stuff OBJ over OBJ;hurl/throw/toss OBJ at OBJ;hurl/throw/toss OBJ in OBJ;hurl/throw/toss OBJ off OBJ;hurl/throw/toss OBJ out OBJ;hurl/throw/toss OBJ over OBJ;hurl/throw/toss OBJ throug OBJ;hurl/throw/toss OBJ to OBJ;hurl/throw/toss OBJ up OBJ;jimmy/pick OBJ with OBJ;lock OBJ with OBJ;move OBJ with OBJ;pass/pay OBJ throug OBJ;pole-/poleva/vault over OBJ with OBJ;pour/spill/sprink OBJ from OBJ;pour/spill/sprink OBJ in OBJ;pour/spill/sprink OBJ on OBJ;pour/spill/sprink OBJ over OBJ;pour/spill/sprink out OBJ into OBJ;reach OBJ with OBJ;read/skim OBJ on OBJ;read/skim OBJ throug OBJ;read/skim OBJ with OBJ;shake OBJ with OBJ;show OBJ OBJ;show OBJ to OBJ;slide OBJ down OBJ;slide OBJ in OBJ;slide OBJ on OBJ;slide OBJ throug OBJ;slide/press/pull/push/shove/move/hang/insert/lay/place/put/stuff OBJ under OBJ;tame OBJ with OBJ;tell OBJ OBJ;tell OBJ about OBJ;tell OBJ to OBJ;unlock OBJ with OBJ;",
    "max_word_length" : 6
}

curses = {
    "name": "curses",
    "rom": "curses.z5",
    "seed": 0,
    # Walkthrough adapted from https://ifarchive.org/if-archive/solutions/Curses.step and http://mirror.ifarchive.org/if-archive/solutions/CursesR16.sol
    "walkthrough": "drop biscuit, paper/south/get parcel from cupboard/unwrap parcel/north/north/west/south/examine sheets/turn wireless on/push wireless north/west/give box of chocolates to jemima/say yellow/wait/wait/wait/wait/wait/wait/wait/get gloves/wear gloves/east/east/east/get wrench/west/south/south/southeast/east/examine rolls/open torch/empty torch/get new battery/put new battery in torch/close torch/south/take sack/north/open door/north/get all/turn handle/south/west/west/get flash/east/south/west/get wrench/tighten joint/get novel/get poetry/east/north/northwest/get all from cupboard/north/close trapdoor/get jewellery box/open trapdoor/north/open demijohn/get all from demijohn/west/west/east/east/east/turn wheel off/turn wheel/get medicine bottle/put medicine bottle in shaft/turn wheel/enter dumb waiter/get all/pull ropes/out/mouse, south/south/mouse, west/hole, w/hole, w/hole, w/hole, n/hole, w/hole, n/hole, s/hole, e/hole, s/hole, e/hole, e/hole, e/hole, e/get key/north/enter dumb waiter/pull ropes/out/wear gas mask/north/unlock door with brass key/open door/north/remove gas mask/read poetry/west/take handkerchief/wave handkerchief/west/say time/take poetry/northwest/west/west/get bottle/get implement/enter roller/turn roller on/e/e/e/w/n/n/w/w/n/n/n/n/w/w/w/get out/get etching/enter roller/e/e/e/s/s/s/s/s/e/e/s/s/get out/southeast/south/south/enter dumb waiter/pull ropes/out/west/south/south/southeast/east/north/up/northwest/take gothic key/throw wishbone at ghost/southeast/down/put all in fireplace/west/down/get all/unlock hatch with brass key/open hatch/down/east/turn wheel off/turn wheel/enter dumb waiter/pull ropes/pull ropes/out/west/south/south/southeast/south/south/turn projector on/get ace/put ace in projector/south/examine cups/pull anchor/put ship in mounted bottle/examine ship/fore/get branch/aft/up/take flag/port/get flag/get spar/aft/turn wheel/down/get ace/north/north/east/south/push south wall/south/put flag on bed/break windows/south/look under sill/take gold key/north/lie on bed/sleep/east/east/east/turn wheel/pinch me/get up/north/north/west/northwest/north/north/east/enter dumb waiter/pull ropes/pull ropes/out/north/east/east/break frame/unlock jewellery box with gold key/open jewellery box/take sketch/take spar/take clover/wave spar/wave clover/open coffin/put rods in coffin/close lid/open lid/close lid/open lid/get rods from coffin/southeast/get sceptre/up/up/look up 1420 in map/turn door/northeast/push ball southwest/push ball south/get tarot box/east/break cabinet/get all from cabinet/get rod of returning/strike it/wait/wait/eat tablet/get crook/point rod of returning at me/s/se/s/s/get etching/put it in projector/south/e/e/s/s/s/s/e/e/e/e/e/squeeze weed killer bottle/w/w/w/w/w/n/n/n/n/w/w/take bean pole/strike returning/point it at me/read poetry/north/open tarot box/get eight/get star/get maiden/up/put eight on pack/put maiden on pack/put star on pack/push bell/say even/north/up/get all cards/down/south/west/west/say time/south/east/east/get stick/get crook/get staff/wave stick/wave crook/wave staff/put rods in coffin/close lid/open lid/close lid/open lid/close lid/open lid/get all from coffin/west/west/north/northwest/enter roller/n/n/e/e/e/get out/get rose/down/strike rod of bronze/point it at mural/down/get wrought iron key/down/smell/smell/down/turn switch off/up/west/strike rod of bronze/point it at metal/north/slide i/slide k/slide c/slide a/slide n/slide e/slide l/slide o/slide s/slide t/south/slide k/slide k/get rod of returning/strike it/point it at me/se/s/s/get etching/get maiden/put maiden in projector/south/up/east/get fire/get husbandry/get luck/strike rod of husbandry/point it at goats/south/strike rod of fire/point it at thorns/south/strike rod of luck/point it at me/south/get coin/southeast/get stone/southwest/wake homer/say agamemnon/say ptolemy/say yellow/north/northwest/push dionysus southeast/push dionysus southwest/push poseidon northeast/again/push demeter southwest/push demeter northwest/southeast/put stone in opening/down/get amber/up/south/northeast/northwest/north/north/north/east/south/give coin to bartender/get ekmek/north/get fig/west/west/southwest/play syrinx/put fig in urn/oracle, hello/northeast/down/give ekmek to andromeda/wave hairband/get rod of returning/strike it/point it at me/n/get book/s/east/down/down/northeast/east/east/get implement/walk 4 paces west/walk 4 paces south/dig/get box/unlock it with gothic key/open it/west/west/southwest/up/up/w/s/se/s/s//get maiden/get sketch/put sketch in projector/jump/south/north/take stone/put round stone into grating/wait/wait/wait/wait/wait/wait/south/southeast/southwest/blow whistle/take amber/put amber in socket/get cloak/wear it/south/north/northeast/northeast/southeast/south/anoint me/north/southeast/get spindle/northwest/wait/get alpha/get kappa/get epic poem/get short poem/put epic poem in kappa/put short poem in alpha/east/give kappa to callimachus/south/give alpha to apollonius/get sash/north/west/northwest/north/west/get rusty key/east/south/southwest/southwest/down/lie on couch/sleep/lie on couch/sleep/lie on couch/sleep/lie on couch/sleep/z/z/z/z/z/z/z/z/w/get up/w/get up/w/get up/w/get up/twist nose/west/west/north/east/west/take oak/take sceptre/put sceptre in first socket/turn sceptre/turn sceptre/turn sceptre/turn sceptre/turn sceptre/turn sceptre/turn sceptre/turn sceptre/turn sceptre/turn sceptre/turn sceptre/turn sceptre/turn sceptre/turn sceptre/turn sceptre/turn sceptre/turn sceptre/turn sceptre/get sceptre/put sceptre in second socket/[ Repeatedly \"turn sceptre\" until the coffin opens ]/turn sceptre/turn sceptre/turn sceptre/turn sceptre/east/east/up/northeast/southeast/remove cloak/turn it/wear it/open door/up/put oak on table/northwest/northwest/north/unlock grating with rusty key/open grating/down/get heart from boat/up/south/southeast/southwest/down/west/west/enter coffin/close lid/again/up/west/west/up/up/enter roller/w/w/w/s/s/get out/east/get orb/west/southeast/south/east/east/get featureless rod/get spindle/put featureless rod in coffin/wave spindle/put it in coffin/get eight of wands/wave it/put it in coffin/get bean pole/wave bean pole/put it in coffin/close lid/open lid/close lid/open lid/close lid/open lid/close lid/open lid/get all from coffin/west/west/north/northwest/east/east/mosaic, lagach/mural, lagach/still life, lagach/north/remove cloak/turn it/wear cloak/northeast/northeast/north/north/remove cloak/wear sash/north/northeast/east/south/anoppe/take astrolabe/put astrolabe in mounting/look through astrolabe/get hand/down/down/west/put skull on statue/turn it/put hand on statue/turn it/put heart in statue/get rod of fire/get rod of ice/strike rod of fire/point it at knight/point east/east/point east/east/give rose to knight/show keepsake to knight/point west/west/knight, open flagstone/point down/strike rod of ice/point it at rod of life/get rod of life/again/south/south/down/northwest/west/west/southeast/south/south/enter dumb waiter/pull ropes/again/out/west/unlock door with wrought iron key/open door/northwest/polish orb/get rod of sacrifice/strike it/point sacrifice at board/get rods from sack/put rods in socket/get rods from sack/put rods in socket/get rods from sack/put rods in socket/get orb/put it in opening/strike rod of infinity/point it at lemniscus/west/down/swing rope/get daisy/wear it/up/east/get torch/northeast/east/south/south/east/wear sandals/west/south/north/west/open cover/put torch in well/down/east/z/z/z/z/z/z/z/z/west/up/z/z/z/z/get pole/east/get stone/wave pole/strike it/point it at me/read poetry/east/down/wave stone/give note to man/say carte/up/west/west/west/say time/get torch/southeast/east/enter dumb waiter/pull ropes/again/out/west/south/down",
    "grammar" : "anoppe/eppona;answer/say/shout/speak;awake/awaken/wake;awake/awaken/wake up;beep/bleep/chirp;bet/gamble/wager;bother/curses/darn/drat;brief/normal;carry/get/hold/take inventory;carry/get/hold/take off;carry/get/hold/take out;close/cover/shut up;damn/fuck/shit/sod;diagnose;die/q/quit;dig;display/present/show off;dive/swim;drink/sip/swallow;exhibit/reveal/sing;exit/out/outside/stand;float/sail;float/sail away;full/fullscore;full/fullscore score;go/leave/run/walk;hear/listen;help;hint/hints;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;lagach;lie/sit;lie/sit down;long/verbose;make/wish;make/wish a wish;make/wish wish;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;pace;places;plain;play croquet;plover/plugh/xyzzy;pray;pretty;restart;restore;rip/tear;save;score;script;script off;script on;shantih;short/superbrie;smell/sniff;sorry;stand/carry/get/hold/take up;think;time;verify;version;wait/z;wave;y/yes;achetez/buy/purchase OBJ;add/join/mend/repair/attach/fasten/fix/tie OBJ;adjust/set OBJ;anoint/oil OBJ;answer/say/shout/speak lagach to OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;beckon/direct/gesture/point OBJ;beckon/direct/gesture/point at OBJ;bet/gamble/wager with OBJ;board/embark/cross/enter/go/leave/run/walk OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;carry/get/hold/take OBJ;carry/get/hold/take off OBJ;change/flip/switch OBJ;check/describe/examine/watch/x reflectio of OBJ;chop/cut/prune/slice OBJ;climb/scale OBJ;climb/scale over OBJ;climb/scale up OBJ;close/cover/shut OBJ;damn/fuck/shit/sod OBJ;dance/tango/waltz with OBJ;dig OBJ;dig with OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;etch/inscribe/scribe/write OBJ;fill OBJ;frisk OBJ;go/leave/run/walk through OBJ;go/leave/run/walk/carry/get/hold/take into OBJ;hear/listen OBJ;hear/listen to OBJ;help OBJ;hop/jump/skip over OBJ;hypnotise/hypnotize OBJ;kick/attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;knock at OBJ;knock on OBJ;l/look at OBJ;l/look in OBJ;l/look inside OBJ;l/look into OBJ;l/look through OBJ;l/look under OBJ;lie/sit down on OBJ;lie/sit/go/leave/run/walk inside OBJ;lie/sit/go/leave/run/walk/carry/get/hold/take in OBJ;lie/sit/stand/carry/get/hold/take on OBJ;make/wish for OBJ;milk OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pet/stroke/tickle/feel/fondle/grope/touch OBJ;pick OBJ up;pick up OBJ;pinch/slap OBJ;play with OBJ;play/blow OBJ;put OBJ down;put down OBJ;put on OBJ;ram OBJ;read/check/describe/examine/watch/x OBJ;reverse/revolve/tighten/tweak/unwind/wind/wrench/rotate/screw/turn/twist/unscrew OBJ;ring/clear/move/press/push/shift OBJ;rip/tear OBJ;rip/tear down OBJ;roll/shoot/toss OBJ;rotate/screw/turn/twist/unscrew OBJ around;rotate/screw/turn/twist/unscrew OBJ inside out;rotate/screw/turn/twist/unscrew round OBJ;scratch/clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;search OBJ;shantih OBJ;smell/sniff OBJ;squash/squeeze OBJ;stack OBJ;start/stop OBJ;strike OBJ;swing OBJ;swing on OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;taste OBJ;wash mouth out with OBJ;wash mouth with OBJ;wash my mouth out with OBJ;wash my mouth with OBJ;wave OBJ;add/join/mend/repair/attach/fasten/fix/tie OBJ to OBJ;adjust/set OBJ to OBJ;ask OBJ for OBJ;beckon/direct/gesture/point OBJ at OBJ;burn/light OBJ with OBJ;carry/get/hold/take OBJ off OBJ;check/describe/examine/watch/x OBJ in OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;close/cover/shut OBJ with OBJ;discard/drop/throw OBJ against OBJ;discard/drop/throw OBJ at OBJ;discard/drop/throw OBJ down OBJ;discard/drop/throw/insert/put OBJ in OBJ;discard/drop/throw/insert/put OBJ into OBJ;discard/drop/throw/put OBJ on OBJ;discard/drop/throw/put OBJ onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ into OBJ;empty OBJ on OBJ;empty OBJ onto OBJ;empty OBJ to OBJ;etch/inscribe/scribe/write OBJ on OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;hang/mount OBJ on OBJ;hang/mount OBJ onto OBJ;hang/mount OBJ up on OBJ;hang/mount OBJ up onto OBJ;hang/mount up OBJ on OBJ;hang/mount up OBJ onto OBJ;hypnotise/hypnotize OBJ with OBJ;lay OBJ on OBJ;lean/prop/rest/support OBJ against OBJ;lean/prop/rest/support OBJ on OBJ;lean/prop/rest/support OBJ with OBJ;lean/prop/rest/support up OBJ with OBJ;lock OBJ with OBJ;put OBJ inside OBJ;remove/carry/get/hold/take OBJ from OBJ;rotate/screw/turn/twist/unscrew OBJ with OBJ;shantih OBJ OBJ;stack OBJ in OBJ;stack OBJ on OBJ;stack OBJ onto OBJ;stack OBJ with OBJ;strike/attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ with OBJ;tighten/tweak/unwind/wind/wrench OBJ with OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

cutthroat = {
    "name": "cutthroat",
    "rom": "cutthroat.z3",
    "seed": 10,
    # walkthrough adapted from https://ifarchive.org/if-archive/solutions/Sols3.zip and http://www.eristic.net/games/infocom/cutthroats.html
    "walkthrough": 'look out window/wind watch/get out of bed/read note/open dresser/get passbook and room key/look in closet/i/open door/n/close door/lock door/wait/n/n/e/e/e/e/s/sit/order food/order drink/eat food/drink drink/yes/get out of chair/n/w/w/s/s/w/w/e/e/e/e/ne/s/s/sw/w/w/e/e/wait/n/withdraw $603/s/ne/n/nw/w/w/w/open window/look through window/w/drop passbook/e/e/n/n/w/w/sw/sw/nw/wait/examine plate/se/ne/ne/e/s/n/e/e/s/n/e/s/buy drink/drink drink/n/se/s/s/se/i/wait for johnny/YES/YES/YES/YES/YES/YES/yes/show $500/no/nw/n/n/nw/w/s/wait/wait/look/give $56/buy flashlight and repellent/buy c battery and putty/buy electromagnet/rent compressor/i/n/e/s/sit/order food/order drink/eat food/drink drink/get out of chair/n/se/s/s/sw/w/w/wait/wait/wait/wait/wait/wait/wait/wait/wait/wait/e/e/ne/n/n/nw/w/w/s/s/w/wait/look through window/w/e/wait/look through window/open window/enter window/get envelope/n/w/s/s/unlock door/open door/s/read envelope/get all from closet/i/n/close door/lock door/n/n/e/e/s/s/w/w/drop room key/e/e/e/e/ne/nw/s/sit/order drink/drink drink/wait/wait/get off chair/n/w/s/wait/n/w/n/w/s/d/n/n/n/get drill/open panel/get c battery/put c battery in drill/close panel/s/hide envelope under bunk/s/s/s/wait/wait/wait/latitude is 25/longitude is 25/n/u/n/s/drop wet suit/drop flippers/drop mask/drop drill/i/w/n/d/n/get all/examine compressor/examine air tank/fill tank with air/get air tank/s/s/drink water/s/d/u/s/n/n/n/look under bunk/n/s/u/w/s/examine drill/n/wait/get out of bunk/get all/get envelope/s/s/s/show envelope to johnny/n/u/d/n/eat stew/s/u/drop all/get watch/wear watch/get wet suit/wear wet suit/get air tank/wear air tank/get flippers/wear flippers/get mask/wear mask/i/look/get tube/get flashlight/get canister/get drill/get electromagnet/i/look/dive in ocean/open shark repellent/d/turn on flashlight/d/d/d/s/open door/s/put magnet on mine/turn on magnet/drop magnet/u/remove tank/s/s/turn drill on/drill safe with drill/turn drill off/grab case/n/n/wear air tank/d/n/u/examine glass case/examine stamps/turn drill on/drill case with drill/open tube/put glob on case/d/n/u/u/u/u/u',
    "grammar" : "affirm/ok/okay/sure/uh-hu/y/yeah/yes/yup;again/g;back;barf/chomp/lose;bathe/swim/wade;breath;brief;bye/goodby;chase/come/follow/pursue;chat/say/speak/talk;curse/cuss/damn/fuck/hell/shit/swear;diagno;disemb/exit;dive;dunno/maybe;enter;gaze/l/look/peer/stare;hello/hi;help;hop/skip;i/invent;jump/leap;leave/withdr;lie/nap/rest/sleep;mumble/sigh;negati/no/nope/uh-uh;pray;progre/rating/score;q/quit;restar;restor;save;scream/shout/yell;script;stand;stay;super/superb;t/time;unscri;verbos;versio;wait/z;what/what'/whats/who/who's/whos;win/winnag;ask/inquir/questi OBJ;ask/inquir/questi about OBJ;ask/inquir/questi for OBJ;awake/startl/surpri/wake OBJ;awake/startl/surpri/wake up OBJ;bathe/swim/wade OBJ;bathe/swim/wade in OBJ;bite/chew/consum/eat/munch/nibble OBJ;blow out OBJ;board OBJ;brandi/wave OBJ;brandi/wave at OBJ;brandi/wave to OBJ;break/chip/chop/damage/destro/hit/smash in OBJ;breath OBJ;buy/order/purcha OBJ;bye/goodby OBJ;call OBJ;call to OBJ;carry/get/grab/hold/remove/take OBJ;carry/get/grab/hold/remove/take off OBJ;carry/get/grab/hold/remove/take out OBJ;cast/chuck/hurl/throw/toss OBJ;chase/come/follow/pursue OBJ;chat/say/speak/talk to OBJ;chat/say/speak/talk with OBJ;check OBJ;check/gaze/l/look/peer/stare/search for OBJ;clean/polish/scrub OBJ;climb OBJ;climb down OBJ;climb out OBJ;climb throug OBJ;climb up OBJ;climb/carry/get/grab/hold/remove/take in OBJ;climb/carry/get/grab/hold/remove/take on OBJ;close/shut OBJ;count OBJ;cross/ford OBJ;curse/cuss/damn/fuck/hell/shit/swear OBJ;deflat OBJ;deposi OBJ;descri/examin OBJ;detach/discon/free/unfast/unhook/untie OBJ;disemb OBJ;dive in OBJ;douse/exting OBJ;drink/guzzle/imbibe/sip/swallo OBJ;drop/releas OBJ;empty OBJ;enter OBJ;exit OBJ;feel/pat/pet/rub/touch OBJ;fill OBJ;find/see/seek/where OBJ;flip/set/turn OBJ;flip/set/turn off OBJ;flip/set/turn on OBJ;flip/set/turn over OBJ;fold OBJ;fold up OBJ;gaze/l/look/peer/stare OBJ;gaze/l/look/peer/stare around OBJ;gaze/l/look/peer/stare at OBJ;gaze/l/look/peer/stare behind OBJ;gaze/l/look/peer/stare in OBJ;gaze/l/look/peer/stare on OBJ;gaze/l/look/peer/stare out OBJ;gaze/l/look/peer/stare throug OBJ;gaze/l/look/peer/stare under OBJ;gaze/l/look/peer/stare with OBJ;go/procee/run/step/walk OBJ;go/procee/run/step/walk around OBJ;go/procee/run/step/walk down OBJ;go/procee/run/step/walk in OBJ;go/procee/run/step/walk on OBJ;go/procee/run/step/walk throug OBJ;go/procee/run/step/walk to OBJ;go/procee/run/step/walk up OBJ;hello/hi OBJ;help OBJ;hide behind OBJ;hide in OBJ;hide under OBJ;insert/place/put/stuff/wedge down OBJ;insert/place/put/stuff/wedge on OBJ;jump/leap across OBJ;jump/leap from OBJ;jump/leap in OBJ;jump/leap off OBJ;jump/leap/go/procee/run/step/walk over OBJ;kick OBJ;kiss OBJ;knock/rap at OBJ;knock/rap down OBJ;knock/rap on OBJ;knock/rap over OBJ;latitu OBJ;launch OBJ;lean on OBJ;lease/rent OBJ;leave OBJ;lie/nap/rest/sleep down OBJ;lie/nap/rest/sleep in OBJ;lie/nap/rest/sleep on OBJ;lift/raise OBJ;light/start/strike OBJ;listen for OBJ;listen to OBJ;longit OBJ;lower OBJ;make OBJ;molest/rape OBJ;move/roll/pull/tug/yank OBJ;open OBJ;open up OBJ;pick OBJ;pick up OBJ;play OBJ;pour/spill OBJ;pray for OBJ;press/push/shove OBJ;press/push/shove on OBJ;press/push/shove/lift/raise up OBJ;pull/tug/yank on OBJ;pump up OBJ;reach in OBJ;read/skim OBJ;read/skim in OBJ;rob OBJ;roll up OBJ;scream/shout/yell at OBJ;search OBJ;search in OBJ;send OBJ;send for OBJ;shake OBJ;sit down OBJ;sit in OBJ;sit on OBJ;sit with OBJ;slide OBJ;smell/sniff OBJ;smoke OBJ;spin OBJ;squeez OBJ;stand on OBJ;stand/carry/get/grab/hold/remove/take up OBJ;swing/thrust OBJ;taste OBJ;tell OBJ;unfold OBJ;unlock OBJ;wait/z OBJ;wait/z for OBJ;wear OBJ;weigh OBJ;what/what'/whats/who/who's/whos OBJ;wind OBJ;wind up OBJ;withdr OBJ;aim/point OBJ at OBJ;apply OBJ to OBJ;ask/inquir/questi OBJ about OBJ;ask/inquir/questi OBJ for OBJ;attach/connec/fasten/secure/tie OBJ around OBJ;attach/connec/fasten/secure/tie OBJ to OBJ;attach/connec/fasten/secure/tie up OBJ with OBJ;attack/fight/hurt/injure OBJ with OBJ;blind/jab/poke OBJ with OBJ;blow up OBJ with OBJ;brace/suppor OBJ with OBJ;brandi/wave OBJ at OBJ;break/chip/chop/damage/destro/hit/smash OBJ with OBJ;break/chip/chop/damage/destro/hit/smash down OBJ with OBJ;break/chip/chop/damage/destro/hit/smash in OBJ with OBJ;burn/ignite/incine OBJ with OBJ;burn/ignite/incine down OBJ with OBJ;buy/order/purcha OBJ from OBJ;carry/get/grab/hold/remove/take OBJ from OBJ;carry/get/grab/hold/remove/take OBJ off OBJ;carry/get/grab/hold/remove/take OBJ out OBJ;cast/chuck/hurl/throw/toss OBJ at OBJ;cast/chuck/hurl/throw/toss OBJ down OBJ;cast/chuck/hurl/throw/toss OBJ in OBJ;cast/chuck/hurl/throw/toss OBJ off OBJ;cast/chuck/hurl/throw/toss OBJ on OBJ;cast/chuck/hurl/throw/toss OBJ over OBJ;cast/chuck/hurl/throw/toss OBJ with OBJ;cut/pierce/scrape/slice OBJ with OBJ;deposi OBJ in OBJ;deposi/insert/place/put/stuff/wedge OBJ on OBJ;detach/discon/free/unfast/unhook/untie OBJ from OBJ;dig OBJ in OBJ;dig OBJ with OBJ;dig in OBJ with OBJ;dispat/kill/murder/slay/stab OBJ with OBJ;donate/feed/give/hand/offer/pay OBJ OBJ;donate/feed/give/hand/offer/pay OBJ to OBJ;drill OBJ in OBJ;drill OBJ with OBJ;drop/releas OBJ down OBJ;drop/releas OBJ in OBJ;drop/releas OBJ on OBJ;feel/pat/pet/rub/touch OBJ to OBJ;feel/pat/pet/rub/touch OBJ with OBJ;fill OBJ with OBJ;fix/glue/patch/plug/repair OBJ with OBJ;flash/show OBJ OBJ;flash/show OBJ to OBJ;flip/set/turn OBJ for OBJ;flip/set/turn OBJ to OBJ;flip/set/turn OBJ with OBJ;gaze/l/look/peer/stare at OBJ with OBJ;grease/lubric OBJ with OBJ;hide OBJ behind OBJ;hide OBJ in OBJ;hide OBJ under OBJ;inflat OBJ with OBJ;insert/place/put/stuff/wedge OBJ across OBJ;insert/place/put/stuff/wedge OBJ agains OBJ;insert/place/put/stuff/wedge OBJ at OBJ;insert/place/put/stuff/wedge OBJ behind OBJ;insert/place/put/stuff/wedge OBJ betwee OBJ;insert/place/put/stuff/wedge OBJ by OBJ;insert/place/put/stuff/wedge OBJ in OBJ;insert/place/put/stuff/wedge OBJ over OBJ;insert/place/put/stuff/wedge OBJ under OBJ;lease/rent OBJ from OBJ;lift/raise OBJ with OBJ;light/start OBJ with OBJ;liquif/melt OBJ with OBJ;lock OBJ with OBJ;lower OBJ down OBJ;move OBJ with OBJ;move/roll/pull/tug/yank/press/push/shove/slide OBJ OBJ;open OBJ with OBJ;pick OBJ with OBJ;pour/spill OBJ from OBJ;pour/spill OBJ in OBJ;pour/spill OBJ on OBJ;press/push/shove OBJ off OBJ;press/push/shove OBJ throug OBJ;press/push/shove OBJ under OBJ;pump up OBJ with OBJ;read/skim OBJ with OBJ;roll/press/push/shove/slide OBJ to OBJ;slide OBJ under OBJ;spray OBJ on OBJ;spray OBJ with OBJ;squeez OBJ on OBJ;strike OBJ with OBJ;swing/thrust OBJ at OBJ;tell OBJ about OBJ;unlock OBJ with OBJ;what/what'/whats/who/who's/whos OBJ OBJ;",
    "max_word_length" : 6
}

deephome = {
    "name": "deephome",
    "rom": "deephome.z5",
    "seed": 0,
    # walkthrough adapted from http://www.ifarchive.org/if-archive/solutions/deephome.sol
    "walkthrough": "read note/x door/push mountain/sw/open cabinet/l in cabinet/take shield/take sword/search table/read letter/sw/read warning note/get torch/wait/wait/s/s/s/s/s/s/get pickaxe/n/e/dig rock with axe/take coal/w/n/e/open furnace/put coal in furnace/close furnace/x generator/pull lever/w/n/n/n/n/w/enter car/push yellow/out/nw/sw/get gear/ne/w/e/nw/se/n/s/ne/sw/e/w/se/enter car/push green button/out/w/sw/sw/x terrock/ne/ne/w/e/s/n/e/enter car/push yellow button/out/e/s/s/e/l up terrock in leshosh/w/s/w/w/get moss/e/e/n/n/n/w/enter car/push green button/out/w/sw/sw/put moss in nest/x pipe/push rod/ne/ne/e/enter car/push yellow button/out/e/s/s/s/s/sw/turn wheel/ne/n/e/se/x panel/open hatch/l in hatch/put gear on post/push lever/push button/s/s/s/s/w/e/s/w/ask man about hammer/ask man about eranti/e/s/wear shield/wield sword/kill eranti/kill eranti/kill eranti/kill eranti/n/w/get hammer/e/n/n/n/n/w/w/read sign/w/sw/w/s/e/n/w/e/x clover/get clover/read sign/s/e/e/e/n/nw/w/n/n/n/w/enter car/push yellow button/out/nw/sw/get scraps/open forge/light coal/put scraps in forge/wait/wait/get scraps/put scraps on anvil/hammer scraps/get sharp pick/ne/se/enter car/push red button/out/sw/n/x box/pick lock with sharp pick/open box/l in box/take key/s/unlock door with key/open door/w/ask spirit for name/search valuables/get coin/e/ne/enter car/push yellow button/out/e/s/s/w/ask spirit for name/e/s/w/s/n/w/n/s/w/w/ask spirit for name/e/e/e/e/n/e/look up Kebarn in Leshosh/look up Partaim in Fresto/look up Indanaz in Leshosh/look up Ternalim in Fresto/look up Cholok in Leshosh/look up Yetzuiz in Fresto/look up squirrel in Leshosh/w/s/e/se/s/s/s/s/s/e/x chest/pick lock with sharp pick/open chest/drop sword/drop shield/get net/w/n/n/dig ground with axe/put net on hole/get acorns/put acorns in net/climb tree/climb down/get net/n/n/n/nw/w/w/w/w/w/open net/e/e/e/e/n/n/w/open desk/get paper/e/e/drop hammer/drop pickaxe/get bottle/fill bottle/w/s/w/burn paper/drop coin/pour water on coin/put ashes on coin/put clover on coin/pray to kraxis/manaz/take coin/e/n/e/fill bottle/w/ne/sw/n/u/d/w/enter car/push red button/out/sw/w/drop net/open net/put coin in net/pour water on net/get coin/pray to kraxis/manaz",
    "grammar" : "answer/say/shout/speak manaz;awake/awaken/wake;awake/awaken/wake up;bother/curses/darn/drat;brief/normal;carry/hold/take inventory;climb/scale down;credits;damn/fuck/shit/sod;diag/diagnose/health;die/q/quit;dive/swim;exit/out/outside/stand;exits;flip;full/fullscore;full/fullscore score;get out/off/up;hear/listen;help;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;leave/go/run/walk;long/verbose;manaz;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;plugh;pray;restart;restore;save;score;script/transcrip;script/transcrip off;script/transcrip on;short/superbrie;sing;smell/sniff;sorry;stand up;think;verify;version;wait/z;wave;xyzzy;y/yes;adjust/set OBJ;answer/say/shout/speak OBJ;answer/say/shout/speak manaz to OBJ;attach/fasten/fix/tie OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;beat/hammer OBJ;blow OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;carry/hold/take off OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;cross/enter/go/run/walk OBJ;damn/fuck/shit/sod OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;flip OBJ;get in/into/on/onto OBJ;get off OBJ;get out of OBJ;get/carry/hold/take OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look under OBJ;leave OBJ;leave/go/run/walk into/in/inside/through OBJ;lie/sit at OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pick OBJ;pick OBJ up;pick up OBJ;pour OBJ;pray to OBJ;put OBJ down;put down OBJ;put on OBJ;read/check/describe/examine/watch/x OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;smell/sniff OBJ;spread OBJ;squash/squeeze OBJ;stand on OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;taste OBJ;use OBJ;wave OBJ;wield OBJ;adjust/set OBJ to OBJ;attach/fasten/fix/tie OBJ to OBJ;beat/hammer OBJ with OBJ;burn/light OBJ with OBJ;carry/hold/take OBJ off OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;consult OBJ about OBJ;consult OBJ on OBJ;dig OBJ with OBJ;dig hole in OBJ with OBJ;dig hole with OBJ in OBJ;dig in OBJ with OBJ;discard/drop/throw OBJ at/against/on/onto OBJ;discard/drop/throw OBJ in/into/down OBJ;discard/drop/throw/put OBJ on/onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ to/into/on/onto OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;insert OBJ in/into OBJ;l/look up OBJ in OBJ;lock OBJ with OBJ;pick OBJ with OBJ;pour OBJ on OBJ;put OBJ in/inside/into OBJ;put OBJ over OBJ;read OBJ in OBJ;read about OBJ in OBJ;remove/get/carry/hold/take OBJ from OBJ;spread OBJ on OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

detective = {
    "name": "detective",
    "rom": "detective.z5",
    "seed": 0,
    # Walkthrough adapted from https://solutionarchive.com/file/id,1554/
    "walkthrough": "TAKE PAPER/READ PAPER/DROP PAPER/INVENTORY/W/TAKE GUN/E/N/W/E/E/TAKE WOOD/W/W/TAKE NOTE/READ NOTE/E/N/N/W/N/N/W/E/N/E/E/E/S/TAKE HAMBURGER/N/N/E/N/N/N/N/E/W/W/E/N/W/N/W/N/N/w/n/n/up",
    "grammar" : "about/help/info/informati;actions;actions off;actions on;awake/awaken/wake;awake/awaken/wake up;bother/curses/darn/drat;brief/normal;carry/hold/take inventory;changes;changes off;changes on;daemons/timers;daemons/timers off;daemons/timers on;damn/fuck/shit/sod;die/q/quit;dive/swim;exit/out/outside/stand;footnote/note;full/fullscore;full/fullscore score;get out/off/up;hear/listen;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;leave/go/run/walk;long/verbose;manual;manual pronouns;manual pronouns off;manual pronouns on;melenkuri/noside/plover/plugh/samoht/xyzzy/zorton;messages/routines;messages/routines off;messages/routines on;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;nouns/pronouns off;nouns/pronouns on;objects;places;pray;random;read footnote;read footnotes;recording;recording off;recording on;replay;restart;restore;save;scope;score;script/transcrip;script/transcrip off;script/transcrip on;short/superbrie;showobj;sing;smell/sniff;sorry;stand up;think;trace;trace off;trace on;tree;verify;version;wait/z;wave;y/yes;adjust/set OBJ;attach/fasten/fix/tie OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;carry/hold/take off OBJ;check/describe/examine/watch/x OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;cross/enter/go/run/walk OBJ;damn/fuck/shit/sod OBJ;dig OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;footnote/note OBJ;get in/into/on/onto OBJ;get off OBJ;get/carry/hold/take OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look under OBJ;leave OBJ;leave/go/run/walk into/in/inside/through OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;purloin OBJ;put OBJ down;put down OBJ;put on OBJ;read OBJ;read footnote OBJ;read note OBJ;rotate/screw/turn/twist/unscrew OBJ;scope OBJ;search OBJ;showobj OBJ;showverb OBJ;smell/sniff OBJ;squash/squeeze OBJ;stand on OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;taste OBJ;trace OBJ;tree OBJ;wave OBJ;abstract OBJ to OBJ;adjust/set OBJ to OBJ;answer/say/shout/speak OBJ to OBJ;ask OBJ about OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;burn/light OBJ with OBJ;carry/hold/take OBJ off OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;consult OBJ about OBJ;consult OBJ on OBJ;dig OBJ with OBJ;discard/drop/throw OBJ at/against/on/onto OBJ;discard/drop/throw OBJ in/into/down OBJ;discard/drop/throw/put OBJ on/onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ to/into/on/onto OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;insert OBJ in/into OBJ;l/look up OBJ in OBJ;lock OBJ with OBJ;put OBJ in/inside/into OBJ;read OBJ in OBJ;read about OBJ in OBJ;remove/get/carry/hold/take OBJ from OBJ;shoot OBJ at OBJ;shoot OBJ with OBJ;tell OBJ about OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

dragon = {
    "name": "dragon",
    "rom": "dragon.z5",
    "seed": 0,
    # Walkthrough adapted from http://mirror.ifarchive.org/if-archive/games/glulx/dragon.zip
    "walkthrough": "s/e/d/get coin/examine barrels/get mug/u/w/w/buy box/get box/w/s/w/n/get lamp/s/e/n/e/s/s/e/get key/examine table/get bananas/rub lamp/s/w/n/w/s/s/tip boot/get screwdriver/n/n/n/n/n/get bell/unlock door with key/drop key/n/u/give bananas/build glider/drop screw/get sword/get booklet/get glider/jump/e/ring bell/n/hello/give bell/get horn/s/s/examine reeds/get sack/open sack/get water/s/e/fill bath/get candle/w/examine stump/get matches/light candle/drop matches/e/n/n/read booklet/drop booklet/get flute/e/s/s/play flute/examine bones/get bottle/examine bottle/break bottle/examine parchment/n/n/e/u/examine chair/examine carvings/examine goblin/d/w/s/s/blow horn/e",
    "grammar" : "awake/awaken/wake;awake/awaken/wake up;bother/curses/darn/drat;brief/normal;candle off;candle on;carry/hold/take inventory;damn/fuck/shit/sod;die/q/quit;dive/swim;escape/run/leave/yes;exit/out/outside/stand;extinguis candle;extinguis light;find dragon;find gold;find treasure;fix/sing;fly glider;fly/hop/jump/skip;full/fullscore;full/fullscore score;games/instructi;get out/off/up;go/walk;greetings/hello/hi/hiya/hullo;hear/listen;help/hint;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;info;l/look;long/verbose;nap/sleep;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;pray;rescue;restart;restore;save;score;script/transcrip;script/transcrip off;script/transcrip on;short/superbrie;smell/sniff;sorry;stand up;strike match;think;verify;version;wait/z;wave;y;adjust/set OBJ;attach/fasten/tie OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;bother/curses/darn/drat OBJ;build/construct/fit/make OBJ;buy/purchase OBJ;carry/hold/take off OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;damn/fuck/shit/sod OBJ;dig OBJ;discard/drop OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ out;empty out OBJ;exam/read/check/describe/examine/watch/x OBJ;feel/fondle/grope/touch OBJ;fill OBJ;find OBJ;get in/into/on/onto OBJ;get off OBJ;get/carry/hold/take OBJ;greetings/hello/hi/hiya/hullo/greet OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;ignite/burn/light OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look under OBJ;leave/yes OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;no/open/uncover/undo/unwrap OBJ;off OBJ;on OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;play OBJ;pour OBJ;put OBJ down;put down OBJ;put on OBJ;ride OBJ;ring OBJ;rotate/screw/turn/twist/unscrew OBJ;run/go/walk/cross/enter OBJ;run/go/walk/leave/yes into/in/inside/through OBJ;search OBJ;shatter OBJ;smell/sniff OBJ;spend OBJ;squash/squeeze OBJ;stand on OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;taste OBJ;throw OBJ;throw OBJ down;throw down OBJ;tip/empty OBJ;unlock/lock OBJ;wave OBJ;adjust/set OBJ to OBJ;answer/say/shout/speak OBJ to OBJ;ask OBJ about OBJ;ask OBJ for OBJ;attach/fasten/tie OBJ to OBJ;burn/light OBJ with OBJ;carry/hold/take OBJ off OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;consult OBJ about OBJ;consult OBJ on OBJ;dig OBJ with OBJ;discard/drop OBJ in/into/down OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ to/into/on/onto OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;l/look up OBJ in OBJ;lock OBJ with OBJ;put OBJ in/inside/into OBJ;read OBJ in OBJ;read about OBJ in OBJ;remove/get/carry/hold/take OBJ from OBJ;tell OBJ about OBJ;throw/discard/drop OBJ at/against/on/onto OBJ;throw/discard/drop/put OBJ on/onto OBJ;throw/insert OBJ in/into OBJ;unlock/no/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

enchanter = {
    "name" : "enchanter",
    "rom" : "enchanter.z3",
    "seed" : 0,
    # Walkthrough adapted from http://mirror.ifarchive.org/if-archive/solutions/jgunness.zip
    "walkthrough": "NE/enter shack/OPEN OVEN/GET BREAD/take JUG/take LANTERN/exit shack/NE/SE/NE/FILL JUG/SW/SE/SW/SW/S/READ SCROLL/GNUSTO REZROV SPELL/NE/NE/E/E/LEARN REZROV/REZROV GATE/E/N/FROTZ LANTERN/N/U/GET EGG/EXAMINE IT/TURN HANDLE/PRESS KNOB/PULL SLIDE/MOVE CRANK/PUSH BUTTON/GET SHREDDED SCROLL/READ IT/D/E/E/E/E/E/LEARN REZROV/REZROV GATE/N/GET CRUMPLED SCROLL/READ IT/GNUSTO KREBF SPELL/LEARN KREBF/KREBF SHREDDED SCROLL/READ FADED SCROLL/GNUSTO ZIFMIA SPELL/E/LEARN NITFOL/NITFOL FROGS/LOOK UNDER LILY PAD/READ DAMP SCROLL/GNUSTO CLEESH SPELL/W/drink water/S/S/EXAMINE TRACKS/REACH INTO HOLE/Take book/EAT BREAD/N/EXAMINE dusty book/READ OF UNSEEN TERROR/DROP DUSTY BOOK/READ FRAYED SCROLL/GNUSTO GONDAR SPELL/W/W/W/W/W/S/S/S/S/U/wait/LIE DOWN/STAND UP/EXAMINE POST/PRESS BUTTON/GET GOLD LEAF SCROLL/READ IT/GNUSTO VAXUM SPELL/D/E/S/OPEN DOOR/N/READ WRITINGS/MOVE BLOCK/E/GET STAINED SCROLL/READ IT/GNUSTO EXEX SPELL/W/S/U/E/E/S/SE/LEARN NITFOL/NITFOL TURTLE/TURTLE, FOLLOW ME/NW/N/E/U/LEARN EXEX/EXEX TURTLE/drink water/TURTLE, SE AND GET SCROLL THEN NW/READ BRITTLE SCROLL/GET IT/D/W/W/TURN OFF LANTERN/LOOK/MOVE LIGHTED PORTRAIT/GET BLACK SCROLL/READ IT/GNUSTO OZMOO SPELL/GET CANDLE/LEARN FROTZ/FROTZ CANDLE/LEARN FROTZ/LEARN OZMOO/W/N/FROTZ LANTERN/DROP ALL BUT CANDLE/eat bread/S/E/E/N/N/N/WAIT/OZMOO MYSELF/WAIT/D/W/W/S/CUT ROPE WITH DAGGER/DROP DAGGER/GET ALL BUT DAGGER/S/W/U/LIE DOWN/STAND UP/D/N/N/N/N/LEARN ZIFMIA/LEARN VAXUM/E/E/E/E/ZIFMIA ADVENTURER/LEARN BLORB/VAXUM ADVENTURER/SHOW EGG TO ADVENTURER THEN EAST/E/ADVENTURER, OPEN DOOR/WAIT/BLORB ADVENTURER/U/DROP EGG/drink water/GET PENCIL/GET MAP/D/W/W/W/W/W/W/S/S/S/S/EAT BREAD/E/S/D/READ MAP/DRAW LINE FROM F TO P/WAIT/ERASE LINE BETWEEN B AND R/ERASE LINE BETWEEN M AND V/DRAW LINE FROM B TO J/E/SE/SE/SW/DROP MAP/DROP PENCIL/GET SCROLL/READ IT/NE/NW/NW/W/U/U/N/OPEN BOX/GET VELLUM SCROLL/READ IT/GNUSTO MELBOR SPELL/N/W/W/W/drink water/W/NW/NE/FILL JUG/SW/SE/E/E/E/S/S/LEARN MELBOR/SLEEP/LEARN VAXUM/LEARN GONDAR/LEARN MELBOR/E/E/MELBOR MYSELF/EAT BREAD/E/N/N/N/E/E/KULCAD STAIRS/READ ORNATE SCROLL/IZYUK MYSELF/E/GONDAR DRAGON/VAXUM BEING/GUNCHO KRILL",
    "grammar" : "again/g;answer/reply;back;bathe/swim/wade;brief;call/say/talk;chase/come/follow/pursue;concea/hide;curse/damn;diagno;dive/jump/leap;enter;filfre;gaze/l/look/stare;hello/hi;hop/skip;i/invent;krebf;leave;mumble/sigh;nap/sleep/snooze;plugh/xyzzy;pray;q/quit;repent;restar;restor;save;score;scream/shout/yell;script;spells;stand;stay;super/superb;t/time;thank/thanks;unscri;verbos;versio;wait/z;zork;answer/reply OBJ;attack/fight/hit/hurt/injure OBJ;avoid OBJ;awake/startl/surpri/wake OBJ;awake/startl/surpri/wake up OBJ;banish/begone/drive/exorci OBJ;banish/begone/drive/exorci away OBJ;banish/begone/drive/exorci out OBJ;bathe/swim/wade in OBJ;beckon/brandi/motion/wave OBJ;beckon/brandi/motion/wave to OBJ;beckon/brandi/motion/wave/scream/shout/yell at OBJ;bite/kick OBJ;blorb OBJ;blow out OBJ;board OBJ;break/crack/damage/destro/hatch/smash OBJ;call/say/talk to OBJ;carry/get/grab/hold/remove/take OBJ;carry/get/grab/hold/remove/take off OBJ;carry/get/grab/hold/remove/take out OBJ;cast/incant OBJ;chase/come/follow/pursue OBJ;cleesh OBJ;climb/scale/sit OBJ;climb/scale/sit/carry/get/grab/hold/remove/take in OBJ;climb/scale/sit/carry/get/grab/hold/remove/take on OBJ;climb/scale/sit/go/procee/run/step/walk down OBJ;climb/scale/sit/go/procee/run/step/walk up OBJ;close OBJ;concea/hide OBJ;connec OBJ;consum/eat/taste OBJ;count OBJ;cross/ford OBJ;curse/damn OBJ;deflat OBJ;descri/examin/inspec/what/whats OBJ;descri/examin/inspec/what/whats on OBJ;descri/examin/inspec/what/whats/gaze/l/look/stare in OBJ;dig in OBJ;dig with OBJ;discon/erase/rub OBJ;discon/erase/rub betwee OBJ;discon/erase/rub from OBJ;discon/erase/rub out OBJ;disemb OBJ;dispat/kill/murder/slay/stab OBJ;dive/jump/leap across OBJ;dive/jump/leap from OBJ;dive/jump/leap in OBJ;dive/jump/leap off OBJ;dive/jump/leap/go/procee/run/step/walk over OBJ;douse/exting OBJ;draw/make betwee OBJ;draw/make from OBJ;draw/make on OBJ;drink/sip/swallo OBJ;drink/sip/swallo from OBJ;drop/exit/releas OBJ;enter OBJ;escape OBJ;escape from OBJ;exex OBJ;feel/pat/pet/touch OBJ;filfre OBJ;fill OBJ;find/see/seek/where OBJ;flip/set/shut/turn OBJ;flip/set/shut/turn off OBJ;flip/set/shut/turn on OBJ;fly/go/procee/run/step/walk OBJ;forget/unlear/unmemo OBJ;free/unatta/unfast/unhook/untie OBJ;frotz OBJ;gaze/l/look/stare OBJ;gaze/l/look/stare around OBJ;gaze/l/look/stare at OBJ;gaze/l/look/stare behind OBJ;gaze/l/look/stare out OBJ;gaze/l/look/stare throug OBJ;gaze/l/look/stare under OBJ;gaze/l/look/stare with OBJ;gaze/l/look/stare/search for OBJ;gestur/point at OBJ;gestur/point to OBJ;gnusto OBJ;go/procee/run/step/walk around OBJ;go/procee/run/step/walk behind OBJ;go/procee/run/step/walk in OBJ;go/procee/run/step/walk on OBJ;go/procee/run/step/walk to OBJ;go/procee/run/step/walk under OBJ;go/procee/run/step/walk with OBJ;gondar OBJ;gross out OBJ;guncho OBJ;hello/hi OBJ;insert/lay/place/put/stuff down OBJ;insert/lay/place/put/stuff on OBJ;izyuk OBJ;kiss OBJ;knock/rap at OBJ;knock/rap down OBJ;knock/rap on OBJ;krebf OBJ;kulcad OBJ;launch OBJ;lean on OBJ;learn OBJ;leave OBJ;lie down OBJ;lift/raise OBJ;lift/raise up OBJ;light OBJ;listen for OBJ;listen to OBJ;lower OBJ;melbor OBJ;memori OBJ;molest/rape OBJ;move/pull/tug OBJ;nap/sleep/snooze in OBJ;nap/sleep/snooze on OBJ;nitfol OBJ;open OBJ;open up OBJ;ozmoo OBJ;pick OBJ;pick up OBJ;play OBJ;pour/spill OBJ;press/push OBJ;press/push on OBJ;pull/tug on OBJ;pump up OBJ;reach in OBJ;read/skim OBJ;rezrov OBJ;roll up OBJ;search OBJ;search in OBJ;send for OBJ;shake OBJ;slide OBJ;smell/sniff OBJ;spin OBJ;squeez OBJ;stand/carry/get/grab/hold/remove/take up OBJ;stay OBJ;strike OBJ;swing/thrust OBJ;tell OBJ;thank/thanks OBJ;vaxum OBJ;wait/z for OBJ;wear OBJ;who OBJ;wind OBJ;wind up OBJ;write on OBJ;write with OBJ;zifmia OBJ;apply OBJ to OBJ;ask OBJ for OBJ;attach/fasten/secure/tie OBJ to OBJ;attach/fasten/secure/tie up OBJ with OBJ;attack/fight/hit/hurt/injure OBJ with OBJ;beckon/brandi/motion/wave OBJ at OBJ;blind/jab/poke OBJ with OBJ;break/crack/damage/destro/hatch/smash OBJ with OBJ;break/crack/damage/destro/hatch/smash down OBJ with OBJ;burn/ignite OBJ with OBJ;burn/ignite down OBJ with OBJ;carry/get/grab/hold/remove/take OBJ from OBJ;carry/get/grab/hold/remove/take OBJ off OBJ;carry/get/grab/hold/remove/take OBJ out OBJ;carry/get/grab/hold/remove/take/bring OBJ OBJ;cast/incant OBJ at OBJ;cast/incant OBJ on OBJ;chuck/hurl/throw/toss OBJ at OBJ;chuck/hurl/throw/toss OBJ in OBJ;chuck/hurl/throw/toss OBJ off OBJ;chuck/hurl/throw/toss OBJ on OBJ;chuck/hurl/throw/toss OBJ over OBJ;chuck/hurl/throw/toss OBJ with OBJ;concea/hide OBJ from OBJ;connec OBJ to OBJ;connec OBJ with OBJ;cut/pierce/slice OBJ with OBJ;cut/pierce/slice with OBJ with OBJ;dig OBJ with OBJ;dig in OBJ with OBJ;discon/erase/rub betwee OBJ to OBJ;discon/erase/rub betwee OBJ with OBJ;discon/erase/rub from OBJ to OBJ;discon/erase/rub from OBJ with OBJ;discon/erase/rub out OBJ with OBJ;dispat/kill/murder/slay/stab OBJ with OBJ;donate/feed/give/hand/offer OBJ OBJ;donate/feed/give/hand/offer OBJ to OBJ;draw/make betwee OBJ to OBJ;draw/make betwee OBJ with OBJ;draw/make from OBJ to OBJ;draw/make from OBJ with OBJ;draw/make on OBJ with OBJ;drop/exit/releas OBJ down OBJ;drop/exit/releas OBJ on OBJ;drop/exit/releas/insert/lay/place/put/stuff OBJ in OBJ;feel/pat/pet/touch OBJ with OBJ;fill OBJ at OBJ;fill OBJ with OBJ;fix/glue/patch/plug/repair OBJ with OBJ;flip/set/shut/turn OBJ for OBJ;flip/set/shut/turn OBJ to OBJ;flip/set/shut/turn OBJ with OBJ;free/unatta/unfast/unhook/untie OBJ from OBJ;gag OBJ with OBJ;gaze/l/look/stare at OBJ with OBJ;grease/lubric/oil OBJ with OBJ;hone/sharpe OBJ with OBJ;inflat OBJ with OBJ;insert/lay/place/put/stuff OBJ behind OBJ;insert/lay/place/put/stuff OBJ on OBJ;insert/lay/place/put/stuff OBJ under OBJ;light OBJ with OBJ;liquif/melt OBJ with OBJ;lock OBJ with OBJ;open OBJ with OBJ;pick OBJ with OBJ;pour/spill OBJ from OBJ;pour/spill OBJ in OBJ;pour/spill OBJ on OBJ;pump up OBJ with OBJ;read/skim OBJ with OBJ;show OBJ OBJ;show OBJ to OBJ;slide/press/push OBJ OBJ;slide/press/push OBJ to OBJ;slide/press/push OBJ under OBJ;spray OBJ on OBJ;spray OBJ with OBJ;squeez OBJ on OBJ;strike OBJ with OBJ;swing/thrust OBJ at OBJ;unlock OBJ with OBJ;write on OBJ with OBJ;",
    "max_word_length" : 6
}

enter = {
    "name": "enter",
    "rom": "enter.z5",
    "seed" : 0,
    # Walkthrough obtained by issuing the command WALKTHRU.
    "walkthrough": "open door/talk to alltext/3/g/3/g/1/1/talk to queenie/2/g/3/g/4/look at mural/look at queenie/4/n/take list/take envelope/read list/s/close door/w/n/e/give gram to meghan/w/s/s/e/w/s/talk to Stephanie/1/g/2/look at Stephanie/put gram in basket/3/open door/w/give gram to Danielle/say -120 to garrulous/e/n/n/n/n/wear badge/open door/knock on door/talk to empirious/1/w/take jar/give gram to ed/e/nw/talk to woman/1/w/w/e/n/talk to reunite/1/g/3/s/w/w/s/give gram to Alicia/give gram to andrea/n/e/n/say rat to Picasso/give gram to silas/s/e/n/give pass to reunite/s/se/s/s/w/1/give gram to jim/say firefly to jim/look at list/talk to alltext/2/e/give gram to queenie/talk to queenie/4/e/open door/n",
    "grammar" : "about;awake/awaken/wake;awake/awaken/wake up;bother/curses/darn/drat;brief/normal;carry/hold/take inventory;damn/fuck/shit/sod;die/q/quit;dive/swim;exit/out/outside/stand;full/fullscore;full/fullscore score;get out/off/up;hear/listen;hint;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;intro;l/look;leave/go/run/walk;long/verbose;menu;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;pray;restart;restore;save;score;script/transcrip;script/transcrip off;script/transcrip on;short/superbrie;sing;smell/sniff;smile;sorry;stand up;think;verify;version;wait/z;walkthru;wave;wink;y/yes;0;1;2;3;4;adjust/set OBJ;attach/fasten/fix/tie OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;carry/hold/take off OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;cross/enter/go/run/walk OBJ;damn/fuck/shit/sod OBJ;dig OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;get in/into/on/onto OBJ;get off OBJ;get/carry/hold/take OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;knock on OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look through OBJ;l/look under OBJ;leave OBJ;leave/go/run/walk into/in/inside/through OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;lock OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;put OBJ down;put down OBJ;put on OBJ;read/check/describe/examine/watch/x OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;smell/sniff OBJ;smile at OBJ;squash/squeeze OBJ;stand on OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;talk to OBJ;taste OBJ;wave OBJ;wink at OBJ;adjust/set OBJ to OBJ;answer/say/shout/speak OBJ to OBJ;ask OBJ about OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;burn/light OBJ with OBJ;carry/hold/take OBJ off OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;consult OBJ about OBJ;consult OBJ on OBJ;dig OBJ with OBJ;discard/drop/throw OBJ at/against/on/onto OBJ;discard/drop/throw OBJ in/into/down OBJ;discard/drop/throw/put OBJ on/onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ to/into/on/onto OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;insert OBJ in/into OBJ;l/look up OBJ in OBJ;lock OBJ with OBJ;put OBJ in/inside/into OBJ;read OBJ in OBJ;read about OBJ in OBJ;remove/get/carry/hold/take OBJ from OBJ;tell OBJ about OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

gold = {
    "name": "gold",
    "rom": "gold.z5",
    "seed": 0,
    # Walkthrough adapted from http://mirror.ifarchive.org/if-archive/games/adrift/Goldilocks.zip and http://www.allthingsjacq.com/intfic_clubfloyd_20100301.html
    "walkthrough": "examine pedlar/ask pedlar about suitcase/ask pedlar about beans/south/west/north/north/get milkbottle/south/west/examine vegetable plot/pull leaves/inventory/north/feed turnip to daisy/south/east/south/east/north/inventory/examine packet/open packet/get magic bean/south/west/north/west/in/get secateurs/get paintbrush/examine plant pots/get pots/get trowel/open trunk/get dynamite/out/plant bean in vegetable plot/fill milkbottle with pondwater/water bean/look/get secateurs/get dynamite/get paintbrush/climb beanstalk/jump to roof/climb down chimney/north/examine mousetrap/get cheese/open freezer/get pork chops/south/east/open door/up/ask wolf about pigs/give pork to wolf/down/north/drop secateurs/south/west/north/get matchbox/south/east/north/sit in tiny little chair/look/get firewood/south/west/north/south/examine fireplace/examine ash/put firewood on hearth/light firewood with match/cook pork chops/get pork chops/east/up/give pork chops to wolf/down/wedge door with cheese/out/south/west/north/ask wolf to blow turbine/get oil can/south/east/north/in/inventory/drop matchbox/get rug/open trapdoor/west/north/get porridge oats/examine porridge oats/open carton/get pendant/drop carton/wear pendant/south/east/down/examine wardrobe/unlock wardrobe with key/drop key/open wardrobe/get dumbells/up/west/examine table/get spoon/examine dresser/open dresser/get gigantic bowl/pour hot porridge in gigantic bowl/pour cold porridge in gigantic bowl/eat tiny bowl of porridge/eat gigantic quantity of just-right porridge/drop gigantic bowl/east/down/get dumbells/up/north/sit in medium-sized chair/get spectacles/drop dumbells/out/south/down/move wardrobe/west/north/examine skeleton/south/east/examine washing machine/open washing machine/open washing machine with poker/examine washing machine/search sludge/examine tiny metal/get brass key/examine fusebox/examine volt meter/examine switch A/examine switch b/press switch b/up/north/examine large chair/get antimacassar/examine electrodes/drop brass key/drop antimacassar/drop spoon/get secateurs/cut cable/oil secateurs/cut cable/south/down/press switch b/up/north/sit in large chair/press button/get remote control/examine television/plug in television/watch television/sit in large chair/press button/stand up/south/out/south/west/climb beanstalk/jump to roof/adjust aerial/jump to beanstalk/down/east/north/in/north/sit in large chair/press button/watch television/examine remote control/press channel/press channel/press buy/drop remote control/open fridge/get beer/drink beer/drop beer can/sit in large chair/press button/stand up/south/out/look/get package/open package/get leaflet/drop secateurs/get toaster/drop package/inventory/in/west/look/examine dining table/examine dynamite/examine toaster/put dynamite in toaster/east/north/south/down/press switch a/up/north/sit in large chair/press button/unplug tv/plug in toaster/press lever/examine toaster/inventory/wear spectacles/read leaflet/sit on large chair/press button/stand up/south/down/press switch a/up/inventory/drop spectacles/drop leaflet/north/sit in large chair/press button/west/open crate with poker/look/get magic porridge pot/unlock filing cabinet with key/open filing cabinet/read instructions/examine bench/get wrench/get paint/east/sit in large chair/press button/stand up/south/up/open window with wrench/examine huge bed/get blanket/drop blanket/examine snooker table/examine pockets/get cue ball/down/west/look/paint cue ball/east/out/south/west/throw ball in pond/get frog/east/north/in/up/look/kiss frog/look/ask fairy godmother about cinderella/down/out/south/west/examine vegetable plot/get pumpkin/east/north/in/up/give pumpkin to fairy godmother/ask fairy godmother about horse/down/west/north/get mousetrap/examine mousetrap/get dead mouse/drop mousetrap/south/east/up/give mouse to fairy godmother/ask fairy godmother about dress/look/get wand/down/north/sit in large chair/press button/west/wave wand at magic porridge pot/wave wand at underwear/east/sit in large chair/press button/stand up/south/down/look/say alakazam/up/get bearskin rug/cover trapdoor with bearskin rug/look/up/lie in tiny little bed",
    "grammar" : "about/credits;alakazam;alakazoo;awake/awaken/wake;awake/awaken/wake up;bend;bother/curses/darn/drat;brief/normal;carry/hold/take inventory;damn/fuck/shit/sod;die/q/quit;dive/swim;full/fullscore;full/fullscore score;get out/off/up;hear/listen;help/hint;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;leave/go/run/walk;long/verbose;nap/sleep;no;noscript/unscript;notify;notify off;notify on;nouns/pronouns;objects;places;pray;recording;recording off;recording on;replay;restart;restore;save;score;script/transcrip;script/transcrip off;script/transcrip on;short/superbrie;sing;smell/sniff;sorry;stand up;stand/exit/out/outside;think;verify;version;wait/z;wave;y/yes;zoom;zoom away/absent;zoom in;zoom out;adjust/set OBJ;attach/fasten/fix/tie OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;bury/plant OBJ;buy/purchase OBJ;carry/hold/take off OBJ;carry/hold/take/get OBJ;check/describe/examine/watch/x OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;climb/scale OBJ;climb/scale down OBJ;climb/scale up OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;cook OBJ;damn/fuck/shit/sod OBJ;damn/fuck/shit/sod OBJ;dig OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull/unplug OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty/pour OBJ;empty/pour OBJ out;empty/pour out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;flip OBJ;get in/into/on/onto OBJ;get off OBJ;go/run/walk/cross/enter OBJ;have sex with OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;hop/jump/skip to OBJ;knock OBJ;knock on OBJ;l/look at OBJ;l/look behind OBJ;l/look inside/in/into/through/on OBJ;l/look under OBJ;leave/exit/out/outside OBJ;leave/go/run/walk into/in/inside/through OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;milk OBJ;mix OBJ;oil OBJ;open/uncover/undo/unwrap OBJ;paint OBJ;peel OBJ;peel off OBJ;pet OBJ;pick OBJ up;pick up OBJ;plug OBJ;plug OBJ in;plug in OBJ;put OBJ down;put down OBJ;put on OBJ;read OBJ;ring/clear/move/press/push/shift OBJ;rotate/turn/twist/unscrew OBJ;screw OBJ;screw/rotate/turn/twist/unscrew/switch OBJ off;screw/rotate/turn/twist/unscrew/switch OBJ on;screw/rotate/turn/twist/unscrew/switch on OBJ;screw/rotate/turn/twist/unscrew/switch/close/cover/shut off OBJ;search OBJ;sell OBJ;separate OBJ;smell/sniff OBJ;squash/squeeze OBJ;stand on OBJ;swing OBJ;swing on OBJ;switch OBJ;taste OBJ;use OBJ;water OBJ;wave OBJ;adjust/set OBJ to OBJ;answer/say/shout/speak OBJ to OBJ;ask OBJ about OBJ;ask OBJ for OBJ;ask that OBJ OBJ;attach/fasten/fix/tie OBJ to OBJ;burn/light OBJ with OBJ;bury/plant OBJ in OBJ;carry/hold/take OBJ off OBJ;carry/hold/take/remove/get OBJ from OBJ;chop/cut/prune/slice OBJ with OBJ;clear/move/press/push/shift OBJ OBJ;close/cover/shut OBJ with OBJ;consult OBJ about OBJ;consult OBJ on OBJ;dig OBJ with OBJ;discard/drop/throw OBJ at/against/on/onto OBJ;discard/drop/throw OBJ in/into/down OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty/pour OBJ in OBJ;empty/pour OBJ to/into/on/onto OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;fill OBJ with OBJ;force/jemmy/lever/prise/prize/pry OBJ apart/open with OBJ;force/jemmy/lever/prise/prize/pry apart/open OBJ with OBJ;insert OBJ in/into OBJ;l/look up OBJ in OBJ;lock OBJ with OBJ;oil OBJ with OBJ;plug OBJ into OBJ;put OBJ in/inside/into OBJ;put OBJ under OBJ;put/discard/drop/throw OBJ on/onto OBJ;read OBJ in OBJ;read about OBJ in OBJ;tell OBJ about OBJ;tell/ask OBJ to OBJ;transfer/clear/move/press/push/shift OBJ to OBJ;unlock/force/jemmy/lever/prise/prize/pry/open/uncover/undo/unwrap OBJ with OBJ;wave OBJ at OBJ;wedge OBJ with OBJ;",
    "max_word_length" : 9
}

hhgg = {
    "name": "hhgg",
    "rom": "hhgg.z3",
    "seed" : 4,
    # Walkthrough adapted from http://www.eristic.net/games/infocom/hhg.html
    'walkthrough': 'Get Up/Turn on Light/Get Gown/Wear Gown/Look in pocket/take analgesic/Get all/South/Get Mail/South/Lie Down In Front Of Bulldozer/Wait/Wait/Wait/Wait/Wait/Wait/Wait/Follow Ford/Enter Pub/Look Shelf/Buy Sandwich/Drink Beer/Drink Beer/Drink Beer/Exit/Feed dog sandwich/Get towel/Wait/wait/wait/wait/wait/wait/wait/wait/get device/push green button/n/s/n/s/smell/examine shadow/Eat Peanuts/Take off gown/Put Gown on hook/put towel over drain/wait/get satchel/put satchel in front of panel/put mail on satchel/push dispenser button/get gown/wear gown/get all/push switch/z/z/z/z/z/z/z/enjoy poetry/z/z/z/z/z/type \"bleem\"/get plotter/z/z/z/examine thumb/press green button/n/s/n/s/listen/Aft/read brochure/z/z/inventory/take pincer/put all into thing/d/port/touch pad/get cup/starboard/aft/aft/yes/yes/aft/no/look/look/drop thing/get rasp/get pliers/put rasp into thing/put pliers into thing/get improbability drive/fore/fore/up/drop drive/drop cup/drop plotter/z/drop plotter/z/drop plotter/put small plug in plotter/put bit in cup/turn on drive/n/s/n/s/smell/look at shadow/say my name/e/examine memorial/get sharp stone/put towel on your head/carve my name on the memorial/remove towel/drop stone/w/sw/get interface/z/z/z/z/z/hear the dark/aft/aft/up/d/port/open panel/take circuit/insert interface in nutrimat/close panel/touch pad/starboard/up/put large plug in large receptacle/z/turn on drive/d/port/get tea/starboard/up/drop tea/z/z/z/z/z/z/z/z/z/z/remove bit/put bit in tea/turn on drive/z/touch/touch/drink liquid/examine arthur/drop wine/get fluff/open bag/put fluff in bag/get wine/z/z/z/z/z/z/hear/aft/aft/up/open handbag/get tweezers/get fluff/put all in thing/turn on drive/z/touch/touch/touch/touch/drink liquid/get flowerpot/put it in thing/examine thumb/press red button/give thumb to robot/z/show warranty/press green button/z/z/z/z/hear/aft/aft/up/turn on drive/see/see/see/see/examine light/look under seat/unlock box with key/get glass/get wrench/push autopilot button/steer towards rocky spire/z/z/z/stand up/out/wave at crowd/z/z/z/guards, drop rifles/Trillian, shoot rifles/enter/z/z/z/z/hear/aft/aft/aft/down/get fluff/get tools/up/fore/up/turn on drive/see/examine light/n/open satchel/get fluff/get towel/give towel to Arthur/idiot/walk around bulldozer/Prosser, lie in the mud/s/w/buy beer/buy peanuts/drink beer/drink beer/e/n/give fluff to Arthur/z/z/z/z/z/z/z/hear/aft/aft/up/i/turn on drive/hear/hear/hear/z/hear/hear/hear/hear/aft/get awl/z/z/z/z/n/n/n/get particule/z/z/z/z/hear/aft/aft/up/remove bit/take tea/i/take no tea/i/plant fluff in flowerpot/seat/plant fluff in flowerpot/satchel/plant fluff in flowerpot/jacket/plant fluff in flowerpot/z/z/z/port/examine plant/get fruit/d/aft/port/open door/drink tea/port/get chisel/Marvin, open the hatch/starboard/d/eat fruit/drop all but pincer/take pincer/drop thing/i/starboard/z/z/give pincer to Marvin/port/d',
    "grammar" : "again/g;answer/reply;applau/cheer/clap;argue/protes;blast/fire/shoot;bleem/frippi/gashee/lyshus/misera/morpho/thou/venchi/wimbgu;brief;crawl/kneel/peek;depart/exit/withdr;diagno;disrob;dive/jump/leap;doze/nap/snooze;enter;escape/flee;footno;gaze/l/look/stare;go/procee/run/step/walk;hello/hi;help/hint/hints;hide;hitch/hitchh;hop/skip;howl/scream/shout/yell;idiot;invent/i/i'm/im;leave;no;ok/okay/sure/y/yes;panic;q/quit;relax;restar;restor;rise/stand;save;say/speak/talk;score;script;sleep;smile;stay/wait/z;super/superb;type;unscri;verbos;versio;wave;why;activa/start OBJ;addres/tell OBJ;answer/reply OBJ;answer/reply to OBJ;apprec OBJ;approa OBJ;assaul/attack/fight/hit/kill/murder/punch/slap/strike OBJ;attach/fasten/secure/tie OBJ;attach/fasten/secure/tie togeth OBJ;awake/rouse/wake OBJ;awake/rouse/wake up OBJ;bite OBJ;blast/fire/shoot OBJ;block/stop OBJ;board/embark OBJ;break/crack/damage/demoli/destro/smash/wreck OBJ;break/crack/damage/demoli/destro/smash/wreck down OBJ;brush OBJ;buy/order/purcha OBJ;call/phone OBJ;carry/catch/get/grab/hold/take OBJ;carry/catch/get/grab/hold/take dresse OBJ;carry/catch/get/grab/hold/take drunk OBJ;carry/catch/get/grab/hold/take off OBJ;carry/catch/get/grab/hold/take out OBJ;carry/catch/get/grab/hold/take undres OBJ;chase/follow/pursue OBJ;clean/tidy/wash OBJ;clean/tidy/wash up OBJ;climb/scale OBJ;climb/scale down OBJ;climb/scale over OBJ;climb/scale up OBJ;climb/scale/dive/jump/leap/go/procee/run/step/walk throug OBJ;climb/scale/rest/sit/squat/carry/catch/get/grab/hold/take in OBJ;climb/scale/rest/sit/squat/carry/catch/get/grab/hold/take on OBJ;close/shut OBJ;close/shut off OBJ;count OBJ;debark/disemb OBJ;depart/exit/withdr OBJ;descen OBJ;descri/examin/inspec/observ/scour/see/study OBJ;descri/examin/inspec/observ/scour/see/study on OBJ;descri/examin/inspec/observ/scour/see/study/gaze/l/look/stare in OBJ;descri/examin/inspec/observ/scour/see/study/gaze/l/look/stare/frisk/rummag/search for OBJ;devour/eat/gobble/ingest OBJ;dig in OBJ;dig throug OBJ;dig with OBJ;discon/unplug OBJ;dive/jump/leap across OBJ;dive/jump/leap from OBJ;dive/jump/leap off OBJ;dive/jump/leap/go/procee/run/step/walk in OBJ;dive/jump/leap/go/procee/run/step/walk out OBJ;dive/jump/leap/go/procee/run/step/walk over OBJ;doff/remove/shed OBJ;don/wear OBJ;donate/give/hand/offer/sell up OBJ;draw/open/part OBJ;draw/open/part up OBJ;drink/guzzle/imbibe/quaff/sip/swallo/swill OBJ;drink/guzzle/imbibe/quaff/sip/swallo/swill from OBJ;drop OBJ;enjoy OBJ;enter OBJ;escape/flee OBJ;escape/flee from OBJ;exting OBJ;feed OBJ;feel/pat/pet/rub/touch OBJ;fill OBJ;find/seek OBJ;fix/repair/unjam OBJ;flick/flip/switch/toggle/turn OBJ;flick/flip/switch/toggle/turn around OBJ;flick/flip/switch/toggle/turn off OBJ;flick/flip/switch/toggle/turn on OBJ;footno OBJ;free/unatta/unfast/unknot/untie OBJ;frisk/rummag/search OBJ;frisk/rummag/search in OBJ;gaze/l/look/stare OBJ;gaze/l/look/stare around OBJ;gaze/l/look/stare at OBJ;gaze/l/look/stare behind OBJ;gaze/l/look/stare down OBJ;gaze/l/look/stare on OBJ;gaze/l/look/stare out OBJ;gaze/l/look/stare throug OBJ;gaze/l/look/stare under OBJ;gaze/l/look/stare up OBJ;go/procee/run/step/walk OBJ;go/procee/run/step/walk around OBJ;go/procee/run/step/walk away OBJ;go/procee/run/step/walk behind OBJ;go/procee/run/step/walk down OBJ;go/procee/run/step/walk on OBJ;go/procee/run/step/walk to OBJ;go/procee/run/step/walk up OBJ;hear OBJ;hello/hi OBJ;hide behind OBJ;hide under OBJ;howl/scream/shout/yell at OBJ;howl/scream/shout/yell to OBJ;hurl/throw/toss OBJ;hurl/throw/toss in OBJ;i/i'm/im OBJ;insert/lay/place/put/stuff down OBJ;insert/lay/place/put/stuff on OBJ;kick OBJ;kiss OBJ;knock/rap at OBJ;knock/rap down OBJ;knock/rap on OBJ;leave OBJ;lick/taste OBJ;lie/reclin before OBJ;lie/reclin down OBJ;lie/reclin in OBJ;lie/reclin on OBJ;lift/raise OBJ;lift/raise up OBJ;light OBJ;listen to OBJ;lock OBJ;lower OBJ;make OBJ;move/pull OBJ;move/pull togeth OBJ;pay for OBJ;pick OBJ;pick up OBJ;point/steer at OBJ;point/steer to OBJ;pour/spill/sprink OBJ;press/push on OBJ;press/push/slide OBJ;rape OBJ;read/skim OBJ;refuse OBJ;replac OBJ;rest/sit/squat down OBJ;rise/stand before OBJ;rise/stand in OBJ;rise/stand on OBJ;rise/stand/carry/catch/get/grab/hold/take up OBJ;rotate/spin/whirl OBJ;save/help/hint/hints OBJ;say/speak/talk OBJ;say/speak/talk to OBJ;shake OBJ;sleep in OBJ;sleep on OBJ;smell/sniff/whiff OBJ;smile at OBJ;stay/wait/z for OBJ;thank/thanks OBJ;type on OBJ;unlock OBJ;wave OBJ;wave at OBJ;wave to OBJ;what/what'/whats OBJ;what/what'/whats about OBJ;where/wheres OBJ;who/whos OBJ;ask/consul/query OBJ about OBJ;ask/consul/query OBJ for OBJ;ask/consul/query OBJ on OBJ;assaul/attack/fight/hit/kill/murder/punch/slap/strike OBJ with OBJ;blast/fire/shoot OBJ at OBJ;blast/fire/shoot OBJ with OBJ;block/stop OBJ with OBJ;break/crack/damage/demoli/destro/smash/wreck OBJ with OBJ;brush OBJ with OBJ;bury/plant OBJ in OBJ;call/phone OBJ on OBJ;call/phone OBJ with OBJ;carry/catch/get/grab/hold/take OBJ in OBJ;carry/catch/get/grab/hold/take OBJ off OBJ;carry/catch/get/grab/hold/take OBJ out OBJ;carve/inscri/scratc/write OBJ in OBJ;carve/inscri/scratc/write OBJ on OBJ;carve/inscri/scratc/write OBJ with OBJ;connec/plug/attach/fasten/secure/tie OBJ to OBJ;cover OBJ with OBJ;cut/slice OBJ with OBJ;cut/slice throug OBJ with OBJ;dangle/drop/hang/insert/lay/place/put/stuff OBJ in OBJ;descri/examin/inspec/observ/scour/see/study OBJ throug OBJ;doff/remove/shed/carry/catch/get/grab/hold/take OBJ from OBJ;drape/wrap OBJ in OBJ;draw/open/part OBJ with OBJ;drop OBJ down OBJ;drop/insert/lay/place/put/stuff OBJ before OBJ;drop/insert/lay/place/put/stuff/drape/wrap OBJ on OBJ;feed/donate/give/hand/offer/sell OBJ OBJ;feed/donate/give/hand/offer/sell OBJ to OBJ;feel/pat/pet/rub/touch OBJ with OBJ;flick/flip/switch/toggle/turn OBJ to OBJ;flick/flip/switch/toggle/turn OBJ with OBJ;flick/flip/switch/toggle/turn off OBJ OBJ;flick/flip/switch/toggle/turn on OBJ OBJ;gaze/l/look/stare at OBJ throug OBJ;hang OBJ from OBJ;hang OBJ on OBJ;hurl/throw/toss OBJ at OBJ;hurl/throw/toss OBJ in OBJ;hurl/throw/toss OBJ off OBJ;hurl/throw/toss OBJ over OBJ;hurl/throw/toss OBJ throug OBJ;hurl/throw/toss OBJ to OBJ;hurl/throw/toss OBJ up OBJ;insert/lay/place/put/stuff OBJ across OBJ;insert/lay/place/put/stuff OBJ at OBJ;insert/lay/place/put/stuff OBJ behind OBJ;insert/lay/place/put/stuff OBJ down OBJ;insert/lay/place/put/stuff/attach/fasten/secure/tie/drape/wrap OBJ around OBJ;insert/lay/place/put/stuff/drape/wrap OBJ over OBJ;lock OBJ with OBJ;move/pull/press/push/flick/flip/switch/toggle/turn/hurl/throw/toss OBJ OBJ;my OBJ OBJ;pick OBJ with OBJ;plug OBJ in OBJ;plug in OBJ in OBJ;plug in OBJ to OBJ;point/steer OBJ at OBJ;point/steer OBJ to OBJ;pour/spill/sprink OBJ in OBJ;pour/spill/sprink OBJ on OBJ;pour/spill/sprink OBJ over OBJ;press/push/insert/lay/place/put/stuff/slide OBJ under OBJ;read/skim OBJ throug OBJ;read/skim OBJ with OBJ;shake OBJ with OBJ;show OBJ OBJ;show OBJ to OBJ;tell OBJ OBJ;tell OBJ about OBJ;tell OBJ to OBJ;unlock OBJ with OBJ;water OBJ with OBJ;what/what'/whats OBJ OBJ;",
    "max_word_length" : 6
}

hollywood = {
    "name": "hollywood",
    "rom": "hollywood.z3",
    "seed" : 0,
    # walkthrough adapted from http://mirror.ifarchive.org/if-archive/solutions/jgunness.zip
    "walkthrough": "N/OPEN MAILBOX/GET PIECE OF PAPER AND BUSINESS CARD/OPEN DOOR/N/TURN ON FLASHLIGHT/N/EXAMINE MODEL/PRESS GREEN/PRESS GREEN/PRESS GREEN/PRESS BLACK/PRESS BLACK/PRESS WHITE/PRESS WHITE/PRESS GREEN/PRESS GREEN/PRESS GREEN/PRESS BLACK/PRESS BLUE/PRESS GREEN/PRESS GREEN/PRESS GREEN/PRESS RED/PRESS RED/PRESS RED/GET RING/E/E/S/GET FILM AND SLIDE/EXAMINE FILM PROJECTOR/REMOVE CAP/DROP IT/TURN ON SLIDE PROJECTOR/INSERT SLIDE IN IT/FOCUS SLIDE LENS/INSERT FILM IN FILM PROJECTOR/TURN ON FILM PROJECTOR/EXAMINE SCREEN/N/GET YELLOW CARD/W/W/S/W/EXAMINE RED STATUETTE/EXAMINE WHITE  STATUETTE/EXAMINE BLUE STATUETTE/E/E/LOOK BEHIND PAINTING/GET GREEN CARD/EXAMINE SAFE/TURN DIAL RIGHT 3/TURN IT LEFT 7/TURN IT RIGHT 5/OPEN SAFE/GET GRATER/E/PLAY people/PUSH PIANO NORTH/D/S/GET PILLAR/DROP IT/N/U/PUSH PIANO SOUTH/AGAIN/D/N/GET METER/S/U/OPEN PIANO/GET VIOLET CARD/W/W/DROP RING/DROP GRATER/DROP METER/N/UNLOCK DOOR/OPEN IT/N/GET ORANGE CARD/S/S/OPEN CLOSET/IN/PULL THIRD PEG/OPEN DOOR/OUT/TURN NEWEL/W/S/LOOK UNDER MAT/GET RED CARD/N/E/E/GET SACK/OPEN WINDOW/OPEN SACK/S/GET BLUE CARD/N/W/D/DROP SACK/W/IN/REMOVE BRICK/DROP IT/GET INDIGO CARD/drop all but flashlight/U/U/U/E/D/GET PENGUIN/U/W/D/D/D/take all/OUT/N/W/D/READ BUSINESS CARD/DROP IT/EXAMINE COMPUTER/TURN IT ON/INSERT RED CARD IN SLOT/INSERT ORANGE CARD IN SLOT/INSERT YELLOW CARD IN SLOT/INSERT GREEN CARD IN SLOT/INSERT BLUE CARD IN SLOT/INSERT INDIGO CARD IN SLOT/INSERT VIOLET CARD IN SLOT/EXAMINE LIGHTS/U/GET MATCHBOX/E/GET PAPER/PUT IT ON YELLOWED PAPER/S/GET RED STATUETTE/DIAL 576-3190/E/N/W/W/D/TAKE TOUPEE/U/E/E/S/U/IN/GET SKIS/PULL SECOND PEG/OPEN DOOR/OUT/N/W/W/D/U/E/E/S/DROP TOUPEE/DROP PHOTO/DROP LETTER/GET FINCH/DROP FINCH/N/N/N/NW/GET SHOVEL/NE/N/N/W/N/W/N/W/S/W/W/N/W/S/E/S/E/N/E/S/W/N/W/S/W/N/W/S/W/N/E/N/E/N/E/E/N/E/S/E/E/S/E/N/E/N/E/S/S/S/W/W/S/E/N/W/S/DIG IN GROUND/DROP SHOVEL/GET STAMP/N/E/S/W/N/E/E/N/N/N/W/S/W/S/W/N/W/W/N/W/S/W/W/S/W/S/W/S/E/N/E/S/E/N/E/S/E/N/W/S/W/N/W/N/E/S/E/E/N/E/S/E/S/E/S/S/N/E/N/GET BALL/PUT IT IN CANNON/OPEN MATCHBOX/GET MATCH/LIGHT IT/LIGHT FUSE WITH MATCH/OPEN COMPARTMENT/GET MASK/E/E/DROP FLASHLIGHT/WEAR SKIS/D/REMOVE SKIS/DROP THEM/GET MATCH/LIGHT CANDLE WITH FIRE/PUT MATCH IN WAX/S/W/DIVE/D/D/W/U/U/N/LIGHT MATCH/LIGHT CANDLE WITH MATCH/N/U/PULL CHAIN/BURN ROPE WITH CANDLE/ENTER RIGHT END OF PLANK/WAIT/DROP ALL BUT CANDLE/GET LADDER/PUT IT IN HOLE/D/GET LADDER/HANG IT ON HOOKS/EXAMINE SAFE/READ PLAQUE/TURN DIAL LEFT 4/TURN IT RIGHT 5/TURN IT LEFT 7/OPEN SAFE/GET FILM/U/GET ALL/U/E/E/GET FLASHLIGHT/W/W/S/GET BUCKET/FILL IT WITH WATER/SE/SW/S/S/S/IN/HANG BUCKET ON THIRD PEG/OUT/U/OPEN DOOR/IN/WAIT/WAIT/OPEN DOOR/OUT/OPEN PANEL/GET HYDRANT/GET PEG/READ NOTE/D/OPEN DOOR/IN/PUT PEG IN HOLE/take gun/throw gun at herman/take stick/throw stick at herman/take club/throw club at herman/stop blade/throw club at belt/turn off saw",
    "grammar" : "aftern/bye/farewe/goodby/greet/greeti/hello/hi/salute/affirm/aye/naw/nay/negati/no/nope/ok/okay/positi/sure/y/yes/yup;back/ski/advanc/crawl/hike/hop/procee/run/skip/step/tramp/trudge/walk;bathe/swim;brief;diagno;fly;gaze/l/look/peek/peer/stare;hint/hints/aid/help/pray;i/invent;loiter/wait/z;nap/rest/sleep/snooze;play;q/quit;restar;restor;rise/stand;save;score;script;super/superb;t/time;tten;unscri;verbos;versio;advanc/crawl/hike/hop/procee/run/skip/step/tramp/trudge/walk off OBJ;affirm/aye/naw/nay/negati/no/nope/ok/okay/positi/sure/y/yes/yup OBJ;aftern/bye/farewe/goodby/greet/greeti/hello/hi/salute OBJ;aid/help/save OBJ;answer/reply/respon OBJ;answer/reply/respon to OBJ;ascend OBJ;ask/interr/query/questi/quiz OBJ;assaul/attack/fight/hit/hurt/injure/kill/murder/punch/slap/slay/stab/strike/whack/wound OBJ;awake/awaken/rouse/startl/surpri/wake OBJ;awake/awaken/rouse/startl/surpri/wake up OBJ;bathe/swim OBJ;bathe/swim in OBJ;bathe/swim to OBJ;bite OBJ;blow OBJ;blow in OBJ;blow out OBJ;blow throug OBJ;blow up OBJ;board/embark OBJ;break/crack/damage/demoli/destro/erase/smash/trash/wreck OBJ;break/crack/damage/demoli/destro/erase/smash/trash/wreck in OBJ;break/crack/damage/demoli/destro/erase/smash/trash/wreck throug OBJ;brush/clean/sweep OBJ;brush/clean/sweep off OBJ;buy OBJ;call/dial/phone OBJ;call/dial/phone up OBJ;carry/catch/confis/get/grab/hold/seize/snatch/steal/take OBJ;carry/catch/confis/get/grab/hold/seize/snatch/steal/take off OBJ;carry/catch/confis/get/grab/hold/seize/snatch/steal/take out OBJ;carry/catch/confis/get/grab/hold/seize/snatch/steal/take up OBJ;chase/follow/pursue OBJ;check/descri/examin/inspec/observ/see/study/survey/watch OBJ;check/descri/examin/inspec/observ/see/study/survey/watch/gaze/l/look/peek/peer/stare in OBJ;check/descri/examin/inspec/observ/see/study/survey/watch/gaze/l/look/peek/peer/stare on OBJ;check/descri/examin/inspec/observ/see/study/survey/watch/gaze/l/look/peek/peer/stare/frisk/ransac/rummag/search for OBJ;chuck/fling/hurl/pitch/throw/toss OBJ;climb/scale OBJ;climb/scale over OBJ;climb/scale throug OBJ;climb/scale under OBJ;climb/scale/carry/catch/confis/get/grab/hold/seize/snatch/steal/take in OBJ;climb/scale/carry/catch/confis/get/grab/hold/seize/snatch/steal/take on OBJ;climb/scale/go/advanc/crawl/hike/hop/procee/run/skip/step/tramp/trudge/walk down OBJ;climb/scale/go/advanc/crawl/hike/hop/procee/run/skip/step/tramp/trudge/walk up OBJ;climb/scale/go/dive/jump/leap/advanc/crawl/hike/hop/procee/run/skip/step/tramp/trudge/walk out OBJ;close/shut/slam OBJ;concea/hide OBJ;concea/hide behind OBJ;concea/hide under OBJ;consum/devour/eat/gobble/nibble/swallo OBJ;count/tally OBJ;cross/traver OBJ;crush/squash/squeez OBJ;debark/disemb OBJ;defile/molest/rape OBJ;depart/exit/scram/withdr OBJ;descen OBJ;detach/free/unatta/undo/unfast/unhook/untie OBJ;dig/excava at OBJ;dig/excava in OBJ;dig/excava throug OBJ;dig/excava up OBJ;dig/excava with OBJ;distur/feel/pat/pet/rub/touch OBJ;dive/jump/leap OBJ;dive/jump/leap from OBJ;dive/jump/leap off OBJ;dive/jump/leap over OBJ;doff/remove/shed OBJ;don/wear OBJ;douse/exting/quench/snuff OBJ;drag/pull/shove/tug/yank OBJ;drag/pull/shove/tug/yank down OBJ;drag/pull/shove/tug/yank on OBJ;drag/pull/shove/tug/yank up OBJ;drink/guzzle/sip OBJ;drink/guzzle/sip from OBJ;drop/dump OBJ;elevat/hoist/lift/raise OBJ;elevat/hoist/lift/raise up OBJ;employ/exploi/use OBJ;empty OBJ;empty out OBJ;enter OBJ;face/flip/rotate/set/spin/turn/twist/whirl OBJ;face/flip/rotate/set/spin/turn/twist/whirl off OBJ;face/flip/rotate/set/spin/turn/twist/whirl on OBJ;fill OBJ;find/seek OBJ;fire/shoot OBJ;flush OBJ;fly OBJ;fly on OBJ;fly with OBJ;focus OBJ;force/insert/lay/load/place/put/stash/stuff/thread/wedge down OBJ;force/insert/lay/load/place/put/stash/stuff/thread/wedge on OBJ;force/insert/lay/load/place/put/stash/stuff/thread/wedge out OBJ;frisk/ransac/rummag/search OBJ;frisk/ransac/rummag/search in OBJ;gaze/l/look/peek/peer/stare OBJ;gaze/l/look/peek/peer/stare around OBJ;gaze/l/look/peek/peer/stare at OBJ;gaze/l/look/peek/peer/stare behind OBJ;gaze/l/look/peek/peer/stare down OBJ;gaze/l/look/peek/peer/stare out OBJ;gaze/l/look/peek/peer/stare throug OBJ;gaze/l/look/peek/peer/stare up OBJ;gaze/l/look/peek/peer/stare/frisk/ransac/rummag/search under OBJ;go/advanc/crawl/hike/hop/procee/run/skip/step/tramp/trudge/walk OBJ;go/advanc/crawl/hike/hop/procee/run/skip/step/tramp/trudge/walk around OBJ;go/advanc/crawl/hike/hop/procee/run/skip/step/tramp/trudge/walk behind OBJ;go/advanc/crawl/hike/hop/procee/run/skip/step/tramp/trudge/walk over OBJ;go/advanc/crawl/hike/hop/procee/run/skip/step/tramp/trudge/walk throug OBJ;go/advanc/crawl/hike/hop/procee/run/skip/step/tramp/trudge/walk to OBJ;go/advanc/crawl/hike/hop/procee/run/skip/step/tramp/trudge/walk under OBJ;go/dive/jump/leap/advanc/crawl/hike/hop/procee/run/skip/step/tramp/trudge/walk in OBJ;grin/laugh/nod/smile/sneer/wave at OBJ;grin/laugh/nod/smile/sneer/wave to OBJ;hang OBJ;hang up OBJ;hear OBJ;howl/scream/shout/yell OBJ;howl/scream/shout/yell at OBJ;howl/scream/shout/yell to OBJ;ignite/light OBJ;jostle/rattle/shake OBJ;kick OBJ;kick down OBJ;kick in OBJ;kiss/smooch OBJ;knock/pound/rap at OBJ;knock/pound/rap down OBJ;knock/pound/rap on OBJ;leave OBJ;let go OBJ;lie/reclin down OBJ;lie/reclin in OBJ;lie/reclin on OBJ;listen OBJ;listen for OBJ;listen in OBJ;listen to OBJ;lock OBJ;loiter/wait/z for OBJ;lower OBJ;move/roll/shift OBJ;move/roll/shift up OBJ;nap/rest/sleep/snooze in OBJ;nap/rest/sleep/snooze on OBJ;nudge/press/push/ring/thrust OBJ;nudge/press/push/ring/thrust down OBJ;nudge/press/push/ring/thrust on OBJ;nudge/press/push/ring/thrust up OBJ;open/pry/unseal OBJ;open/pry/unseal up OBJ;pick OBJ;pick up OBJ;play OBJ;reach in OBJ;read/skim OBJ;releas OBJ;replac OBJ;ride OBJ;ride in OBJ;ride on OBJ;rise/stand under OBJ;rise/stand up OBJ;rise/stand/dive/jump/leap/advanc/crawl/hike/hop/procee/run/skip/step/tramp/trudge/walk on OBJ;say/speak/talk/utter OBJ;scrape off OBJ;sit/squat OBJ;sit/squat at OBJ;sit/squat down OBJ;sit/squat in OBJ;sit/squat on OBJ;ski OBJ;ski down OBJ;smell/sniff OBJ;splice OBJ;swing OBJ;swing on OBJ;taste OBJ;tell OBJ;unlock OBJ;unroll OBJ;ask/interr/query/questi/quiz OBJ about OBJ;ask/interr/query/questi/quiz OBJ for OBJ;assaul/attack/fight/hit/hurt/injure/kill/murder/punch/slap/slay/stab/strike/whack/wound OBJ with OBJ;attach/fasten/hook/secure/tie OBJ to OBJ;attach/fasten/hook/secure/tie up OBJ with OBJ;bestow/delive/donate/give/hand/offer/presen OBJ OBJ;bestow/delive/donate/give/hand/offer/presen OBJ to OBJ;blind/jab/poke OBJ with OBJ;break/crack/damage/demoli/destro/erase/smash/trash/wreck OBJ off OBJ;break/crack/damage/demoli/destro/erase/smash/trash/wreck OBJ with OBJ;break/crack/damage/demoli/destro/erase/smash/trash/wreck down OBJ with OBJ;break/crack/damage/demoli/destro/erase/smash/trash/wreck in OBJ with OBJ;break/crack/damage/demoli/destro/erase/smash/trash/wreck throug OBJ with OBJ;burn OBJ with OBJ;burn down OBJ with OBJ;buy OBJ with OBJ;call/dial/phone OBJ on OBJ;carry/catch/confis/get/grab/hold/seize/snatch/steal/take OBJ from OBJ;carry/catch/confis/get/grab/hold/seize/snatch/steal/take OBJ in OBJ;carry/catch/confis/get/grab/hold/seize/snatch/steal/take OBJ off OBJ;carry/catch/confis/get/grab/hold/seize/snatch/steal/take OBJ on OBJ;carry/catch/confis/get/grab/hold/seize/snatch/steal/take OBJ out OBJ;check/descri/examin/inspec/observ/see/study/survey/watch OBJ throug OBJ;check/descri/examin/inspec/observ/see/study/survey/watch OBJ with OBJ;chuck/fling/hurl/pitch/throw/toss OBJ at OBJ;chuck/fling/hurl/pitch/throw/toss OBJ down OBJ;chuck/fling/hurl/pitch/throw/toss OBJ in OBJ;chuck/fling/hurl/pitch/throw/toss OBJ off OBJ;chuck/fling/hurl/pitch/throw/toss OBJ on OBJ;chuck/fling/hurl/pitch/throw/toss OBJ out OBJ;chuck/fling/hurl/pitch/throw/toss OBJ over OBJ;chuck/fling/hurl/pitch/throw/toss OBJ throug OBJ;chuck/fling/hurl/pitch/throw/toss OBJ to OBJ;clip/cut/slash OBJ with OBJ;clip/cut/slash throug OBJ with OBJ;compar OBJ to OBJ;concea/hide OBJ behind OBJ;concea/hide OBJ from OBJ;concea/hide OBJ under OBJ;cover OBJ with OBJ;crush/squash/squeez OBJ on OBJ;detach/free/unatta/undo/unfast/unhook/untie OBJ from OBJ;dig/excava OBJ in OBJ;dig/excava OBJ with OBJ;dig/excava in OBJ with OBJ;distur/feel/pat/pet/rub/touch OBJ with OBJ;doff/remove/shed OBJ from OBJ;drag/pull/shove/tug/yank OBJ out OBJ;drip/pour/spill/sprink OBJ from OBJ;drip/pour/spill/sprink OBJ in OBJ;drip/pour/spill/sprink OBJ on OBJ;drip/pour/spill/sprink out OBJ in OBJ;drop/dump OBJ down OBJ;drop/dump OBJ in OBJ;drop/dump OBJ on OBJ;empty OBJ from OBJ;empty OBJ out OBJ;face/flip/rotate/set/spin/turn/twist/whirl OBJ OBJ;face/flip/rotate/set/spin/turn/twist/whirl OBJ left OBJ;face/flip/rotate/set/spin/turn/twist/whirl OBJ right OBJ;face/flip/rotate/set/spin/turn/twist/whirl OBJ to OBJ;face/flip/rotate/set/spin/turn/twist/whirl OBJ with OBJ;feed OBJ OBJ;feed OBJ to OBJ;feed OBJ with OBJ;fill OBJ with OBJ;fire/shoot OBJ at OBJ;fire/shoot OBJ with OBJ;force/insert/lay/load/place/put/stash/stuff/thread/wedge OBJ behind OBJ;force/insert/lay/load/place/put/stash/stuff/thread/wedge OBJ down OBJ;force/insert/lay/load/place/put/stash/stuff/thread/wedge OBJ in OBJ;force/insert/lay/load/place/put/stash/stuff/thread/wedge OBJ on OBJ;force/insert/lay/load/place/put/stash/stuff/thread/wedge OBJ over OBJ;force/insert/lay/load/place/put/stash/stuff/thread/wedge OBJ under OBJ;gaze/l/look/peek/peer/stare at OBJ throug OBJ;hang OBJ from OBJ;hang OBJ on OBJ;hang up OBJ from OBJ;hang up OBJ on OBJ;ignite/light OBJ with OBJ;leave OBJ in OBJ;leave OBJ on OBJ;lock OBJ with OBJ;move/roll/shift OBJ down OBJ;nudge/press/push/ring/thrust OBJ down OBJ;nudge/press/push/ring/thrust OBJ under OBJ;nudge/press/push/ring/thrust OBJ up OBJ;nudge/press/push/ring/thrust/move/roll/shift OBJ OBJ;nudge/press/push/ring/thrust/move/roll/shift OBJ to OBJ;open/pry/unseal OBJ with OBJ;pick OBJ with OBJ;play OBJ on OBJ;read/skim OBJ throug OBJ;read/skim OBJ to OBJ;scrape OBJ off OBJ;show OBJ OBJ;show OBJ to OBJ;splice OBJ with OBJ;swing OBJ at OBJ;tell OBJ about OBJ;unlock OBJ with OBJ;",
    "max_word_length" : 6
}

huntdark = {
    "name": "huntdark",
    "rom": "huntdark.z5",
    "seed" : 0,
    # Walkthrough adapted from http://mirror.ifarchive.org/if-archive/solutions/huntdark.sol
    "walkthrough": "cock crossbow/shoot prey/left/x shape/take rags/bandage arm with rags/down/ahead/ahead/ahead/ahead/ahead/ahead/ahead/ahead/ahead/ahead/ahead/ahead/wait/wait/wait/wait/wait/wait/x bats/up/wait/wait/wait/wait/wait/x bats/ahead/wait/wait/wait/wait/wait/x bats/left/wait/wait/wait/x bats/up/wait/wait/x bats/right/wait/wait/x bats/up/x pool/remove bandage/wait/wait/wait/wait/wait/ahead/wait/wait/wait/ahead/up",
    "grammar" : "about/info;awake/awaken/wake;awake/awaken/wake up;bother/curses/darn/drat;breathe/inhale/smell/sniff;brief/normal;carry/hold/take inventory;damn/fuck/shit/sod;die/q/quit;dive/swim;exit/out/outside/stand;full/fullscore;full/fullscore score;get out/off/up;hear/listen;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;leave/go/run/walk;long/verbose;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;pray;rest/wait/z;restart;restore;rotate/screw/turn/twist/unscrew around;save;score;script/transcrip;script/transcrip off;script/transcrip on;short/superbrie;sing;sorry;stand up;swing;think;verify;version;wave;y/yes;adjust/set OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;bother/curses/darn/drat OBJ;breathe/inhale/smell/sniff OBJ;burn OBJ;buy/purchase OBJ;carry/hold/take off OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;climb/scale OBJ;climb/scale in/into OBJ;climb/scale up/over/on/onto OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;cock OBJ;cross/enter OBJ;damn/fuck/shit/sod OBJ;detach/unfasten/untie OBJ;dig OBJ;discard/drop/throw OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;fill OBJ;fix/repair OBJ;get in/into/on/onto OBJ;get off OBJ;get/carry/hold/take OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip OBJ;hop/jump/skip in/into OBJ;hop/jump/skip over OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look under OBJ;leave/go/run/walk into/in/inside/through OBJ;let OBJ go;let go OBJ;let go of OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;light/switch OBJ;load/reload OBJ;move/clear/press/push/shift OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;put OBJ down;put down OBJ;put on OBJ;read/check/describe/examine/watch/x OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;shoot OBJ;shoot/fire at OBJ;squash/squeeze OBJ;stand on OBJ;swing OBJ;swing on/from OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;tap/feel/fondle/grope/touch OBJ;taste OBJ;uncock OBJ;unstrap/disrobe/doff/shed/remove OBJ;wave OBJ;adjust/set OBJ to OBJ;answer/say/shout/speak OBJ to OBJ;ask OBJ about OBJ;ask OBJ for OBJ;bandage OBJ with OBJ;carry/hold/take OBJ off OBJ;consult OBJ about OBJ;consult OBJ on OBJ;detach/unfasten/untie OBJ from OBJ;dig OBJ with OBJ;discard/drop/throw OBJ at/against/on/onto OBJ;discard/drop/throw OBJ in/into/down OBJ;discard/drop/throw/put OBJ on/onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ to/into/on/onto OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;fix/attach/fasten/tie OBJ to/onto/around OBJ;insert OBJ in/into OBJ;load/reload OBJ in/into OBJ;load/reload OBJ with OBJ;lock OBJ with OBJ;move/clear/press/push/shift OBJ OBJ;move/clear/press/push/shift/transfer OBJ to OBJ;put OBJ in/inside/into OBJ;read OBJ in OBJ;read about OBJ in OBJ;remove/get/carry/hold/take OBJ from OBJ;shoot OBJ with OBJ;shoot/fire OBJ at OBJ;strap OBJ to/on/onto/around OBJ;tell OBJ about OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

infidel = {
    "name": "infidel",
    "rom": "infidel.z3",
    "seed" : 0,
    # Walkthrough adapted from http://mirror.ifarchive.org/if-archive/solutions/jgunness.zip
    "walkthrough": "get out of cot/s/sw/w/get pickaxe/get shovel/e/se/s/read note/get knapsack/n/n/get matchbook/n/n/smash padlock with pickaxe/remove padlock/drop padlock/open trunk/get beef/get map/eat beef/s/w/w/drink water/drop knapsack/get canteen/open canteen/fill canteen/close canteen/put canteen in knapsack/get knapsack/e/e/e/se/se/dig in sand/dig in sand/dig in sand/dig in sand/dig in sand/open map/insert cube in opening/d/drop map/open jar/get torch/dip torch in liquid/close jar/drop knapsack/put jar in knapsack/open matchbook/get match/close matchbook/strike match/light torch/s/s/ne/nw/w/n/e/n/n/n/n/n/w/s/get golden chalice/n/e/e/s/get silver chalice/n/w/s/s/s/s/s/w/s/e/n/w/get scroll/e/e/d/w/examine slot/put torch in golden chalice/remove shim/drop all/raise beam/get all/drop shovel/drop shim/e/u/w/get beam/s/se/sw/n/n/put golden chalice in knapsack/put silver chalice in knapsack/get rope/get torch/tie rope to altar/throw rope north/get knapsack/n/push statue/get head/roll statue sw/drop knapsack/ne/ne/ne/get ruby cluster/read hieroglyphs/sw/sw/get golden cluster/sw/put golden cluster in knapsack/put ruby cluster in knapsack/get all/roll statue ne/roll statue ne/drop all/get torch/sw/sw/sw/get emerald cluster/read hieroglyphs/ne/ne/ne/put emerald cluster in knapsack/get all/roll statue sw/roll statue nw/drop all/get torch/se/se/se/get opal cluster/read hieroglyphs/nw/nw/nw/put opal cluster in knapsack/get all/roll statue se/roll statue se/drop all/get torch/nw/nw/nw/get diamond cluster/read hieroglyphs/se/se/se/get all/drop head/nw/u/w/s/e/read scroll/remove first brick/drop first brick/remove third brick/drop third brick/remove fifth brick/drop fifth brick/drop scroll/e/n/d/hit plaster with pickaxe/w/w/w/insert beam in niches/stand on beam/hit plaster with pickaxe/open door/w/get beam/s/put beam across doorway/open door/w/put diamond cluster in first hole/drop knapsack/get jar/open jar/pour liquid on torch/put jar in knapsack/get opal/get ruby/get emerald/insert ruby cluster in second hole/insert emerald cluster in third hole/insert opal cluster in fourth hole/open slab/get book/get knapsack/e/get beam/n/n/put beam under lintel/break seal with pickaxe/open door/n/put book in large recess/e/drop knapsack/get canteen/get silver chalice/get golden chalice/put golden chalice on left disc/put silver chalice on right disc/open canteen/pour water in silver chalice/get scarab/w/put scarab in small recess/turn neith/turn selkis/turn isis/turn nephthys/open quartz cover",
    "grammar" : "again/g;answer/reply;back;barf/chomp/lose;bathe/swim/wade;blast;brief;bug;chant/incant;chase/come/follow/pursue;curse/damn/fuck/hell/shit;dive/jump/leap;enter;exit;gaze/l/look/stare;hello/hi;help;hop/skip;i/invent;leave;lie/rest/sleep;mumble/sigh;plugh/xyzzy;pray;q/quit;repent;restar;restor;save;say/talk;score;scream/shout/yell;script;stand;stay;super/superb;time;unscri;verbos;versio;wait/z;win/winnag;zork;answer/reply OBJ;ask/tell OBJ;awake/startl/surpri/wake OBJ;awake/startl/surpri/wake up OBJ;banish/begone/cast/drive/exorci OBJ;banish/begone/cast/drive/exorci away OBJ;banish/begone/cast/drive/exorci out OBJ;bathe/swim/wade in OBJ;bite/chew/consum/eat OBJ;blow out OBJ;blow up OBJ;board OBJ;brandi/signal/wave OBJ;brandi/signal/wave at OBJ;brandi/signal/wave to OBJ;carry/get/grab/hold/remove/take OBJ;carry/get/grab/hold/remove/take off OBJ;carry/get/grab/hold/remove/take out OBJ;chase/come/follow/pursue OBJ;chuck/hurl/throw/toss OBJ;clean/polish/scrub OBJ;climb OBJ;climb/carry/get/grab/hold/remove/take in OBJ;climb/carry/get/grab/hold/remove/take on OBJ;climb/go/procee/run/step/walk down OBJ;climb/go/procee/run/step/walk up OBJ;close OBJ;compar OBJ;count OBJ;cross/ford OBJ;curse/damn/fuck/hell/shit OBJ;deflat OBJ;descri/examin/what/whats OBJ;descri/examin/what/whats/gaze/l/look/stare in OBJ;descri/examin/what/whats/gaze/l/look/stare on OBJ;dig in OBJ;dig with OBJ;disemb OBJ;dive/jump/leap OBJ;dive/jump/leap across OBJ;dive/jump/leap from OBJ;dive/jump/leap in OBJ;dive/jump/leap off OBJ;dive/jump/leap/go/procee/run/step/walk over OBJ;douse/exting OBJ;drink/imbibe/sip/swallo OBJ;drink/imbibe/sip/swallo from OBJ;drop/releas OBJ;empty/shake OBJ;enter OBJ;exit OBJ;feel/pat/pet/rub/touch OBJ;fill OBJ;fill in OBJ;fill out OBJ;find/see/seek/where OBJ;flip/set/shut/turn OBJ;flip/set/shut/turn off OBJ;flip/set/shut/turn on OBJ;flip/set/shut/turn over OBJ;fold OBJ;fold up OBJ;free/unatta/unfast/unhook/untie OBJ;gaze/l/look/stare OBJ;gaze/l/look/stare around OBJ;gaze/l/look/stare at OBJ;gaze/l/look/stare behind OBJ;gaze/l/look/stare down OBJ;gaze/l/look/stare throug OBJ;gaze/l/look/stare under OBJ;gaze/l/look/stare up OBJ;gaze/l/look/stare with OBJ;gaze/l/look/stare/search for OBJ;go/procee/run/step/walk OBJ;go/procee/run/step/walk around OBJ;go/procee/run/step/walk in OBJ;go/procee/run/step/walk on OBJ;go/procee/run/step/walk to OBJ;go/procee/run/step/walk with OBJ;hello/hi OBJ;help OBJ;hide/insert/place/put/stuff/wedge down OBJ;hide/insert/place/put/stuff/wedge on OBJ;kick OBJ;kiss OBJ;knock/rap at OBJ;knock/rap down OBJ;knock/rap on OBJ;knock/rap over OBJ;launch OBJ;lean on OBJ;leave OBJ;lie/rest/sleep down OBJ;lie/rest/sleep in OBJ;lie/rest/sleep on OBJ;lift/raise OBJ;light OBJ;listen for OBJ;listen to OBJ;lower OBJ;make OBJ;molest/rape OBJ;move/pull/tug/yank OBJ;open OBJ;open up OBJ;pick OBJ;pick up OBJ;play OBJ;pour/spill OBJ;pray for OBJ;press/push OBJ;press/push on OBJ;press/push/lift/raise up OBJ;pull/tug/yank on OBJ;pull/tug/yank up OBJ;pump up OBJ;reach in OBJ;read/skim OBJ;read/skim in OBJ;roll OBJ;roll up OBJ;say/talk to OBJ;search OBJ;search in OBJ;send OBJ;send for OBJ;sit on OBJ;slide OBJ;smell/sniff OBJ;smoke OBJ;spin OBJ;squeez OBJ;stand on OBJ;stand/carry/get/grab/hold/remove/take under OBJ;stand/carry/get/grab/hold/remove/take up OBJ;strike OBJ;swing/thrust OBJ;taste OBJ;unfold OBJ;wear OBJ;weigh OBJ;wind OBJ;wind up OBJ;apply OBJ to OBJ;attach/fasten/secure/tie OBJ around OBJ;attach/fasten/secure/tie OBJ to OBJ;attach/fasten/secure/tie up OBJ with OBJ;attack/fight/hurt/injure OBJ with OBJ;blind/jab/poke OBJ with OBJ;blow up OBJ with OBJ;brandi/signal/wave OBJ at OBJ;break/chip/chop/damage/destro/hit/smash OBJ with OBJ;break/chip/chop/damage/destro/hit/smash down OBJ with OBJ;break/chip/chop/damage/destro/hit/smash in OBJ with OBJ;burn/ignite/incine OBJ with OBJ;burn/ignite/incine down OBJ with OBJ;carry/get/grab/hold/remove/take OBJ from OBJ;carry/get/grab/hold/remove/take OBJ of OBJ;carry/get/grab/hold/remove/take OBJ off OBJ;carry/get/grab/hold/remove/take OBJ out OBJ;carry/get/grab/hold/remove/take OBJ with OBJ;chuck/hurl/throw/toss OBJ OBJ;chuck/hurl/throw/toss OBJ at OBJ;chuck/hurl/throw/toss OBJ down OBJ;chuck/hurl/throw/toss OBJ in OBJ;chuck/hurl/throw/toss OBJ off OBJ;chuck/hurl/throw/toss OBJ on OBJ;chuck/hurl/throw/toss OBJ over OBJ;chuck/hurl/throw/toss OBJ to OBJ;chuck/hurl/throw/toss OBJ with OBJ;clear OBJ from OBJ;compar OBJ to OBJ;compar OBJ with OBJ;cut/pierce/slice OBJ with OBJ;dig OBJ in OBJ;dig OBJ with OBJ;dig in OBJ with OBJ;dip/dunk/immers/submer OBJ in OBJ;dispat/kill/murder/slay/stab OBJ with OBJ;donate/feed/give/hand/offer OBJ OBJ;donate/feed/give/hand/offer OBJ to OBJ;drink/imbibe/sip/swallo OBJ from OBJ;drink/imbibe/sip/swallo OBJ in OBJ;drop/releas OBJ down OBJ;drop/releas OBJ in OBJ;drop/releas OBJ on OBJ;feel/pat/pet/rub/touch OBJ with OBJ;fill OBJ with OBJ;fix/glue/patch/plug/repair OBJ with OBJ;flip/set/shut/turn OBJ for OBJ;flip/set/shut/turn OBJ to OBJ;flip/set/shut/turn OBJ with OBJ;free/unatta/unfast/unhook/untie OBJ from OBJ;gaze/l/look/stare at OBJ with OBJ;grease/lubric OBJ with OBJ;hide/insert/place/put/stuff/wedge OBJ across OBJ;hide/insert/place/put/stuff/wedge OBJ agains OBJ;hide/insert/place/put/stuff/wedge OBJ at OBJ;hide/insert/place/put/stuff/wedge OBJ behind OBJ;hide/insert/place/put/stuff/wedge OBJ betwee OBJ;hide/insert/place/put/stuff/wedge OBJ by OBJ;hide/insert/place/put/stuff/wedge OBJ in OBJ;hide/insert/place/put/stuff/wedge OBJ on OBJ;hide/insert/place/put/stuff/wedge OBJ over OBJ;hide/insert/place/put/stuff/wedge OBJ under OBJ;inflat OBJ with OBJ;is OBJ in OBJ;is OBJ on OBJ;light OBJ with OBJ;liquif/melt OBJ with OBJ;lock OBJ with OBJ;lower OBJ down OBJ;move/roll/pull/tug/yank/press/push/slide OBJ OBJ;open OBJ with OBJ;pick OBJ with OBJ;pour/spill OBJ from OBJ;pour/spill OBJ in OBJ;pour/spill OBJ on OBJ;press/push OBJ throug OBJ;press/push OBJ under OBJ;pull/tug/yank OBJ throug OBJ;pump up OBJ with OBJ;read/skim OBJ with OBJ;roll/press/push/slide OBJ to OBJ;slide OBJ under OBJ;spray OBJ on OBJ;spray OBJ with OBJ;squeez OBJ on OBJ;strike OBJ with OBJ;swing/thrust OBJ at OBJ;unlock OBJ with OBJ;wet OBJ with OBJ;",
    "max_word_length" : 6
}

inhumane = {
    "name": "inhumane",
    "rom": "inhumane.z5",
    "seed" : 0,
    "walkthrough" : "get amulet/s/w/get torch/get shovel/e/e/e/e/e/n/dig/put amulet in slot/x note/s/w/w/w/w/s/open toilet/d/push button/w/s/s/take pebble/put pebble on second disk/take cube/north/north/e/e/e/e/open door/e/e/e/take necklace/n/n/u/n/n/n/n/n/n/n/n/e/n/open door/n/n/push button/w/w/z/z/z/w/z/z/z/w/n/get key/n/get figure/s/s/s/get sphere/n/z/z/z/z/z/z/e/z/z/s/w/turn crank/e/get diamond/w/turn crank/e/e/n/n/take ruby/s/s/open door/s/close door/take needle/open chest with needle/take dorkmid/open door/e/s/jump/get key/n/e/e/unlock door with iron key/open door/e/s/push coffin n/push coffin w/push coffin w/push coffin w/push coffin s",
    "grammar" : "about/rating/help;awake/awaken/wake;awake/awaken/wake up;brief/normal;carry/get/hold/take inventory;carry/get/hold/take off;carry/get/hold/take out;close/cover/shut up;die/q/quit;dig;dive/swim;exit/out/outside/stand;full/fullscore;go/leave/run/walk;hear/listen;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;long/verbose;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;pray;restart;restore;save;score;script;script off;script on;short/superbrie;sing;smell/sniff;stand/carry/get/hold/take up;think;verify;version;wait/z;wave;y/yes;adjust/set OBJ;attach/fasten/fix/tie OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake up OBJ;blow OBJ;burn/light OBJ;buy/purchase OBJ;carry/get/hold/take OBJ;carry/get/hold/take off OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale over OBJ;climb/scale up OBJ;close/cover/shut OBJ;cross/enter OBJ;dig with OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;go/leave/run/walk OBJ;go/leave/run/walk into OBJ;go/leave/run/walk through OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;l/look at OBJ;l/look in OBJ;l/look inside OBJ;l/look through OBJ;l/look under OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;put OBJ down;put down OBJ;put on OBJ;read/check/describe/examine/watch/x OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;sit/go/leave/run/walk inside OBJ;sit/go/leave/run/walk/carry/get/hold/take in OBJ;sit/stand/carry/get/hold/take on OBJ;smell/sniff OBJ;squash/squeeze OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;taste OBJ;wave OBJ;adjust/set OBJ to OBJ;answer/say/shout/speak OBJ to OBJ;ask OBJ about OBJ;attach/fasten/fix/tie OBJ to OBJ;burn/light OBJ with OBJ;carry/get/hold/take OBJ off OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;discard/drop/throw OBJ against OBJ;discard/drop/throw OBJ at OBJ;discard/drop/throw OBJ down OBJ;discard/drop/throw/insert/put OBJ in OBJ;discard/drop/throw/insert/put OBJ into OBJ;discard/drop/throw/put OBJ on OBJ;discard/drop/throw/put OBJ onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ into OBJ;empty OBJ on OBJ;empty OBJ onto OBJ;empty OBJ to OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;lock OBJ with OBJ;put OBJ inside OBJ;remove/carry/get/hold/take OBJ from OBJ;tell OBJ about OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

jewel = {
    "name": "jewel",
    "rom": "jewel.z5",
    "seed" : 0,
    "walkthrough" : "i/drop all/w/nw/x minerals/pull quartz/u/u/get book/x gaping/x outcrop/x insect/throw book at outcrop/d/d/se/w/w/n/get moss/x moss/smell/smell dirty floor/clean dirty floor with moss/open trapdoor/d/get lye/u/s/s/x skeleton/put lye on moss/clean skeleton with moss/get bladder/get crampons/n/e/e/nw/w/w/x porous wall/wear crampons/climb porous wall/u/u/e/x ariana/x boots/search boots/get lockpick/get crossbow/x crossbow/w/d/d/d/put bladder in geyser/z/z/z/look/drop crampons/get bladder/x bladder/read label/w/search refuse/get axe/e/e/e/se/w/w/w/x block/chop ice with axe/chop ice with axe/chop ice with axe/chop ice with axe/chop ice with axe/drop axe/s/se/x dragon/look in mouth/open claws/get coat/wear coat/s/get treasure/n/nw/n/e/n/n/x fungus/x mushroom/x crossbow/shoot mushroom with crossbow/get arrow/put arrow in crossbow/shoot mushroom with crossbow/put arrow in crossbow/shoot mushroom with crossbow/put arrow in crossbow/s/s/e/e/e/get all/x body/get sack/open sack/wear sack/get salt/x salt/rub bug/light salt with bug/smell smoke/i/read book/ask allarah about white/ask allarah about black/ask allarah about red/ask allarah about jewel/look/touch mist/put bug in sack/put bladder in sack/ne/e/touch flower/ne/rub flower/s/squeeze flower/w/pull flower/n/cut flower/e/x door/unlock door with key/unlock lock with lockpick/drop key/drop lockpick/e/ask dragon about trinket/ask dragon about white/ask dragon about black/ask dragon about red/ask dragon about jewel/read book/x lye/x coat/put lye in coat/z/z/z/z/z/attack dragon with sword/se/push boulders/nw/show crossbow to dragon/dragon, give ring to me/i/wear ring/dragon, open door/ask dragon about jewel/sit on dragon/z/z/z/z/z/z/z/z/z/z/w/z/z/z/z/z/z/z/z/w/remove ring/put ring, book in sack/get bladder/x chandelier/shoot rope with crossbow/put crossbow in sack/look/get embers/put embers in coat/n/z/z/z/z/z/z/n/x murals/n/x murals/n/x murals/n/x mirror/x pedestal/look under cushion/touch mirror",
    "grammar" : "about/help/info;awake/awaken/wake;awake/awaken/wake up;bother/curses/darn/drat;brief/normal;bypass;carry/hold/take inventory;damn/fuck/shit/sod;die/q/quit;dive/swim;exit/out/outside/stand;full/fullscore;full/fullscore score;get out/off/up;hear/listen;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;inhale/smell/smoke/sniff;l/look;leave/go/run/walk;long/verbose;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;pray;restart;restore;save;score;script/transcrip;script/transcrip off;script/transcrip on;short/superbrie;sing;sorry;stand up;think;verify;version;wait/z;wave;xyzzy;y/yes;adjust/set OBJ;attach/fasten/fix/tie OBJ;attack/break/crack/destroy/fight/hit/kick/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;blow OBJ;blow up OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;carry/hold/take off OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale on OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;cross/enter/go/run/walk OBJ;damn/fuck/shit/sod OBJ;dig OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;get in/into/on/onto OBJ;get off OBJ;get/carry/hold/take OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;inhale/smell/smoke/sniff OBJ;knock on OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look under OBJ;leave OBJ;leave/go/run/walk into/in/inside/through OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;pour/put OBJ down;pour/put down OBJ;pour/put on OBJ;read/check/describe/examine/watch/x OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;squash/squeeze OBJ;stand on OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;taste OBJ;wave OBJ;adjust/set OBJ to OBJ;answer/say/shout/speak OBJ to OBJ;ask OBJ about OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;attack/break/crack/destroy/fight/hit/kick/kill/murder/punch/smash/thump/torture/wreck OBJ with OBJ;burn/light OBJ with OBJ;carry/hold/take OBJ off OBJ;chop/cut/prune/slice OBJ with OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ with OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;consult OBJ about OBJ;consult OBJ on OBJ;dig OBJ with OBJ;discard/drop/throw OBJ at/against/on/onto OBJ;throw OBJ at OBJ;discard/drop/throw OBJ in/into/down OBJ;discard/drop/throw/pour/put OBJ on/onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ to/into/on/onto OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;insert/load OBJ in/into OBJ;l/look up OBJ in OBJ;lock OBJ with OBJ;pour/put OBJ in/inside/into OBJ;read OBJ in OBJ;read about OBJ in OBJ;remove/get/carry/hold/take OBJ from OBJ;shoot OBJ at OBJ;shoot OBJ with OBJ;tell OBJ about OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

karn = {
    "name": "karn",
    "rom": "karn.z5",
    "seed" : 0,
    "walkthrough" : "i/remove jacket/drop jacket/drop yo-yo/drop key/e/open door/s/get toolkit/open toolkit/get screwdriver/get homing/x homing/turn on homing/open cupboard/get pouch/open pouch/put pouch in toolkit/n/w/x scanner/pull lever/w/nw/ne/e/u/search ruins/get scalpel/put scalpel in toolkit/d/ne/nw/w/x creature/x globe/e/se/sw/w/sw/se/e/se/e/n/read sign/take off scarf/tie scarf to signpost/climb scarf/open hatch with screwdriver/get battery/put homing in hatch/close hatch/d/put screwdriver in toolkit/get battery/nw/x tree/climb tree/get branch/w/w/sw/w/sw/se/e/se/e/fill battery/n/get scarf/s/w/nw/w/enter tardis/drop scarf/e/e/get match/put match in toolkit/n/x k9/put battery in panel/close panel/s/w/w/x console/open drawer/get link/ask k9 about k9/k9, follow me/w/k9, shoot boulder/get stone/w/get firework/put firework in toolkit/s/open tapestry/w/put link in chalice/open shield/put stone in fire/close shield/get link/close link/e/close tapestry/n/e/nw/w/s/e/push boulder/put branch under boulder/pull branch/get branch/w/n/e/se/k9, follow me/enter tardis/put link in drawer/close drawer/x console/x slot/get brown/drop brown/get gold/put gold in slot/z/z/z/z/z/z/z/z/z/z/z/z/z/pull lever/push button/x scanner/pull lever/get gold/put gold in toolkit/k9, follow me/w/open hatch/get torch/get mine/put all in toolkit/n/w/ask k9 about door/x bubble/drop mine/drop branch/e/s/d/turn on torch/nw/x plate/open catch/ne/n/open hatch/turn off torch/u/e/s/open door/e/w/close door/turn wheel/x bubble/pull lever/pull lever/push button/turn wheel/open door/e/open hatch/d/turn on torch/n/w/x plate/nw/open hatch/u/open door/turn off torch/x left screen/push left button/x right screen/push right button/e/s/s/s/e/w/w/w/get screwdriver/get scalpel/unlock box with screwdriver/open box/look up/cut green with scalpel/look up/turn on torch/close plate/se/turn off torch/put all in toolkit/u/k9, follow me/n/w/ask k9 about door/k9, shoot door/w/x control/push switch/ask k9 about reactor/ask k9 about control/ask k9 about sequence/d/turn on torch/e/get branch/jam branch under plate/open catch/x mine/push button/w/turn off torch/u/push green/push blue/push yellow/push blue/ask k9 about reactor/ask k9 about sequence/push red/push yellow/push blue/push yellow/k9, follow me/e/get white/put white in toolkit/k9, follow me/turn on torch/ne/n/turn off torch/u/get torch/drop torch/get rope/d/tie rope to k9/u/put rope in unit/k9, follow me/e/s/s/w/s/push table n/push table e/push table n/push table n/push table n/push table e/x door/push table e/x door/get white/put white in slot/push table s/climb on table/x device/push button/exit/get match/get firework/light match/light firework/drop match/drop firework/n/w/w/z/z/e/e/get white/put white in unit/pull pipe/pull pipe/get gold/get pouch/put pouch under pipe/ask k9 about cybermen/put gold in unit/get pouch/w/n/get black/s/w/s/s/s/e/s/x door/put black in slot/w/x apparatus/x respirator/x vent/put dust in vent/drop pouch/get screwdriver/get scalpel/unlock box with screwdriver/open box/cut green with scalpel/open tank/get brain/e/n/w/w/s/enter tardis/put silver in slot/drop all but brain/pull lever/push button/x scanner/pull lever/w/give brain to timelord",
    "grammar" : "about;awake/awaken/wake;awake/awaken/wake up;backgroun;bother/curses/darn/drat;brief/normal;carry/get/hold/take inventory;carry/get/hold/take off;carry/get/hold/take out;close/cover/shut up;damn/fuck/shit/sod;damn/fuck/shit/sod;die/q/quit;dive/swim;exit/out/outside/stand;full/fullscore;full/fullscore score;go/leave/run/walk;hear/listen;help/instructi;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look/l/look;long/verbose;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;play;pray;restart;restore;save;score;script;script off;script on;short/superbrie;sing;smell/sniff;sorry;spin;stand/carry/get/hold/take up;stay;stay here;stay there;think;verify;version;wait/z;wave;y/yes;adjust/set OBJ;attach/fasten/fix/tie OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blast/shoot OBJ;blow OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;carry/get/hold/take OBJ;carry/get/hold/take off OBJ;check/describe/examine/watch/x/l/look OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale down OBJ;climb/scale over OBJ;climb/scale/climb/scale up OBJ;climb/scale/lie/sit/stand/carry/get/hold/take on OBJ;close/cover/shut OBJ;cross/enter/go/leave/run/walk OBJ;damn/fuck/shit/sod OBJ;damn/fuck/shit/sod OBJ;dig OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;draw/slide OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;feel/fondle/grope/touch OBJ;fill OBJ;flip OBJ;flip/switch/rotate/screw/turn/twist/unscrew OBJ off;flip/switch/rotate/screw/turn/twist/unscrew OBJ on;flip/switch/rotate/screw/turn/twist/unscrew on OBJ;flip/switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;follow OBJ;go/leave/run/walk through OBJ;go/leave/run/walk/carry/get/hold/take into OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;knock on OBJ;l/look at OBJ;l/look in OBJ;l/look inside OBJ;l/look into OBJ;l/look on OBJ;l/look through OBJ;l/look under OBJ;lie/sit/go/leave/run/walk inside OBJ;lie/sit/go/leave/run/walk/carry/get/hold/take in OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;play with OBJ;put OBJ down;put down OBJ;put on OBJ;read OBJ;release OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;smell/sniff OBJ;spin OBJ;squash/squeeze OBJ;stay OBJ;strike OBJ;swing OBJ;swing on OBJ;switch OBJ;taste OBJ;untie OBJ;wave OBJ;adjust/set OBJ to OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;burn/light OBJ with OBJ;carry/get/hold/take OBJ off OBJ;chop/cut/prune/slice OBJ with OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;dig OBJ with OBJ;discard/drop/throw OBJ against OBJ;discard/drop/throw OBJ at OBJ;discard/drop/throw OBJ down OBJ;discard/drop/throw/insert/put OBJ in OBJ;discard/drop/throw/insert/put OBJ into OBJ;discard/drop/throw/put OBJ on OBJ;discard/drop/throw/put OBJ onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ in OBJ;empty OBJ into OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;fill OBJ with OBJ;jam/wedge/prop OBJ against OBJ;jam/wedge/prop/put OBJ under OBJ;jam/wedge/prop/put OBJ underneat OBJ;lock OBJ with OBJ;pour OBJ in OBJ;pour OBJ into OBJ;prop OBJ upth OBJ;prop up OBJ with OBJ;put OBJ inside OBJ;remove/carry/get/hold/take OBJ from OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

library = {
    "name": "library",
    "rom": "library.z5",
    "seed" : 0,
    "walkthrough" : "X security gates/X attendant/Read tag/Ask Alan about novel/Ask him about Nelson/Ask him about librarian/W/X librarian/Read tag/Ask Marion about Nelson/Ask her about rare books/Ask her about key/E/Ask Alan about key/I/Give card to Alan/W/N/X stairs/Smell/Look under stairs/U/X painting/Give fish to grue/S/Search shelves/Unlock door with key/Open door/S/Get book/N/Close door/Lock door with key/E/X technician/Ask technician about security gates/X printouts/W/N/D/S/Ask Marion about encyclopedia/Give encyclopedia to Marion/X shelves/X magazines/Xyzzy/E/Give key to Alan/Give novel to Alan/X technician/Ask technician about security gates/E",
    "grammar" : "awake/awaken/wake;awake/awaken/wake up;bother/curses/darn/drat;brief/normal;carry/get/hold/take inventory;carry/get/hold/take off;carry/get/hold/take out;close/cover/shut up;damn/fuck/shit/sod;die/q/quit;dive/swim;exit/out/outside/stand;full/fullscore;full/fullscore score;go/leave/run/walk;hear/listen;help;help author;help changes;help comments;help credits;help ftp;help ftp.gmd;help gmd;help inform;help intro;help introduct;help licence;help license;help quotes;help xxx;hint/hints;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;info;l/look;long/verbose;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;pray;quotes;quotes off;quotes on;restart;restore;save;score;script;script off;script on;short/superbrie;sing;smell/sniff;sorry;stand/carry/get/hold/take up;think;verify;version;wait/z;wave;xyzzy;y/yes;adjust/set OBJ;attach/fasten/fix/tie OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;carry/get/hold/take OBJ;carry/get/hold/take off OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale over OBJ;climb/scale up OBJ;close/cover/shut OBJ;cross/enter/go/leave/run/walk OBJ;damn/fuck/shit/sod OBJ;dig OBJ;disable OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;go/leave/run/walk through OBJ;go/leave/run/walk/carry/get/hold/take into OBJ;hear/listen OBJ;hear/listen to OBJ;help OBJ;hop/jump/skip over OBJ;l/look at OBJ;l/look in OBJ;l/look inside OBJ;l/look into OBJ;l/look through OBJ;l/look under OBJ;lie/sit/go/leave/run/walk inside OBJ;lie/sit/go/leave/run/walk/carry/get/hold/take in OBJ;lie/sit/stand/carry/get/hold/take on OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;put OBJ down;put down OBJ;put on OBJ;read/check/describe/examine/watch/x OBJ;repair OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;smell/sniff OBJ;squash/squeeze OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;taste OBJ;wave OBJ;adjust/set OBJ to OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;burn/light OBJ with OBJ;carry/get/hold/take OBJ off OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;dig OBJ with OBJ;discard/drop/throw OBJ against OBJ;discard/drop/throw OBJ at OBJ;discard/drop/throw OBJ down OBJ;discard/drop/throw/insert/put OBJ in OBJ;discard/drop/throw/insert/put OBJ into OBJ;discard/drop/throw/put OBJ on OBJ;discard/drop/throw/put OBJ onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ into OBJ;empty OBJ on OBJ;empty OBJ onto OBJ;empty OBJ to OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;lock OBJ with OBJ;put OBJ inside OBJ;remove/carry/get/hold/take OBJ from OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

loose = {
    "name": "loose",
    "rom": "loose.z5",
    "seed" : 0,
    "walkthrough" : "n/n/take pot/open pot/empty pot/drop pot/take hairpin/sw/w/w/knock knock/boo/give hairpin to mary/ask mary for ladder/sw/take ladder/yes/take ladder/sw/put ladder in well/here kitty kitty/take ladder/ne/ne/e/e/ne/s/s/lean ladder against fence/take ladder/n/n/sw/w/w/sw/drop ladder/sw/nw/s/s/take kitten/take key/unlock door with key/s/x figure/n/z/z",
    "grammar" : "about/commands/help/hint/info;anita/annie/apple/arthur/banana/bob/boo/canoe/carl/doris/dorris/gladys/harry/irish/isabelle/ivan/joke/justin/lettuce/minnie/olive/orange/owl/police/radio/venice/wanda/wayne/wendy/yodelx;apologise/apologize/sorry;awake/awaken/wake;awake/awaken/wake up;bend/straighte/unbend spoon;bother/curses/darn/drat;brief/normal;carry/catch/grab/hold/lift/snatch/steal/take inventory;damn/fuck/shit/sod;die/q/quit;dive/swim;exit/out/outside;exit/out/outside/leave/stand;full/fullscore;full/fullscore score;get down/off/up;get out/off/up;go/run/walk;go/run/walk in/into/inside;go/run/walk on;go/run/walk out/outside;hear/listen;hop/jump/skip;hop/jump/skip/climb/scale down/off;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter/cross/enter;l/look/l/look;long/verbose;maybe/possibly/no/deal/ok/okay/y/yes;nap/sleep;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;pray;restart;restore;save;score;script/transcrip;script/transcrip off;script/transcrip on;short/superbrie;sing;smell/sniff;stand up;think;verify;version;wait/z;wave;xyzzy;activate OBJ;adjust/set OBJ;answer/call/say/speak/talk OBJ;answer/call/say/speak/talk how/what/when/where/who/why OBJ;answer/call/say/speak/talk to OBJ;apologise/apologize/sorry to OBJ;attach/fasten/fix/tie OBJ;attack/beat/break/crack/destroy/fight/hit/kick/kill/murder/punch/rip/smash/tear/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;bang/knock/pound/tap OBJ;bang/knock/pound/tap OBJ down/over;bang/knock/pound/tap down/over OBJ;bang/knock/pound/tap on/at OBJ;blow OBJ;boil/cook/eat/fry/poach/scramble OBJ;boil/cook/eat/fry/poach/scramble OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;carry/catch/grab/hold/lift/snatch/steal/take off OBJ;chase/follow/pursue/track/trail OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift/shove/slide OBJ;clear/move/press/push/shift/shove/slide OBJ in/out;clear/move/press/push/shift/shove/slide OBJ over;climb/scale OBJ;climb/scale down OBJ;climb/scale down/off from/off OBJ;climb/scale in/into/through OBJ;climb/scale out/through OBJ;climb/scale up/over OBJ;climb/scale/go/run/walk on OBJ;close/cover/shut/slam OBJ;close/cover/shut/slam up OBJ;cross/enter OBJ;cross/enter/go/run/walk OBJ;damn/fuck/shit/sod OBJ;dig OBJ;disrobe/doff/shed/remove/untie/unwind OBJ;don/wear OBJ;drag/pull/tug/yank OBJ;drag/pull/tug/yank OBJ down/off/over;drag/pull/tug/yank on OBJ;draw OBJ;draw OBJ closed;draw OBJ open;drink/sip/swallow OBJ;dump/empty/pour OBJ;dump/empty/pour OBJ out;dump/empty/pour out OBJ;embrace/hug/kiss OBJ;exit/out/outside OBJ;feed OBJ;feel/fondle/grope/pat/pet/shake/stroke/touch OBJ;fill OBJ;flick/flip/switch OBJ;flick/flip/switch OBJ off/down;flick/flip/switch OBJ on/up;flick/flip/switch off/down OBJ;flick/flip/switch on/up OBJ;get down/off/up from/of/off OBJ;get in/into/on/onto OBJ;get off OBJ;give/offer/pay OBJ back;give/offer/pay back OBJ;go/run/walk in/into/inside OBJ;go/run/walk inside of OBJ;go/run/walk out/outside OBJ;go/run/walk out/outside of OBJ;go/run/walk through OBJ;hear/listen OBJ;hear/listen at OBJ;hear/listen to OBJ;hop/jump/skip down/off from/of/off OBJ;hop/jump/skip from/off OBJ;hop/jump/skip in/into/on/onto OBJ;hop/jump/skip over OBJ;introduce me/myself/self to OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look out OBJ;l/look over/around/underneat OBJ;l/look under OBJ;lean/put/stick/wind OBJ down;lean/put/stick/wind down OBJ;lean/put/stick/wind head in/into OBJ;lean/put/stick/wind on OBJ;leave OBJ;leave into/in/inside/through OBJ;lick/taste OBJ;lie/sit at OBJ;lie/sit down on/in OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;open/uncover/undo/unwrap OBJ;peel off OBJ;peel/pick OBJ;pick OBJ up;pick up OBJ;pry OBJ;read/check/describe/examine/watch/x OBJ;remove/untie/unwind/get/carry/catch/grab/hold/lift/snatch/steal/take OBJ;rotate/screw/turn/twist/unscrew OBJ;rotate/screw/turn/twist/unscrew OBJ off;rotate/screw/turn/twist/unscrew OBJ on;rotate/screw/turn/twist/unscrew on OBJ;rotate/screw/turn/twist/unscrew/close/cover/shut/slam off OBJ;search OBJ;shout/yell at/to OBJ;smell/sniff OBJ;squash/squeeze OBJ;stand on OBJ;stir OBJ;stir OBJ with spoon;stop/deactivat OBJ;swing OBJ;swing on OBJ;throw/discard/drop/toss OBJ;use OBJ;wave OBJ;adjust/set OBJ to OBJ;answer/call/say/speak/talk OBJ to OBJ;answer/call/say/speak/talk OBJ to OBJ;ask OBJ about OBJ;ask OBJ for OBJ;ask/tell OBJ how/what/when/where/who/why OBJ;ask/tell OBJ to OBJ;attach/fasten/fix/tie OBJ on/onto/with OBJ;attach/fasten/fix/tie/attach/fasten/fix/tie OBJ to OBJ;attack/beat/break/crack/destroy/fight/hit/kick/kill/murder/punch/rip/smash/tear/thump/torture/wreck OBJ with OBJ;bang/knock/pound/tap OBJ on/at OBJ;boil/cook/eat/fry/poach/scramble OBJ with OBJ;burn/light OBJ with OBJ;carry/catch/grab/hold/lift/snatch/steal/take OBJ from OBJ;carry/catch/grab/hold/lift/snatch/steal/take OBJ off OBJ;clear/move/press/push/shift/shove/slide OBJ OBJ;clear/move/press/push/shift/shove/slide OBJ down/off from/of/off OBJ;clear/move/press/push/shift/shove/slide OBJ from/off/of OBJ;clear/move/press/push/shift/shove/slide OBJ in/out OBJ;clear/move/press/push/shift/shove/slide OBJ to OBJ;clear/move/press/push/shift/shove/slide/drag/pull/tug/yank OBJ through OBJ;clear/move/press/push/shift/shove/slide/lean/put/stick/wind OBJ under OBJ;consult OBJ about OBJ;consult OBJ on OBJ;dig OBJ with OBJ;display/present/show OBJ OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;drag/pull/tug/yank OBJ down/off from/of/off OBJ;drag/pull/tug/yank OBJ from/of/off OBJ;dump/empty/pour OBJ by/in/into/on/onto OBJ;dump/empty/pour OBJ next to OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;feel/fondle/grope/pat/pet/shake/stroke/touch OBJ with OBJ;give/offer/pay OBJ OBJ back;give/offer/pay OBJ back OBJ;give/offer/pay OBJ back to OBJ;give/offer/pay back OBJ to OBJ;insert/lower OBJ in/into OBJ;insert/lower OBJ in/into/inside OBJ;l/look up OBJ in OBJ;lean/put/stick/wind OBJ against/around OBJ;lean/put/stick/wind OBJ back in/inside/into OBJ;lean/put/stick/wind OBJ back on/onto OBJ;lean/put/stick/wind OBJ in/inside/into OBJ;lean/put/stick/wind OBJ through OBJ;lock OBJ with OBJ;pick OBJ with OBJ;point out OBJ to OBJ;pry OBJ from/off/with OBJ;pry OBJ off with OBJ;remove/untie/unwind OBJ from OBJ;remove/untie/unwind/get/carry/catch/grab/hold/lift/snatch/steal/take OBJ from OBJ;rotate/screw/turn/twist/unscrew OBJ in OBJ;shout/yell OBJ at/to OBJ;stuff OBJ in/into/inside OBJ;tell OBJ OBJ;tell OBJ about OBJ;throw OBJ OBJ;throw OBJ at/to OBJ;throw/discard/drop/toss OBJ at/against/on/onto OBJ;throw/discard/drop/toss OBJ in/into/down OBJ;throw/discard/drop/toss/lean/put/stick/wind OBJ on/onto OBJ;transfer OBJ to OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;use OBJ in OBJ;use OBJ on/with OBJ;",
    "max_word_length" : 9
}

lostpig = {
    "name": "lostpig",
    "rom": "lostpig.z8",
    "seed" : 0,
    "walkthrough" : "X ME/INVENTORY/X FARM/X FOREST/LOOK FOR PIG/LISTEN/NORTHEAST/X STAIRS/X METAL THING/TAKE TUBE AND TORCH/LOOK INSIDE TUBE/BLOW IN TUBE/X CRACK/EAST/X PIG/FOLLOW PIG/CATCH IT/X FOUNTAIN/X BOWL/X COIN/X CURTAIN/X MAN/NORTH/X WEST MURAL/X EAST MURAL/X STATUE/X HAT/TAKE IT/WEAR IT/SOUTH/SOUTHWEST/X BOX/PUT COIN IN SLOT/PULL LEVER/X BRICK/TAKE IT/SMELL IT/TASTE IT/EAT IT/X DENT/HIT BOX/TAKE COIN/PUT COIN IN SLOT/PULL LEVER/HIT BOX/TAKE ALL FROM BASKET/PUT COIN IN SLOT/TAKE ALL FROM BASKET/X CHAIR/TAKE IT/EAST/X SHADOW/LISTEN/SHOUT/GREET GNOME/TELL GNOME ABOUT GRUNK/ASK GNOME ABOUT STATUE/ASK WHAT GNOME LOOKING FOR/LOOK UNDER BED/TALK TO GNOME ABOUT MOGGLEV/LOOK/LOOK UNDER BED/OPEN TRUNK/X BALL/TAKE BALL/SHOW TORCH TO GNOME/ASK GNOME ABOUT FIRE/SHOW BRICK TO GNOME/ASK GNOME ABOUT MOTHER/EAST/X SHELF/X TOP SHELF/DROP CHAIR/STAND ON CHAIR/X TOP SHELF/TAKE BOOK/X IT/GET DOWN/OPEN CHEST/TAKE POLE/X IT/WEST/SHOW POLE TO GNOME/ASK GNOME ABOUT COLOR MAGNET/SHOW BOOK TO GNOME/GIVE BOOK TO GNOME/EAST/ASK GNOME ABOUT PAGE/EAST/NORTHWEST/EAST/X RIVER/X THING/TAKE THING/CROSS RIVER/TOUCH THING WITH POLE/X KEY/TAKE WATER/FILL HAT WITH WATER/WEST/SOUTHEAST/UNLOCK CHEST/OPEN IT/POUR WATER ON POWDER/LIGHT TORCH WITH FIRE/NORTHWEST/WEST/X CRACK/TAKE PAPER/TAKE PAPER WITH POLE/BURN POLE WITH TORCH/TAKE PAPER WITH POLE/EAST/SOUTHWEST/EAST/GIVE PAPER TO GNOME/WAIT/GO TO PIG/SHOW BRICK TO PIG/DROP ALL BRICKS/Z/Z/Z/Z/TAKE PIG/GO TO STATUE/X HAND/PUT TORCH IN HAND/NORTH/X WINDY TUNNEL/NORTH/SOUTH/TAKE TORCH/GO TO GNOME/ASK GNOME FOR BALL/GIVE TORCH TO GNOME/THANK GNOME/GO TO WINDY CAVE/NORTH/EAST/DROP POLE/NORTHWEST/PLAY WHISTLE/SOUTHEAST/ENTER HOLE/FOLLOW GNOME",
    "grammar" : "a/t/talk piglish;about/author/clue/clues/credit/credits/help/hint/hints/info/menu/walkthrou/walkthru;arr/arrr/arrrr/growl/grr/grrr/grrrr/rar/rarr/rarrr/roar/rrr/rrrr/scream/yell/shout;awake/awaken/wake;awake/awaken/wake up;back/step/stand;back/step/stand back;back/step/stand up;bah/grumble/sigh;bathe/dive/swim;burp/fart;bye/farewell/good-bye/goodbye;consider/contempla/think;cough;crap/pee/piss/poop/wee/wizz;cry/frown/grimace/scowl/sniffle/sob;curse/dummy/idiot/stupid/damn/fuck/shit/sod;dance;declaim/deliver;declaim/deliver at wall;declaim/deliver from table top;declaim/deliver from table/tabletop;declaim/deliver monologue/monologue;declaim/deliver monologue/monologue at wall;declaim/deliver monologue/monologue from table/tabletop/top;declaim/deliver monologue/monologue to wall;declaim/deliver to wall;die/q/quit;dig;drink/sip;drool/spit;dross/bother/curses/darn/drat;dunno/shrug;exit/out/outside;exits;fly;fly away;fly up;frotz/plover/plugh/rezrov/wazzum/xyzzy/yoho/zarf/zork;full/fullscore;full/fullscore score;get down;get out/off/up;good bye;greet/hello/hi/a/t/talk/wave;grin/smile/smirk;groan/ugh/ugh!/uh/um;ha/ha!/haw/hee/laugh;ha/ha!/haw/hee/laugh ha/haw/ha!/hee;ha/ha!/haw/hee/laugh ha/haw/hee ha/haw/ha!/hee;ha/ha!/haw/hee/laugh ha/haw/hee ha/haw/hee ha/haw/ha!/hee;ha/ha!/haw/hee/laugh ha/haw/hee ha/haw/hee ha/haw/hee ha/haw/ha!/hee;have/take a bath;have/take bath;hear/listen;heat/warm up;hiccough/hiccup;hide;hooray/hurrah/hurray/woo/woohoo/wooo/woot/yay;hop/jump/skip;i dont/don't know/know!;i dunno/dunno!;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/enter;l/look;la/lalala la;la/lalala la la;la/lalala/sing;leave/go/run/walk;nah/never/nope/no;nod/ok/sure/yeah/yup/y/yes;noscript/unscript;notify;notify off;notify on;nouns/pronouns;objects;places;play;pray;recording;recording off;recording on;relax/rest/wait/z;replay;restart;restore;save;score;script/transcrip;script/transcrip off;script/transcrip on;short/superbrie/long/verbose/brief/normal;smell/sniff;sneeze;snooze/nap/sleep;snort/grunt/knio/oink/squeal;sorry;stand by;stick out tongue;stick tongue out;stretch;stretch out;take inventory;thank/thanks;thank/thanks you;topic/topics;topic/topics off;topic/topics on;verify;version;whistle;win;win game;win lost pig;win story;yawn;zobleb;ztorf;a/t/talk piglish at/to OBJ;a/t/talk/answer/say/speak to OBJ;adjust/set OBJ;adjust/set/burn/light OBJ on fire;answer OBJ;apologise/apologize to OBJ;arr/arrr/arrrr/growl/grr/grrr/grrrr/rar/rarr/rarrr/roar/rrr/rrrr/scream/yell at OBJ;attach/fasten/tie OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;back/step/stand away from OBJ;bah/grumble/sigh at/to OBJ;beat/kick/poke/prod/slap/spank/attack/break/crack/destroy/fight/hit/murder/punch/smash/thump/wreck OBJ;bite/chew/lick/taste/eat OBJ;blow OBJ;blow on/at/in OBJ;bother/curses/darn/drat OBJ;buy/purchase OBJ;call OBJ;call to/for OBJ;carry/hold OBJ;chase OBJ;chase after OBJ;check/describe/examine/watch/x OBJ;chop/cut/prune/slice OBJ;climb/scale OBJ;climb/scale into/in/inside OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;complain to/at OBJ;consider/contempla OBJ;consider/contempla/think about OBJ;cook/burn/light/burn/light OBJ;count OBJ;crap/pee/piss/poop/wee/wizz on/in OBJ;cry/frown/grimace/scowl/sniffle/sob at/to OBJ;curse/damn/fuck/shit/sod OBJ;dance with OBJ;discard/drop OBJ;disrobe/doff/shed/remove OBJ;dive/swim OBJ;dive/swim in OBJ;don/wear OBJ;douse/extinguis/smother OBJ;drag/pull OBJ;draw OBJ;draw OBJ;drink/sip OBJ;drink/sip from OBJ;drool/spit at/in/on OBJ;drown/splash OBJ;dry OBJ;dry OBJ off;dry off OBJ;dummy/idiot/stupid OBJ;dust/polish/rub/scrub/shine/sweep/wipe OBJ;earn OBJ;empty OBJ out;equip/wield OBJ;feel/fondle/grope/touch in/inside OBJ;fill OBJ;flip OBJ;frotz/plover/plugh/rezrov/wazzum/xyzzy/yoho/zarf/zork OBJ;get in/into/on/onto OBJ;get off OBJ;get/catch/grab/pin/steal/swipe/trap/take OBJ;go/run/walk back to OBJ;go/run/walk to OBJ;go/run/walk/enter OBJ;goto/find/follow/seek/go/run/walk OBJ;greet/hello/hi OBJ;grin/smile/smirk at/to OBJ;groan/ugh/ugh!/uh/um OBJ;grunt/knio/oink/squeal at OBJ;ha/ha!/haw/hee/laugh OBJ;ha/ha!/haw/hee/laugh at OBJ;ha/ha!/haw/hee/laugh ha/haw/hee OBJ;ha/ha!/haw/hee/laugh ha/haw/hee ha/haw/ha!/hee OBJ;ha/ha!/haw/hee/laugh ha/haw/hee ha/haw/hee ha/haw/ha!/hee OBJ;ha/ha!/haw/hee/laugh ha/haw/hee ha/haw/hee ha/haw/hee ha/haw/hee OBJ;hear/listen OBJ;hear/listen for OBJ;hear/listen to OBJ;heat/warm OBJ;heat/warm OBJ up;heat/warm up OBJ;heat/warm up by OBJ;heat/warm up over by OBJ;heat/warm up with OBJ;hide/get/go/run/walk behind/under/in OBJ;hooray/hurrah/hurray/woo/woohoo/wooo/woot/yay OBJ;hooray/hurrah/hurray/woo/woohoo/wooo/woot/yay for OBJ;hop/jump/skip on/at OBJ;huff/puff and puff at OBJ;huff/puff at OBJ;kill OBJ;l/look at OBJ;l/look behind OBJ;l/look inside/in/into/through/on OBJ;l/look under OBJ;leave/exit/out/outside OBJ;leave/go/run/walk into/in/inside/through OBJ;lie/sit at OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;lock OBJ;molest/embrace/hug/kiss OBJ;nod/ok/sure/yeah/yup at/to OBJ;nudge/straighte/clear/move/press/push/shift OBJ;open/uncover/undo/unwrap OBJ;paw OBJ;paw at OBJ;peel off OBJ;pet/scratch/feel/fondle/grope/touch OBJ;pick OBJ up;pick up OBJ;play OBJ;play with/on/in OBJ;pour/empty OBJ;pour/empty out OBJ;put OBJ down;put down OBJ;put on OBJ;put/blow OBJ out;put/blow out OBJ;reach into/in OBJ;read OBJ;remember OBJ;repair/fix OBJ;rip/tear OBJ;rock/shake OBJ;rotate/screw/turn/twist/unscrew OBJ;rotate/screw/turn/twist/unscrew/switch OBJ off;rotate/screw/turn/twist/unscrew/switch OBJ on;rotate/screw/turn/twist/unscrew/switch on OBJ;rotate/screw/turn/twist/unscrew/switch/close/cover/shut off OBJ;scare/threaten OBJ;scoop up OBJ;scoop/peel OBJ;search OBJ;search/l/look for OBJ;shout at/to OBJ;shout for OBJ;sing at/to OBJ;smoke OBJ;snort/smell/sniff OBJ;stand by OBJ;stand in OBJ;stand on OBJ;step in/into OBJ;step on/onto OBJ;step/stand near OBJ;step/stand next to OBJ;stick out tongue at OBJ;stick tongue out at OBJ;swallow OBJ;switch OBJ;take OBJ off;take off OBJ;thank/thanks OBJ;thank/thanks you OBJ;topic/topics OBJ;torture OBJ;toss/throw OBJ;unlock OBJ;vault/cross/hop/jump/skip OBJ;vault/hop/jump/skip over OBJ;wash/clean OBJ;wave at/to OBJ;wave/swing OBJ;waylay/wrestle OBJ;wrestle with OBJ;wring/squash/squeeze OBJ out;wring/squash/squeeze out OBJ;wring/squidge/squish/squash/squeeze OBJ;adjust/set OBJ to OBJ;adjust/set/burn/light OBJ on fire with/using OBJ;answer/say/speak OBJ to OBJ;attach/fasten/tie OBJ to OBJ;beat/kick/poke/prod/slap/spank OBJ at OBJ;beat/kick/poke/prod/slap/spank/attack/break/crack/destroy/fight/hit/murder/punch/smash/thump/wreck OBJ with OBJ;burn/light OBJ with/using OBJ;catch/grab/pin/steal/swipe/trap/take OBJ off OBJ;chase OBJ OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift OBJ in/into/to/toward OBJ;consult OBJ about OBJ;consult OBJ on OBJ;cook/burn/light OBJ with OBJ;dip/dunk OBJ in/inside/into OBJ;discard/drop OBJ at/against/on/onto OBJ;discard/drop OBJ in/into/down OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;display/present/show/display/present/show OBJ OBJ;display/present/show/display/present/show OBJ to OBJ;douse/extinguis/smother OBJ with/in OBJ;draw OBJ with OBJ;drown/splash OBJ on/at OBJ;drown/splash OBJ with/in OBJ;dry OBJ off on OBJ;dry OBJ off on OBJ;dry OBJ off with OBJ;dry OBJ off with OBJ;dry OBJ on OBJ;dry OBJ on OBJ;dry OBJ with OBJ;dry OBJ with OBJ;dry off OBJ with OBJ;dry off OBJ with OBJ;dust/polish/rub/scrub/shine/sweep/wipe OBJ on/over/across OBJ;empty OBJ on/onto OBJ;empty OBJ to/in/into OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feel/fondle/grope/touch OBJ to OBJ;feel/fondle/grope/touch in/inside OBJ with OBJ;fill OBJ from/with OBJ;force/jemmy/lever/prise/prize/pry OBJ apart/open with OBJ;force/jemmy/lever/prise/prize/pry apart/open OBJ with OBJ;get/catch/grab/pin/steal/swipe/trap/take/remove OBJ from OBJ;get/catch/grab/pin/steal/swipe/trap/take/remove/peel OBJ with OBJ;get/take OBJ in OBJ;give/offer/pay OBJ and OBJ;give/offer/pay over OBJ to OBJ;heat/warm OBJ up with OBJ;heat/warm OBJ up with OBJ;heat/warm OBJ with OBJ;heat/warm OBJ with OBJ;heat/warm up OBJ with OBJ;heat/warm up OBJ with OBJ;insert OBJ in/into OBJ;l/look up OBJ in OBJ;lock OBJ with OBJ;open/uncover/undo/unwrap OBJ with OBJ;pick OBJ up in OBJ;pick OBJ up with OBJ;pick up OBJ in OBJ;pick up OBJ with OBJ;point OBJ at OBJ;point at OBJ with OBJ;pour OBJ into/in OBJ;pour OBJ onto/on OBJ;pour out OBJ into/in OBJ;pour out OBJ onto/on OBJ;put OBJ out with/in OBJ;put out OBJ with/in OBJ;reach OBJ in/into OBJ;reach into/in OBJ with OBJ;reach/feel/fondle/grope/touch/dust/polish/rub/scrub/shine/sweep/wipe/clear/move/press/push/shift OBJ with OBJ;rip/tear/chop/cut/prune/slice OBJ with OBJ;scoop OBJ up with/into OBJ;scoop OBJ with/into OBJ;scoop up OBJ with/into OBJ;shout OBJ at/to OBJ;stick/put OBJ over/across OBJ;stick/put/discard/drop OBJ on/onto OBJ;take OBJ off of OBJ;torture/kill OBJ with OBJ;toss/throw OBJ at/against/on/onto OBJ;toss/throw/stick/put OBJ in/inside/into OBJ;transfer OBJ to OBJ;unlock/force/jemmy/lever/prise/prize/pry OBJ with OBJ;vault OBJ with OBJ;vault over OBJ with OBJ;wash/clean OBJ with/in OBJ;wring/squash/squeeze OBJ out over/into OBJ;wring/squidge/squish/squash/squeeze OBJ over/into OBJ;",
    "max_word_length" : 9
}

ludicorp = {
    "name": "ludicorp",
    "rom": "ludicorp.z5",
    "seed" : 0,
    "walkthrough" : "x building/s/se/x car/open car/enter car/x car/smell car/x gun/take gun/out/nw/n/e/e/s/e/x ladder/x pots/x wire/x statue/take all/w/s/x well/x footprints/x plants/d/x water/x fuse/take fuse/u/n/n/w/x bushes/s/s/d/ne/x label/x generator/put fuse in generator/sw/u/n/n/w/n/x door/open door/s/w/w/e/e/s/w/x gate/x panel/x button/x grill/push button/w/n/x boxes/x clingfilm/n/n/n/x keypad/e/n/x cupboard/x counter/e/x cooler/s/x trees/x flowers/x paper/u/d/e/s/x key/take key/w/x fountain/x water/n/n/e/x copier/x tray/open tray/take paper/x paper/e/x shelves/u/x pen/take pen/d/s/x desks/x chairs/x computers/s/w/s/e/s/x cupboard/unlock cupboard with key/open cupboard/x knife/take knife/n/w/w/s/x desk/x cup/take cup/x coffee/n/w/w/s/cut clingfilm with knife/x patch/x knife/n/e/n/u/s/x window/x carpark/shoot window/e/x whiteboard/x marker/take marker/write on whiteboard with marker/s/x toner/take toner/n/e/e/n/n/x screen/n/x machine/w/x bar/take bar/eat bar/w/w/s/w/x cubicles/s/drop all/s/x dispenser/push button/x blank card/n/take all/n/e/n/e/e/e/s/s/w/x printer/x slot/open slot/put toner in slot/close slot/x tray/open tray/put sheet in tray/close tray/x light/x button/push button/x sheet/e/s/w/w/w/n/d/s/w/n/n/x keypad/push button 1/push button 7/push button 3/push button 9/push button enter/n/u/w/u/x door/x papers/d/e/d/s/s/s/e/n/u/u/s/w/x city/n/n/s/s/e/e/x arcade/play arcade/x pool/play pool/s/n/e/e/n/x duct/x pipe/put patch on pipe/n/x console/n/x servers/w/w/x door/open door/w/x slot/e/e/s/s/s/w/w/w/n/u/w/ne/se/x drain/pour coffee in drain/x pass/sw/nw/e/d/s/e/e/e/n/n/n/w/w/close outer door/put pass in slot/w/x robot/x plaque/e/put pass in slot/open outer door/e/e/s/s/s/w/w/w/n/d/s/e/e/e/n/n/n/x machine/punch cat_robot->desist(); on blank card/s/s/s/w/w/w/n/u/s/e/e/e/n/n/n/w/w/close outer/put pass in slot/w/put card in slot/s/x keys/take keys/n/e/put pass in slot/open outer/e/e/s/s/s/w/w/w/n/d/d/s/w/n/n/n/u/w/u/unlock door with keys",
    "grammar" : "awake/awaken/wake;awake/awaken/wake up;bother/curses/darn/drat;brief/normal;carry/hold/take inventory;damn/fuck/shit/sod;die/q/quit;dive/swim;exit/out/outside/stand;full/fullscore;full/fullscore score;get out/off/up;hear/listen;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;leave/go/run/walk;long/verbose;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;pray;restart;restore;save;score;script/transcrip;script/transcrip off;script/transcrip on;short/superbrie;sing;smell/sniff;sorry;stand up;think;verify;version;wait/z;wave;y/yes;adjust/set OBJ;attach/fasten/fix/tie OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;carry/hold/take off OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;clear/move/press/push/shift OBJ 1;clear/move/press/push/shift OBJ 2;clear/move/press/push/shift OBJ 3;clear/move/press/push/shift OBJ 4;clear/move/press/push/shift OBJ 5;clear/move/press/push/shift OBJ 6;clear/move/press/push/shift OBJ 7;clear/move/press/push/shift OBJ 8;clear/move/press/push/shift OBJ 9;clear/move/press/push/shift OBJ enter;climb/scale OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;cross/enter/go/run/walk OBJ;damn/fuck/shit/sod OBJ;dig OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;fire OBJ;fire/shoot OBJ;fire/shoot at OBJ;get in/into/on/onto OBJ;get off OBJ;get/carry/hold/take OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look under OBJ;leave OBJ;leave/go/run/walk into/in/inside/through OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pick OBJ;pick OBJ up;pick up OBJ;play OBJ;play with OBJ;pour/tip OBJ;pour/tip OBJ away;pour/tip OBJ out;pour/tip away OBJ;pour/tip out OBJ;punch/attack/break/crack/destroy/fight/hit/kill/murder/smash/thump/torture/wreck OBJ;put OBJ down;put down OBJ;put on OBJ;read/check/describe/examine/watch/x OBJ;rip/tear OBJ;rotate/screw/turn/twist/unscrew OBJ;scribble/scribe/write on OBJ;search OBJ;smell/sniff OBJ;squash/squeeze OBJ;stand on OBJ;start OBJ;stop OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;taste OBJ;uncoil OBJ;use OBJ;wave OBJ;adjust/set OBJ to OBJ;answer/say/shout/speak OBJ to OBJ;ask OBJ about OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;burn/light OBJ with OBJ;carry/hold/take OBJ off OBJ;chop/cut/prune/slice OBJ using OBJ;chop/cut/prune/slice OBJ with OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;consult OBJ about OBJ;consult OBJ on OBJ;dig OBJ with OBJ;discard/drop/throw OBJ at/against/on/onto OBJ;discard/drop/throw OBJ in/into/down OBJ;discard/drop/throw/put OBJ on/onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ to/into/on/onto OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;fire OBJ at OBJ;fire/shoot OBJ with OBJ;fire/shoot at OBJ with OBJ;insert OBJ in/into OBJ;l/look up OBJ in OBJ;lock OBJ with OBJ;pour/tip OBJ in OBJ;pour/tip OBJ into OBJ;pour/tip OBJ on OBJ;pour/tip OBJ onto OBJ;put OBJ in/inside/into OBJ;read OBJ in OBJ;read about OBJ in OBJ;remove/get/carry/hold/take OBJ from OBJ;scribble/scribe/write on OBJ with OBJ;tell OBJ about OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;use OBJ on OBJ;use OBJ with OBJ;",
    "max_word_length" : 9
}

lurking = {
    "name": "lurking",
    "rom": "lurking.z3",
    "seed" : 0,
    # Walkthrough adapted from http://mirror.ifarchive.org/if-archive/solutions/jgunness.zip and http://www.eristic.net/games/infocom/lurking.html
    "walkthrough": "STAND/S/W/OPEN FRIDGE/GET COKE AND CARTON/OPEN CARTON/OPEN OVEN/PUT CARTON IN OVEN/CLOSE OVEN/PRESS 4/PRESS 0/PRESS 5/PRESS MED/PRESS START/Z/Z/Z/Z/OPEN OVEN/GET CARTON/E/N/GIVE CARTON TO HACKER/ASK HACKER ABOUT KEYS/ASK HACKER FOR MASTER KEY/SIT DOWN/CLICK ON EDIT/CLICK ON PAPER/READ PAGE/CLICK ON MORE/AGAIN/AGAIN/AGAIN/D/Z/GET STONE/Z/Z/STAND UP/Z/Z/Z/S/PRESS DOWN BUTTON/Z/Z/S/OPEN PANEL/GET FLASHLIGHT/OPEN DOOR/N/D/D/E/GET GLOVES AND CROWBAR/WEAR GLOVES/U/LIGHT FLASHLIGHT/GET FLASK/D/TURN OFF FLASHLIGHT/W/W/W/U/S/GET CONTAINER/E/Z/Z/Z/E/U/CLIMB ROPE/LOWER LADDER/OPEN DOOR/OUT/U/REMOVE PLUG/DROP PLUG/GET PAPER/D/IN/D/D/E/SMASH CABINET/GET AXE/W/THROW AXE AT CORD/OPEN CONTAINER/POUR WAX ON FLOOR/DROP CONTAINER AND ASSIGNMENT/E/E/N/D/SE/GET BOOTS/WEAR THEM/U/U/UNLOCK DOOR WITH KEY/OPEN DOOR/OUT/U/D/THROW STONE AT CREATURE/U/EXAMINE TREE/DIG IN TUB/GET HAND/D/IN/D/S/GET STONE/N/D/NW/U/S/W/W/W/W/N/D/E/GET IN FORKLIFT/START IT/E/E/E/LIGHT FLASHLIGHT/REMOVE JUNK WITH FORKLIFT/AGAIN/AGAIN/AGAIN/E/GET OUT OF FORKLIFT/OPEN MANHOLE WITH CROWBAR/D/N/D/GET KNIFE/U/S/U/W/W/TURN OFF FLASHLIGHT/W/W/W/U/S/E/E/E/E/S/KNOCK ON DOOR/Z/GIVE PAPER TO PROFESSOR/S/Z/Z/CUT LINE WITH KNIFE/GET OUT OF PENTAGRAM/MOVE BENCH/OPEN TRAPDOOR/D/OPEN TRAPDOOR/LIGHT FLASHLIGHT/U/PUT HAND IN LIQUID/Z/Z/GET HAND/GET HYRAX/PUT IT ON HAND/DRINK COKE/N/OPEN DOOR/N/TURN OFF FLASHLIGHT/N/W/W/W/W/N/S/E/E/E/E/W/W/W/W/N/D/SHOW HAND TO URCHIN/GET CUTTER/D/DROP CUTTER, FLASK AND AXE/NW/UNLOCK PADLOCK WITH KEY/GET PADLOCK/OPEN HATCH/LIGHT FLASHLIGHT/D/E/TURN VALVE WITH CROWBAR/Z/Z/Z/TURN VALVE/CLOSE VALVE/E/E/REMOVE BRICK WITH CROWBAR/REMOVE NEW BRICK WITH CROWBAR/W/W/W/U/TURN OFF FLASHLIGHT/DROP KNIFE AND CROWBAR/SE/GET ALL/U/E/E/U/PRESS DOWN/D/Z/Z/WEDGE DOORS WITH AXE/D/GET CHAIN/TIE CHAIN TO ROD/LOCK IT WITH PADLOCK/U/PUT CHAIN ON HOOK/GET AXE/U/U/PRESS UP BUTTON/D/D/Z/Z/Z/WEDGE DOORS WITH AXE/D/GET AXE/LIGHT FLASHLIGHT/N/W/W/W/W/W/D/D/CUT GROWTH WITH CUTTER/D/N/D/S/S/D/OPEN FLASK/LOOK IN IT/POUR LIQUID ON SLIME/UNLOCK DOOR WITH KEY/OPEN DOOR/S/REACH INTO POOL/PULL LINE/CUT LINE WITH AXE/AGAIN/AGAIN/GET LINE/OPEN METAL COVER/UNPLUG COAXIAL CABLE/PUT LINE IN SOCKET/Z/THROW STONE AT THING/GET STONE",
    "grammar" : "answer/reply/respon;brief;call/say/talk;chase/follow;clear/move/shift/drive/go/procee/run/steer/step/walk;concea/hide;damn/fuck/shit;depart/exit/withdr;diagno;die;disemb;dive/jump/leap;enter;gaze/l/look/stare;greeti/hello/hi;hack;help/hint;hop/skip;i/invent;leave;listen;nap/sleep;no/nope;okay/y/yes;pray;q/quit;restar;restor;rise/stand;save;score;scream/shout/yell;script;smell/sniff;super/superb;swim/wade;t/time;thank/thanks;unscri;verbos;versio;wait/z;where;who;yawn;admire/compli OBJ;answer/reply/respon OBJ;approa OBJ;ask/quiz about OBJ;ask/quiz for OBJ;attack/fight/hit/strike OBJ;awake/wake OBJ;awake/wake up OBJ;bargai with OBJ;beckon/wave OBJ;beckon/wave to OBJ;beckon/wave/scream/shout/yell at OBJ;bite OBJ;blow out OBJ;board/ride OBJ;break/crack/destro/scrape/scratc/smash/wreck OBJ;bury OBJ;call/say/talk OBJ;call/say/talk to OBJ;carry/catch/get/grab/hold/snatch/take OBJ;carry/catch/get/grab/hold/snatch/take off OBJ;carry/catch/get/grab/hold/snatch/take out OBJ;carry/catch/get/grab/hold/snatch/take/drag/pull/tug down OBJ;chase/follow OBJ;check/descri/examin/watch/x OBJ;check/descri/examin/watch/x/gaze/l/look/stare in OBJ;check/descri/examin/watch/x/gaze/l/look/stare on OBJ;check/descri/examin/watch/x/gaze/l/look/stare/rummag/search for OBJ;choose/click/select OBJ;choose/click/select on OBJ;clear/move/shift/drag/pull/tug OBJ;climb/scale OBJ;climb/scale down OBJ;climb/scale off OBJ;climb/scale out OBJ;climb/scale over OBJ;climb/scale up OBJ;climb/scale/carry/catch/get/grab/hold/snatch/take on OBJ;climb/scale/rest/sit/carry/catch/get/grab/hold/snatch/take in OBJ;close/shut OBJ;compar OBJ;concea/hide OBJ;concea/hide behind OBJ;concea/hide from OBJ;concea/hide under OBJ;concea/hide/rise/stand in OBJ;consum/eat/gobble OBJ;cook/heat/warm OBJ;count OBJ;cross OBJ;curdle/scare/startl/surpri OBJ;depart/exit/withdr OBJ;descen OBJ;detach/discon/free/unatta/unfast/unhook/untie/unwrap OBJ;dig in OBJ;dig throug OBJ;dig with OBJ;disemb OBJ;dive/jump/leap across OBJ;dive/jump/leap down OBJ;dive/jump/leap from OBJ;dive/jump/leap in OBJ;dive/jump/leap off OBJ;dive/jump/leap on OBJ;dive/jump/leap to OBJ;dive/jump/leap/drive/go/procee/run/steer/step/walk over OBJ;drag/pull/tug on OBJ;drink/sip/swallo OBJ;drink/sip/swallo from OBJ;drive/go/procee/run/steer/step/walk OBJ;drive/go/procee/run/steer/step/walk around OBJ;drive/go/procee/run/steer/step/walk away OBJ;drive/go/procee/run/steer/step/walk down OBJ;drive/go/procee/run/steer/step/walk in OBJ;drive/go/procee/run/steer/step/walk on OBJ;drive/go/procee/run/steer/step/walk throug OBJ;drive/go/procee/run/steer/step/walk to OBJ;drive/go/procee/run/steer/step/walk under OBJ;drive/go/procee/run/steer/step/walk up OBJ;drop/dump OBJ;drop/dump from OBJ;edit OBJ;empty/pour/spill OBJ;enter OBJ;erase OBJ;erect/lift/raise OBJ;erect/lift/raise/insert/lay/place/put up OBJ;exting OBJ;feel/pat/pet/rub/squeez/touch OBJ;fill OBJ;find OBJ;fix/patch/repair OBJ;flip/power/set/turn OBJ;flip/power/set/turn around OBJ;flip/power/set/turn off OBJ;flip/power/set/turn on OBJ;flip/power/set/turn over OBJ;gaze/l/look/stare OBJ;gaze/l/look/stare around OBJ;gaze/l/look/stare at OBJ;gaze/l/look/stare behind OBJ;gaze/l/look/stare down OBJ;gaze/l/look/stare throug OBJ;gaze/l/look/stare under OBJ;gaze/l/look/stare up OBJ;gestur/point at OBJ;gestur/point to OBJ;greeti/hello/hi OBJ;hack OBJ;hang from OBJ;help/hint OBJ;hurl/pitch/throw/toss OBJ;hurl/pitch/throw/toss away OBJ;input/type OBJ;input/type login OBJ;input/type passwo OBJ;insert/lay/place/put down OBJ;insert/lay/place/put on OBJ;kick OBJ;kill/murder/slay/stab OBJ;kiss OBJ;knock/rap at OBJ;knock/rap down OBJ;knock/rap on OBJ;lean on OBJ;leave OBJ;let go OBJ;lie down OBJ;lie on OBJ;light OBJ;light up OBJ;listen for OBJ;listen to OBJ;login OBJ;login as OBJ;login on OBJ;lower OBJ;nap/sleep in OBJ;nap/sleep on OBJ;open OBJ;open up OBJ;passwo OBJ;pick OBJ;pick up OBJ;plug/screw in OBJ;press/push/shove OBJ;press/push/shove down OBJ;press/push/shove on OBJ;press/push/shove up OBJ;rattle/shake OBJ;reach in OBJ;reach under OBJ;read OBJ;releas OBJ;remove/shed OBJ;rest/sit at OBJ;rest/sit down OBJ;rest/sit on OBJ;rise/stand on OBJ;rise/stand/carry/catch/get/grab/hold/snatch/take up OBJ;roll up OBJ;rummag/search OBJ;rummag/search in OBJ;sample/taste OBJ;shoot OBJ;slide OBJ;slide on OBJ;smell/sniff OBJ;start OBJ;start/flip/power/set/turn up OBJ;stop OBJ;swim/wade in OBJ;swing/thrust OBJ;tell OBJ;tell about OBJ;thank/thanks OBJ;tortur OBJ;trade OBJ;unplug/unscre OBJ;wait/z OBJ;wait/z for OBJ;wear OBJ;what OBJ;what/read about OBJ;where OBJ;who OBJ;apply OBJ to OBJ;ask/quiz OBJ about OBJ;ask/quiz OBJ for OBJ;attach/connec/fasten/hook/loop/tie/wrap OBJ around OBJ;attach/connec/fasten/hook/loop/tie/wrap OBJ on OBJ;attach/connec/fasten/hook/loop/tie/wrap OBJ to OBJ;attach/connec/fasten/hook/loop/tie/wrap up OBJ with OBJ;attack/fight/hit/strike OBJ with OBJ;beckon/wave OBJ at OBJ;break/crack/destro/scrape/scratc/smash/wreck OBJ with OBJ;break/crack/destro/scrape/scratc/smash/wreck down OBJ with OBJ;burn/ignite OBJ with OBJ;burn/ignite down OBJ with OBJ;bury OBJ in OBJ;buy/purcha OBJ from OBJ;buy/purcha OBJ with OBJ;carry/catch/get/grab/hold/snatch/take OBJ from OBJ;carry/catch/get/grab/hold/snatch/take OBJ in OBJ;carry/catch/get/grab/hold/snatch/take OBJ off OBJ;carry/catch/get/grab/hold/snatch/take OBJ out OBJ;carry/catch/get/grab/hold/snatch/take OBJ with OBJ;choose/click/select OBJ with OBJ;choose/click/select on OBJ with OBJ;chop/cut/prune/slash/slice/split OBJ with OBJ;chop/cut/prune/slash/slice/split throug OBJ with OBJ;clear/move/shift OBJ with OBJ;close/shut OBJ with OBJ;compar OBJ to OBJ;compar OBJ with OBJ;concea/hide OBJ from OBJ;count OBJ in OBJ;cover OBJ with OBJ;curdle/scare/startl/surpri OBJ with OBJ;detach/discon/free/unatta/unfast/unhook/untie/unwrap OBJ from OBJ;dig OBJ with OBJ;dig in OBJ with OBJ;drive/go/procee/run/steer/step/walk OBJ OBJ;drive/go/procee/run/steer/step/walk OBJ on OBJ;drive/go/procee/run/steer/step/walk OBJ over OBJ;drop/dump OBJ on OBJ;drop/dump/insert/lay/place/put OBJ down OBJ;drop/dump/insert/lay/place/put OBJ in OBJ;empty/pour/spill OBJ from OBJ;empty/pour/spill OBJ in OBJ;empty/pour/spill OBJ on OBJ;empty/pour/spill OBJ over OBJ;empty/pour/spill OBJ throug OBJ;erect/lift/raise up OBJ with OBJ;feed/give/offer OBJ OBJ;feed/give/offer OBJ to OBJ;feed/give/offer OBJ with OBJ;feel/pat/pet/rub/squeez/touch OBJ to OBJ;feel/pat/pet/rub/squeez/touch OBJ with OBJ;fill OBJ at OBJ;fill OBJ with OBJ;fix/patch/repair OBJ with OBJ;flip/power/set/turn OBJ to OBJ;flip/power/set/turn OBJ with OBJ;gaze/l/look/stare at OBJ throug OBJ;gaze/l/look/stare up OBJ in OBJ;hang OBJ from OBJ;hang OBJ on OBJ;hone/sharpe OBJ on OBJ;hone/sharpe OBJ with OBJ;hurl/pitch/throw/toss OBJ at OBJ;hurl/pitch/throw/toss OBJ away OBJ;hurl/pitch/throw/toss OBJ down OBJ;hurl/pitch/throw/toss OBJ in OBJ;hurl/pitch/throw/toss OBJ off OBJ;hurl/pitch/throw/toss OBJ on OBJ;hurl/pitch/throw/toss OBJ over OBJ;hurl/pitch/throw/toss OBJ throug OBJ;hurl/pitch/throw/toss OBJ to OBJ;insert/lay/place/put OBJ across OBJ;insert/lay/place/put OBJ around OBJ;insert/lay/place/put OBJ behind OBJ;insert/lay/place/put OBJ betwee OBJ;insert/lay/place/put OBJ on OBJ;insert/lay/place/put OBJ over OBJ;insert/lay/place/put OBJ under OBJ;kill/murder/slay/stab OBJ with OBJ;lean OBJ on OBJ;lean/rise/stand OBJ agains OBJ;lever/pry out OBJ with OBJ;lock OBJ to OBJ;lock OBJ with OBJ;lower OBJ down OBJ;lower OBJ in OBJ;melt/thaw OBJ with OBJ;open OBJ with OBJ;pick OBJ with OBJ;plug/screw OBJ in OBJ;plug/screw OBJ with OBJ;press/push/shove OBJ OBJ;press/push/shove/clear/move/shift OBJ on OBJ;press/push/shove/clear/move/shift OBJ to OBJ;prop/wedge OBJ betwee OBJ;prop/wedge OBJ in OBJ;prop/wedge OBJ with OBJ;rattle/shake OBJ at OBJ;reach in OBJ with OBJ;read OBJ to OBJ;remove/shed OBJ from OBJ;remove/shed/unplug/unscre/lever/pry/erect/lift/raise OBJ with OBJ;sell OBJ OBJ;sell OBJ to OBJ;show OBJ OBJ;show OBJ to OBJ;slide/press/push/shove OBJ under OBJ;swing/thrust OBJ at OBJ;tell OBJ OBJ;tell OBJ about OBJ;trade OBJ with OBJ;trade/feed/give/offer OBJ for OBJ;unlock OBJ with OBJ;unplug/unscre OBJ from OBJ;",
    "max_word_length" : 6
}

moonlit = {
    "name": "moonlit",
    "rom": "moonlit.z5",
    "seed" : 0,
    "walkthrough" : "take mask/x mask/x self/d/x light/x leaf/x kite/x comb/x shadow/take dagger/n/take comb/x comb/hit comb/x compass/x feather/x hawk/x swallow/x crane/set compass to hawk/look/x trees/x leaf/take leaf/unfold leaf/i/x crane/set compass to crane/get fan/x fan/cut blue tassel/i/attach paper to teeth/i/attach string to kite/set compass to swallow/fly kite/s/u/look up/x horse/x flower/d/n/w/x bones/get bones with chopsticks/d/x arrangement/set constellations to horse/x arrangement/d/x hawks/s/wear mask/l/u/x storm/u",
    "grammar" : "about/help;awake/awaken/wake;awake/awaken/wake up;bathe;bother/curses/darn/drat;breathe/smell/sniff;brief;carry/hold/take inventory;damn/fuck/shit/sod;die/q/quit;dive/swim;exit/out/outside/stand;fly;full/fullscore/score;get out/off/up;hear/listen;hint;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;l/look up;leave/go/run/walk;nap/sleep;no;normal/long/verbose;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;pray;restart;restore;save;script/transcrip;script/transcrip off;script/transcrip on;short/superbrie;sing;sorry;stand up;think;verify;version;wait/z;wave;xyzzy;y/yes;arrange/clear/move/press/push/shift OBJ;attach/fasten/fix/tie OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;blow into OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;carry/hold/take apart OBJ;carry/hold/take off OBJ;change/spin/rotate/screw/turn/twist/unscrew/adjust/set OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;climb/scale OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;comb OBJ;cross/enter/go/run/walk OBJ;damn/fuck/shit/sod OBJ;dig OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;fly OBJ;fold OBJ;get in/into/on/onto OBJ;get off OBJ;get/carry/hold/take OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look under OBJ;leave OBJ;leave/go/run/walk into/in/inside/through OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;play OBJ;put OBJ down;put down OBJ;put on OBJ;read/check/describe/examine/watch/x OBJ;recite OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;smell/sniff OBJ;squash/squeeze OBJ;stand on OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;taste OBJ;tear/bash/strike/attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;unfold OBJ;unknot/untie OBJ;wave OBJ;adjust/set OBJ to OBJ;answer/say/shout/speak OBJ to OBJ;arrange OBJ as OBJ;arrange OBJ to OBJ;arrange/get/carry/hold/take OBJ with OBJ;ask OBJ about OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;burn/light OBJ with OBJ;carry/hold/take OBJ off OBJ;change/spin/rotate/screw/turn/twist/unscrew/rotate/screw/turn/twist/unscrew/adjust/set OBJ to OBJ;chop/cut/prune/slice OBJ with OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;consult OBJ about OBJ;consult OBJ on OBJ;dig OBJ with OBJ;discard/drop/throw OBJ at/against/on/onto OBJ;discard/drop/throw OBJ in/into/down OBJ;discard/drop/throw/put OBJ on/onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ to/into/on/onto OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;insert OBJ in/into OBJ;l/look up OBJ in OBJ;lock OBJ with OBJ;put OBJ in/inside/into OBJ;read OBJ in OBJ;read about OBJ in OBJ;remove/get/carry/hold/take OBJ from OBJ;tell OBJ about OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

murdac = {
    "name": "murdac",
    "rom": "murdac.z5",
    "seed" : 0,
    "walkthrough" : "s/n/s/n/n/n/take shawm/s/blow shawm/s/s/s/take plank/take rod/e/take key/n/e/w/n/dig/take lamp/s/read grave/e/e/howl arac/take sword/w/unlock door/open door/n/close door/lock door/drop key/d/w/w/throw plank/w/w/take plank/throw rod/throw plank/n/s/w/w/take bowl/s/take toad/no/take stone/n/e/e/e/e/e/take pillow/e/e/e/e/w/e/w/e/n/s/n/e/drop pillow/take peridots/n/e/n/blow shawm/n/take perfume/s/s/e/s/drop perfume/drop peridots/drop bowl/drop shawm/drop sword/s/se/take beads/e/n/take erbium/eat toadstone/s/w/d/drop lamp/look/s/gnoeval/take all/n/take lamp/u/nw/n/e/ne/wave beads/take thorn/sw/w/drop all/take lamp/ne/ne/d/s/take bread/oozelumny/n/u/ne/sw/e/s/nw/w/d/se/take myrrh/d/nw/nw/e/e/n/ne/ne/n/d/sw/sw/drop myrrh/ne/feed pigeon/take pigeon/sw/n/w/take dummy/s/drop pigeon/look/agganrw/take statuette/n/w/w/n/take dodo/s/e/e/e/n/d/wait/s/s/drop dodo/drop statuette/take bowl/s/sw/fill bowl/ne/n/w/w/w/w/w/w/w/s/look/n/e/e/e/e/e/e/e/drop bowl/take beads/take tiepin/take sword/e/d/d/prick dummy/drop dummy/u/u/w/drop pin/ne/get wig/u/u/take staff/d/d/sw/e/d/s/u/w/ne/u/u/d/d/sw/w/w/w/w/w/w/w/s/wave scroll/w/w/w/wave beads/w/ne/e/se/sw/dig/take hoard/w/e/ne/exodus/e/e/n/e/e/e/e/e/e/e/drop bible/drop sword/drop hoard/e/drop wig/d/s/u/w/ne/u/u/take amethysts/d/d/sw/take all/n/n/n/drop all/take lamp/s/s/s/take all/n/n/n/drop all/get lamp/s/s/s/take all/n/n/n/sword/throw sword into lake",
    "grammar": "allhints;allpuzzle/puzzles;awake/awaken/wake;awake/awaken/wake up;bother/curses/darn/drat;brief/normal;carry/get/hold/take inventory;carry/get/hold/take off;carry/get/hold/take out;close/cover/shut up;damn/fuck/shit/sod;die/q/quit;dive/swim;exit/out/outside/stand;full/fullscore;full/fullscore score;go/leave/run/walk;hear/listen;help;hint/hints;hints off;hints on;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;long/verbose;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;off;on;places;pray;restart;restore;review;save;score;script;script off;script on;short/superbrie;sing;smell/sniff;sorry;stand/carry/get/hold/take up;think;verify;version;wait/z;wave;xyzzy;y/yes;dig;adjust/set OBJ;attach/fasten/fix/tie OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;carry/get/hold/take OBJ;carry/get/hold/take off OBJ;chase/follow/pursue/trail OBJ;chase/follow/pursue/trail after OBJ;check/describe/examine/watch/x OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;click OBJ;click on OBJ;climb/scale OBJ;climb/scale over OBJ;climb/scale up OBJ;close/cover/shut OBJ;cross/enter/go/leave/run/walk OBJ;damn/fuck/shit/sod OBJ;dig OBJ;drop OBJ;throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;drink/sip/swallow at OBJ;drink/sip/swallow from OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;go/leave/run/walk through OBJ;go/leave/run/walk/carry/get/hold/take into OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;l/look at OBJ;howl OBJ;l/look behind OBJ;l/look in OBJ;l/look inside OBJ;l/look into OBJ;l/look through OBJ;l/look under OBJ;lie/sit/go/leave/run/walk inside OBJ;lie/sit/go/leave/run/walk/carry/get/hold/take in OBJ;lie/sit/stand/carry/get/hold/take on OBJ;open/uncover/undo/unwrap OBJ;unlock OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;put OBJ down;put down OBJ;put on OBJ;read OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;smell/sniff OBJ;squash/squeeze OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;taste OBJ;unfold OBJ;wave OBJ;adjust/set OBJ to OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;burn/light OBJ with OBJ;carry/get/hold/take OBJ off OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;click OBJ on OBJ;dig OBJ with OBJ;discard/drop/throw OBJ against OBJ;discard/drop/throw OBJ at OBJ;discard/drop/throw OBJ down OBJ;discard/drop/throw/insert/put OBJ in OBJ;discard/drop/throw/insert/put OBJ into OBJ;discard/drop/throw/put OBJ on OBJ;discard/drop/throw/put OBJ onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ into OBJ;empty OBJ on OBJ;empty OBJ onto OBJ;empty OBJ to OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;lock OBJ with OBJ;put OBJ inside OBJ;remove/carry/get/hold/take OBJ from OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

night = {
    "name": "night",
    "rom": "night.z5",
    "seed" : 0,
    "walkthrough" : "ne/s/e/open box/pull hose/take light/w/n/w/d/d/e/s/e/open door/s/listen/n/w/n/w/u/e/s/push fountain/open panel/turn on light/go panel/go panel/e/z/z/follow mouse/follow mouse/follow mouse/follow mouse/follow mouse/get printer/ask gnome about prinout/w/x sign/w/w/w/e/e/w/u/n/w/u/e/sw/click ftp/click if-archive/click designers_manual/click lpr/take manual/ne/w/d/e/s/d/z/z/z/z/z/follow mouse/follow mouse/follow mouse/follow mouse/follow mouse/follow mouse/give manual/take printer/w/w/w/e/e/w/u/n/w/u/e/sw/put printer on table",
    "grammar" : "allhints;allpuzzle/puzzles;awake/awaken/wake;awake/awaken/wake up;bother/curses/darn/drat;brief/normal;carry/get/hold/take inventory;carry/get/hold/take off;carry/get/hold/take out;close/cover/shut up;damn/fuck/shit/sod;die/q/quit;dive/swim;exit/out/outside/stand;full/fullscore;full/fullscore score;go/leave/run/walk;hear/listen;help;hint/hints;hints off;hints on;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;long/verbose;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;off;on;places;pray;restart;restore;review;save;score;script;script off;script on;short/superbrie;sing;smell/sniff;sorry;stand/carry/get/hold/take up;think;verify;version;wait/z;wave;xyzzy;y/yes;adjust/set OBJ;attach/fasten/fix/tie OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;carry/get/hold/take OBJ;carry/get/hold/take off OBJ;chase/follow/pursue/trail OBJ;chase/follow/pursue/trail after OBJ;check/describe/examine/watch/x OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;click OBJ;click on OBJ;climb/scale OBJ;climb/scale over OBJ;climb/scale up OBJ;close/cover/shut OBJ;cross/enter/go/leave/run/walk OBJ;damn/fuck/shit/sod OBJ;dig OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;drink/sip/swallow at OBJ;drink/sip/swallow from OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;go/leave/run/walk through OBJ;go/leave/run/walk/carry/get/hold/take into OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;l/look at OBJ;l/look behind OBJ;l/look in OBJ;l/look inside OBJ;l/look into OBJ;l/look through OBJ;l/look under OBJ;lie/sit/go/leave/run/walk inside OBJ;lie/sit/go/leave/run/walk/carry/get/hold/take in OBJ;lie/sit/stand/carry/get/hold/take on OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;put OBJ down;put down OBJ;put on OBJ;read OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;smell/sniff OBJ;squash/squeeze OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;taste OBJ;unfold OBJ;wave OBJ;adjust/set OBJ to OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;burn/light OBJ with OBJ;carry/get/hold/take OBJ off OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;click OBJ on OBJ;dig OBJ with OBJ;discard/drop/throw OBJ against OBJ;discard/drop/throw OBJ at OBJ;discard/drop/throw OBJ down OBJ;discard/drop/throw/insert/put OBJ in OBJ;discard/drop/throw/insert/put OBJ into OBJ;discard/drop/throw/put OBJ on OBJ;discard/drop/throw/put OBJ onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ into OBJ;empty OBJ on OBJ;empty OBJ onto OBJ;empty OBJ to OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;lock OBJ with OBJ;put OBJ inside OBJ;remove/carry/get/hold/take OBJ from OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

omniquest = {
    "name": "omniquest",
    "rom": "omniquest.z5",
    "seed" : 0,
    "walkthrough" : "x tree/e/s/sw/take match/ne/se/take raincoat/open raincoat/put match in raincoat/close raincoat/nw/n/e/e/n/take shovel/s/w/nw/wear snorkel/n/n/n/dig earth/s/push rock/pull torch/turn on lamp/se/ne/se/take sword/n/take parka/e/dig ground/w/s/se/se/open raincoat/give match to man/read scroll/sw/se/put on parka/se/fish/fish/x boot/nw/sw/take rice/make sushi/n/n/nw/w/give sushi to samurai/w/x cage/put crystal in space/take wings/e/e/ne/nw/n/ne/n/play organ/s/sw/w/w/wear wings/fly",
    "grammar" : "actions;actions off;actions on;awake/awaken/wake;awake/awaken/wake up;bait/fish;bother/curses/darn/drat;brief/normal;carry/hold/take inventory;changes;changes off;changes on;daemons/timers;daemons/timers off;daemons/timers on;damn/fuck/shit/sod;diag/diagnose;die/q/quit;dive/swim;exit/out/outside/stand;fly;footnote;full/fullscore;full/fullscore score;geomancer;geomancer is cool/great/awesome;geomancer is great/awesome in bed;get out/off/up;hear/listen;hint/help;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;leave/go/run/walk;long/verbose;make sushi;messages/routines;messages/routines off;messages/routines on;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;play/hop/jump/skip;popcpr/pop/cprpop/cpr;pray;random;recording;recording off;recording on;replay;restart;restore;save;scope;score;script/transcrip;script/transcrip off;script/transcrip on;short/superbrie;showobj;sing;smell/sniff;sorry;stand up;think;trace;trace off;trace on;tree;use rod;use shovel;verify;version;wait/z;wave;what is a grue;who am i;who/what are you;y/yes;yell/scream;adjust/set OBJ;attach/fasten/fix/tie OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;bait OBJ;blow OBJ;bother/curses/darn/drat OBJ;burn OBJ;buy/purchase OBJ;carry/hold/take off OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;cross/enter/go/run/walk OBJ;damn/fuck/shit/sod OBJ;dig OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;ex/read/check/describe/examine/watch/x OBJ;feel/fondle/grope/touch OBJ;fill OBJ;footnote OBJ;geomancer OBJ;get in/into/on/onto OBJ;get off OBJ;get/carry/hold/take OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look under OBJ;leave OBJ;leave/go/run/walk into/in/inside/through OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;lift/open/uncover/undo/unwrap OBJ;light OBJ;make OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;play OBJ;play with OBJ;pull on OBJ;pull/drag OBJ;purloin OBJ;put OBJ down;put down OBJ;put on OBJ;read OBJ;rotate/screw/turn/twist/unscrew OBJ;scope OBJ;search OBJ;showobj OBJ;showverb OBJ;smell/sniff OBJ;squash/squeeze OBJ;stand on OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;talk/speak to OBJ;taste OBJ;trace OBJ;tree OBJ;use OBJ;wave OBJ;what OBJ;you OBJ;abstract OBJ to OBJ;adjust/set OBJ to OBJ;ask OBJ about OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;carry/hold/take OBJ off OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;consult OBJ about OBJ;consult OBJ on OBJ;dig OBJ with OBJ;discard/drop/throw OBJ at/against/on/onto OBJ;discard/drop/throw OBJ in/into/down OBJ;discard/drop/throw/put OBJ on/onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ to/into/on/onto OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;insert OBJ in/into OBJ;l/look up OBJ in OBJ;light/burn OBJ with OBJ;lock OBJ with OBJ;put OBJ in/inside/into OBJ;read OBJ in OBJ;read about OBJ in OBJ;remove/get/carry/hold/take OBJ from OBJ;speak/answer/say/shout OBJ to OBJ;tell OBJ about OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

partyfoul = {
    "name": "partyfoul",
    "rom": "partyfoul.z8",
    "seed" : 0,
    "walkthrough" : "l/give drink to frank/look at frank/look at ron/w/z/take purse/e/n/take jar/put jar in purse/w/l/take knife/put knife in purse/e/l/take peanut butter/s/w/take knife/spread peanut butter on frank/e/n/open door/l/open closet/take hair dryer/plug hair dryer into wall/turn on hair dryer/turn on space heater/drop hair dryer/e/nw/plug toaster into wall/turn on toaster/e/z/z/l/take napkin/s/order drink/take celery/wipe celery with napkin/put celery in purse/n/take peanut butter/w/take knife/put peanut butter on celery/put raisins on celery/give celery to barb/z/z/z",
    "grammar" : "awake/awaken/wake;awake/awaken/wake up;blow my nose;blow nose;blow your nose;bother/curses/darn/drat;carry/hold/take inventory;chuckle/laugh;cringe/swear/pout/sigh;damn/fuck/shit;exit/leave/out/stand;get out/off/up;go/run/walk;hocus pocus;hop/jump/skip;i/inv/inventory;info/about/hints/hint/help;l/look;listen;long/verbose;magic word;magic words;magic/pocus/hocus/abracadab/plough/frotz/plover/sneeze/xyzzy;nap/sleep;no;normal/brief;notify;notify off;notify on;pray;pronouns/nouns;q/quit;remember;restart;restore;save;score;short/superbrie;sing;smell/sniff;sorry;stand up;stomp/yell/scream/answer/say/shout/speak;think;think harder;transcrip/script;transcrip/script off;transcrip/script on;tutorial mode;tutorial mode off;tutorial mode on;tutorial off;tutorial on;verify;version;wait/z;wave;y/yes;yawn;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;burn/light OBJ;buy/purchase OBJ;carry/hold/take off OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;climb/scale OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;converse with OBJ;create/make OBJ;create/make a OBJ;create/make the OBJ;cross/enter/go/run/walk OBJ;discard/drop/throw OBJ;disconnec/unplug OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;dry OBJ;eat OBJ;embrace/hug/kiss OBJ;feel/touch OBJ;flirt with OBJ;get in/into/on/onto OBJ;get off OBJ;get/carry/hold/take OBJ;go/run/walk into/in/inside/through OBJ;hear OBJ;kick/throttle/smother/attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;knock over OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look under OBJ;listen to OBJ;mess up OBJ;mess/tilt/disturb OBJ;open/uncover/unwrap OBJ;order/buy/purchase OBJ;order/buy/purchase a OBJ;pick OBJ up;pick up OBJ;play OBJ;pour/spill OBJ;put OBJ down;put down OBJ;put on OBJ;read/check/describe/examine/watch/x OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;shoving/clear/move/press/push/shift OBJ;sit on OBJ;sit on top of OBJ;sit on/in/inside OBJ;smell/sniff OBJ;squash/squeeze OBJ;stand on OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;talk OBJ;talk to OBJ;taste OBJ;un plug OBJ;wave OBJ;wink at OBJ;adjust/set OBJ to OBJ;aim/point OBJ at OBJ;aim/point OBJ towards OBJ;answer/say/shout/speak OBJ to OBJ;apply OBJ to OBJ;apply/paint/spread/smear OBJ onto OBJ;ask OBJ about OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;carry/hold/take OBJ off OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ with OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe down OBJ with OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe up OBJ with OBJ;connect OBJ to OBJ;connect/plug OBJ into OBJ;consult OBJ on/about OBJ;discard/drop/throw OBJ at/against/on/onto OBJ;discard/drop/throw OBJ in/into/down OBJ;discard/drop/throw/put OBJ on/onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;draw on OBJ with OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;insert OBJ in/into OBJ;l/look up OBJ in OBJ;lock OBJ with OBJ;paint/spread/smear OBJ on OBJ;plug in OBJ OBJ;plug in OBJ into OBJ;plug in OBJ to OBJ;plug/plug OBJ in OBJ;put OBJ in/inside/into OBJ;read OBJ in OBJ;read about OBJ in OBJ;remove/get/carry/hold/take OBJ from OBJ;tell OBJ about OBJ;unlock/open/uncover/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

pentari = {
    "name": "pentari",
    "rom": "pentari.z5",
    "seed" : 0,
    "walkthrough" : "n/n/in/city/e/covert/s/smash seal/n/n/n/in/get scroll/out/s/e/n/get towel/s/w/w/get dagger/n/open towel/fwoosh/get emerald/put emerald in towel/s/e/e/u/get emerald/put emerald on box/l",
    "grammar" : "awake/awaken/wake;awake/awaken/wake up;bother/curses/darn/drat;brief/normal;carry/hold/take inventory;city;covert;damn/fuck/shit/sod;defiant;die/q/quit;dive/swim;exit/out/outside/stand;full/fullscore;full/fullscore score;fwoosh;get out/off/up;hear/listen;help;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;info;l/look;leave/go/run/walk;long/verbose;luminus;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;pray;restart;restore;save;score;script/transcrip;script/transcrip off;script/transcrip on;short/superbrie;sing;smell/sniff;sorry;stand up;think;verify;version;wait/z;wave;y/yes;adjust/set OBJ;attach/fasten/fix/tie OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;carry/hold/take off OBJ;chase/follow/pursue/trail OBJ;chase/follow/pursue/trail after OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;cross/enter/go/run/walk OBJ;damn/fuck/shit/sod OBJ;dig OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;fold OBJ;get in/into/on/onto OBJ;get off OBJ;get/carry/hold/take OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look under OBJ;leave OBJ;leave/go/run/walk into/in/inside/through OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;put OBJ down;put down OBJ;put on OBJ;read/check/describe/examine/watch/x OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;shatter/attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;smell/sniff OBJ;squash/squeeze OBJ;stand on OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;taste OBJ;unfold OBJ;wave OBJ;adjust/set OBJ to OBJ;attach/fasten/fix/tie OBJ to OBJ;burn/light OBJ with OBJ;carry/hold/take OBJ off OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;consult OBJ about OBJ;consult OBJ on OBJ;dig OBJ with OBJ;discard/drop/throw OBJ at/against/on/onto OBJ;discard/drop/throw OBJ in/into/down OBJ;discard/drop/throw/put OBJ on/onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ to/into/on/onto OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;insert OBJ in/into OBJ;l/look up OBJ in OBJ;lock OBJ with OBJ;put OBJ in/inside/into OBJ;read OBJ in OBJ;read about OBJ in OBJ;remove/get/carry/hold/take OBJ from OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

planetfall = {
    "name": "planetfall",
    "rom": "planetfall.z3",
    "seed" : 0,
    # Walkthrough adapted from http://mirror.ifarchive.org/if-archive/solutions/jgunness.zip
    "walkthrough": "WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/W/GET IN WEB/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/GET OUT OF WEB/GET KIT/OPEN DOOR/OUT/U/U/U/U/N/NE/E/E/E/S/S/S/SW/GET BAR/NE/N/N/N/N/HOLD BAR OVER CREVICE/DROP BAR/S/W/W/UNLOCK PADLOCK WITH KEY/REMOVE PADLOCK/DROP IT AND KIT/OPEN DOOR/N/DROP KEY AND BRUSH/GET LADDER/S/E/E/N/N/DROP LADDER/EXTEND LADDER/PUT LADDER ACROSS RIFT/N/W/OPEN DESK/GET KITCHEN CARD AND UPPER CARD/W/OPEN DESK/GET SHUTTLE CARD/E/E/S/S/S/W/W/GET KIT/OPEN IT/EAT RED GOO/DROP KIT/S/GET CANTEEN/SLIDE KITCHEN CARD THROUGH SLOT/S/EXAMINE MACHINE/OPEN CANTEEN/PUT IT IN NICHE/PRESS BUTTON/GET CANTEEN/CLOSE IT/N/DROP KITCHEN CARD/N/E/E/E/PRESS BLUE BUTTON/WAIT/WAIT/N/SLIDE UPPER CARD THROUGH SLOT/PRESS UP BUTTON/WAIT/WAIT/S/NE/SW/N/PRESS DOWN BUTTON/WAIT/WAIT/S/W/S/S/S/SW/GET FLASK/E/PUT FLASK UNDER SPOUT/PRESS GRAY BUTTON/GET FLASK/E/OPEN FLOYD/TURN ON FLOYD/NW/N/N/N/E/N/SLIDE UPPER CARD THROUGH SLOT/PRESS UP BUTTON/WAIT/WAIT/S/NE/POUR FLUID IN HOLE/SW/N/PRESS DOWN BUTTON/WAIT/WAIT/S/W/W/S/LIE DOWN/WAIT/STAND UP/GET ALL/N/W/GET KIT/EAT GREEN GOO/E/E/DROP KIT/S/S/S/S/PUT FLASK UNDER SPOUT/PRESS BLUE BUTTON/GET FLASK/N/N/N/N/E/N/SLIDE UPPER CARD THROUGH SLOT/PRESS UP BUTTON/WAIT/WAIT/S/NE/POUR FLUID IN HOLE/SW/N/PRESS DOWN BUTTON/WAIT/WAIT/S/W/S/S/S/S/PUT FLASK UNDER SPOUT/PRESS brown button/GET FLASK/N/N/N/N/E/N/SLIDE UPPER CARD THROUGH SLOT/PRESS UP BUTTON/WAIT/WAIT/S/NE/POUR FLUID IN HOLE/SW/N/PRESS DOWN BUTTON/WAIT/WAIT/S/W/DROP FLASK/GET KIT/EAT BROWN GOO/DROP KIT/S/E/DROP UPPER CARD/GET BOX/W/S/S/SW/GET PLIERS/NE/N/N/N/E/PRESS RED BUTTON/WAIT/WAIT/WAIT/S/SLIDE LOWER CARD THROUGH SLOT/PRESS DOWN BUTTON/WAIT/WAIT/WAIT/N/E/S/E/SLIDE SHUTTLE CARD THROUGH SLOT/OPEN CANTEEN/DRINK LIQUID/PRESS LEVER/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/PULL LEVER/PULL LEVER/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/W/N/E/E/NE/N/TELL FLOYD TO GO NORTH/TELL FLOYD TO GET SHINY BOARD/S/E/N/OPEN PANEL/REMOVE SECOND BOARD/DROP IT/INSERT SHINY BOARD IN PANEL/S/DROP CANTEEN AND SHUTTLE CARD/W/NW/GET BOTTLE/OPEN IT/DRINK MEDICINE/DROP BOTTLE/SE/E/E/N/OPEN CUBE/REMOVE FUSED BEDISTOR WITH PLIERS/DROP IT AND PLIERS/INSERT GOOD BEDISTOR IN CUBE/S/S/S/E/S/OPEN LAB UNIFORM/GET TELEPORTATION CARD AND BATTERY/N/W/N/E/SLIDE TELEPORTATION CARD THROUGH SLOT/PRESS 2/W/W/S/S/S/SW/REMOVE OLD BATTERY/DROP IT/INSERT NEW BATTERY IN LASER/GET LASER/NE/N/N/N/E/E/SLIDE TELEPORTATION CARD THROUGH SLOT/PRESS 3/W/S/S/N/E/OPEN BIO-LOCK DOOR/SE/E/LOOK THROUGH WINDOW/OPEN DOOR/CLOSE DOOR/WAIT/OPEN DOOR/CLOSE DOOR/DROP BOX/GET MINIATURIZATION CARD/W/OPEN DOOR/W/SW/EXAMINE OUTPUT/S/SLIDE MINIATURIZATION CARD THROUGH SLOT/TYPE 384/E/N/N/TURN DIAL TO 1/LOOK INTO RELAY/BURN SPECK/BURN SPECK/BURN SPECK/BURN SPECK/BURN SPECK/BURN SPECK/BURN SPECK/FIRE LASER/FIRE LASER/S/THROW LASER INTO VOID/S/W/N/OPEN DESK/GET MASK/WEAR IT/PRESS EMERGENCY BUTTON/OPEN DOOR/W/OPEN LAB DOOR/W/W/OPEN DOOR/W/W/W/S/S/PRESS BUTTON/WAIT/WAIT/WAIT/N",
    "grammar" : "affirm/y/yes;again/g;answer/reply;bathe/swim/wade;brief;climb;curse/damn/fuck/krip/megakr/shit/trot/trotti;diagno;dunno/maybe/possib;enter;escape;exit;fly;gaze/l/look/stare;grin/smile;hello/hi;help/hint/hints;hop/skip;i/invent;jump/leap;lay/lie/reclin/sit;leave;negati/no;q/quit;restar;restor;save;say/talk;score;scream/shout/yell;script;sleep;sneeze/zork;stand;super/superb;t/time;unscri;verbos;versio;wait/z;activa OBJ;affirm/y/yes OBJ;aim/gestur/point at OBJ;aim/gestur/point to OBJ;answer/reply OBJ;ask/tell OBJ;attack/dispat/fight/hit/hurt/injure/kill/murder/slay/strike OBJ;awake/startl/surpri/wake OBJ;awake/startl/surpri/wake up OBJ;bathe/swim/wade OBJ;bathe/swim/wade down OBJ;bathe/swim/wade in OBJ;bathe/swim/wade to OBJ;bathe/swim/wade up OBJ;blast/burn/fire/shoot/zap OBJ;blast/burn/fire/shoot/zap at OBJ;board OBJ;brandi/wave OBJ;break/damage/destro/smash OBJ;break/damage/destro/smash down OBJ;brush/clean/mop/polish/scrub/swab OBJ;brush/clean/mop/polish/scrub/swab up OBJ;carry/get/hold/take OBJ;carry/get/hold/take off OBJ;carry/get/hold/take out OBJ;chase/follow/pursue OBJ;chuck/hurl/throw/toss OBJ;climb OBJ;climb in OBJ;climb on OBJ;climb to OBJ;climb up OBJ;climb/go/procee/run/walk down OBJ;climb/go/procee/run/walk with OBJ;close/collap/fold/shorte OBJ;descri/examin/what/whats OBJ;descri/examin/what/whats on OBJ;descri/examin/what/whats/gaze/l/look/stare in OBJ;disemb OBJ;drink/eat/swallo OBJ;drop/releas OBJ;empty OBJ;enter OBJ;exit OBJ;extend/length/open/unfold OBJ;extend/length/open/unfold up OBJ;feel/pat/pet/rub/touch OBJ;find/see/seek/where OBJ;fix/repair OBJ;flush OBJ;fly OBJ;gaze/l/look/stare OBJ;gaze/l/look/stare around OBJ;gaze/l/look/stare at OBJ;gaze/l/look/stare behind OBJ;gaze/l/look/stare down OBJ;gaze/l/look/stare on OBJ;gaze/l/look/stare out OBJ;gaze/l/look/stare under OBJ;gaze/l/look/stare with OBJ;gaze/l/look/stare/rummag/search/sift/sort for OBJ;go/procee/run/walk OBJ;go/procee/run/walk around OBJ;go/procee/run/walk in OBJ;go/procee/run/walk out OBJ;go/procee/run/walk to OBJ;go/procee/run/walk up OBJ;grin/smile at OBJ;hello/hi OBJ;insert/place/put/stuff OBJ;insert/place/put/stuff down OBJ;insert/place/put/stuff on OBJ;jump/leap across OBJ;jump/leap from OBJ;jump/leap in OBJ;jump/leap off OBJ;jump/leap over OBJ;kick OBJ;kiss OBJ;knock/rap at OBJ;knock/rap down OBJ;knock/rap on OBJ;lay/lie/reclin/sit down OBJ;lay/lie/reclin/sit/carry/get/hold/take in OBJ;lay/lie/reclin/sit/carry/get/hold/take on OBJ;leave OBJ;listen to OBJ;lubric/oil OBJ;molest/rape OBJ;move OBJ;move/pull/tug/press/push down OBJ;move/pull/tug/press/push up OBJ;pick up OBJ;play OBJ;play with OBJ;pour/spill OBJ;press/push OBJ;press/push agains OBJ;press/push off OBJ;press/push on OBJ;pull/tug OBJ;pull/tug on OBJ;reach for OBJ;reach in OBJ;read/skim OBJ;remove OBJ;rummag/search/sift/sort OBJ;rummag/search/sift/sort in OBJ;rummag/search/sift/sort with OBJ;salute OBJ;say/talk to OBJ;scold OBJ;scream/shout/yell at OBJ;set/turn OBJ;set/turn off OBJ;set/turn on OBJ;shake OBJ;smell/sniff OBJ;stand on OBJ;stand/carry/get/hold/take up OBJ;step in OBJ;step on OBJ;taste OBJ;type OBJ;type in OBJ;wear OBJ;aim/gestur/point OBJ at OBJ;apply OBJ to OBJ;ask/tell OBJ for OBJ;attack/dispat/fight/hit/hurt/injure/kill/murder/slay OBJ with OBJ;blast/burn/fire/shoot/zap OBJ at OBJ;blast/burn/fire/shoot/zap OBJ with OBJ;brandi/wave OBJ at OBJ;break/damage/destro/smash OBJ with OBJ;brush/clean/mop/polish/scrub/swab OBJ with OBJ;carry/get/hold/take OBJ from OBJ;carry/get/hold/take OBJ off OBJ;carry/get/hold/take OBJ out OBJ;chuck/hurl/throw/toss OBJ at OBJ;chuck/hurl/throw/toss OBJ in OBJ;chuck/hurl/throw/toss OBJ off OBJ;chuck/hurl/throw/toss OBJ on OBJ;chuck/hurl/throw/toss OBJ over OBJ;chuck/hurl/throw/toss OBJ with OBJ;donate/feed/give/hand/offer OBJ OBJ;donate/feed/give/hand/offer OBJ to OBJ;drop/releas OBJ down OBJ;drop/releas OBJ in OBJ;drop/releas OBJ on OBJ;empty OBJ in OBJ;extend/length/open/unfold OBJ with OBJ;feel/pat/pet/rub/touch OBJ to OBJ;insert/place/put/stuff OBJ on OBJ;insert/place/put/stuff/slide/swing/go/procee/run/walk OBJ with OBJ;lay/lie/reclin/sit/insert/place/put/stuff OBJ in OBJ;lay/lie/reclin/sit/insert/place/put/stuff OBJ under OBJ;lay/lie/reclin/sit/insert/place/put/stuff/carry/get/hold/take/brandi/wave OBJ near OBJ;lay/lie/reclin/sit/insert/place/put/stuff/carry/get/hold/take/brandi/wave OBJ over OBJ;lay/lie/reclin/sit/insert/place/put/stuff/slide/swing OBJ across OBJ;lock OBJ with OBJ;lubric/oil OBJ with OBJ;pick up OBJ with OBJ;play OBJ with OBJ;pour/spill OBJ in OBJ;pour/spill OBJ on OBJ;pour/spill OBJ out OBJ;pour/spill OBJ over OBJ;press/push/slide/swing OBJ under OBJ;pull/tug/feel/pat/pet/rub/touch/carry/get/hold/take/remove/attrac OBJ with OBJ;remove OBJ from OBJ;set/turn OBJ to OBJ;set/turn OBJ with OBJ;shake OBJ with OBJ;show OBJ to OBJ;strike OBJ with OBJ;unlock OBJ with OBJ;",
    "max_word_length" : 6
}

plundered = {
    "name": "plundered",
    "rom": "plundered.z3",
    "seed" : 0,
    # Walkthrough adapted from http://mirror.ifarchive.org/if-archive/solutions/jgunness.zip
    "walkthrough": "Z/STAND UP/Z/Z/GET COFFER/Z/HIT CRULLEY WITH COFFER/Z/Z/READ MISSIVE/YES/Z/Z/STAND UP/Z/Z/Z/N/OPEN CUPBOARD/IN/GET CLOTHES/REMOVE FROCK/TEAR IT/WEAR BREECHES/WEAR SHIRT/OUT/Z/D/N/N/GET BOTTLE/S/S/OPEN COFFER/GET INVITATION/U/S/SMASH WINDOW WITH COFFER/S/CLIMB ROPE/U/U/U/U/N/N/EXAMINE BARRELS/DIP RAG IN WATER/OPEN HATCH/D/THROW RAG AT FIRE/U/N/EXAMINE WINCH/RAISE LEVER/IN/GET DAGGER/OUT/S/S/SIT IN CASK/CUT LINE WITH DAGGER/CUT LINE WITH DAGGER/GET PORK/Z/Z/GET OUT OF CASK/W/N/W/N/E/Z/GET GARTER/W/S/NE/U/REMOVE CLOTHES/GET GOWN/WEAR IT/N/E/D/SHOW INVITATION TO BUTLER/S/Z/Z/Z/Z/E/N/N/EXAMINE BOOKCASE/GET TREATISE/GET HAT/PRESS ISLAND/N/D/E/E/GET KEY/GET HORN/W/W/S/EXAMINE BOTTLE/READ LABEL/PUT LAUDANUM ON PORK/GIVE PORK TO CROCODILE/Z/Z/S/W/UNLOCK DOOR WITH KEY/OPEN IT/N/GIVE GARTER TO PAPA/S/E/N/N/U/S/S/W/S/Z/Z/Z/N/Z/Z/Z/N/U/E/OPEN DOOR/N/DRINK WINE/POUR WINE IN GREEN GOBLET/POUR WINE IN BLUE GOBLET/PUT LAUDANUM IN BLUE GOBLET/GET SPICES/BLOW SPICES AT LAFOND/GET TRAY/WAVE IT IN MOONLIGHT/S/GIVE BLUE GOBLET TO BUTLER/Z/Z/Z/Z/S/W/D/E/N/Open portrait/N/D/S/S/GET RAPIER/ATTACK CRULLEY/AGAIN/WAKE FALCON WITH SALTS/UNLOCK CHAIN WITH BROOCH/N/N/U/S/S/W/U/E/S/UNTIE ROPE/CLIMB DOWN ROPE/GET ALL/S/S/S/Z/Z/YES/GET PISTOL/LOAD IT/SHOOT CRULLEY",
    "grammar" : "aaieee/scream/shout/shriek/yell;applau/clap;brief;cry/gasp/sob/weep;debark/disemb;depart/exit/withdr;disrob/strip/undres;dive/jump/leap/vault;doze/nap/sleep/snooze;dress;duck/go/wade;enter;greet/hello/hi;help/hint/warn;hide;i/invent;l/look/watch;laugh/smile;leave;listen;moan/sigh;nay/never/no/nope;nod/ok/okay/sure/y/yes/yup;procee/run/sidle/step/walk;q/quit;rescue/save;restar;restor;rise/stand;score;script;smell/sniff/whiff;super/superb;swim;thank/thanks;unscri;verbos;versio;wait/z;aaieee/scream/shout/shriek/yell at OBJ;aaieee/scream/shout/shriek/yell to OBJ;aim/point/shine/signal OBJ;applau/clap OBJ;approa OBJ;ask for OBJ;attack/bash/fight/hit/kill/murder/punch/slap/strike/whack OBJ;awake/revive/rouse/wake OBJ;awake/revive/rouse/wake up OBJ;bind/fetter/hobble/manacl/shackl OBJ;bite OBJ;blow OBJ;blow/dip/hang/insert/lay/place/put/sprink/stick out OBJ;board/mount/ride OBJ;boost/lift/raise OBJ;bounce/shake OBJ;bow/curtse/curtsy to OBJ;break/crush/damage/demoli/destro/smash/trampl/wreck OBJ;break/crush/damage/demoli/destro/smash/trampl/wreck down OBJ;break/crush/damage/demoli/destro/smash/trampl/wreck out OBJ;bribe OBJ;browse/read/skim OBJ;browse/read/skim throug OBJ;burn/melt OBJ;burn/melt up OBJ;carry/get/grab/hold/take OBJ;carry/get/grab/hold/take down OBJ;carry/get/grab/hold/take dresse OBJ;carry/get/grab/hold/take drunk OBJ;carry/get/grab/hold/take off OBJ;carry/get/grab/hold/take on OBJ;carry/get/grab/hold/take out OBJ;carry/get/grab/hold/take undres OBJ;chase/follow/pursue OBJ;circle OBJ;clean/wash/wipe OBJ;clean/wash/wipe off OBJ;clean/wash/wipe up OBJ;climb/crawl/scale OBJ;climb/crawl/scale off OBJ;climb/crawl/scale on OBJ;climb/crawl/scale out OBJ;climb/crawl/scale over OBJ;climb/crawl/scale up OBJ;climb/crawl/scale/carry/get/grab/hold/take in OBJ;climb/crawl/scale/duck/go/wade under OBJ;climb/crawl/scale/duck/go/wade/dive/jump/leap/vault/procee/run/sidle/step/walk throug OBJ;climb/crawl/scale/slide down OBJ;close/shut OBJ;close/shut off OBJ;close/shut up OBJ;cut/slice/stab OBJ;dance/piroue/twirl OBJ;dance/piroue/twirl with OBJ;deacti/douse/exting OBJ;debark/disemb OBJ;depart/exit/withdr OBJ;descen OBJ;descri/examin/inspec/observ/study/x OBJ;devour/eat/nibble/taste OBJ;dig in OBJ;dig throug OBJ;dip/hang/insert/lay/place/put/sprink/stick down OBJ;dip/hang/insert/lay/place/put/sprink/stick on OBJ;disrob/strip/undres OBJ;dive/jump/leap/vault down OBJ;dive/jump/leap/vault off OBJ;dive/jump/leap/vault out OBJ;dive/jump/leap/vault over OBJ;dive/jump/leap/vault overbo OBJ;dive/jump/leap/vault to OBJ;dive/jump/leap/vault up OBJ;dive/jump/leap/vault/dive/jump/leap/vault across OBJ;don/wear OBJ;doze/nap/sleep/snooze in OBJ;doze/nap/sleep/snooze on OBJ;dress OBJ;drink/quaff/sip/swallo OBJ;drink/quaff/sip/swallo from OBJ;drop/dump OBJ;dry/squeez/wring OBJ;duck/go/wade OBJ;duck/go/wade/come with OBJ;duck/go/wade/dive/jump/leap/vault/procee/run/sidle/step/walk in OBJ;duck/go/wade/hide/rise/stand/procee/run/sidle/step/walk behind OBJ;duck/go/wade/move/pull/procee/run/sidle/step/walk around OBJ;duck/go/wade/procee/run/sidle/step/walk away OBJ;duck/go/wade/procee/run/sidle/step/walk down OBJ;duck/go/wade/procee/run/sidle/step/walk to OBJ;duck/go/wade/procee/run/sidle/step/walk up OBJ;embrac/hug OBJ;empty OBJ;empty out OBJ;enter OBJ;faint/swoon OBJ;feed OBJ;feel/grip/rub/smooth/touch throug OBJ;fiddle/joggle/wiggle with OBJ;fill/load OBJ;find/locate/seek OBJ;fire/shoot/sling OBJ;fire/shoot/sling at OBJ;fix/repair/sharpe/whet OBJ;flick/flip/rotate/set/spin/switch/turn OBJ;flick/flip/rotate/set/spin/switch/turn around OBJ;flick/flip/rotate/set/spin/switch/turn off OBJ;flick/flip/rotate/set/spin/switch/turn on OBJ;free/loosen/unatta/unknot/untie/unweav OBJ;greet/hello/hi OBJ;hear OBJ;help/hint/warn OBJ;hide under OBJ;hurl/throw/toss OBJ;hurl/throw/toss away OBJ;hurl/throw/toss overbo OBJ;i/invent love OBJ;kick OBJ;kiss OBJ;knock/pound/rap at OBJ;knock/pound/rap down OBJ;knock/pound/rap on OBJ;knock/pound/rap over OBJ;l/look/watch OBJ;l/look/watch around OBJ;l/look/watch at OBJ;l/look/watch behind OBJ;l/look/watch down OBJ;l/look/watch in OBJ;l/look/watch on OBJ;l/look/watch out OBJ;l/look/watch over OBJ;l/look/watch throug OBJ;l/look/watch to OBJ;l/look/watch up OBJ;l/look/watch/rummag/search for OBJ;l/look/watch/rummag/search under OBJ;laugh/smile at OBJ;launch OBJ;lean agains OBJ;leave OBJ;let go OBJ;lie down OBJ;lie in OBJ;lie on OBJ;light OBJ;listen to OBJ;lock OBJ;lower OBJ;make love OBJ;make out OBJ;marry/wed OBJ;move/pull OBJ;move/pull down OBJ;move/pull in OBJ;move/pull up OBJ;oar/row OBJ;oar/row to OBJ;open OBJ;open up OBJ;pick OBJ;pick up OBJ;play with OBJ;pour/spill OBJ;press/push OBJ;press/push down OBJ;press/push on OBJ;press/push/boost/lift/raise up OBJ;procee/run/sidle/step/walk OBJ;procee/run/sidle/step/walk across OBJ;procee/run/sidle/step/walk out OBJ;procee/run/sidle/step/walk over OBJ;rape OBJ;reach in OBJ;remove OBJ;rescue/save OBJ;return OBJ;rip/tear OBJ;rip/tear up OBJ;rise/stand in OBJ;rise/stand on OBJ;rise/stand/carry/get/grab/hold/take up OBJ;roll/tip OBJ;rummag/search OBJ;rummag/search in OBJ;rummag/search throug OBJ;sink OBJ;sit down OBJ;sit in OBJ;sit on OBJ;smell/sniff/whiff OBJ;soak/wet OBJ;speak/talk to OBJ;stop OBJ;swim in OBJ;swing OBJ;swing down OBJ;swing from OBJ;swing on OBJ;tap on OBJ;tap/feel/grip/rub/smooth/touch OBJ;tell OBJ;thank/thanks OBJ;unbar/unlock OBJ;unroll OBJ;use OBJ;wave OBJ;wave at OBJ;what/what'/whats/who/whos OBJ;where/wheres/whithe OBJ;zzmgck OBJ;aim/point/shine/signal OBJ at OBJ;aim/point/shine/signal OBJ from OBJ;aim/point/shine/signal OBJ in OBJ;aim/point/shine/signal OBJ on OBJ;aim/point/shine/signal OBJ out OBJ;aim/point/shine/signal OBJ with OBJ;ask OBJ about OBJ;ask OBJ for OBJ;ask OBJ to OBJ;attach/fasten/moor/secure/tie/weave OBJ around OBJ;attach/fasten/moor/secure/tie/weave OBJ to OBJ;attach/fasten/moor/secure/tie/weave OBJ with OBJ;attach/fasten/moor/secure/tie/weave up OBJ with OBJ;attack/bash/fight/hit/kill/murder/punch/slap/strike/whack OBJ with OBJ;awake/revive/rouse/wake OBJ with OBJ;blow OBJ at OBJ;blow OBJ on OBJ;bounce/shake OBJ with OBJ;break/crush/damage/demoli/destro/smash/trampl/wreck OBJ with OBJ;bribe OBJ with OBJ;browse/read/skim OBJ throug OBJ;browse/read/skim OBJ with OBJ;burn/melt OBJ in OBJ;carry/get/grab/hold/take OBJ from OBJ;carry/get/grab/hold/take OBJ in OBJ;carry/get/grab/hold/take OBJ off OBJ;carry/get/grab/hold/take OBJ on OBJ;carry/get/grab/hold/take OBJ out OBJ;carry/get/grab/hold/take OBJ with OBJ;close/shut OBJ on OBJ;cover OBJ with OBJ;cut/slice/stab OBJ with OBJ;cut/slice/stab throug OBJ with OBJ;dip/hang/insert/lay/place/put/sprink/stick OBJ around OBJ;dip/hang/insert/lay/place/put/sprink/stick OBJ behind OBJ;dip/hang/insert/lay/place/put/sprink/stick OBJ over OBJ;dip/hang/insert/lay/place/put/sprink/stick OBJ throug OBJ;drink/quaff/sip/swallo OBJ from OBJ;drop/dump OBJ down OBJ;drop/dump OBJ in OBJ;drop/dump OBJ throug OBJ;drop/dump/dip/hang/insert/lay/place/put/sprink/stick OBJ out OBJ;dry/squeez/wring OBJ from OBJ;dry/squeez/wring OBJ in OBJ;dry/squeez/wring OBJ on OBJ;dry/squeez/wring OBJ out OBJ;empty OBJ from OBJ;empty OBJ in OBJ;empty OBJ on OBJ;feed OBJ OBJ;feed OBJ with OBJ;feel/grip/rub/smooth/touch OBJ on OBJ;feel/grip/rub/smooth/touch OBJ with OBJ;fill/load OBJ in OBJ;fill/load OBJ with OBJ;find/locate/seek OBJ on OBJ;fire/shoot/sling OBJ at OBJ;fire/shoot/sling OBJ in OBJ;fire/shoot/sling OBJ with OBJ;flick/flip/rotate/set/spin/switch/turn OBJ to OBJ;give/hand/offer/presen OBJ OBJ;give/hand/offer/presen OBJ with OBJ;give/hand/offer/presen/pay/feed/pass OBJ to OBJ;hurl/throw/toss OBJ OBJ;hurl/throw/toss OBJ at OBJ;hurl/throw/toss OBJ down OBJ;hurl/throw/toss OBJ in OBJ;hurl/throw/toss OBJ on OBJ;hurl/throw/toss OBJ out OBJ;hurl/throw/toss OBJ over OBJ;hurl/throw/toss OBJ throug OBJ;hurl/throw/toss OBJ to OBJ;hurl/throw/toss OBJ with OBJ;leave/dip/hang/insert/lay/place/put/sprink/stick OBJ in OBJ;leave/drop/dump/dip/hang/insert/lay/place/put/sprink/stick OBJ on OBJ;light OBJ in OBJ;light OBJ on OBJ;light OBJ with OBJ;lock OBJ with OBJ;lower OBJ out OBJ;lower OBJ throug OBJ;move/pull OBJ to OBJ;muzzle OBJ with OBJ;oar/row OBJ OBJ;oar/row OBJ to OBJ;open OBJ with OBJ;pick OBJ with OBJ;pour/spill OBJ from OBJ;pour/spill OBJ in OBJ;pour/spill OBJ on OBJ;pour/spill OBJ out OBJ;press/push OBJ in OBJ;press/push OBJ on OBJ;press/push/dip/hang/insert/lay/place/put/sprink/stick OBJ under OBJ;press/push/move/pull OBJ OBJ;press/push/move/pull OBJ down OBJ;press/push/move/pull OBJ up OBJ;reflec OBJ in OBJ;remove OBJ from OBJ;return OBJ to OBJ;rip/tear OBJ in OBJ;rip/tear OBJ with OBJ;roll/tip/press/push OBJ to OBJ;show OBJ OBJ;show OBJ to OBJ;soak/wet OBJ in OBJ;soak/wet OBJ with OBJ;swing OBJ at OBJ;tell OBJ OBJ;tell OBJ about OBJ;unbar/unlock OBJ with OBJ;use OBJ on OBJ;wave OBJ at OBJ;wave OBJ in OBJ;wrap OBJ around OBJ;wrap OBJ in OBJ;",
    "max_word_length" : 6
}

reverb = {
    "name": "reverb",
    "rom": "reverb.z5",
    "seed" : 0,
    "walkthrough" : "x counter/read note/get pizza box/sw/x note/s/w/s/x district attorney/z/open pizza box/search pizza/show file to district attorney/n/w/w/n/e/w/s/e/open window/unlock cabinet with key/open cabinet/get file/jump out window/kick second window/z/z/jill, hold me/jump/w/n/e/e/e/n/get pizza box/open pizza box/get bomb/s/put bomb in sewer/e/s/se/get spray/spray thug/kick thug/nw/n/z/z/s/sw/take hammer/take rope/ne/n/w/w/w/close pizza box/show box to guard/w/n/s/n/tie rope to rod/hold rope/jump/break glass with hammer/take axe/z/hit floor with axe",
    "grammar" : "awake/awaken/wake;awake/awaken/wake up;bother/curses/darn/drat;breast/penis;brief/normal;bro/bud/dude/duder;carry/catch/hold/take inventory;die/q/quit;dive/swim;exit/out/outside/stand;fuck/damn/shit/sod;full/fullscore;full/fullscore score;get out/off/up;hear/listen;help;hint;hop/jump/skip;hop/jump/skip off;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;lame/suck;leave/go/run/walk;let go;long/verbose;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;plugh/xyzzy;pray;restart;restore;rule;save;score;script;script off;script on;short/superbrie;sing;smell/sniff;sorry;stand up;swing;think;verify;version;wait/z;wave;y/yes;adjust/set OBJ;attach/fasten/fix/tie OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;carry/catch/hold/take off OBJ;cast/discard/drop/fling/heave/hurl/launch/lob/pitch/propel/toss OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;cross/enter/go/run/walk OBJ;damn/shit/sod OBJ;detach/disconnec/untie OBJ;dig OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;fuck OBJ;get in/into/on/onto OBJ;get off OBJ;get/carry/catch/hold/take OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip in OBJ;hop/jump/skip into OBJ;hop/jump/skip off OBJ;hop/jump/skip off of OBJ;hop/jump/skip out OBJ;hop/jump/skip out of OBJ;hop/jump/skip over OBJ;hop/jump/skip through OBJ;kick/attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;knock OBJ;knock on OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look under OBJ;leave OBJ;leave/go/run/walk into/in/inside/through OBJ;let go of OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;open/uncover/undo/unwrap OBJ;pay for OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;put OBJ down;put down OBJ;put on OBJ;read/check/describe/examine/watch/x OBJ;release OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;shake OBJ;smell/sniff OBJ;spray OBJ;squash/squeeze OBJ;stand on OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;taste OBJ;throw OBJ;wave OBJ;adjust/set OBJ to OBJ;answer/say/shout/speak OBJ to OBJ;ask OBJ about OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ with OBJ;burn/light OBJ with OBJ;carry/catch/hold/take OBJ off OBJ;cast/discard/drop/fling/heave/hurl/launch/lob/pitch/propel/toss OBJ at/against/on/onto OBJ;cast/discard/drop/fling/heave/hurl/launch/lob/pitch/propel/toss OBJ in/into/down OBJ;cast/discard/drop/fling/heave/hurl/launch/lob/pitch/propel/toss/put OBJ on/onto OBJ;chop/cut/prune/slice OBJ with OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;consult OBJ about OBJ;consult OBJ on OBJ;dig OBJ with OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ to/into/on/onto OBJ;feed/give/offer OBJ OBJ;feed/give/offer OBJ to OBJ;feed/give/offer over OBJ to OBJ;insert OBJ in/into OBJ;l/look up OBJ in OBJ;lock OBJ with OBJ;pay OBJ OBJ;pay OBJ to OBJ;pay over OBJ to OBJ;put OBJ in/inside/into OBJ;read OBJ in OBJ;read about OBJ in OBJ;remove/get/carry/catch/hold/take OBJ from OBJ;spray OBJ at OBJ;spray OBJ with OBJ;tell OBJ about OBJ;throw OBJ OBJ;throw OBJ against OBJ;throw OBJ at OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

seastalker = {
    "name": "seastalker",
    "rom": "seastalker.z3",
    "seed" : 0,
    "walkthrough" : "turn on videophone/adjust videophone/get microphone/turn on microphone/ask bly about problem/ask bly about monster/z/no/drop microphone/n/turn on computestor/ask computestor about videophone/e/open door/e/x electric panel/close circuit breaker/e/ask kemp about circuit breaker/w/w/s/s/w/take capsule/n/s/push test button/read sign/ask tip for tool/open access panel/enter access panel/fix voltage regulator/exit/close access panel/close hatch/insert capsule into reactor/close reactor/turn reactor on/fill tank/open gate/start engines/open throttle/push joystick east/x sonar/d/e/e/e/e/x sonar/e/e/e/e/x sonar/ne/ne/ne/ne/x sonar/ne/ne/ne/ne/x sonar/n/n/n/n/x sonar/ne/ne/ne/ne/x sonar/ne/ne/ne/ne/x sonar/nw/nw/n/n/turn on autopilot/set throttle to fast/z/yes/z/yes/dock/z/open hatch/exit scimitar/n/n/n/open air supply system with tool/get relay/screw relay into space/se/s/get bazooka/n/e/z/yes/ask about evidence/open box with tool/look in box/w/get wrench/open office door/z/yes/yes/yes/yes/yes/yes/yes/give magazine to doc/yes/yes/z/no/put dart on claw/s/put bazooka on claw/yes/no/ask tip about grid/yes/yes/yes/yes/z/no/e/n/n/n/n/n/n/n/se/s/s/s/s/z/no/d/take syringe/exit/n/n/w/n/w/ask doc about syringe/z/no/e/se/s/s/s/arrest bill/turn off electricity/turn on electricity/w/w/s/s/amy, leave/close roof/s/close hatch/fill tank/turn on engine/open throttle/s/e/se/z/z/yes/no/yes/no/no/yes/stop/nw/open throttle/e/e/z/aim bazooka at pod/shoot pod with bazooka/yes",
    "grammar" : "10-/affirm/aye/ok/okay/okeh/okey/roger/sure/wilco/y/yeah/yes/yup;abando/debark/disemb/evacua/exit/leave;answer/reply/respon;bathe/swim/wade;brief;bye/good-/goodby;curse/damn/fuck/fudge/pee/piss/poo/shit/snot;diagno;dive/submer;editio/releas/revisi/versio;enter;explai/say/speak/state/talk;fast;gaze/l/look/peek/see/stare;greet/greeti/hello/hi;help;i/invent;lean/prop/stand;medium;nay/negati/no/nope;pause/save/suspen;q/quit;restar;restor/resume;rise;score;scream/shout/yell;script;slow;super/superb;surfac;thank/thanks;unscri;verbos;abando/debark/disemb/evacua/exit/leave OBJ;abando/debark/disemb/evacua/exit/leave from OBJ;activa/engage/start OBJ;activa/engage/start over OBJ;adjust/focus/tune OBJ;adjust/focus/tune in OBJ;analys/analyz/check/test/troubl OBJ;analys/analyz/check/test/troubl out OBJ;answer/reply/respon OBJ;arm OBJ;arrest/captur OBJ;ask/consul/inquir/questi OBJ;ask/consul/inquir/questi about OBJ;ask/consul/inquir/questi for OBJ;assaul/attack/fight/molest/rape/repel OBJ;assaul/attack/fight/molest/rape/repel off OBJ;awake/startl/surpri/wake OBJ;awake/startl/surpri/wake up OBJ;bathe/swim/wade in OBJ;bite/hit/hurt/injure/kick/punch/slap OBJ;blast/fire/shoot OBJ;blow/drain/empty OBJ;board/climb OBJ;board/climb throug OBJ;board/climb/carry/get/grab/hold/lead/remove/seize/steal/take in OBJ;board/climb/carry/get/grab/hold/lead/remove/seize/steal/take on OBJ;board/climb/drive/go/head/procee/run/steer/walk down OBJ;board/climb/drive/go/head/procee/run/steer/walk up OBJ;break/crush/damage/destro/smash OBJ;bring/fetch OBJ;brush/clean/wipe OBJ;bye/good-/goodby OBJ;call/phone/signal/summon OBJ;call/phone/signal/summon for OBJ;call/phone/signal/summon to OBJ;call/phone/signal/summon up OBJ;carry/get/grab/hold/lead/remove/seize/steal/take OBJ;carry/get/grab/hold/lead/remove/seize/steal/take off OBJ;carry/get/grab/hold/lead/remove/seize/steal/take out OBJ;carry/get/grab/hold/lead/remove/seize/steal/take rid OBJ;chase/follow/pursue/trace OBJ;chuck/hurl/throw/toss away OBJ;close/replac/reset OBJ;come OBJ;come to OBJ;come/drive/go/head/procee/run/steer/walk with OBJ;compar/match OBJ;consum/eat OBJ;crouch/hide on OBJ;crouch/hide/drive/go/head/procee/run/steer/walk/crawl in OBJ;curse/damn/fuck/fudge/pee/piss/poo/shit/snot OBJ;curse/damn/fuck/fudge/pee/piss/poo/shit/snot on OBJ;cut/interr OBJ;descri/examin/inspec/scruti/study/x OBJ;detect/find/locate OBJ;detect/find/locate out OBJ;diagno OBJ;dig/search OBJ;dig/search in OBJ;dig/search up OBJ;discus OBJ;dive/submer OBJ;dive/submer by OBJ;dive/submer under OBJ;dive/submer/rise to OBJ;dock OBJ;douse/exting OBJ;drink/imbibe/swallo OBJ;drive/go/head/procee/run/steer/walk/crawl OBJ;drive/go/head/procee/run/steer/walk/crawl around OBJ;drive/go/head/procee/run/steer/walk/crawl out OBJ;drive/go/head/procee/run/steer/walk/crawl throug OBJ;drive/go/head/procee/run/steer/walk/crawl to OBJ;drive/go/head/procee/run/steer/walk/crawl under OBJ;drop/lower OBJ;editio/releas/revisi/versio OBJ;enter OBJ;explai/say/speak/state/talk OBJ;explai/say/speak/state/talk with OBJ;explai/say/speak/state/talk/scream/shout/yell in OBJ;explai/say/speak/state/talk/scream/shout/yell to OBJ;explai/say/speak/state/talk/tell about OBJ;feel/pat/pet/rub/shade/touch OBJ;fill/flood OBJ;fix/repair OBJ;flip/shut/swing/switch/turn OBJ;flip/shut/swing/switch/turn down OBJ;flip/shut/swing/switch/turn in OBJ;flip/shut/swing/switch/turn off OBJ;flip/shut/swing/switch/turn on OBJ;flip/shut/swing/switch/turn to OBJ;flip/shut/swing/switch/turn up OBJ;free/unatta/uncuff/unfast/unhook/untie OBJ;gaze/l/look/peek/see/stare around OBJ;gaze/l/look/peek/see/stare at OBJ;gaze/l/look/peek/see/stare behind OBJ;gaze/l/look/peek/see/stare down OBJ;gaze/l/look/peek/see/stare in OBJ;gaze/l/look/peek/see/stare on OBJ;gaze/l/look/peek/see/stare out OBJ;gaze/l/look/peek/see/stare over OBJ;gaze/l/look/peek/see/stare throug OBJ;gaze/l/look/peek/see/stare under OBJ;gaze/l/look/peek/see/stare up OBJ;gaze/l/look/peek/see/stare/dig/search for OBJ;greet/greeti/hello/hi OBJ;hang up OBJ;help/pause/save/suspen OBJ;identi/name OBJ;insert/instal/load/mount/place/put/stuff down OBJ;insert/instal/load/mount/place/put/stuff on OBJ;kill/strang OBJ;kiss OBJ;knock/rap at OBJ;knock/rap down OBJ;knock/rap on OBJ;launch OBJ;lean/prop/stand/carry/get/grab/hold/lead/remove/seize/steal/take up OBJ;level off OBJ;level out OBJ;lift/raise OBJ;lift/raise up OBJ;light OBJ;listen at OBJ;listen to OBJ;lock OBJ;medita/relax/rest/stay/wait/z OBJ;medita/relax/rest/stay/wait/z for OBJ;medita/relax/rest/stay/wait/z till OBJ;medita/relax/rest/stay/wait/z until OBJ;move/pull/tug OBJ;nod at OBJ;nod to OBJ;open OBJ;open up OBJ;peal/ring OBJ;peruse/read/skim OBJ;pick OBJ;pick up OBJ;play OBJ;play with OBJ;press/push OBJ;press/push on OBJ;pull/tug on OBJ;pump out OBJ;revive OBJ;rise OBJ;rise by OBJ;scream/shout/yell for OBJ;screw in OBJ;send OBJ;send out OBJ;sit down OBJ;sit in OBJ;sit on OBJ;smell/sniff OBJ;smoke OBJ;stop OBJ;strike OBJ;surfac OBJ;tell OBJ;thank/thanks OBJ;unlock OBJ;use OBJ;aim/point OBJ OBJ;aim/point OBJ at OBJ;aim/point OBJ to OBJ;aim/point at OBJ with OBJ;analys/analyz/check/test/troubl OBJ for OBJ;analys/analyz/check/test/troubl OBJ in OBJ;analys/analyz/check/test/troubl OBJ on OBJ;apply/fit OBJ to OBJ;arrest/captur OBJ for OBJ;ask/consul/inquir/questi OBJ about OBJ;ask/consul/inquir/questi OBJ for OBJ;assaul/attack/fight/molest/rape/repel OBJ with OBJ;attach/fasten/secure/tie OBJ to OBJ;attach/fasten/secure/tie OBJ with OBJ;attach/fasten/secure/tie up OBJ to OBJ;attach/fasten/secure/tie up OBJ with OBJ;bite/hit/hurt/injure/kick/punch/slap OBJ with OBJ;blast/fire/shoot OBJ at OBJ;blast/fire/shoot OBJ with OBJ;break/crush/damage/destro/smash OBJ with OBJ;break/crush/damage/destro/smash down OBJ with OBJ;bring/fetch OBJ OBJ;bring/fetch OBJ to OBJ;brush/clean/wipe OBJ with OBJ;build/make/prepar OBJ OBJ;build/make/prepar OBJ from OBJ;call/phone/signal/summon OBJ by OBJ;call/phone/signal/summon OBJ on OBJ;carry/get/grab/hold/lead/remove/seize/steal/take OBJ from OBJ;carry/get/grab/hold/lead/remove/seize/steal/take OBJ out OBJ;carry/get/grab/hold/lead/remove/seize/steal/take OBJ to OBJ;carry/get/grab/hold/lead/remove/seize/steal/take OBJ with OBJ;chase/follow/pursue/trace OBJ OBJ;chase/follow/pursue/trace OBJ to OBJ;chuck/hurl/throw/toss OBJ at OBJ;chuck/hurl/throw/toss OBJ on OBJ;chuck/hurl/throw/toss OBJ over OBJ;chuck/hurl/throw/toss OBJ throug OBJ;close/replac/reset OBJ with OBJ;come with OBJ to OBJ;compar/match OBJ to OBJ;compar/match OBJ with OBJ;confro OBJ with OBJ;crouch/hide/chuck/hurl/throw/toss OBJ in OBJ;crouch/hide/insert/instal/load/mount/place/put/stuff OBJ under OBJ;detect/find/locate OBJ with OBJ;dig/search OBJ for OBJ;discus OBJ with OBJ;donate/feed/give/hand/offer OBJ OBJ;donate/feed/give/hand/offer OBJ to OBJ;drive/go/head/procee/run/steer/walk OBJ over OBJ;drop/lower OBJ down OBJ;drop/lower OBJ in OBJ;drop/lower/fit/hang/insert/instal/load/mount/place/put/stuff OBJ on OBJ;explai/say/speak/state/talk to OBJ about OBJ;feel/pat/pet/rub/shade/touch OBJ on OBJ;feel/pat/pet/rub/shade/touch OBJ over OBJ;feel/pat/pet/rub/shade/touch OBJ with OBJ;fix/repair OBJ with OBJ;flip/shut/swing/switch/turn OBJ on OBJ;flip/shut/swing/switch/turn OBJ to OBJ;flip/shut/swing/switch/turn off OBJ with OBJ;flip/shut/swing/switch/turn on OBJ with OBJ;free/unatta/uncuff/unfast/unhook/untie OBJ from OBJ;gaze/l/look/peek/see/stare at OBJ throug OBJ;gaze/l/look/peek/see/stare up OBJ in OBJ;insert/instal/load/mount/place/put/stuff OBJ agains OBJ;insert/instal/load/mount/place/put/stuff OBJ in OBJ;kill/strang OBJ with OBJ;lean/prop/stand OBJ agains OBJ;lean/prop/stand OBJ on OBJ;lean/prop/stand OBJ up OBJ;move/open/set OBJ to OBJ;move/pull/tug OBJ OBJ;open OBJ with OBJ;peal/ring OBJ with OBJ;peruse/read/skim OBJ OBJ;peruse/read/skim OBJ throug OBJ;peruse/read/skim about OBJ in OBJ;pick OBJ with OBJ;press/push OBJ OBJ;press/push OBJ on OBJ;press/push OBJ to OBJ;press/push OBJ under OBJ;screw OBJ in OBJ;send OBJ OBJ;send OBJ to OBJ;set OBJ OBJ;set OBJ at OBJ;set OBJ for OBJ;set OBJ on OBJ;show OBJ OBJ;show OBJ to OBJ;strike OBJ with OBJ;tell OBJ OBJ;tell OBJ about OBJ;unlock OBJ with OBJ;use OBJ agains OBJ;",
    "max_word_length" : 6
}

sherbet = {
    "name": "sherbet",
    "rom": "sherbet.z5",
    "seed" : 0,
    "grammar" : "answer/say/shout/speak;awake/awaken/wake;awake/awaken/wake up;bark/howl/woof;bother/curses/darn/drat;brief/normal;c,cast;carry/get/hold/take inventory;carry/get/hold/take out/off/up;chirrup;close/cover/shut up;coo;damn/fuck/shit/sod;die/q/quit;dive/swim;exit/out/outside/stand;full/fullscore;full/fullscore score;hear/listen;help/hint/hints;hop/jump/skip;hop/jump/skip across;hop/jump/skip over;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;leave/go/run/walk;long/verbose;memory/spells;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;pray;restart;restore;save;score;script;script off;script on;shake/wave;short/superbrie;sing;smell/sniff;sorry;stand up;think;verify;version;wait/z;y/yes;adjust/set OBJ;answer/say/shout/speak OBJ;attach/fasten/fix/tie OBJ;attack/break/crack/destroy/drum/fight/hit/kick/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;bark/howl/woof OBJ;bite/chew OBJ;blow OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;c,cast OBJ;carry/get/hold/take OBJ;carry/get/hold/take in/into/on/onto OBJ;carry/get/hold/take off OBJ;cast OBJ;chop/cut/prune/slice/tear OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;count/enumerate OBJ;cross/enter/go/run/walk OBJ;damn/fuck/shit/sod OBJ;dig OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;draw/open/uncover/undo/unwrap OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;fire/shoot an arrow at OBJ;fire/shoot arrow at OBJ;fire/shoot at OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip across to OBJ;hop/jump/skip onto OBJ;hop/jump/skip over OBJ;hop/jump/skip over to OBJ;hop/jump/skip to OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look under OBJ;leave OBJ;leave/go/run/walk into/in/inside/through OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;poison OBJ;put OBJ down;put down OBJ;put on OBJ;read/check/describe/examine/watch/x OBJ;rotate/screw/swivel/turn/twist/unscrew OBJ;search OBJ;shake/wave OBJ;shoot OBJ;smell/sniff OBJ;squash/squeeze OBJ;stand on OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/swivel/turn/twist/unscrew OBJ off;switch/rotate/screw/swivel/turn/twist/unscrew OBJ on;switch/rotate/screw/swivel/turn/twist/unscrew on OBJ;switch/rotate/screw/swivel/turn/twist/unscrew/close/cover/shut off OBJ;taste OBJ;untie OBJ;adjust/set OBJ to OBJ;ask OBJ about OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;bind OBJ in OBJ;bind OBJ into OBJ;burn/light OBJ with OBJ;carry/get/hold/take OBJ from/off OBJ;cast OBJ at OBJ;cast OBJ on OBJ;check/describe/examine/watch/x OBJ in OBJ;check/describe/examine/watch/x OBJ through OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;consult OBJ about OBJ;consult OBJ on OBJ;dig OBJ with OBJ;dip/insert OBJ in/into OBJ;dip/insert/put OBJ up OBJ;discard/drop/throw OBJ at/against/on/onto OBJ;discard/drop/throw OBJ in/into/down OBJ;discard/drop/throw OBJ to OBJ;discard/drop/throw/put OBJ on/onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ to/into/on/onto OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;fire/shoot OBJ at OBJ;grind OBJ with OBJ;hang/lean/prop/suspend OBJ on/from/against OBJ;hang/lean/prop/suspend OBJ up on/from/against OBJ;hang/lean/prop/suspend up OBJ on/from/against OBJ;l/look at OBJ in OBJ;l/look at OBJ through OBJ;l/look at OBJ using OBJ;l/look at OBJ with OBJ;l/look through OBJ at OBJ;l/look up OBJ in OBJ;lock OBJ with OBJ;pour/tip OBJ on OBJ;pour/tip OBJ onto OBJ;pour/tip/discard/drop/throw OBJ over OBJ;put OBJ in/inside/into OBJ;read OBJ in OBJ;read about OBJ in OBJ;remove OBJ from OBJ;tell OBJ about OBJ;unlock/draw/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

sherlock = {
    "name": "sherlock",
    "rom": "sherlock.z5",
    "seed" : 0,
    # Walkthrough adapted from http://mirror.ifarchive.org/if-archive/solutions/jgunness.zip
    "walkthrough": "KNOCK ON DOOR/U/N/GET NEWSPAPER/SHOW IT TO HOLMES/EXAMINE SLIPPER/GET TOBACCO,KNIFE,PIPE/WAIT/No/READ PAPER/WAIT/No/W/GET LAMP, GLASS AND AMPOULE/E/S/D/N/GET MATCHBOOK/S/OPEN DOOR/E/LIGHT LAMP/N/E/TURN OFF LAMP/DROP IT/PUT TOBACCO IN PIPE/OPEN MATCHBOOK/GET MATCH/STRIKE IT/LIGHT PIPE WITH MATCH/DROP MATCH/N/ASK HOLMES ABOUT ASH/W/EXAMINE STATUES/EXAMINE FAWKES/GET TORCH/LIGHT NEWSPAPER WITH PIPE/LIGHT TORCH WITH NEWSPAPER/EXAMINE CHARLES/GET HEAD/MELT HEAD WITH TORCH/GET GEM/E/S/GET LAMP/LIGHT IT/E/Z/BLOW WHISTLE/BLOW WHISTLE/ENTER CAB/DRIVE TO WHITEHALL/GET OUT/E/D/LOOK IN ROWBOAT/GET OAR/U/W/S/W/HAGGLE WITH SALESMAN/HAGGLE WITH SALESMAN/BUY TELESCOPE/E/Z/SE/U/OPEN BAG/OPEN BLUE BOTTLE/GET BALLS/WEAR BALLS/WAIT/WAIT/GET SAPPHIRE/GET SAPPHIRE/GET SAPPHIRE/EXAMINE SAPPHIRE/READ SAPPHIRE SCRATCH WITH GLASS/READ EMERALD SCRATCH WITH GLASS/D/NW/TURN OFF LAMP/BLOW WHISTLE/BLOW WHISTLE/ENTER CAB/DRIVE TO COVENT GARDEN/GET OUT/REMOVE BALLS/DROP THEM/REMOVE HAT/DROP MATCHBOOK/GET STETHOSCOPE/WEAR IT/LISTEN TO GIRL/OPEN BROWN BOTTLE/TAKE YELLOW PILL/GIVE IT TO GIRL/REMOVE STETHOSCOPE/PUT IT IN HAT/WEAR HAT/N/E/S/W/ASK FOR PIGEON/E/BLOW WHISTLE/BLOW WHISTLE/ENTER CAB/DRIVE TO TRAFALGAR SQUARE/GET OUT/LOOK AT STATUE THROUGH TELESCOPE/SHOW RUBY TO PIGEON/TELL PIGEON TO GET RUBY/THROW IT/DROP TELESCOPE/BLOW WHISTLE/BLOW WHISTLE/ENTER CAB/DRIVE TO PINCHIN LANE/GET OUT/W/ASK FOR PIGEON/READ RUBY SCRATCH WITH GLASS/E/BLOW WHISTLE/BLOW WHISTLE/ENTER CAB/DRIVE TO THE EMBANKMENT/GET/OUT/ENTER BOAT/INSERT OAR IN OARLOCK/WEIGH ANCHOR/S/ROW EAST/ROW EAST/DROP/ANCHOR/EXAMINE BRIDGE/EXAMINE MOSS/GET MOSS/READ OPAL SCRATCH WITH GLASS/WEIGH ANCHOR/ROW WEST/ROW WEST/N/GET OUT/N/W/N/Z/N/W/NE/N/E/OPEN BOOK/SHUT UP/OPEN BOOK/READ BOOK/W/S/SW/S/S/S/SW/E/S/SE/DROP PIPE/GET PACQUET, PAPER AND CRAYON/NW/OPEN DOOR/S/W/READ SIGN/E/N/N/EXAMINE TOMB/OPEN PACQUET OF PAPER/GET BROWN PAPER/PUT IT ON TOMB/RUB IT WITH CRAYON/GET IT/E/N/N/LOOK/HEAT BROWN PAPER OVER/CANDLES/READ BACK OF BROWN PAPER/PUT IT IN BAG/S/E/EXAMINE TOMB/GET YELLOW/PAPER/PUT IT ON TOMB/RUB IT WITH CRAYON/GET IT/S/W/EXAMINE TOMBS/GET BLUE PAPER/PUT IT ON HENRY'S TOMB/RUB IT WITH CRAYON/GET IT/DROP CRAYON AND PACQUET/E/N/W/N/HEAT YELLOW PAPER OVER CANDLES/READ BACK OF YELLOW PAPER/HEAT BLUE PAPER OVER CANDLES/READ BACK OF BLUE PAPER/DROP BLUE PAPER AND YELLOW PAPER/S/S/W/W/BLOW WHISTLE/BLOW WHISTLE/ENTER CAB/DRIVE TO THE MONUMENT/z/GET OUT/READ PLAQUE/NW/NW/EXAMINE URCHIN/GIVE SHILLING TO WIGGINS/ASK WIGGINS TO STEAL KEYS/N/GIVE OPAL, RUBY, SAPPHIRE AND EMERALD TO GUARD/N/EXAMINE DOOR/REMOVE HAT/GET STETHOSCOPE/WEAR IT/LISTEN TO DIAL/TURN DIAL RIGHT/TURN DIAL RIGHT/TURN DIAL LEFT/TURN DIAL RIGHT/TURN DIAL RIGHT/W/UNLOCK BOX 600 WITH KEY/GET TOPAZ/READ TOPAZ SCRATCH WITH GLASS/E/S/W/W/W/S/W/ASK FOR MYCROFT HOLMES/GIVE RING TO BUTLER/E/BLOW WHISTLE/BLOW WHISTLE/ENTER CAB/DRIVE TO TOWER OF LONDON/GET OUT/E/E/Aragon/N/N/SE/U/GET MACE/D/NW/NE/EXAMINE KEG/HIT BUNG WITH MACE/LOOK IN KEG/ASK WIGGINS TO GET GARNET/READ GARNET SCRATCH WITH GLASS/SW/E/D/WEAR ARMOUR/U/W/S/S/S/GET PADDLE/PULL CHAIN/S/ENTER BOAT/WEIGH ANCHOR/S/PADDLE WEST/PADDLE WEST/PADDLE WEST/N/REMOVE ARMOUR/E/E/D/W/REMOVE STETHOSCOPE/DROP IT/GET AMPOULE/PUT IT IN HAT/WEAR HAT/WAIT FOR 36 HOURS/WAIT FOR 35 MINUTES/ASK FOR AKBAR/swordfish/GIVE GARNET TO AKBAR/REMOVE HAT/GET AMPOULE/HOLD BREATH/BREAK AMPOULE/GET KNIFE/CUT ROPE WITH KNIFE/TIE MORIARTY AND AKBAR WITH ROPE/GET KEY, JEWELS AND WHISTLE/UNLOCK DOOR WITH KEY/OPEN IT/OUT/BLOW WHISTLE/BLOW WHISTLE/ENTER CAB/DRIVE TO BUCKINGHAM PALACE/GET OUT/GIVE JEWELS TO GUARD",
    "grammar" : "aragon;boleyn;brief/super/superbrie/verbose;chico/echo/groucho/gummo/harpo/hum/marx/punt/sing/whistle/zeppo;cleves;clue/clues/help/hint/hints/invisiclu;fly;gaze/l/look/peek/peer/stare;gin;go/back/retreat/hike/proceed/step/trudge/walk;howard;hush/quiet/shh/shhh/shhhh/shush/sshh/sshhh;i/inventory;maybe;nap/rest/sleep/snooze;no;notify;parr;pray;q/quit;restart;restore;rise/stand;save;score;script/unscript;seymour;swordfish;thank/thanks;version;y/yes;aid/assist/preserve/rescue OBJ;answer OBJ;approach OBJ;arrest OBJ;ask/interroga/query/question OBJ;ask/interroga/query/question about OBJ;ask/interroga/query/question for OBJ;awake/awaken/revive/rouse/wake OBJ;awake/awaken/revive/rouse/wake up OBJ;bargain/deal/dicker/haggle/negotiate with OBJ;bathe/swim/wade OBJ;bathe/swim/wade in OBJ;bathe/swim/wade over OBJ;bathe/swim/wade through OBJ;bathe/swim/wade to OBJ;bathe/swim/wade under OBJ;bathe/swim/wade/dive down OBJ;bite/eat/swallow OBJ;blow OBJ;blow in OBJ;blow on OBJ;blow out OBJ;blow through OBJ;blow up OBJ;board/mount OBJ;bound/hurdle/jump/leap/vault OBJ;bound/hurdle/jump/leap/vault from OBJ;bound/hurdle/jump/leap/vault in OBJ;bound/hurdle/jump/leap/vault off OBJ;bound/hurdle/jump/leap/vault over OBJ;bound/hurdle/jump/leap/vault through OBJ;bound/hurdle/jump/leap/vault to OBJ;bound/hurdle/jump/leap/vault up OBJ;bow/genuflect/kneel before OBJ;bow/genuflect/kneel to OBJ;breathe in OBJ;breathe out OBJ;breathe/hypervent/inhale OBJ;browse/leaf/read/skim OBJ;browse/leaf/read/skim through OBJ;brush/clean/polish/smear/sweep/wipe OBJ;brush/clean/polish/smear/sweep/wipe off OBJ;burn/ignite/kindle OBJ;buy OBJ;bye/farewell/goodbye OBJ;call/hail OBJ;carry/catch/grab/keep/retrieve/seize/snatch/take down OBJ;carry/catch/grab/keep/retrieve/seize/snatch/take off OBJ;carry/catch/grab/keep/retrieve/seize/snatch/take up OBJ;cast off OBJ;chase/follow/pursue OBJ;check/describe/examine/inspect/see/study/survey/trace/x OBJ;check/describe/examine/inspect/see/study/survey/trace/x on OBJ;check/describe/examine/inspect/see/study/survey/trace/x/gaze/l/look/peek/peer/stare in OBJ;check/describe/examine/inspect/see/study/survey/trace/x/gaze/l/look/peek/peer/stare/frisk/ransack/rummage/search/sift for OBJ;chuck/fling/hurl/pitch/throw/toss OBJ;chuck/fling/hurl/pitch/throw/toss away OBJ;clear/empty OBJ;clear/empty off OBJ;clear/empty/shake out OBJ;climb through OBJ;climb under OBJ;climb/get in OBJ;climb/get on OBJ;climb/go/bound/hurdle/jump/leap/vault/hike/proceed/step/trudge/walk out OBJ;climb/go/scale/hike/proceed/step/trudge/walk down OBJ;climb/go/scale/hike/proceed/step/trudge/walk up OBJ;climb/scale over OBJ;climb/scale/ascend OBJ;close/slam/rotate/toggle/turn/twist/shut off OBJ;close/slam/shut OBJ;clue/clues/help/hint/hints/invisiclu off OBJ;count/tally OBJ;crouch/settle/sit/squat OBJ;crouch/settle/sit/squat at OBJ;crouch/settle/sit/squat down OBJ;crouch/settle/sit/squat in OBJ;crouch/settle/sit/squat on OBJ;cry/howl/scream/shout/yell OBJ;cry/howl/scream/shout/yell at OBJ;cry/howl/scream/shout/yell to OBJ;depart/exit/scram/withdraw/leave/disembark OBJ;descend OBJ;detonate/explode OBJ;discover/find/seek OBJ;disembark from OBJ;disembark out OBJ;dislocate/move/roll/shift OBJ;disrobe/strip/undress OBJ;dive OBJ;dive in OBJ;dive over OBJ;dive under OBJ;don/wear OBJ;douse/extinguis/quench/snuff OBJ;drag/pull/tug/yank OBJ;drag/pull/tug/yank on OBJ;drag/pull/tug/yank out OBJ;dress OBJ;drink/guzzle/imbibe/quaff/sip/swill OBJ;drink/guzzle/imbibe/quaff/sip/swill from OBJ;drive OBJ;drive to OBJ;drop/dump OBJ;elevate/hoist/lift/raise OBJ;elevate/hoist/lift/raise up OBJ;embark on OBJ;embark/enter OBJ;employ/exploit/operate/use OBJ;escape/flee OBJ;escape/flee from OBJ;exhale OBJ;extend/unflatten/unfold OBJ;fasten/secure/tie OBJ;feel/grope/reach in OBJ;fiddle/play/toy OBJ;fiddle/play/toy with OBJ;fire/shoot OBJ;flip OBJ;fly OBJ;fly on OBJ;fly over OBJ;fly with OBJ;focus on OBJ;focus/adjust OBJ;fold/wrap OBJ;fold/wrap out OBJ;fold/wrap up OBJ;foo OBJ;frisk/ransack/rummage/search/sift OBJ;frisk/ransack/rummage/search/sift in OBJ;frisk/ransack/rummage/search/sift through OBJ;gaze/l/look/peek/peer/stare OBJ;gaze/l/look/peek/peer/stare around OBJ;gaze/l/look/peek/peer/stare at OBJ;gaze/l/look/peek/peer/stare behind OBJ;gaze/l/look/peek/peer/stare down OBJ;gaze/l/look/peek/peer/stare on OBJ;gaze/l/look/peek/peer/stare out OBJ;gaze/l/look/peek/peer/stare over OBJ;gaze/l/look/peek/peer/stare through OBJ;gaze/l/look/peek/peer/stare to OBJ;gaze/l/look/peek/peer/stare up OBJ;gaze/l/look/peek/peer/stare/frisk/ransack/rummage/search/sift under OBJ;get down OBJ;get off OBJ;get out OBJ;get under OBJ;get up OBJ;get/carry/catch/grab/keep/retrieve/seize/snatch/take OBJ;go/get/back/retreat/escape/flee/hike/proceed/step/trudge/walk away OBJ;go/hike/proceed/step/trudge/walk OBJ;go/hike/proceed/step/trudge/walk around OBJ;go/hike/proceed/step/trudge/walk behind OBJ;go/hike/proceed/step/trudge/walk in OBJ;go/hike/proceed/step/trudge/walk over OBJ;go/hike/proceed/step/trudge/walk through OBJ;go/hike/proceed/step/trudge/walk to OBJ;go/hike/proceed/step/trudge/walk under OBJ;go/retreat/hike/proceed/step/trudge/walk from OBJ;go/rise/stand/bound/hurdle/jump/leap/vault/hike/proceed/step/trudge/walk on OBJ;greet/greetings/hello/hi/salute OBJ;grope/reach through OBJ;guess OBJ;haul OBJ;haul in OBJ;haul up OBJ;hear OBJ;hide OBJ;hide behind OBJ;hide in OBJ;hide/rise/stand under OBJ;hold OBJ;hold down OBJ;hold on OBJ;hold up OBJ;hold/carry/catch/grab/keep/retrieve/seize/snatch/take/drag/pull/tug/yank apart OBJ;insert/lay/place/put/stuff down OBJ;insert/lay/place/put/stuff on OBJ;insert/lay/place/put/stuff out OBJ;kick OBJ;kick around OBJ;kick down OBJ;kick in OBJ;kiss/smooch OBJ;knock/pound/rap/tap at OBJ;knock/pound/rap/tap on OBJ;land OBJ;launch OBJ;lean on OBJ;let go OBJ;lick/taste OBJ;lie down OBJ;lie in OBJ;lie on OBJ;light OBJ;listen OBJ;listen for OBJ;listen in OBJ;listen to OBJ;loiter/stay/wait/z OBJ;loiter/stay/wait/z for OBJ;loiter/stay/wait/z until OBJ;lower OBJ;make OBJ;make up OBJ;nap/rest/sleep/snooze in OBJ;nap/rest/sleep/snooze on OBJ;nudge/press/push/shove/stick/thrust OBJ;nudge/press/push/shove/stick/thrust in OBJ;nudge/press/push/shove/stick/thrust off OBJ;nudge/press/push/shove/stick/thrust on OBJ;nudge/press/push/shove/stick/thrust/drag/pull/tug/yank down OBJ;nudge/press/push/shove/stick/thrust/drag/pull/tug/yank up OBJ;observe/watch OBJ;open OBJ;open up OBJ;paddle OBJ;paddle with OBJ;password OBJ;pet/pat/feel/disturb/scratch/touch OBJ;pick OBJ;pick up OBJ;pinch/steal OBJ;pocket OBJ;point OBJ;point at OBJ;point to OBJ;pour/spill/sprinkle OBJ;pour/spill/sprinkle out OBJ;proclaim/say/speak/talk/utter OBJ;proclaim/say/speak/talk/utter to OBJ;refuse OBJ;remove OBJ;rent OBJ;replace OBJ;reply/respond to OBJ;retract OBJ;ride OBJ;ride in OBJ;ride on OBJ;ring OBJ;rip/tear off OBJ;rise/stand in OBJ;rise/stand up OBJ;rob OBJ;rotate/toggle/turn/twist around OBJ;rotate/toggle/turn/twist down OBJ;rotate/toggle/turn/twist on OBJ;rotate/toggle/turn/twist over OBJ;rotate/toggle/turn/twist through OBJ;rotate/toggle/turn/twist to OBJ;rotate/toggle/turn/twist up OBJ;save/clue/clues/help/hint/hints/invisiclu OBJ;set off OBJ;shut up OBJ;slide OBJ;slide/bound/hurdle/jump/leap/vault down OBJ;smell/sniff/whiff OBJ;smoke OBJ;spin/whirl OBJ;start OBJ;stop OBJ;swing OBJ;swing on OBJ;tell OBJ;tell about OBJ;thank/thanks OBJ;tip OBJ;translate OBJ;undo/unfasten/unhook/untie OBJ;wave OBJ;wave/grin/laugh/motion/nod/smile/sneer at OBJ;wave/grin/laugh/motion/nod/smile/sneer to OBJ;weigh OBJ;what/what's/whats OBJ;what/what's/whats about OBJ;where/where's/wheres OBJ;who/who's/whos OBJ;wind OBJ;wind up OBJ;ask/interroga/query/question OBJ about OBJ;ask/interroga/query/question OBJ for OBJ;blind/jab/poke OBJ with OBJ;block/cover/shield OBJ with OBJ;block/cover/shield over OBJ with OBJ;block/cover/shield up OBJ with OBJ;break/damage/destroy/erase/smash/trash/wreck OBJ off OBJ;break/damage/destroy/erase/smash/trash/wreck OBJ with OBJ;break/damage/destroy/erase/smash/trash/wreck down OBJ with OBJ;break/damage/destroy/erase/smash/trash/wreck in OBJ with OBJ;break/damage/destroy/erase/smash/trash/wreck through OBJ with OBJ;bribe/entice/pay OBJ to OBJ;bribe/entice/pay OBJ with OBJ;browse/leaf/read/skim OBJ OBJ;browse/leaf/read/skim OBJ through OBJ;browse/leaf/read/skim OBJ to OBJ;browse/leaf/read/skim OBJ with OBJ;brush/clean/polish/smear/sweep/wipe OBJ off OBJ;brush/clean/polish/smear/sweep/wipe OBJ on OBJ;brush/clean/polish/smear/sweep/wipe OBJ over OBJ;brush/clean/polish/smear/sweep/wipe off OBJ on OBJ;brush/clean/polish/smear/sweep/wipe off OBJ over OBJ;burn/ignite/kindle OBJ with OBJ;burn/ignite/kindle down OBJ with OBJ;burn/ignite/kindle up OBJ with OBJ;buy OBJ from OBJ;buy OBJ with OBJ;call/hail OBJ with OBJ;carry/catch/grab/keep/retrieve/seize/snatch/take OBJ to OBJ;check/describe/examine/inspect/see/study/survey/trace/x OBJ through OBJ;check/describe/examine/inspect/see/study/survey/trace/x OBJ with OBJ;chop/cut/slash down OBJ with OBJ;chop/cut/slash off OBJ with OBJ;chop/cut/slash through OBJ with OBJ;chop/cut/slash up OBJ with OBJ;chuck/fling/hurl/pitch/throw/toss OBJ OBJ;chuck/fling/hurl/pitch/throw/toss OBJ at OBJ;chuck/fling/hurl/pitch/throw/toss OBJ down OBJ;chuck/fling/hurl/pitch/throw/toss OBJ in OBJ;chuck/fling/hurl/pitch/throw/toss OBJ off OBJ;chuck/fling/hurl/pitch/throw/toss OBJ on OBJ;chuck/fling/hurl/pitch/throw/toss OBJ over OBJ;chuck/fling/hurl/pitch/throw/toss OBJ through OBJ;chuck/fling/hurl/pitch/throw/toss OBJ to OBJ;clear/empty OBJ from OBJ;clear/empty OBJ out OBJ;clear/empty out OBJ from OBJ;clear/empty/pour/spill/sprinkle OBJ in OBJ;clear/empty/pour/spill/sprinkle OBJ on OBJ;clear/empty/pour/spill/sprinkle out OBJ on OBJ;clear/empty/shake/pour/spill/sprinkle out OBJ in OBJ;conceal OBJ in OBJ;conceal/hide OBJ behind OBJ;conceal/hide OBJ under OBJ;deliver/give/hand/lend/loan/offer OBJ to OBJ;deliver/give/hand/lend/loan/offer/bribe/entice/pay OBJ OBJ;diagnose OBJ with OBJ;display/show OBJ OBJ;display/show OBJ to OBJ;disturb/scratch/touch OBJ with OBJ;drag/pull/tug/yank OBJ from OBJ;drag/pull/tug/yank OBJ out OBJ;drag/pull/tug/yank OBJ with OBJ;drag/pull/tug/yank down OBJ with OBJ;drag/pull/tug/yank on OBJ with OBJ;drag/pull/tug/yank up OBJ with OBJ;drop/dump OBJ down OBJ;drop/dump OBJ in OBJ;drop/dump OBJ on OBJ;employ/exploit/operate/use OBJ on OBJ;fasten/secure/tie OBJ to OBJ;fasten/secure/tie OBJ with OBJ;fasten/secure/tie up OBJ with OBJ;feed OBJ OBJ;feed OBJ to OBJ;feed OBJ with OBJ;fell/chop/cut/slash OBJ with OBJ;fill OBJ at OBJ;fill OBJ with OBJ;fire/shoot OBJ at OBJ;fire/shoot OBJ with OBJ;fix up OBJ with OBJ;fix/repair/service OBJ with OBJ;focus OBJ at OBJ;focus OBJ on OBJ;fold/wrap OBJ in OBJ;fold/wrap/wind OBJ around OBJ;fold/wrap/wind up OBJ in OBJ;force/wedge OBJ in OBJ;force/wedge/elevate/hoist/lift/raise up OBJ with OBJ;force/wedge/nudge/press/push/shove/stick/thrust/dislocate/move/roll/shift/elevate/hoist/lift/raise OBJ with OBJ;free/release/unjam OBJ from OBJ;free/release/unjam OBJ with OBJ;gaze/l/look/peek/peer/stare at OBJ through OBJ;gaze/l/look/peek/peer/stare at OBJ with OBJ;gaze/l/look/peek/peer/stare in OBJ through OBJ;gaze/l/look/peek/peer/stare in OBJ with OBJ;gaze/l/look/peek/peer/stare through OBJ at OBJ;get/bring OBJ OBJ;get/bring OBJ for OBJ;get/bring OBJ to OBJ;get/carry/catch/grab/keep/retrieve/seize/snatch/take OBJ from OBJ;get/carry/catch/grab/keep/retrieve/seize/snatch/take OBJ in OBJ;get/carry/catch/grab/keep/retrieve/seize/snatch/take OBJ off OBJ;get/carry/catch/grab/keep/retrieve/seize/snatch/take OBJ on OBJ;get/carry/catch/grab/keep/retrieve/seize/snatch/take OBJ out OBJ;get/carry/catch/grab/keep/retrieve/seize/snatch/take OBJ with OBJ;grope/reach OBJ with OBJ;grope/reach for OBJ with OBJ;grope/reach out OBJ with OBJ;grope/reach to OBJ with OBJ;heat/warm OBJ over OBJ;heat/warm OBJ with OBJ;hit/slap/swat/whack at OBJ with OBJ;hit/slap/swat/whack/knock/pound/rap/tap OBJ with OBJ;hold OBJ in OBJ;hold OBJ on OBJ;hold OBJ over OBJ;hold OBJ up OBJ;hold/disturb/scratch/touch OBJ to OBJ;hold/insert/lay/place/put/stuff OBJ against OBJ;hook/jiggle/loosen/wiggle/wobble OBJ with OBJ;illuminat OBJ with OBJ;insert/lay/place/put/stuff OBJ behind OBJ;insert/lay/place/put/stuff OBJ down OBJ;insert/lay/place/put/stuff OBJ in OBJ;insert/lay/place/put/stuff OBJ on OBJ;insert/lay/place/put/stuff OBJ over OBJ;insert/lay/place/put/stuff OBJ through OBJ;insert/lay/place/put/stuff OBJ under OBJ;kill/murder/punch/stab/wound/attack/fight/hurt OBJ with OBJ;knock/pound/rap/tap down OBJ with OBJ;knock/pound/rap/tap out OBJ with OBJ;leave OBJ in OBJ;leave OBJ on OBJ;let OBJ go OBJ;light OBJ from OBJ;light OBJ with OBJ;light up OBJ from OBJ;light up OBJ with OBJ;listen to OBJ through OBJ;listen to OBJ with OBJ;lock OBJ with OBJ;make OBJ OBJ;melt OBJ with OBJ;nudge/press/push/shove/stick/thrust OBJ at OBJ;nudge/press/push/shove/stick/thrust OBJ in OBJ;nudge/press/push/shove/stick/thrust OBJ on OBJ;nudge/press/push/shove/stick/thrust OBJ over OBJ;nudge/press/push/shove/stick/thrust OBJ under OBJ;nudge/press/push/shove/stick/thrust down OBJ with OBJ;nudge/press/push/shove/stick/thrust on OBJ with OBJ;nudge/press/push/shove/stick/thrust/dislocate/move/roll/shift/drag/pull/tug/yank OBJ OBJ;nudge/press/push/shove/stick/thrust/dislocate/move/roll/shift/drag/pull/tug/yank OBJ to OBJ;observe/watch OBJ through OBJ;observe/watch OBJ with OBJ;open OBJ with OBJ;open up OBJ with OBJ;paddle OBJ with OBJ;pick OBJ with OBJ;pinch/steal OBJ from OBJ;pinch/steal OBJ out OBJ;point at OBJ for OBJ;point out OBJ to OBJ;point to OBJ for OBJ;point/aim OBJ at OBJ;point/aim OBJ to OBJ;point/aim at OBJ with OBJ;pour/spill/sprinkle OBJ from OBJ;pour/spill/sprinkle OBJ out OBJ;proclaim/say/speak/talk/utter OBJ to OBJ;remove OBJ from OBJ;remove OBJ in OBJ;remove OBJ on OBJ;remove OBJ with OBJ;rip/tear through OBJ with OBJ;rip/tear up OBJ with OBJ;rob OBJ from OBJ;rotate/toggle/turn/twist OBJ with OBJ;rotate/toggle/turn/twist/spin/whirl OBJ OBJ;rotate/toggle/turn/twist/spin/whirl/set/dial OBJ to OBJ;row OBJ OBJ;rub OBJ with OBJ;sell OBJ OBJ;sell OBJ to OBJ;set OBJ at OBJ;shake OBJ with OBJ;shake/pour/spill/sprinkle out OBJ from OBJ;shine OBJ at OBJ;shine OBJ in OBJ;shine OBJ on OBJ;shine OBJ over OBJ;shine in OBJ with OBJ;shine on OBJ with OBJ;shine over OBJ with OBJ;slide OBJ down OBJ;slide OBJ in OBJ;slide OBJ to OBJ;slide OBJ under OBJ;start OBJ with OBJ;strike OBJ with OBJ;swing OBJ at OBJ;tell OBJ about OBJ;unlock OBJ with OBJ;unscrew OBJ from OBJ;unscrew OBJ out OBJ;wind OBJ in OBJ;work on OBJ with OBJ;",
    "max_word_length" : 9
}

snacktime = {
    "name": "snacktime",
    "rom": "snacktime.z8",
    "seed" : 0,
    "walkthrough" : "w/pull cloth/close cold box/e/push pet/bark/lick pet/x box/x couch/x soft things/take cushion/w/pull cloth/get can/close cold box/e/show can to pet/get on couch/l/take wand/d/push wand/push wand/push wand/z/z/z/n/take dino/s/w/drop dino/z/z",
    "grammar" : "awake/awaken/wake;awake/awaken/wake up;beg;bother/curses/darn/drat;carry/hold/take inventory;change/switch channel;channel surf;chase/get tail;chase/spin;damn/fuck/shit;get out/off/up;go/leave/run/walk;go/leave/run/walk potty;growl/bark at dino;growl/bark at dinosaur;hop/jump/skip;hop/jump/skip on him;hop/jump/skip on man;hop/jump/skip on master;hop/jump/skip on owner;hop/jump/skip on pet;hop/jump/skip up;hop/jump/skip/get down;howl/sing;i/inv/inventory;l/look;lay/lie down;listen;long/verbose;love/kiss on dino;love/kiss on dinosaur;love/kiss/embrace/hug dino;love/kiss/embrace/hug dinosaur;make sandwich;make snack;nap/sleep;no;nod/shake head;normal/brief;notify;notify off;notify on;off/exit/out/stand;paw/shake;play dead;pronouns/nouns;q/quit;restart;restore;roll over;rollover;save;score;scratch;scratch him;scratch man;scratch master;scratch me;scratch myself;scratch owner;scratch pet;scratch player;scratch self;shake hand;shake hands;shake him;shake man;shake master;shake me;shake owner;shake paw;shake pet;shake self;shake yourself;short/superbrie;sit;sit down;smell/sniff;snack;sorry;spin/rotate/screw/turn/twist/unscrew around;stand up;switch show;talk to dino;talk to dinosaur;talk to friend;think;transcrip/script;transcrip/script off;transcrip/script on;urinate/poop/poo/pee;use toilet;verify;version;wag my tail;wag/shake tail;wait/z;walkthru/walkthrou/info/about/hints/hint/help;wave;whimper/whine/growl/talk/answer/say/shout/speak;y/yes;yap/yip/bark;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;bark at OBJ;bark to OBJ;bite/chew OBJ;bite/chew on OBJ;burn/light OBJ;buy/purchase OBJ;carry/hold/take off OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale on OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;cross/enter/go/leave/run/walk OBJ;dig in OBJ;dig/search OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;feel/touch OBJ;fetch/get/carry/hold/take OBJ;get in/into/on/onto OBJ;get off OBJ;go/leave/run/walk into/in/inside/through OBJ;growl at OBJ;hear OBJ;hop/jump/skip on OBJ;hop/jump/skip onto OBJ;hop/jump/skip up on OBJ;hop/jump/skip up onto OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look under OBJ;listen to OBJ;love/kiss on OBJ;love/kiss/embrace/hug OBJ;open/uncover/unwrap OBJ;pick OBJ up;pick up OBJ;play with OBJ;put OBJ down;put down OBJ;put on OBJ;read/check/describe/examine/watch/x OBJ;rotate/screw/turn/twist/unscrew OBJ;scratch OBJ;shake OBJ;sit on top of OBJ;sit on/in/inside OBJ;smell/sniff OBJ;squash/squeeze OBJ;stand on OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;talk to OBJ;taste OBJ;urinate/poop/poo/pee in OBJ;urinate/poop/poo/pee on OBJ;use OBJ;wave OBJ;adjust/set OBJ to OBJ;answer/say/shout/speak OBJ to OBJ;ask OBJ about OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;carry/hold/take OBJ off OBJ;consult OBJ on/about OBJ;discard/drop/throw OBJ at/against/on/onto OBJ;discard/drop/throw OBJ in/into/down OBJ;discard/drop/throw/put OBJ on/onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;insert OBJ in/into OBJ;l/look up OBJ in OBJ;lock OBJ with OBJ;put OBJ in/inside/into OBJ;read OBJ in OBJ;read about OBJ in OBJ;remove/get/carry/hold/take OBJ from OBJ;tell OBJ about OBJ;unlock/open/uncover/unwrap OBJ with OBJ;use OBJ on OBJ;",
    "max_word_length" : 9
}

sorcerer = {
    "name": "sorcerer",
    "rom": "sorcerer.z3",
    "seed" : 0,
    # Walkthrough adapted from http://mirror.ifarchive.org/if-archive/solutions/jgunness.zip
    "walkthrough": "WAIT/FROTZ BOOK/GET UP/W/READ NOTE/DROP IT/W/OPEN DESK/GET BOX AND JOURNAL/LOOK BEHIND TAPESTRY/GET KEY/OPEN JOURNAL/READ IT/DROP JOURNAL AND KEY/E/S/S/W/GET VIAL, CALENDAR AND MATCHBOOK/E/OPEN RECEPTACLE/READ MATCHBOOK/PUT IT IN RECEPTACLE/E/GET SCROLL/READ IT/GNUSTO MEEF SPELL/W/D/PRESS white, gray, black, red, black/GET SCROLL/READ IT/OPEN VIAL/DRINK OCHRE POTION/DROP VIAL/U/OPEN RECEPTACLE/GET ORANGE VIAL/N/W/GET SCROLL/READ IT/GNUSTO GASPAR SPELL/AIMFIZ BELBOZ/NE/E/NE/LEARN PULVER/PULVER RIVER/D/NE/GET GUANO, SCROLL AND AMBER VIAL/READ SCROLL/GNUSTO FWEEP SPELL/D/S/GET INDIGO VIAL/W/D/W/SW/SW/W/LEARN IZYUK SPELL/AGAIN/IZYUK ME/W/W/N/GET COIN/S/E/IZYUK ME/E/E/NE/NE/E/E/WAKE GNOME/GIVE COIN TO GNOME/SEARCH GNOME/E/E/N/N/SLEEP/LEARN FWEEP/LEARN FWEEP/LEARN FWEEP/LEARN FWEEP/LEARN FWEEP/DROP ALL/E/FWEEP ME/N/E/S/S/W/D/E/E/N/N/U/U/S/E/GET SCROLL/READ IT/PUT IT IN HOLE/FWEEP ME/W/W/S/E/D/D/W/W/U/U/N/N/D/E/FWEEP ME/S/E/N/D/W/S/W/U/W/WAIT/WAIT/GET ALL/S/S/E/OPEN BOX/DROP BOX/GET AMULET AND SCROLL/GNUSTO SWANZO SPELL/LEARN IZYUK/W/W/W/W/U/U/W/W/IZYUK ME/NE/SE/E/LOWER FLAG/EXAMINE IT/DROP CALENDAR/GET AQUA VIAL/E/LOOK IN CANNON/PUT GUANO IN CANNON/GET SCROLL/READ IT/W/W/LEARN IZYUK/IZYUK ME/NW/SW/W/D/D/S/S/SW/W/GIVE COIN TO GNOME/W/W/S/SLEEP/OPEN AQUA VIAL/DRINK POTION/DROP AQUA VIAL/GET BALL/THROW IT AT RABBIT/READ GLITTERING SCROLL/GNUSTO MALYON SPELL/N/E/E/NE/S/YONK MALYON SPELL/LEARN MALYON/MALYON DRAGON/S/OPEN ORANGE VIAL/FROTZ ME/E/DRINK POTION/THROW ALL BUT BOOK INTO LOWER CHUTE/GIVE BOOK TO TWIN/E/TURN DIAL TO 639/OPEN DOOR/E/GET ROPE/U/NW/GET TIMBER/NW/W/TIE ROPE TO TIMBER/PUT TIMBER ACROSS CHUTE/THROW ROPE INTO CHUTE/D/GET SHIMMERING SCROLL/READ IT/GOLMAC ME/OPEN LAMP/GET SMELLY SCROLL/D/WAIT/WAIT/SAY TO TWIN \"THE COMBINATION IS 639\"/D/WAIT/SLEEP/LEARN MEEF, MEEF AND SWANZO/DROP ALL/E/D/MEEF WEEDS/OPEN CRATE/GET SUIT/U/W/GET ALL/WEAR SUIT/NE/N/MEEF VINES/W/W/OPEN WHITE DOOR/VARDIK ME/SWANZO BELBOZ",
    "grammar" : "advanc/go/hike/procee/run/step/tramp/trudge/walk;answer/reply/respon;bathe/swim/wade;bound/dive/hurdle/jump/leap/vault;brief;call/procla/say/talk/utter;cavort/gambol/hop/skip;chase/follow/pursue;concea/enscon/hide/secret/stash;damn/fuck/shit;depart/exit/withdr;diagno;enter;fly;fweep;gaspar;gaze/l/look/stare;greeti/hello/hi/saluta;help/hint/hints;howl/scream/shout/yell;i/invent;land;leave;nap/snooze/sleep;q/quit;restar;restor;rise/stand;save;score;script;spells;super/superb;t/time;thank/thanks;unscri;verbos;versio;vezza;wait/z;advanc/go/hike/procee/run/step/tramp/trudge/walk OBJ;advanc/go/hike/procee/run/step/tramp/trudge/walk around OBJ;advanc/go/hike/procee/run/step/tramp/trudge/walk down OBJ;advanc/go/hike/procee/run/step/tramp/trudge/walk in OBJ;advanc/go/hike/procee/run/step/tramp/trudge/walk on OBJ;advanc/go/hike/procee/run/step/tramp/trudge/walk throug OBJ;advanc/go/hike/procee/run/step/tramp/trudge/walk to OBJ;advanc/go/hike/procee/run/step/tramp/trudge/walk up OBJ;aimfiz OBJ;answer/reply/respon OBJ;assaul/attack/fight/hit/hurt/injure OBJ;awake/rouse/startl/surpri/wake OBJ;awake/rouse/startl/surpri/wake up OBJ;banish/drive/exorci OBJ;banish/drive/exorci away OBJ;banish/drive/exorci out OBJ;bathe/swim/wade in OBJ;beckon/brandi/motion/wave OBJ;beckon/brandi/motion/wave to OBJ;beckon/brandi/motion/wave/howl/scream/shout/yell at OBJ;bite OBJ;blow out OBJ;blow up OBJ;board/embark/ride OBJ;bound/dive/hurdle/jump/leap/vault across OBJ;bound/dive/hurdle/jump/leap/vault from OBJ;bound/dive/hurdle/jump/leap/vault in OBJ;bound/dive/hurdle/jump/leap/vault off OBJ;bound/dive/hurdle/jump/leap/vault/advanc/go/hike/procee/run/step/tramp/trudge/walk over OBJ;break/crack/damage/demoli/destro/smash/wreck OBJ;call/procla/say/talk/utter to OBJ;carry/catch/confis/get/grab/hold/seize/snatch/take OBJ;carry/catch/confis/get/grab/hold/seize/snatch/take off OBJ;carry/catch/confis/get/grab/hold/seize/snatch/take out OBJ;cast/incant/invoke OBJ;chase/follow/pursue OBJ;check/descri/examin/inspec/observ/study/survey/watch OBJ;check/descri/examin/inspec/observ/study/survey/watch on OBJ;check/descri/examin/inspec/observ/study/survey/watch/gaze/l/look/stare in OBJ;check/descri/examin/inspec/observ/study/survey/watch/gaze/l/look/stare/frisk/ransac/rummag/search for OBJ;climb/scale OBJ;climb/scale down OBJ;climb/scale over OBJ;climb/scale up OBJ;climb/scale/rest/sit/squat/carry/catch/confis/get/grab/hold/seize/snatch/take in OBJ;climb/scale/rest/sit/squat/carry/catch/confis/get/grab/hold/seize/snatch/take on OBJ;close/shut OBJ;combin/combo OBJ;concea/enscon/hide/secret/stash OBJ;concea/enscon/hide/secret/stash behind OBJ;concea/enscon/hide/secret/stash under OBJ;consum/devour/eat/gobble/ingest/nibble/taste OBJ;count/tally OBJ;cross/ford/traver OBJ;debark/disemb OBJ;defile/molest/rape/ravish OBJ;deflat OBJ;depart/exit/withdr OBJ;descen OBJ;dig/excava in OBJ;dig/excava throug OBJ;dig/excava with OBJ;discha/fire/shoot OBJ;disloc/displa/move/shift/drag/pull/shove/tug/yank OBJ;dispat/kill/murder/slay/stab/vanqui OBJ;doff/remove/shed OBJ;don/wear OBJ;douse/exting/quench OBJ;drag/pull/shove/tug/yank down OBJ;drag/pull/shove/tug/yank on OBJ;drink/guzzle/imbibe/quaff/sip/swallo/swill OBJ;drink/guzzle/imbibe/quaff/sip/swallo/swill from OBJ;drop/dump/releas OBJ;elevat/hoist/lift/raise OBJ;elevat/hoist/lift/raise up OBJ;enter OBJ;feel/pat/pet/rub/touch OBJ;fill OBJ;find/see/seek OBJ;flip/set/turn OBJ;flip/set/turn off OBJ;flip/set/turn on OBJ;fly OBJ;forget/unlear/unmemo OBJ;free/unatta/unfast/unhook/untie OBJ;frisk/ransac/rummag/search OBJ;frisk/ransac/rummag/search in OBJ;frotz OBJ;fweep OBJ;gaspar OBJ;gaze/l/look/stare OBJ;gaze/l/look/stare around OBJ;gaze/l/look/stare at OBJ;gaze/l/look/stare behind OBJ;gaze/l/look/stare down OBJ;gaze/l/look/stare on OBJ;gaze/l/look/stare throug OBJ;gaze/l/look/stare under OBJ;gaze/l/look/stare up OBJ;gestur/point at OBJ;gestur/point to OBJ;gnusto OBJ;golmac OBJ;greeti/hello/hi/saluta OBJ;gyrate/rotate/spin/whirl OBJ;harken/listen for OBJ;harken/listen to OBJ;inflat OBJ;insert/lay/place/put/stuff down OBJ;insert/lay/place/put/stuff on OBJ;izyuk OBJ;jostle/rattle/shake OBJ;kick OBJ;kiss/smooch OBJ;knock/rap at OBJ;knock/rap down OBJ;knock/rap on OBJ;know/learn/memori OBJ;launch OBJ;lean on OBJ;leave OBJ;lie/reclin/repose down OBJ;lie/reclin/repose on OBJ;light OBJ;lower OBJ;malyon OBJ;meef OBJ;nap/snooze/sleep in OBJ;nap/snooze/sleep on OBJ;nudge/press/push/thrust OBJ;nudge/press/push/thrust on OBJ;open OBJ;open up OBJ;pay OBJ;pick OBJ;pick up OBJ;play OBJ;polish/shine/wax OBJ;pour/spill/sprink OBJ;pulver OBJ;pump up OBJ;reach in OBJ;read/skim OBJ;read/skim about OBJ;rest/sit/squat at OBJ;rest/sit/squat down OBJ;rezrov OBJ;rise/stand on OBJ;rise/stand/carry/catch/confis/get/grab/hold/seize/snatch/take up OBJ;roll up OBJ;send for OBJ;slide OBJ;smell/sniff/whiff OBJ;spray OBJ;squeez OBJ;strike OBJ;swanzo OBJ;swing OBJ;tell OBJ;thank/thanks OBJ;tortur OBJ;vardik OBJ;vezza OBJ;wait/z for OBJ;what/whats OBJ;where/wheres OBJ;who/whos OBJ;yomin OBJ;yonk OBJ;aimfiz OBJ to OBJ;apply OBJ to OBJ;ask/interr/query/quiz OBJ about OBJ;ask/interr/query/quiz OBJ for OBJ;assaul/attack/fight/hit/hurt/injure OBJ with OBJ;attach/fasten/secure/tie OBJ to OBJ;attach/fasten/secure/tie up OBJ with OBJ;beckon/brandi/motion/wave OBJ at OBJ;bestow/donate/feed/give/hand/offer/presen OBJ OBJ;bestow/donate/feed/give/hand/offer/presen OBJ to OBJ;blind/jab/poke OBJ with OBJ;break/crack/damage/demoli/destro/smash/wreck OBJ with OBJ;break/crack/damage/demoli/destro/smash/wreck down OBJ with OBJ;burn/combus/ignite/kindle OBJ with OBJ;burn/combus/ignite/kindle down OBJ with OBJ;carry/catch/confis/get/grab/hold/seize/snatch/take OBJ from OBJ;carry/catch/confis/get/grab/hold/seize/snatch/take OBJ in OBJ;carry/catch/confis/get/grab/hold/seize/snatch/take OBJ off OBJ;carry/catch/confis/get/grab/hold/seize/snatch/take OBJ out OBJ;cast/incant/invoke OBJ at OBJ;cast/incant/invoke OBJ on OBJ;chuck/fling/hurl/pitch/throw/toss OBJ at OBJ;chuck/fling/hurl/pitch/throw/toss OBJ off OBJ;chuck/fling/hurl/pitch/throw/toss OBJ over OBJ;chuck/fling/hurl/pitch/throw/toss OBJ throug OBJ;cleave/cut/gash/lacera/sever/slash/slice/split OBJ with OBJ;cleave/cut/gash/lacera/sever/slash/slice/split throug OBJ with OBJ;clog/fix/glue/patch/plug/repair OBJ with OBJ;compar OBJ to OBJ;concea/enscon/hide/secret/stash OBJ from OBJ;dig/excava OBJ with OBJ;dig/excava in OBJ with OBJ;dispat/kill/murder/slay/stab/vanqui OBJ with OBJ;dissol/liquif/melt/thaw OBJ with OBJ;drop/dump/releas/chuck/fling/hurl/pitch/throw/toss/insert/lay/place/put/stuff OBJ down OBJ;drop/dump/releas/chuck/fling/hurl/pitch/throw/toss/insert/lay/place/put/stuff OBJ in OBJ;feel/pat/pet/rub/touch OBJ with OBJ;fill OBJ at OBJ;fill OBJ with OBJ;flip/set/turn OBJ for OBJ;flip/set/turn OBJ to OBJ;flip/set/turn OBJ with OBJ;free/unatta/unfast/unhook/untie OBJ from OBJ;gaze/l/look/stare at OBJ throug OBJ;gaze/l/look/stare up OBJ in OBJ;hone/sharpe OBJ with OBJ;insert/lay/place/put/stuff OBJ across OBJ;insert/lay/place/put/stuff OBJ behind OBJ;insert/lay/place/put/stuff OBJ on OBJ;insert/lay/place/put/stuff OBJ over OBJ;insert/lay/place/put/stuff OBJ under OBJ;light OBJ with OBJ;lock OBJ with OBJ;lower OBJ down OBJ;lower OBJ in OBJ;open OBJ with OBJ;pay OBJ OBJ;pay OBJ to OBJ;pay OBJ with OBJ;pick OBJ with OBJ;polish/shine/wax OBJ with OBJ;pour/spill/sprink OBJ from OBJ;pour/spill/sprink OBJ in OBJ;pour/spill/sprink OBJ on OBJ;pump up OBJ with OBJ;read/skim OBJ throug OBJ;read/skim about OBJ in OBJ;show OBJ OBJ;show OBJ to OBJ;slide/nudge/press/push/thrust OBJ OBJ;slide/nudge/press/push/thrust OBJ to OBJ;slide/nudge/press/push/thrust OBJ under OBJ;spray OBJ on OBJ;spray OBJ with OBJ;squeez/drop/dump/releas/chuck/fling/hurl/pitch/throw/toss OBJ on OBJ;strike OBJ with OBJ;swing OBJ at OBJ;unlock OBJ with OBJ;",
    "max_word_length" : 6
}

spellbrkr = {
    "name": "spellbrkr",
    "rom": "spellbrkr.z3",
    "seed" : 0,
    "walkthrough" : "z/z/z/z/s/take bread/s/learn lesoch/cast lesoch/take cube/write 1 on cube/learn blorple/blorple 1/frotz burin/d/d/z/z/z/z/z/z/get stained scroll/read stained scroll/gnusto caskly/learn blorple/blorple 1/e/s/take zipper/open zipper/reach in zipper/look in zipper/take flimsy scroll/read flimsy scroll/learn blorple/blorple 1/s/take dirty scroll/read dirty scroll/gnusto throck/u/z/z/z/cast girgol/u/u/u/u/take coin/examine coin/w/learn caskly/caskly hut/take cube/e/put coin in zipper/put bread in zipper/put knife in zipper/write 2 on cube/learn blorple/blorple 2/s/pull weed/pull weed/learn blorple/blorple 1/w/n/learn yomin/yomin ogre/plant weed/learn throck/throck weed/d/take dusty scroll/take gold box/u/s/read dusty scroll/gnusto espnis/open box/take cube/put box in zipper/write 3 on cube/learn blorple/blorple 3/take bread from zipper/learn blorple/drop all except bread/s/drop bread/take cube/take bottle/blorple 3/open bottle/look in bottle/take damp scroll/read damp scroll/take all/gnusto liskon/take 1/n/sleep/enter outflow pipe/learn liskon/liskon self/enter inflow pipe/z/z/z/learn liskon/liskon me/z/z/learn liskon/liskon me/frotz bottle/learn blorple/drop all except bottle/take 3/enter outflow pipe/w/take cube/w/climb out of pipe/blorple 3/n/take all/put bottle in zipper/write 4 on cube/learn blorple/blorple 1/e/n/learn liskon/liskon snake/n/n/take cube/learn malyon/malyon idol/learn espnis/learn malyon/malyon idol/z/espnis idol/z/climb idol/look in mouth/take cube/d/write 5 on cube/learn blorple/blorple 5/n/take white scroll/learn blorple/blorple 5/w/read white scroll/gnusto tinsot/e/examine blue carpet/take coin from zipper/point at blue carpet/buy blue carpet/offer 300/offer 400/offer 500/take blue carpet/exit/learn blorple/blorple 3/learn tinsot/learn tinsot/learn tinsot/learn tinsot/put all in zipper/take burin/close zipper/n/rezrov door/tinsot channel/tinsot channel/tinsot channel/z/z/z/tinsot water/enter/u/take cube/open zipper/get book/write 6 on cube/e/n/rezrov cabinet/take moldy book/learn caskly/caskly moldy book/read moldy book/gnusto snavig/s/w/u/drop carpet/sit on carpet/u/w/w/w/w/d/get off carpet/pick up cube/sit on carpet/u/e/e/e/e/d/get off carpet/take carpet/write 7 on cube/d/learn blorple/blorple 3/sleep/learn snavig/learn blorple/put spell book in zipper/close zipper/s/get 3/snavig grouper/d/z/z/z/z/get all/u/blorple 3/sleep/write 8 on cube/open zipper/take spell book from zipper/n/learn blorple/blorple 8/w/learn tinsot/tinsot fragment/take fragment/put all in zipper except book/learn blorple/take 4/blorple 4/n/take compass rose/learn blorple/blorple 4/w/put compass rose in carving/take compass rose/n/touch nw rune with rose/nw/touch w rune with rose/w/touch ne rune with rose/ne/rezrov alabaster/w/take cube/take burin from zipper/write 9 on cube/learn blorple/blorple 9/s/take fragment from zipper/give fragment to green rock/sit on green rock/l/rock, n/rock, sw/rock, e/rock, s/rock, e/rock, e/jump to brown rock/get cube/write 10 on cube/learn blorple/blorple 10/d/learn snavig/drop all except 10, book/d/snavig grue/d/climb pillar/take cube/z/z/z/learn blorple/blorple 10/d/take all/write 11 on cube/learn blorple/blorple 11/n/take box/examine box/put 10 in box/take 10/throw box at outcropping/learn blorple/blorple 10/u/take box/take cube/write 12 on cube/put all in zipper/take book/take 7/learn blorple/blorple 7/s/ask belboz about me/berknip/ask belboz about cube/ask belboz about figure/take 9/learn blorple/blorple 9/e/rezrov door/put all except book in zipper/n/learn jindak/learn jindak/learn jindak/learn blorple/take x1,x2,x7,x8/jindak/put x1, x2, x7 on first pile/get x3, x4, x5, x6/put x8 on second pile/get x12/put x12 on first pile/l/jindak/drop all cubes/take x1, x2, x7, x12/drop all cubes/take x8, x9, x10, x11/drop all cubes/take x1, x10/put x1 in first/put x10 in second/jindak/take x10/blorple x10/d/take key from zipper/unlock cabinet with key/open cabinet/take vellum scroll/read vellum scroll/learn rezrov/learn blorple/learn blorple/learn girgol/put book in cabinet/close cabinet/lock cabinet with key/rezrov door/blorple x10/u/open sack/take flimsy scroll/take burin/copy flimsy scroll to vellum scroll/take sack/empty zipper into sack/put flimsy scroll in zipper/close zipper/drop zipper/take 12/blorple 12/e/z/z/z/take knife/z/z/z/z/z/z/cast girgol/take 12/put sack in tesseract/z",
    "grammar" : "answer/reply/respon;bathe/swim/wade;brief;call/say/talk;cavort/gambol/hop/skip;chase/follow/pursue;concea/hide;damn/fuck/shit;debark/disemb;depart/exit/withdr;diagno;dive/jump/leap;enter;fly;gaze/l/look/stare;girgol;hello/hi;help/hint;i/invent;jindak;land;leave;lesoch;listen;lurk/drool/gurgle/saliva/slaver;move/shift/go/procee/run/step/walk;nap/snooze/sleep;no/nope;okay/y/yes;q/quit;restar;restor;rise/stand;save;score;scream/shout/yell;script;smell/sniff;snavig;spells;super/superb;t/time;thank/thanks;unscri;verbos;versio;wait/z;where;who;yawn;admire/compli OBJ;answer/reply/respon OBJ;ask/query/quiz about OBJ;ask/query/quiz for OBJ;assaul/attack/fight/hit/strike OBJ;awake/rouse/startl/surpri/wake OBJ;awake/rouse/startl/surpri/wake up OBJ;bargai/haggle with OBJ;bathe/swim/wade in OBJ;beckon/wave OBJ;beckon/wave to OBJ;beckon/wave/scream/shout/yell at OBJ;bite OBJ;blorpl OBJ;blow out OBJ;blow up OBJ;board/embark/ride OBJ;break/crack/destro/scratc/smash/wreck OBJ;bury/plant OBJ;call/say/talk to OBJ;carry/catch/get/grab/hold/snatch/take OBJ;carry/catch/get/grab/hold/snatch/take off OBJ;carry/catch/get/grab/hold/snatch/take out OBJ;caskly OBJ;cast/incant/invoke OBJ;chase/follow/pursue OBJ;check/descri/examin/inspec/observ/watch OBJ;check/descri/examin/inspec/observ/watch/gaze/l/look/stare in OBJ;check/descri/examin/inspec/observ/watch/gaze/l/look/stare on OBJ;check/descri/examin/inspec/observ/watch/gaze/l/look/stare/rummag/search for OBJ;climb/scale OBJ;climb/scale down OBJ;climb/scale off OBJ;climb/scale out OBJ;climb/scale over OBJ;climb/scale up OBJ;climb/scale/carry/catch/get/grab/hold/snatch/take on OBJ;climb/scale/medita/rest/sit/carry/catch/get/grab/hold/snatch/take in OBJ;close/shut/zip OBJ;concea/hide OBJ;concea/hide behind OBJ;concea/hide from OBJ;concea/hide in OBJ;concea/hide under OBJ;consum/eat/gobble/taste OBJ;copy OBJ;count OBJ;cross/ford/traver OBJ;debark/disemb OBJ;depart/exit/withdr OBJ;descen OBJ;dig/excava in OBJ;dig/excava throug OBJ;dig/excava with OBJ;dive/jump/leap across OBJ;dive/jump/leap down OBJ;dive/jump/leap from OBJ;dive/jump/leap in OBJ;dive/jump/leap off OBJ;dive/jump/leap on OBJ;dive/jump/leap to OBJ;dive/jump/leap/go/procee/run/step/walk over OBJ;drag/pull/tug down OBJ;drag/pull/tug on OBJ;drink/sip/swallo OBJ;drink/sip/swallo from OBJ;drop/dump/releas OBJ;empty/pour/spill OBJ;enter OBJ;erase OBJ;espnis OBJ;exting OBJ;feel/pat/pet/rub/touch OBJ;fill OBJ;find OBJ;fire/shoot OBJ;fit/insert/lay/place/put/stuff/wedge down OBJ;fit/insert/lay/place/put/stuff/wedge on OBJ;fix/patch/repair OBJ;flip/set/turn OBJ;flip/set/turn off OBJ;flip/set/turn on OBJ;flip/set/turn over OBJ;fly OBJ;forget/unlear OBJ;free/unatta/unfast/untie OBJ;frotz OBJ;gaze/l/look/stare OBJ;gaze/l/look/stare around OBJ;gaze/l/look/stare at OBJ;gaze/l/look/stare behind OBJ;gaze/l/look/stare down OBJ;gaze/l/look/stare throug OBJ;gaze/l/look/stare under OBJ;gaze/l/look/stare up OBJ;gestur/point at OBJ;gestur/point to OBJ;girgol OBJ;gnusto OBJ;go/procee/run/step/walk OBJ;go/procee/run/step/walk around OBJ;go/procee/run/step/walk down OBJ;go/procee/run/step/walk in OBJ;go/procee/run/step/walk on OBJ;go/procee/run/step/walk throug OBJ;go/procee/run/step/walk to OBJ;go/procee/run/step/walk up OBJ;hello/hi OBJ;help/hint OBJ;inflat OBJ;inscri/print/scribe/write OBJ;inscri/print/scribe/write in OBJ;inscri/print/scribe/write on OBJ;jindak OBJ;kick OBJ;kill/murder/slay/stab OBJ;kiss OBJ;knock/rap at OBJ;knock/rap down OBJ;knock/rap on OBJ;label OBJ;lean on OBJ;learn/memori OBJ;leave OBJ;lesoch OBJ;lie down OBJ;lie on OBJ;lift/raise OBJ;lift/raise up OBJ;liskon OBJ;listen for OBJ;listen to OBJ;lower OBJ;lurk behind OBJ;lurk in OBJ;malyon OBJ;medita/rest/sit at OBJ;medita/rest/sit down OBJ;medita/rest/sit on OBJ;move/shift/drag/pull/tug OBJ;nap/snooze/sleep in OBJ;nap/snooze/sleep on OBJ;open/unzip OBJ;open/unzip up OBJ;pay OBJ;pick OBJ;pick up OBJ;play OBJ;press/push/shove OBJ;press/push/shove on OBJ;pump up OBJ;rattle/shake OBJ;reach in OBJ;read OBJ;read about OBJ;remove/shed OBJ;rezrov OBJ;rise/stand on OBJ;rise/stand/carry/catch/get/grab/hold/snatch/take up OBJ;roll up OBJ;rotate/spin/whirl OBJ;rummag/search OBJ;rummag/search in OBJ;send for OBJ;smell/sniff OBJ;snavig OBJ;squeez OBJ;swing/thrust OBJ;tell OBJ;tell about OBJ;thank/thanks OBJ;throck OBJ;tinsot OBJ;tortur OBJ;trade OBJ;wait/z for OBJ;wear OBJ;what OBJ;where OBJ;who OBJ;yomin OBJ;apply OBJ to OBJ;ask/query/quiz OBJ about OBJ;ask/query/quiz OBJ for OBJ;assaul/attack/fight/hit/strike OBJ with OBJ;attach/fasten/tie OBJ to OBJ;attach/fasten/tie up OBJ with OBJ;beckon/wave OBJ at OBJ;blind/jab/poke OBJ with OBJ;block/clog/plug OBJ with OBJ;break/crack/destro/scratc/smash/wreck OBJ with OBJ;break/crack/destro/scratc/smash/wreck down OBJ with OBJ;burn/ignite OBJ with OBJ;burn/ignite down OBJ with OBJ;bury/plant OBJ in OBJ;buy/purcha OBJ from OBJ;buy/purcha OBJ with OBJ;carry/catch/get/grab/hold/snatch/take OBJ from OBJ;carry/catch/get/grab/hold/snatch/take OBJ in OBJ;carry/catch/get/grab/hold/snatch/take OBJ off OBJ;carry/catch/get/grab/hold/snatch/take OBJ out OBJ;cast/incant/invoke OBJ at OBJ;cast/incant/invoke OBJ on OBJ;compar OBJ to OBJ;compar OBJ with OBJ;concea/hide OBJ from OBJ;copy OBJ on OBJ;copy OBJ to OBJ;copy OBJ with OBJ;count OBJ in OBJ;cut/divide/prune/sever/slash/slice/split OBJ with OBJ;cut/divide/prune/sever/slash/slice/split throug OBJ with OBJ;dig/excava OBJ with OBJ;dig/excava in OBJ with OBJ;drop/dump/releas/fit/insert/lay/place/put/stuff/wedge OBJ down OBJ;drop/dump/releas/fit/insert/lay/place/put/stuff/wedge OBJ in OBJ;empty/pour/spill OBJ from OBJ;empty/pour/spill OBJ in OBJ;empty/pour/spill OBJ on OBJ;feed/give/hand/offer OBJ OBJ;feed/give/hand/offer OBJ for OBJ;feed/give/hand/offer OBJ to OBJ;feed/give/hand/offer OBJ with OBJ;feel/pat/pet/rub/touch OBJ to OBJ;feel/pat/pet/rub/touch OBJ with OBJ;fill OBJ at OBJ;fill OBJ with OBJ;fit/insert/lay/place/put/stuff/wedge OBJ across OBJ;fit/insert/lay/place/put/stuff/wedge OBJ behind OBJ;fit/insert/lay/place/put/stuff/wedge OBJ on OBJ;fit/insert/lay/place/put/stuff/wedge OBJ over OBJ;fit/insert/lay/place/put/stuff/wedge OBJ under OBJ;fix/patch/repair OBJ with OBJ;flip/set/turn OBJ to OBJ;flip/set/turn OBJ with OBJ;free/unatta/unfast/untie OBJ from OBJ;gaze/l/look/stare at OBJ throug OBJ;gaze/l/look/stare up OBJ in OBJ;hurl/pitch/throw/toss OBJ at OBJ;hurl/pitch/throw/toss OBJ down OBJ;hurl/pitch/throw/toss OBJ in OBJ;hurl/pitch/throw/toss OBJ off OBJ;hurl/pitch/throw/toss OBJ on OBJ;hurl/pitch/throw/toss OBJ over OBJ;hurl/pitch/throw/toss OBJ throug OBJ;hurl/pitch/throw/toss OBJ to OBJ;inscri/print/scribe/write OBJ in OBJ;inscri/print/scribe/write OBJ on OBJ;inscri/print/scribe/write in OBJ with OBJ;inscri/print/scribe/write on OBJ with OBJ;kill/murder/slay/stab OBJ with OBJ;label OBJ with OBJ;lock OBJ with OBJ;lower OBJ down OBJ;lower OBJ in OBJ;melt/thaw OBJ with OBJ;open/unzip OBJ with OBJ;pay OBJ OBJ;pay OBJ to OBJ;pay OBJ with OBJ;pick OBJ with OBJ;press/push/shove OBJ OBJ;press/push/shove OBJ to OBJ;pry OBJ with OBJ;pry out OBJ with OBJ;pump up OBJ with OBJ;rattle/shake OBJ at OBJ;read OBJ throug OBJ;read about OBJ in OBJ;sell OBJ OBJ;sell OBJ to OBJ;sharpe OBJ with OBJ;show OBJ OBJ;show OBJ to OBJ;slide/press/push/shove OBJ under OBJ;squeez/drop/dump/releas OBJ on OBJ;swing/thrust OBJ at OBJ;tell OBJ OBJ;tell OBJ about OBJ;trade OBJ for OBJ;trade OBJ with OBJ;unlock OBJ with OBJ;",
    "max_word_length" : 6
}

spirit = {
    "name": "spirit",
    "rom": "spirit.z5",
    "seed" : 0,
    "walkthrough" : "z/z/z/z/z/read note/take pallet/n/w/w/take sand/w/n/n/wear amulet/read prayer/learn frotz/cast frotz on amulet/learn frotz/cast frotz on amulet/s/s/e/e/e/e/e/s/take scroll/read scroll/gnusto espnis/read diary/n/w/s/read page/n/n/read journal/push west wall/w/take scroll/read scroll/gnusto foblub/read faded/e/s/w/w/u/e/ne/open window/sw/e/read scriptures/consult scriptures about planes/w/w/d/d/e/n/read paper/s/e/take flour/move barrel/open trapdoor/w/w/u/w/w/s/s/drop all/drop amulet/e/u/w/yell/take scroll/read scroll/enter window/sw/w/d/w/w/s/s/take all/wear amulet/gnusto swanko/s/s/w/d/put pallet on boulder/u/climb tree/shake branch/d/d/take egg/u/e/s/s/throw sand/s/s/s/s/se/push dusty s/n/push moldy s/n/push filthy s/push dusty s/n/push moldy s/n/push filthy s/n/n/take key/x floorboards/move floorboards/s/s/push dusty n/s/push moldy n/s/push filthy n/push filthy n/s/push dusty s/n/push moldy s/n/n/unlock icebox with square key/open icebox/open blue box/take scroll/read scroll/gnusto zemdor/learn zemdor/zemdor blue box/open royal-blue box/take wrapper/open wrapper/read notice/drop notice/open navy-blue box/take whistle/take crunchy cereal/take packet/take butter/hit board/u/s/s/push moldy n/s/push dusty n/n/nw/sw/search couch/take coin/x clock/turn knob/turn knob/turn knob/turn knob/turn knob/turn knob/take clock/take ledger/read ledger/read subway/open door/s/ask governor about key/take key/n/ne/s/d/put coin in slot/se/z/e/learn espnis/spells/espnis thug/search seat/take newspaper/read newspaper/read news in newspaper/read sports in newspaper/read features in newspaper/drop newspaper/w/d/z/z/s/search seat/z/n/n/u/e/e/e/se/e/touch waterfall/e/put egg in pot/put flour in pot/put butter in pot/put packet in pot/put whistle in pot/put shiny in pot/put cereal in pot/put volcano in pot/put clock in pot/put ledger in pot/take pot/take small key/w/n/take glasses/search fountain/s/w/s/unlock toolshed with small key/drop small key/drop glasses/open toolshed/take all from toolshed/wear gloves/wear cap/read cracked/drop cracked/n/n/clip monster/drop cap/drop clipper/s/nw/w/s/look in telescope/open telescope/take scroll/read scroll/gnusto fiznav/n/w/s/ask delbin about ale/ask morgan about dragon/offer coin to delbin/learn zemdor/zemdor ale/take rag/take headdress/put rag in pot/put headdress in pot/n/w/d/put coin in slot/s/z/z/s/z/z/n/u/w/learn foblub/foblub yupple/search seat/z/z/z/z/z/z/z/e/ne/u/n/take scroll/read scroll/gnusto gloth/w/n/n/w/take flat key/e/e/read history book/look up index in history book/look up trophy in history book/w/n/w/search mess/take all/put cube in pot/put decaf in pot/e/n/w/unlock northern door with flat key/drop flat key/open northern door/n/open book/read book/take card/s/e/n/n/turn on switch/open notebook/take term paper/read term paper/s/s/s/e/take scroll/read scroll/w/show card to librarian/drop card/w/gnusto taclor/n/e/e/e/read journal/w/read research paper/w/w/s/s/s/s/e/s/d/put coin in slot/sw/z/z/z/z/z/z/w/z/z/z/z/z/z/e/ne/u/ne/ne/n/z/show term paper to frobar/read scroll/gnusto feeyuk/e/read journal/read twisted/w/s/sw/sw/w/take toy/put toy in pot/s/take coin/read sign/take clock/pull knob/turn knob/push knob/turn knob/turn knob/read scroll/gnusto wigro/drop clock/n/w/sw/sw/take scroll/read muddy scroll/gnusto throck/s/s/x natives/x shaman/take headdress/give headdress to shaman/n/read map/search grass/drop map/n/ne/ne/e/e/d/put coin in slot/sw/z/z/z/w/z/z/z/e/ne/u/take umbrella/se/s/z/l/take coin/s/e/e/d/take scroll/read gray scroll/gnusto tossio/give gloves to zombie/take wire/u/w/w/n/n/nw/d/put coin in slot/put wire in slot/drop wire/sw/d/s/z/z/z/z/z/z/n/u/e/z/z/z/z/z/z/z/z/z/z/w/nw/u/n/w/take rag/ask skier about scroll/give rag to skier/take scroll/read waxy scroll/gnusto egdelp/e/s/d/put coin in slot/se/e/z/z/z/z/z/z/w/nw/u/sw/sw/w/take scroll/read spotted scroll/gnusto bekdab/learn bekdab/gnusto bekdab/x hermit/take cereal/give cereal to hermit/ask hermit about exit/ask hermit about entrance/s/read parchment/drop parchment/ne/ask farmer about oyster/e/e/se/nw/w/take sack/x boat/enter boat/take volcano/s/drop volcano in water/n/exit/n/s/x boat/learn fiznav/fiznav boat/enter boat/s/ne/exit/learn swanko/e/swanko spirit/take gray rod/put gray rod in pot/w/enter boat/sw/n/exit/w/put silver sphere in pot/ne/n/read memo/open fur sack/put coins in fur sack/take all from basis/put coins in fur sack/take coin from basis/put coin in interest/take coin from basis/put coin in loans/take seven coins from basis/put six coins in overhead/s/d/put coin in slot/se/e/z/z/w/d/z/z/z/z/z/z/s/z/z/n/n/u/e/e/e/se/n/learn throck/throck shrub/take dornberries/put dornberries in pot/s/nw/w/nw/read sign/n/n/learn foblub/foblub man/n/take scroll/read pale scroll/gnusto shazok/n/learn egdelp/egdelp golem/learn tossio/tossio golem/learn bekdab/bekdab golem/learn taclor/taclor me/s/x coach/ask coach for trophy/s/s/s/s/sw/s/ask delbin about minirva/n/w/d/take coin/put coin in slot/s/z/s/z/z/z/z/z/z/z/z/z/z/n/u/ne/u/se/ne/x treant/gnusto shazok/learn shazok/shazok storm/put red sphere in pot/sw/s/s/e/e/e/n/take pan/s/take sticker/read sticker/drop sticker/take flour from pot/put flour in pan/take butter from pot/put butter in pan/take packet from pot/put packet in pan/take sugar from pot/put sugar in pan/take egg from pot/put egg in pan/take berries from pot/put berries in pan/mix pan/learn gloth/gloth dough/open oven/put pan in oven/close oven/turn dial/turn dial/turn dial/turn dial/turn dial/turn dial/turn dial/turn dial/push button/open oven/take pan/w/w/w/n/n/nw/d/take coin/take wire/put coin in slot/put wire in slot/drop wire/sw/d/z/z/z/z/s/z/z/z/z/z/z/n/u/nw/u/s/read sign/give pan to guard/s/w/read sign/d/learn feeyuk/feeyuk me/learn feeyuk/feeyuk me/take ebony/w/w/s/s/take ebony/w/e/take balsa beam from northern niche/put ebony in northern niche/n/n/take ebony/w/e/take balsa beam/put ebony in southern niche/s/s/take ebony/take beam from southern niche/put ebony in southern niche/s/s/take beam from eastern niche/put ebony in eastern niche/learn swanko/e/e/swanko spirit/take smoke rod/put smoke rod in pot/enter hole/u/e/s/e/take key/unlock cabinet with shiny key/drop shiny key/open cabinet/learn egdelp/egdelp cabinet/open cabinet/look in cabinet/take crumpled scroll/read crumpled scroll/gnusto ledak/read warped/d/s/take ledger/show ledger to magistrate/x sydney/take toy/give toy to sydney/ask sydney for hat/put brown sphere in pot/drop red hat/n/n/e/s/take vase/n/n/n/x painting/take whistle/blow whistle/drop whistle/take door/s/w/n/n/d/take coin/put coin in slot/se/d/z/z/z/z/z/s/z/z/z/z/z/z/n/u/w/z/z/e/ne/u/n/e/learn ledak/drop door/open door/e/u/n/w/read journal/w/ledak painting/take painting/e/e/s/d/w/search painting/read white scroll/gnusto huncho/drop painting/w/n/n/nw/n/take coin/n/n/drop balsa wood beam/take red flag/take red flag/put red flag on speckled/put red flag on spotted/x cage/pull lever/yes/n/nw/learn taclor/taclor kobold/take green sphere/put green sphere in pot/se/ne/n/n/e/e/e/read torn/w/n/n/u/e/put trophy in depression/take trophy/w/w/put trophy in depression/take trophy/e/s/put trophy in depression/take trophy/n/n/put trophy in depression/learn swanko/s/swanko spirit/take white rod/put white rod in pot/d/s/s/w/w/s/s/sw/s/s/s/s/se/s/s/w/n/n/n/n/e/e/x dials/set left dial to 7/set center dial to 3/set right dial to 4/push button/s/x contraption/stand on disc/sw/sw/s/take briefcase/s/open briefcase/take red scroll/read red scroll/gnusto luncho/drop briefcase/w/z/z/z/z/z/z/z/z/z/z/e/ne/u/w/w/sw/sw/s/w/n/e/push statue w/push statue n/push statue n/n/e/put vase in opening/w/u/e/open umbrella/put umbrella on pool/w/learn swanko/u/swanko spirit/drop all/drop amulet/e/take black rod/put black rod in hole/w/take all/wear amulet/d/d/e/learn huncho/huncho vase/w/s/s/s/e/n/ne/ne/e/e/d/put coin in slot/sw/z/z/w/z/z/z/z/z/z/e/ne/u/n/w/n/n/n/n/e/e/s/stand on disc/se/se/read ripped/sw/sw/take black rod/take smoke rod/take white rod/take gray rod/learn huncho/l/huncho me/take decaf from pot/e/take can/drop decaf/w/listen/listen/enter curtain/z/z/z/z/exit/listen/open door/w/x machine/yes/drop can/x implementor/wake implementor/ne/n/l/enter square/take scrawled/w/n/n/n/n/n/n/n/read scrawled/drop scrawled/s/e/e/d/e/e/d/e/se/read blackened/take silver rod/push purple/jump/z/z/put silver rod in top/take green rod/push purple/say minirva/drop green rod/take red rod/push purple/put red rod in hole/z/take brown rod/push purple/take dusty brick/e/take thick brick/drop dusty brick/put brown rod in hole/x dusty brick/x hole/break wall/take all but parchment/wear amulet/nw/w/u/w/w/u/w/w/s/s/s/s/search snow/search top/take silver rod/s/s/s/s/s/s/s/d/take coin/put coin in slot/se/z/z/z/e/z/z/z/z/z/z/w/nw/u/s/enter boat/s/se/exit/s/search wreck/take green rod/n/enter boat/nw/n/exit/n/d/take coin/put coin in slot/se/z/e/z/z/z/w/d/s/z/z/n/n/u/e/ne/push statue/l/take red rod/sw/w/d/sw/w/d/take coin/put coin in slot/s/s/z/z/z/z/z/z/z/z/z/z/n/u/ne/u/se/s/s/e/e/d/search foundation/l/take brown rod/join red rod to silver rod/join golden rod to green rod/join golden rod to brown rod/take all from pot/throw red at smoke/throw silver at white/throw green at gray/throw brown at black",
    "grammar" : "awake/awaken/wake;awake/awaken/wake up;beg;bellow/scream/yell;bother/curses/darn/drat;brief/normal;c,cast;carry/get/hold/take inventory;carry/get/hold/take off;carry/get/hold/take out;chants/memory/spells;chuckle/laugh;close/cover/shut up;cough/sneeze;damn/fuck/shit/sod;diagnose/health/status;die/q/quit;dive/swim;exit/out/outside/stand;full/fullscore;full/fullscore score;go/leave/run/walk;hear/listen;help/hint;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;long/verbose;meditate;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;plover/plugh/treasure/xyzzy/yoho;pray;restart;restore;save;score;script;script off;script on;short/superbrie;sing;smell/sniff;sorry;stand/carry/get/hold/take up;think;verify;version;wait/z;wave;y/yes;yawn;adjust/set OBJ;attach/fasten/fix/tie OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;c,cast OBJ;carry/get/hold/take OBJ;carry/get/hold/take off OBJ;cast/chant OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale over OBJ;climb/scale up OBJ;clip/trim/chop/cut/prune/slice OBJ;close/cover/shut OBJ;cross/enter/go/leave/run/walk OBJ;damn/fuck/shit/sod OBJ;dig OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;fold OBJ;go/leave/run/walk through OBJ;go/leave/run/walk/carry/get/hold/take into OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;l/look at OBJ;l/look in OBJ;l/look inside OBJ;l/look into OBJ;l/look through OBJ;l/look under OBJ;lie/sit/go/leave/run/walk inside OBJ;lie/sit/go/leave/run/walk/carry/get/hold/take in OBJ;lie/sit/stand/carry/get/hold/take on OBJ;mix/stir OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;play/blow OBJ;put OBJ down;put down OBJ;put on OBJ;read/check/describe/examine/watch/x OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;shake/yank OBJ;smell/sniff OBJ;squash/squeeze OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;taste OBJ;wave OBJ;adjust/set OBJ to OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;burn/light OBJ with OBJ;carry/get/hold/take OBJ off OBJ;cast/chant OBJ at OBJ;cast/chant OBJ on OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;connect/join OBJ to OBJ;connect/join OBJ with OBJ;dig OBJ with OBJ;discard/drop/throw OBJ against OBJ;discard/drop/throw OBJ at OBJ;discard/drop/throw OBJ down OBJ;discard/drop/throw/insert/put OBJ in OBJ;discard/drop/throw/insert/put OBJ into OBJ;discard/drop/throw/put OBJ on OBJ;discard/drop/throw/put OBJ onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ into OBJ;empty OBJ on OBJ;empty OBJ onto OBJ;empty OBJ to OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;lock OBJ with OBJ;put OBJ inside OBJ;remove/carry/get/hold/take OBJ from OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

temple = {
    "name": "temple",
    "rom": "temple.z5",
    "seed" : 0,
    "walkthrough" : "x me/x shadow/x shape/pull railing/x statue/d/x paper/take paper/x table/x writing/x man/touch man/x books/x dust/x desk/d/x door/u/s/take vial/take vial/take vial/n/d/stand on charles/unlock door with key/open door/s/x tower/sw/x sandstone/x temple/ask charles about temple/w/x crack/n/x carvings/n/x carvings/x skeleton/take note/x note/show note to charles/x skeleton/x torn clothes/take book/x book/x vial/x mukhtar/s/s/w/n/s/s/x cat/x slabs/search slabs/move slab/d/d/x carvings/x blocks/n/n/x trapdoor/e/e/x stove/x kettle/x rack/x chest/w/w/s/s/s/ask charles about chest/u/n/e/e/s/x mural/listen/s/x huge statue/n/n/ne/n/u/put mukhtar on table/read writing/x paper/x old man/z/z/z/x mukhtar/x writing/x horriblis/x statue/d/s/sw/w/w/s/d/d/n/n/e/e/take yellow powder/put yellow powder in kettle/take red powder/put red powder in kettle/take kettle/put kettle on stove/turn on stove/draw symbol on me/take bottle/w/w/x thing/throw bottle at thing/w/yell/s/z/z/e/e/look under stove/unlock chest with brass key/open chest/take all from chest/x crowbar/x photograph/w/w/move stone/s/show photograph to charles/s/s/u/throw iron key at cat/take iron key/n/e/e/listen to wall/x wall/x door/open door/e/x device/x column/x bulbs/x lever/pull lever/z/z/z/z/enter cloud/pull lever/w/s/s/z/z/z/z/z/z/z/z",
    "grammar" : "about/clue/help/hint;awake/awaken/wake;awake/awaken/wake up;bother/curses/darn/drat;brief/normal;carry/get/hold/take inventory;carry/get/hold/take off;carry/get/hold/take out;chant/recite/sing;close/cover/shut up;damn/fuck/shit/sod;die/q/quit;dive/swim;draw/paint/sketch epsilon;draw/paint/sketch sign;draw/paint/sketch symbol;exit/out/outside/stand;frotz/gnusto/plugh/rezrov/xyzzy;full/fullscore;full/fullscore score;go/leave/run/walk;hear/listen;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;long/verbose;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;pray;restart;restore;save;score;scream/yell/shout;script;script off;script on;short/superbrie;smell/sniff;sorry;stand/carry/get/hold/take up;think;verify;version;wait/z;walkthrou/walkthru;wave;y/yes;adjust/set OBJ;ask OBJ for help;attach/fasten/fix/tie OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;bang/knock OBJ;bang/knock OBJ down;bang/knock OBJ out;bang/knock OBJ over;bang/knock at OBJ;bang/knock down OBJ;bang/knock on OBJ;bang/knock out OBJ;bang/knock over OBJ;blow OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;carry/get/hold/take OBJ;carry/get/hold/take off OBJ;chant/recite/sing OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale over OBJ;climb/scale up OBJ;close/cover/shut OBJ;cross/enter/go/leave/run/walk OBJ;damn/fuck/shit/sod OBJ;dig OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;draw/paint/sketch OBJ;draw/paint/sketch epsilon on OBJ;draw/paint/sketch sign on OBJ;draw/paint/sketch symbol on OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;follow OBJ;go/leave/run/walk through OBJ;go/leave/run/walk/carry/get/hold/take into OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;kick/attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;l/look at OBJ;l/look in OBJ;l/look inside OBJ;l/look into OBJ;l/look through OBJ;l/look under OBJ;lie/sit/go/leave/run/walk inside OBJ;lie/sit/go/leave/run/walk/carry/get/hold/take in OBJ;lie/sit/stand/carry/get/hold/take on OBJ;lift OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;put OBJ down;put down OBJ;put on OBJ;read/check/describe/examine/watch/x OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;smell/sniff OBJ;squash/squeeze OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;taste OBJ;think about OBJ;wave OBJ;adjust/set OBJ to OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;burn/light OBJ with OBJ;carry/get/hold/take OBJ off OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;dig OBJ with OBJ;discard/drop/throw OBJ against OBJ;discard/drop/throw OBJ at OBJ;discard/drop/throw OBJ down OBJ;discard/drop/throw/insert/put OBJ in OBJ;discard/drop/throw/insert/put OBJ into OBJ;discard/drop/throw/put OBJ on OBJ;discard/drop/throw/put OBJ onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;draw/paint/sketch OBJ on OBJ;empty OBJ into OBJ;empty OBJ on OBJ;empty OBJ onto OBJ;empty OBJ to OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;lock OBJ with OBJ;put OBJ inside OBJ;remove/carry/get/hold/take OBJ from OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

theatre = {
    "name": "theatre",
    "rom": "theatre.z5",
    "seed" : 0,
    "walkthrough" : "nw/d/take all/examine panel/turn on switch/x barrels/get popcorn/get popcorn/get popcorn/get popcorn/u/se/s/n/x thug/z/z/z/z/n/drop all but pager/nw/drop pager/n/get all/w/w/s/w/push piano east/push piano south/climb up piano/open trapdoor/u/get all/n/turn handle/n/get lens/s/s/d/n/n/e/e/n/move carpet/get all/examine body/read book/n/get all/n/open bin/get page/get ticket/sw/s/s/s/se/drop all but lens/u/open door/e/s/open curtains/ne/w/d/put lens in spotlight/get lens/get ticket/u/e/n/push chandelier/drop ticket/e/e/u/go chandelier/nw/get all/s/w/n/get page/get page/s/s/n/unhook chain/push bookcase/s/x nest/get blue/w/u/get crow/d/climb down chimney/open coffin/d/open chest/get bottle/get lump/clean lump/get key/u/u/e/s/w/get mask/break bottle/get mask/e/s/s/climb piano/u/n/wear mask/n/put lens in telescope/drop mask/look in telescope/s/s/d/n/n/n/n/open cabinet/get page/get tablets/get stethoscope/get vial/read letter/s/s/e/e/s/wear stethoscope/turn dial left/turn dial right/turn dial left/turn dial right/drop stethoscope/open desk/get page/get plans/examine plans/drop plans/kick south wall/s/get page/examine skeleton/x rags/x watch/pull dial/turn dial/turn dial/turn dial/turn dial/n/se/drop all/u/get all/n/get all/s/e/n/drop ticket/n/n/drop ticket/get page/examine rope/climb rope/w/open locker/push locker east/d/read newspaper/wear amulet/s/s/e/e/take picture/drop camera/e/nw/examine items/get green/get page/se/w/w/n/se/s/w/d/get all/ne/examine hooks/pull clean hook/d/get page/d/unlock door with key/open door/drop key/e/get page/pour liquid on body/throw body in pit/drop vial/d/e/get page/sw/d/show violet to trent/show blue to trent/show red to trent/show green to trent/u/ne/se/drop popcorn/e/drop popcorn/e/drop popcorn/se/drop popcorn/nw/w/n/examine lever/wait/pull lever/s/e/se/se/get page/put control in top socket/put mana in bottom socket/put strength in right socket/put wisdom in left socket/get dagger/nw/drop amulet/nw/w/w/nw/sw/d/examine dagger/get earth crystal/show earth crystal to trent/show star crystal to trent/put star crystal in dagger/ask trent about elizabeth/drop all/get dagger/get tablets/u/ne/ne/ne/y/n/n/give tablets to trent/get star/d/throw star at young woman//nw/d/u/se/s/enter car",
    "grammar" : "abra cadabra;agaliarep/echo/plover/plugh/xyzzy/yoho;answer/say/shout/speak/whisper;awake/awaken/wake;awake/awaken/wake up;bother/curses/darn/drat;brief/normal;carry/get/take inventory;carry/get/take off;carry/get/take out;close/cover/shut up;cls/dir/ls;credits/version;damn/fuck/shit/sod;die/q/quit;dig;dive/swim;exit/out/outside/stand;full/fullscore;full/fullscore score;go/leave/run/walk;hear/listen;hello/hi/howdy;help/hint/hints/instructi;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;l/look around;l/look down;l/look up;lie/sit down on;long/verbose;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;open/uncover/undo/unwrap sesame;places;pray;prompt/prompting;restart;restore;save;score;script;script off;script on;short/superbrie;sing;smell/sniff;sorry;stand in;stand/carry/get/take up;think;time;verify;wait/z;wave;y/yes;adjust/set OBJ;answer/say/shout/speak/whisper OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;board/mount/ride OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;carry/get/take OBJ;carry/get/take in to OBJ;carry/get/take off OBJ;check/describe/examine/watch/x OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale out OBJ;climb/scale out of OBJ;climb/scale over OBJ;close/cover/shut OBJ;connect/hook/attach/fasten/fix/tie OBJ;cross/enter/go/leave/run/walk OBJ;damn/fuck/shit/sod OBJ;damn/fuck/shit/sod OBJ;descend OBJ;dig OBJ;discard/drop OBJ;discharge/drain/pour/spill OBJ;disconnec/unattach/unhook/untie OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;flick/flip OBJ;go/leave/run/walk through OBJ;go/leave/run/walk/carry/get/take/carry/get/take into OBJ;grab hold of OBJ;grab/peel/remove OBJ;hear/listen OBJ;hear/listen to OBJ;help/hint/hints/instructi OBJ;hold on OBJ;hold on to OBJ;hold onto OBJ;hop/jump/skip over OBJ;kick in OBJ;kick/tear/attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;knock OBJ;knock on OBJ;l/look at OBJ;l/look behind OBJ;l/look down OBJ;l/look in OBJ;l/look inside OBJ;l/look through OBJ;l/look under OBJ;l/look/l/look into OBJ;lie/sit/go/leave/run/walk/stand inside OBJ;lie/sit/go/leave/run/walk/stand/carry/get/take in OBJ;lie/sit/stand/carry/get/take on OBJ;open/uncover/undo/unwrap OBJ;peel off OBJ;photograp OBJ;pick OBJ up;pick up OBJ;play/practice OBJ;put OBJ down;put down OBJ;put on OBJ;read OBJ;rotate/screw/turn/twist/unscrew OBJ;rotate/screw/turn/twist/unscrew OBJ left;rotate/screw/turn/twist/unscrew OBJ right;rotate/screw/turn/twist/unscrew OBJ to left;rotate/screw/turn/twist/unscrew OBJ to right;rotate/screw/turn/twist/unscrew OBJ to the left;rotate/screw/turn/twist/unscrew OBJ to the right;search OBJ;shinny/slide/climb/scale/go/leave/run/walk down OBJ;shinny/slide/climb/scale/go/leave/run/walk up OBJ;smell/sniff OBJ;squash/squeeze OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;talk to OBJ;taste OBJ;wave OBJ;wind OBJ;ask OBJ for OBJ;biff/chuck/throw OBJ against OBJ;biff/chuck/throw OBJ at OBJ;biff/chuck/throw OBJ in OBJ;biff/chuck/throw OBJ into OBJ;burn/light OBJ with OBJ;carry/get/take OBJ off OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;connect/hook/attach/fasten/fix/tie OBJ onto OBJ;connect/hook/attach/fasten/fix/tie OBJ to OBJ;dig OBJ with OBJ;discard/drop OBJ down OBJ;discard/drop/insert/put OBJ in OBJ;discard/drop/insert/put OBJ into OBJ;discard/drop/put OBJ on OBJ;discard/drop/put OBJ onto OBJ;discharge/drain/pour/spill OBJ in OBJ;discharge/drain/pour/spill OBJ into OBJ;discharge/drain/pour/spill OBJ on OBJ;discharge/drain/pour/spill OBJ on to OBJ;discharge/drain/pour/spill OBJ onto OBJ;discharge/drain/pour/spill OBJ over OBJ;disconnec/unattach/unhook/untie OBJ from OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ into OBJ;empty OBJ on OBJ;empty OBJ onto OBJ;empty OBJ to OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;l/look at OBJ through OBJ;lock OBJ with OBJ;photograp OBJ with OBJ;put OBJ inside OBJ;remove/carry/get/take OBJ from OBJ;rotate/screw/turn/twist/unscrew/adjust/set OBJ to OBJ;search/check/describe/examine/watch/x OBJ through OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

trinity = {
    "name": "trinity",
    "rom": "trinity.z4",
    "seed" : 0,
    "walkthrough" : "i/examine watch/take coin/examine coin/e/examine memorial/examine blossoms/take ball/nw/examine sundial/examine gnomon/unscrew gnomon/take gnomon/nw/examine woman/examine pigeons/buy bag/take bag/take coin/feed birds/take ruby/ask woman about roadrunner/ask woman about ruby/e/examine boats/take bird/examine bird/open bird/read paper/nw/examine pram/open pram/look in pram/push pram east/examine boy/push pram east/examine woman/throw ball at umbrella/take umbrella/push pram south/examine notice/e/enter pram/open umbrella/take all but pram/examine statue/examine missile/e/e/i/fold paper/examine meteor/put paper in pocket/put coin in pocket/examine watch/take card/read card/put card in pocket/n/examine toadstools/ne/examine log/take log/examine splinter/take splinter/e/drop bag/drop umbrella/u/u/examine shadow/examine sundial/examine symbols/examine rose/examine hole/examine ring/put gnomon in hole/d/d/s/sw/e/examine sculpture/reach in sculpture/n/u/take axe/examine axe/s/d/w/ne/n/u/u/put gnomon in hole/push lever/turn ring/d/d/s/sw/e/n/u/s/d/w/ne/n/nw/examine flytrap/e/examine tree/examine chasm/examine mesa/examine toadstool/chop tree/push tree north/sw/e/drop axe/take umbrella/w/w/examine waterfall/w/enter waterfall/search waterfall/w/examine icicles/hit icicle with umbrella/take icicle/e/e/e/u/u/d/d/ne/e/e/put icicle on lump/take lump/examine lump/w/w/examine hive/sw/drop lump/drop umbrella/w/w/n/examine crypt/read crypt/open crypt/examine statues/examine barrow/n/examine wight/examine hole/examine door/n/examine bones/search bones/take key/examine key/s/put key in hole/turn key/d/e/e/n/n/examine boy/examine bubble/examine wand/examine dish/examine headphones/talk to boy/se/ne/examine cottage/knock on door/open door/e/examine map/examine cauldron/look in cauldron/smell/examine book/read book/examine pedestal/turn page/read book/examine magpie/examine cage/wait/wait/wait/wait/wait/wait/wait/wait/open cage/take cage/open back door/e/examine herbs/examine fence/examine thyme/take thyme/examine refuse/search refuse/take garlic/examine garlic/examine toadstool/examine white door/w/w/se/w/put hand in hive/w/w/examine flytrap/e/e/put hand in hive/e/nw/e/put honey in cauldron/put hand in cauldron/w/se/sw/w/drop garlic/drop birdcage/drop splinter/take umbrella/u/u/turn ring to sixth symbol/d/d/e/e/enter door/open umbrella/take all/examine teachers/examine children/e/examine spade/take spade/w/wait/give umbrella to girl/e/give paper to girl/w/ride bird/enter door/w/w/w/w/n/open lid with spade/look in crypt/examine corpse/examine bandage/take bandage/examine mouth/take silver coin/examine silver coin/put silver coin in pocket/examine boots/take boots/wear boots/examine shroud/take shroud/examine corpse/kiss corpse/s/e/e/drop shroud/drop bandage/drop spade/take splinter/u/u/turn ring to third symbol/d/d/w/w/n/n/n/enter door/examine cylinder/take lantern/w/turn on lantern/drop lantern/w/put splinter into crevice/take skink/put skink in pocket/e/take all/e/e/s/turn key/d/e/e/e/turn off lantern/drop lantern/examine walkie/drop walkie/take axe/take lump/u/u/turn ring to second symbol/d/d/nw/n/enter dish/z/z/s/sw/enter door/take skink/kill skink/examine satellite/examine stars/examine door/break bubble with axe/e/e/drop skink/drop axe/u/u/turn ring to fourth symbol/d/d/nw/e/n/enter door/d/open box/examine switch/push switch/push button/s/nw/examine islet/examine tree/w/examine crabs/examine fin/look/w/examine coconuts/point at coconut/examine tide/examine tide/examine tide/point to coconut/take coconut/se/n/u/enter door/s/w/se/take axe/take skink/take garlic/ne/e/nw/e/drop coconut/cut coconut with axe/take coconut/pour milk in cauldron/put skink in cauldron/put garlic in cauldron/w/z/e/look in cauldron/examine emerald/take emerald/put emerald in green boot/w/se/w/sw/drop coconut/drop axe/take cage/u/u/turn ring to fifth symbol/d/d/ne/e/nw/e/e/enter white door/d/ne/ne/look in fissure/take lemming/put lemming in cage/close cage/sw/sw/u/enter door/examine lemming/w/w/se/w/sw/take shroud/wear shroud/take walkie/take lantern/take bag/u/u/turn ring to seventh symbol/d/d/se/z/z/enter dory/give silver coin to oarsman/s/drop shroud/enter door/open book/take slip/examine slip/examine diagram/drop slip/w/d/d/take ruby/put ruby in red boot/nw/nw/nw/open jeep/in/examine radio/examine dial/set slider to 31/pull antenna/turn on walkie/out/se/se/se/se/se/open gate/se/s/open door/e/take knife/e/n/n/close door/open cage/open door/drop cage/s/search workbench/take screwdriver/open front door/e/e/se/u/drop walkie/drop bag/d/ne/u/turn on lantern/take binoculars/d/take all but lantern/u/u/take all/s/w/w/sw/sw/s/look through binoculars at shelter/wait/point to key/take key/examine thin man/n/n/n/n/unlock box with key/examine panel/pull breaker/close breaker/sw/sw/sw/sw/examine dog/examine searchlight/drop bag/ne/ne/ne/ne/u/u/e/examine enclosure/examine panel/unscrew panel/look in panel/turn on bulb/look in panel/wait/wait/wait/wait/wait/wait/wait/wait/wait/wait/wait/wait/wait/wait/wait/wait/cut blue wire/i/e/take ball/nw/examine sundial/turn gnomon/take gnomon/nw/ask woman about roadrunner/ask woman about ruby/give card to woman/buy bag/take bag/take coin/feed birds/take ruby/e/examine boats/take paper bird/open bird/read paper/examine watch/nw/open pram/push pram e/take dish/push pram e/examine woman/",
    "grammar" : "brief;diagnose;duck;fly;gaze/l/look/peek/peer/stare;go/back/retreat/advance/crawl/hike/hop/jog/proceed/run/saunter/skip/step/stroll/tramp/trudge/walk;hint/hints/aid/help/pray;i/inventory;loiter/wait/z;nap/rest/sleep/snooze;notify;q/quit;restart;restore;rise/stand;save;score;script;super/superbrie;surface;t/time;thank/thanks;unscript;verbose;version;aid/help/save OBJ;answer OBJ;approach OBJ;arouse/frighten/scare/startle/surprise OBJ;ask/interroga/query/question/quiz OBJ;ask/interroga/query/question/quiz about OBJ;ask/interroga/query/question/quiz for OBJ;awake/awaken/rouse/wake OBJ;awake/awaken/rouse/wake up OBJ;bandage OBJ;bathe/swim/wade OBJ;bathe/swim/wade in OBJ;bathe/swim/wade over OBJ;bathe/swim/wade through OBJ;bathe/swim/wade to OBJ;bathe/swim/wade under OBJ;bathe/swim/wade up OBJ;bathe/swim/wade/dive down OBJ;bite OBJ;blow in OBJ;blow on OBJ;blow out OBJ;blow through OBJ;blow up OBJ;board/mount OBJ;bounce/dribble OBJ;bounce/dribble around OBJ;bound/hurdle/jump/leap/vault OBJ;bound/hurdle/jump/leap/vault from OBJ;bound/hurdle/jump/leap/vault in OBJ;bound/hurdle/jump/leap/vault off OBJ;bound/hurdle/jump/leap/vault over OBJ;bound/hurdle/jump/leap/vault through OBJ;bound/hurdle/jump/leap/vault to OBJ;bound/hurdle/jump/leap/vault up OBJ;bow/genuflect/grovel/kneel before OBJ;bow/genuflect/grovel/kneel to OBJ;breathe in OBJ;breathe out OBJ;breathe/hypervent/inhale OBJ;browse/leaf/read/skim OBJ;browse/leaf/read/skim through OBJ;brush/clean/polish/smear/sweep/wipe OBJ;brush/clean/polish/smear/sweep/wipe off OBJ;buy OBJ;bye/farewell/goodbye OBJ;call/maybe/proclaim/say/speak/talk/utter OBJ;call/maybe/proclaim/say/speak/talk/utter to OBJ;carry/catch/confiscat/grab/keep/seize/snatch/steal/take down OBJ;carry/catch/confiscat/grab/keep/seize/snatch/steal/take off OBJ;carry/catch/confiscat/grab/keep/seize/snatch/steal/take up OBJ;cavort/fiddle/play/toy OBJ;cavort/fiddle/play/toy with OBJ;chase/follow/pursue OBJ;check/describe/examine/inspect/see/study/survey/trace OBJ;check/describe/examine/inspect/see/study/survey/trace on OBJ;check/describe/examine/inspect/see/study/survey/trace/gaze/l/look/peek/peer/stare in OBJ;check/describe/examine/inspect/see/study/survey/trace/gaze/l/look/peek/peer/stare/frisk/ransack/rummage/search/sift for OBJ;chuck/fling/hurl/pitch/throw/toss away OBJ;clear/empty OBJ;clear/empty off OBJ;clear/empty/shake out OBJ;climb through OBJ;climb under OBJ;climb/get in OBJ;climb/get on OBJ;climb/go/bound/hurdle/jump/leap/vault/advance/crawl/hike/hop/jog/proceed/run/saunter/skip/step/stroll/tramp/trudge/walk out OBJ;climb/go/scale/advance/crawl/hike/hop/jog/proceed/run/saunter/skip/step/stroll/tramp/trudge/walk down OBJ;climb/go/scale/advance/crawl/hike/hop/jog/proceed/run/saunter/skip/step/stroll/tramp/trudge/walk up OBJ;climb/scale over OBJ;climb/scale/ascend OBJ;close/shut/slam OBJ;close/shut/slam/flip/rotate/toggle/turn/twist off OBJ;consume/devour/eat/gobble/ingest/nibble/swallow OBJ;count/tabulate/tally OBJ;cross/traverse OBJ;crouch/settle/sit/squat OBJ;crouch/settle/sit/squat at OBJ;crouch/settle/sit/squat down OBJ;crouch/settle/sit/squat in OBJ;crouch/settle/sit/squat on OBJ;crumple/crush/squash/squeeze/squish OBJ;defile/hump/molest/rape/ravish OBJ;deflate OBJ;depart/exit/scram/withdraw/disembark OBJ;descend OBJ;detach/disconnec/disengage/unattach/unplug OBJ;detonate/explode/fire OBJ;disassemb/open/unseal OBJ;disassemb/open/unseal up OBJ;discover/find/seek OBJ;disembark from OBJ;disembark out OBJ;dislocate/move/roll/shift OBJ;dispatch/kill/murder/punch/slay/stab/vanquish/wound OBJ;disrobe/strip/undress OBJ;dive OBJ;dive in OBJ;dive over OBJ;dive under OBJ;don/wear OBJ;douse/extinguis/quench/snuff OBJ;drag/pull/tug/yank OBJ;drag/pull/tug/yank on OBJ;drag/pull/tug/yank out OBJ;dress OBJ;drink/guzzle/imbibe/quaff/sip/swill OBJ;drink/guzzle/imbibe/quaff/sip/swill from OBJ;drive OBJ;drop/dump OBJ;duck/hide/rise/stand under OBJ;elevate/hoist/lift/raise OBJ;elevate/hoist/lift/raise up OBJ;embark on OBJ;embark/enter OBJ;employ/exploit/operate/use OBJ;escape/flee OBJ;escape/flee from OBJ;exhale OBJ;extend/unflatten/unfold OBJ;fasten/secure/tie OBJ;feel/grope/reach in OBJ;flatten out OBJ;flip/rotate/toggle/turn/twist around OBJ;flip/rotate/toggle/turn/twist down OBJ;flip/rotate/toggle/turn/twist on OBJ;flip/rotate/toggle/turn/twist over OBJ;flip/rotate/toggle/turn/twist through OBJ;flip/rotate/toggle/turn/twist to OBJ;flush OBJ;fly OBJ;fly on OBJ;fly over OBJ;fly with OBJ;focus on OBJ;focus/adjust OBJ;fold/wrap out OBJ;fold/wrap up OBJ;fold/wrap/flatten OBJ;frisk/ransack/rummage/search/sift OBJ;frisk/ransack/rummage/search/sift in OBJ;frisk/ransack/rummage/search/sift through OBJ;gaze/l/look/peek/peer/stare OBJ;gaze/l/look/peek/peer/stare around OBJ;gaze/l/look/peek/peer/stare at OBJ;gaze/l/look/peek/peer/stare behind OBJ;gaze/l/look/peek/peer/stare down OBJ;gaze/l/look/peek/peer/stare on OBJ;gaze/l/look/peek/peer/stare out OBJ;gaze/l/look/peek/peer/stare over OBJ;gaze/l/look/peek/peer/stare through OBJ;gaze/l/look/peek/peer/stare to OBJ;gaze/l/look/peek/peer/stare up OBJ;gaze/l/look/peek/peer/stare/frisk/ransack/rummage/search/sift under OBJ;get down OBJ;get off OBJ;get out OBJ;get under OBJ;get up OBJ;get/hold/carry/catch/confiscat/grab/keep/seize/snatch/steal/take OBJ;go/advance/crawl/hike/hop/jog/proceed/run/saunter/skip/step/stroll/tramp/trudge/walk OBJ;go/advance/crawl/hike/hop/jog/proceed/run/saunter/skip/step/stroll/tramp/trudge/walk around OBJ;go/advance/crawl/hike/hop/jog/proceed/run/saunter/skip/step/stroll/tramp/trudge/walk behind OBJ;go/advance/crawl/hike/hop/jog/proceed/run/saunter/skip/step/stroll/tramp/trudge/walk in OBJ;go/advance/crawl/hike/hop/jog/proceed/run/saunter/skip/step/stroll/tramp/trudge/walk through OBJ;go/advance/crawl/hike/hop/jog/proceed/run/saunter/skip/step/stroll/tramp/trudge/walk to OBJ;go/advance/crawl/hike/hop/jog/proceed/run/saunter/skip/step/stroll/tramp/trudge/walk under OBJ;go/cross/traverse/advance/crawl/hike/hop/jog/proceed/run/saunter/skip/step/stroll/tramp/trudge/walk over OBJ;go/get/back/retreat/escape/flee/advance/crawl/hike/hop/jog/proceed/run/saunter/skip/step/stroll/tramp/trudge/walk away OBJ;go/retreat/advance/crawl/hike/hop/jog/proceed/run/saunter/skip/step/stroll/tramp/trudge/walk from OBJ;go/rise/stand/bound/hurdle/jump/leap/vault/advance/crawl/hike/hop/jog/proceed/run/saunter/skip/step/stroll/tramp/trudge/walk on OBJ;greet/greetings/hello/hi/salute/affirmati/aye/naw/nay/negative/no/nope/ok/okay/positive/positivel/sure/y/yes/yup OBJ;grope/reach through OBJ;hear OBJ;heel OBJ;hide OBJ;hide behind OBJ;hide in OBJ;hold down OBJ;hold on OBJ;hold up OBJ;hold/carry/catch/confiscat/grab/keep/seize/snatch/steal/take/drag/pull/tug/yank apart OBJ;howl/scream/shout/yell OBJ;howl/scream/shout/yell at OBJ;howl/scream/shout/yell to OBJ;inflate/blow OBJ;insert/lay/place/put/stash/stuff down OBJ;insert/lay/place/put/stash/stuff on OBJ;insert/lay/place/put/stash/stuff out OBJ;kick OBJ;kick around OBJ;kick in OBJ;kick/stamp/trample down OBJ;kiss/smooch OBJ;knock/pound/rap at OBJ;knock/pound/rap on OBJ;lean on OBJ;leave OBJ;let go OBJ;lick/taste OBJ;lie/recline/repose down OBJ;lie/recline/repose in OBJ;lie/recline/repose on OBJ;listen OBJ;listen for OBJ;listen in OBJ;listen to OBJ;loiter/wait/z for OBJ;lower OBJ;make OBJ;make up OBJ;melt OBJ;nap/rest/sleep/snooze in OBJ;nap/rest/sleep/snooze on OBJ;nudge/press/push/shove/stick/thrust OBJ;nudge/press/push/shove/stick/thrust in OBJ;nudge/press/push/shove/stick/thrust on OBJ;nudge/press/push/shove/stick/thrust/drag/pull/tug/yank down OBJ;nudge/press/push/shove/stick/thrust/drag/pull/tug/yank up OBJ;observe/watch OBJ;pee/urinate/piss OBJ;pee/urinate/piss on OBJ;pet/pat/feel/disturb/rub/touch OBJ;pick up OBJ;piss off OBJ;plug in OBJ;pocket OBJ;point OBJ;point at OBJ;point to OBJ;pour/spill/sprinkle OBJ;pour/spill/sprinkle out OBJ;preserve/rescue OBJ;refuse OBJ;remove OBJ;replace OBJ;reply/respond/retort to OBJ;retract OBJ;ride OBJ;ride in OBJ;ride on OBJ;rip/tear off OBJ;rise/stand in OBJ;rise/stand up OBJ;set off OBJ;shoot OBJ;shoot off OBJ;slide OBJ;slide/bound/hurdle/jump/leap/vault down OBJ;smell/sniff/whiff OBJ;spin/whirl OBJ;stamp/trample on OBJ;stamp/trample over OBJ;start OBJ;stop OBJ;suck OBJ;suck in OBJ;suck on OBJ;swing OBJ;swing on OBJ;tell OBJ;thank/thanks OBJ;undo/unfasten/unhook/untie OBJ;untangle OBJ;wave OBJ;wave/beckon/grin/laugh/motion/nod/smile/sneer at OBJ;wave/beckon/grin/laugh/motion/nod/smile/sneer to OBJ;what/what's/whats OBJ;what/what's/whats about OBJ;where/where's/wheres OBJ;who/who's/whos OBJ;wind OBJ;wind up OBJ;wish for OBJ;ask/interroga/query/question/quiz OBJ about OBJ;ask/interroga/query/question/quiz OBJ for OBJ;assault/attack/fight/hurt/injure OBJ with OBJ;attach/connect OBJ to OBJ;bestow/deliver/donate/give/hand/offer/present OBJ OBJ;bestow/deliver/donate/give/hand/offer/present OBJ to OBJ;blind/jab/poke OBJ with OBJ;block/cover/shield OBJ with OBJ;block/cover/shield over OBJ with OBJ;block/cover/shield up OBJ with OBJ;break/crack/crumble/damage/demolish/destroy/erase/smash/trash/wreck OBJ off OBJ;break/crack/crumble/damage/demolish/destroy/erase/smash/trash/wreck OBJ with OBJ;break/crack/crumble/damage/demolish/destroy/erase/smash/trash/wreck down OBJ with OBJ;break/crack/crumble/damage/demolish/destroy/erase/smash/trash/wreck in OBJ with OBJ;break/crack/crumble/damage/demolish/destroy/erase/smash/trash/wreck through OBJ with OBJ;bribe/entice/pay/renumerat OBJ with OBJ;browse/leaf/read/skim OBJ through OBJ;browse/leaf/read/skim OBJ to OBJ;brush/clean/polish/smear/sweep/wipe OBJ off OBJ;brush/clean/polish/smear/sweep/wipe OBJ on OBJ;brush/clean/polish/smear/sweep/wipe OBJ over OBJ;brush/clean/polish/smear/sweep/wipe off OBJ on OBJ;brush/clean/polish/smear/sweep/wipe off OBJ over OBJ;burn/char/combust/cremate/ignite/incinerat/kindle/scorch OBJ with OBJ;burn/char/combust/cremate/ignite/incinerat/kindle/scorch down OBJ with OBJ;burn/char/combust/cremate/ignite/incinerat/kindle/scorch up OBJ with OBJ;burst/pop OBJ with OBJ;buy OBJ from OBJ;buy OBJ with OBJ;charge OBJ with OBJ;check/describe/examine/inspect/see/study/survey/trace OBJ through OBJ;check/describe/examine/inspect/see/study/survey/trace OBJ with OBJ;chop/cleave/cut/gash/lacerate/sever/slash/slice/split down OBJ with OBJ;chop/cleave/cut/gash/lacerate/sever/slash/slice/split through OBJ with OBJ;chop/cleave/cut/gash/lacerate/sever/slash/slice/split up OBJ with OBJ;chuck/fling/hurl/pitch/throw/toss OBJ OBJ;chuck/fling/hurl/pitch/throw/toss OBJ at OBJ;chuck/fling/hurl/pitch/throw/toss OBJ down OBJ;chuck/fling/hurl/pitch/throw/toss OBJ in OBJ;chuck/fling/hurl/pitch/throw/toss OBJ off OBJ;chuck/fling/hurl/pitch/throw/toss OBJ on OBJ;chuck/fling/hurl/pitch/throw/toss OBJ over OBJ;chuck/fling/hurl/pitch/throw/toss OBJ through OBJ;chuck/fling/hurl/pitch/throw/toss OBJ to OBJ;clear/empty OBJ from OBJ;clear/empty OBJ out OBJ;clear/empty out OBJ from OBJ;clear/empty/pour/spill/sprinkle OBJ in OBJ;clear/empty/pour/spill/sprinkle OBJ on OBJ;clear/empty/pour/spill/sprinkle out OBJ on OBJ;clear/empty/shake/pour/spill/sprinkle out OBJ in OBJ;conceal OBJ in OBJ;conceal/hide OBJ behind OBJ;conceal/hide OBJ under OBJ;crumple/crush/squash/squeeze/squish OBJ on OBJ;detach/disconnec/disengage/unattach/unplug OBJ from OBJ;dig/excavate OBJ with OBJ;dig/excavate at OBJ with OBJ;dig/excavate through OBJ with OBJ;dig/excavate up OBJ with OBJ;dig/excavate with OBJ in OBJ;dig/excavate/dig/excavate in OBJ with OBJ;disassemb/open/unseal OBJ with OBJ;disassemb/open/unseal up OBJ with OBJ;dispatch/kill/murder/punch/slay/stab/vanquish/wound OBJ with OBJ;display/show OBJ OBJ;display/show OBJ to OBJ;disturb/rub/touch OBJ to OBJ;disturb/rub/touch OBJ with OBJ;drag/pull/tug/yank OBJ out OBJ;drag/pull/tug/yank OBJ with OBJ;drag/pull/tug/yank down OBJ with OBJ;drag/pull/tug/yank on OBJ with OBJ;drag/pull/tug/yank up OBJ with OBJ;drop/dump OBJ down OBJ;drop/dump OBJ in OBJ;drop/dump OBJ on OBJ;fasten/secure/tie OBJ to OBJ;fasten/secure/tie up OBJ with OBJ;feed OBJ OBJ;feed OBJ to OBJ;feed OBJ with OBJ;fell/chop/cleave/cut/gash/lacerate/sever/slash/slice/split OBJ with OBJ;fill OBJ at OBJ;fill OBJ with OBJ;fix up OBJ with OBJ;fix/repair/service OBJ with OBJ;flash/shine OBJ at OBJ;flash/shine OBJ in OBJ;flash/shine OBJ on OBJ;flash/shine OBJ over OBJ;flip/rotate/toggle/turn/twist OBJ OBJ;flip/rotate/toggle/turn/twist OBJ with OBJ;flip/rotate/toggle/turn/twist/dial/tune/change/set OBJ to OBJ;focus OBJ at OBJ;focus OBJ on OBJ;fold/wrap OBJ in OBJ;fold/wrap/wind OBJ around OBJ;fold/wrap/wind up OBJ in OBJ;force/wedge OBJ in OBJ;force/wedge/elevate/hoist/lift/raise up OBJ with OBJ;force/wedge/nudge/press/push/shove/stick/thrust/dislocate/move/roll/shift/elevate/hoist/lift/raise OBJ with OBJ;free/release OBJ from OBJ;free/release OBJ with OBJ;gaze/l/look/peek/peer/stare at OBJ through OBJ;gaze/l/look/peek/peer/stare at OBJ with OBJ;gaze/l/look/peek/peer/stare in OBJ through OBJ;gaze/l/look/peek/peer/stare in OBJ with OBJ;gaze/l/look/peek/peer/stare through OBJ at OBJ;get/bring OBJ OBJ;get/bring OBJ for OBJ;get/bring OBJ to OBJ;get/carry/catch/confiscat/grab/keep/seize/snatch/steal/take OBJ from OBJ;get/carry/catch/confiscat/grab/keep/seize/snatch/steal/take OBJ in OBJ;get/carry/catch/confiscat/grab/keep/seize/snatch/steal/take OBJ off OBJ;get/carry/catch/confiscat/grab/keep/seize/snatch/steal/take OBJ on OBJ;get/carry/catch/confiscat/grab/keep/seize/snatch/steal/take OBJ out OBJ;get/carry/catch/confiscat/grab/keep/seize/snatch/steal/take OBJ with OBJ;grope/reach OBJ with OBJ;grope/reach for OBJ with OBJ;grope/reach out OBJ with OBJ;grope/reach to OBJ with OBJ;hit/slap/strike/swat/whack at OBJ with OBJ;hit/slap/strike/swat/whack/knock/pound/rap OBJ with OBJ;hold OBJ against OBJ;hold OBJ in OBJ;hold OBJ on OBJ;hold OBJ over OBJ;hook/jiggle/loosen/wiggle/wobble/pry OBJ with OBJ;illuminat OBJ with OBJ;insert/lay/place/put/stash/stuff OBJ against OBJ;insert/lay/place/put/stash/stuff OBJ behind OBJ;insert/lay/place/put/stash/stuff OBJ down OBJ;insert/lay/place/put/stash/stuff OBJ in OBJ;insert/lay/place/put/stash/stuff OBJ on OBJ;insert/lay/place/put/stash/stuff OBJ over OBJ;insert/lay/place/put/stash/stuff OBJ through OBJ;insert/lay/place/put/stash/stuff OBJ under OBJ;jostle/rattle/shake OBJ with OBJ;knock/pound/rap down OBJ with OBJ;leave OBJ in OBJ;leave OBJ on OBJ;let OBJ go OBJ;light OBJ with OBJ;light up OBJ with OBJ;lock OBJ with OBJ;nudge/press/push/shove/stick/thrust OBJ at OBJ;nudge/press/push/shove/stick/thrust OBJ in OBJ;nudge/press/push/shove/stick/thrust OBJ on OBJ;nudge/press/push/shove/stick/thrust OBJ over OBJ;nudge/press/push/shove/stick/thrust OBJ under OBJ;nudge/press/push/shove/stick/thrust down OBJ with OBJ;nudge/press/push/shove/stick/thrust on OBJ with OBJ;nudge/press/push/shove/stick/thrust/dislocate/move/roll/shift/drag/pull/tug/yank OBJ OBJ;nudge/press/push/shove/stick/thrust/dislocate/move/roll/shift/drag/pull/tug/yank OBJ to OBJ;observe/watch OBJ through OBJ;observe/watch OBJ with OBJ;pick OBJ with OBJ;plug OBJ in OBJ;point at OBJ for OBJ;point out OBJ to OBJ;point to OBJ for OBJ;point/aim OBJ at OBJ;point/aim OBJ to OBJ;point/aim at OBJ with OBJ;pour/spill/sprinkle OBJ from OBJ;pour/spill/sprinkle OBJ out OBJ;pry out OBJ with OBJ;pry up OBJ with OBJ;remove OBJ from OBJ;remove OBJ in OBJ;remove OBJ on OBJ;remove OBJ with OBJ;rip/tear OBJ with OBJ;rip/tear down OBJ with OBJ;rip/tear through OBJ with OBJ;rip/tear up OBJ with OBJ;screw/tighten OBJ in OBJ;screw/tighten OBJ on OBJ;screw/tighten OBJ with OBJ;screw/tighten down OBJ in OBJ;screw/tighten down OBJ on OBJ;screw/tighten down OBJ with OBJ;screw/tighten in OBJ on OBJ;screw/tighten in OBJ with OBJ;sell OBJ OBJ;sell OBJ to OBJ;set OBJ at OBJ;shake/pour/spill/sprinkle out OBJ from OBJ;shine in OBJ with OBJ;shine on OBJ with OBJ;shine over OBJ with OBJ;slide OBJ down OBJ;slide OBJ in OBJ;slide OBJ to OBJ;slide OBJ under OBJ;start OBJ with OBJ;suck OBJ from OBJ;suck OBJ out OBJ;suck out OBJ from OBJ;swing OBJ at OBJ;tell OBJ about OBJ;unlock OBJ with OBJ;unscrew OBJ from OBJ;unscrew OBJ out OBJ;unscrew OBJ with OBJ;wind OBJ in OBJ;work on OBJ with OBJ;",
    "max_word_length" : 9
}

tryst = {
    "name": "tryst205",
    "rom": "tryst205.z5",
    "seed" : 0,
    "walkthrough" : "stand/stand/get gum/n/x gnome/ask george about bag/ask george about beetlebaum/ask george about frank/ask george about gumball/w/open closet/take bag/x bag/open bag/e/x dresser/open drawer/take gloves/wear gloves/s/e/open curtain/get soap/put soap on zipper/open bag/drop soap/remove gloves/drop gloves/w/ne/get bench/s/drop bench/stand on bench/get key/exit/unlock door with key/drop key/open door/s/search clothes/get pack/open closet/get safe/n/ne/x pack/read label/shake pack/put pack on gum/drop pack/get gum/s/chew gum/x paper/get paper/wait/wait/wait/blow dust/blow dust/blow dust/x paper/dehlila/wait/wait/take bag/take safe/ne/x safe/shake safe/open safe/give safe to mark/get key/s/n/w/dehlila/open door/s/get box/unlock box with key/open box/open trapdoor/drop all/d/get gum/chew gum//w/s/w/ne/n/n/n/read sign/w/w/n/look under floorboard/get match/get gum/open box then get cube/x door/tear cloth/w/x stalk/get corn/e/s/s/x jail/w/u/x nest/look in nest/get note/read note/d/e/e/n/get pan/x pan/look in hole/n/x machine/look under table/read green/drop green/s/s/s/x table/x writing/clean table with cloth/x machine/read crumpled/drop crumpled/set first wheel to 9/set second wheel to 2/set third wheel to 8/set fourth wheel to 9/set fifth wheel to 3/x wheels/n/e/s/s/s/sw/sw/x magnetite/put pan in water/shake pan/get gold/drop pan/put cloth in water/sw/s/get sprig/n/ne/ne/ne/n/n/n/w/n/n/x machine/put gold in plate/pull lever/get coin/x coin/s/s/s/x slot/put coin in slot/pull lever/get bottle/open bottle/drop cork/clean table with cloth/drop cloth/read writing/n/e/n/n/open door/x door/x paint splotches/touch red/touch orange/touch yellow/touch blue/touch orange/touch blue/open door/n/enter stall/get shovel/exit/u/get fork/d/e/x grass/search grass/get tin/w/s/s/w/e/s/e/dig plot with shovel/dig plot with shovel/dig plot with shovel/dig plot with shovel/drop shovel/get boots/search boots/read note/give corn to bird/wear boots/w/n/w/w/w/w/get spoon/nw/ne/n/get lantern/s/w/read sign/read book/put cube in cauldron/put gum in cauldron/put sprig in cauldron/mix cauldron with spoon/get gumball/drop spoon/x sketch/ask george about dehlila/ask george about gumball/ask george about town/e/sw/se/e/e/e/drop all/take bottle/take gumball/s/chew gum/drink whiskey/x barkeep/ask barkeep about thad/n/x thad/shoot thad/get boots/wear boots/e/get knife/x knife/w/n/get tin/e/s/s/s/sw/e/open tin/get balm/wear balm/s/x rock/sharpen knife on rock/get berries/eat berries/n/drop tin/w/sw/sw/s/se/cut branch with knife/get stick/nw/n/ne/ne/ne/n/n/n/w/w/n/get gum/s/e/n/chew gum/put gum on stick/put stick in hole/drop stick/get locket/wear locket/s/get all/w/w/w/sw/s/e/u/say wheel/u/say candle/u/say oil/u/get can/d/get candle/d/get wheel/d/d/w/cut rope with knife/drop knife/w/light match/light candle with match/drop match/drop lantern/w/w/ne/look in crack/get piece/open locket/put piece in locket/close locket/ne/w/w/get accordion/e/e/sw/sw/e/e/drop candle/e/e/u/u/u/u/play accordion/d/d/d/d/get rock/x rock/read lettering/w/n/ne/drop boots/nw/ne/w/rub locket/get key/e/sw/se/e/e/e/e/read sign/cuss/s/get bar/wait/wait/wait/wait/wait/wait/wait/wait/wait/wait/wait/wait/wait/wait/open door/n/e/e/s/s/w/move rail with bar/drop bar/e/e/get weeds with fork/drop fork/oil handcar with can/drop can/enter handcar/x handle/move handle/move handle/move handle/move handle/exit/read sign/x door/x wheel/put wheel on peg/read plaque/turn wheel left/turn wheel right/turn wheel right/turn wheel left/turn wheel left/turn wheel left/turn wheel right/open door/s/unlock box with key/drop key/open box/get stick/n/enter car/x lever/pull lever/move handle/move handle/move handle/exit/s/sw/sw/sw/s/sw/w/x pile/put stick in pile/throw rock at stick/rub locket/w/n/n/get blanket/open door/rub locket/w/x cutout/open cover/cover opening with blanket/x frank/x stove/x grille/x flue/x lever/wait/wait/look/e/rub locket/w/pull lever/wait/get watch/get apple/e/untie horse/feed apple to horse/get on horse/x pair/blizzard/x thad/beetlebaum/wait/wait//stand up",
    "grammar" : "awake/awaken/wake;awake/awaken/wake up;beetlebau;blizzard;bother/curses/darn/drat;brief/normal;carry/hold/take inventory;curse/cuss/swear;damn/fuck/shit/sod;dehlila;die/q/quit;dive/swim;exit/out/outside/stand;full/fullscore;full/fullscore score;get out/off/up;hear/listen;help;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;leave/go/run/walk;lift;long/verbose;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;play;pray;restart;restore;save;score;script;script off;script on;shake;short/superbrie;sing;smell/sniff;sneeze;sorry;stand up;think;verify;version;wait/z;wave;xyzzy;y/yes;adjust/set OBJ;answer/say/shout/speak OBJ;attach/fasten/tie OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;blow out OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;carry/hold/take off OBJ;check/describe/examine/watch/x OBJ;chew OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;climb/scale OBJ;climb/scale up/over OBJ;cover/close/shut OBJ;cover/close/shut up OBJ;cover/switch/close/shut off OBJ;cross/enter/go/run/walk OBJ;curse/cuss/swear at OBJ;damn/fuck/shit/sod OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;free/loosen/untie OBJ;get in/into/on/onto OBJ;get off OBJ;get/carry/hold/take OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;jimmy/pry OBJ;kick/attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look under OBJ;leave OBJ;leave/go/run/walk into/in/inside/through OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;lift OBJ;lift up OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pet OBJ;pick OBJ up;pick up OBJ;pitch/discard/drop/throw OBJ;plant OBJ;play OBJ;pump/move/press/push/shift OBJ;put OBJ down;put down OBJ;put on OBJ;read OBJ;ride OBJ;rotate/screw/turn/twist/unscrew OBJ;rotate/screw/turn/twist/unscrew OBJ left;rotate/screw/turn/twist/unscrew OBJ right;scrape OBJ;search OBJ;shake OBJ;shoot OBJ;smell/sniff OBJ;smoke OBJ;squash/squeeze OBJ;stand on OBJ;swing OBJ;swing on OBJ;switch OBJ;switch OBJ off;switch OBJ on;switch on OBJ;taste OBJ;tear OBJ;tear up OBJ;wave OBJ;answer/say/shout/speak OBJ to OBJ;ask OBJ about OBJ;ask OBJ for OBJ;attach/fasten/tie OBJ to OBJ;burn/light OBJ with OBJ;carry/hold/take OBJ off OBJ;chop/cut/prune/slice OBJ with OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ with OBJ;consult OBJ about OBJ;consult OBJ on OBJ;cover OBJ with OBJ;cover up OBJ with OBJ;dig OBJ with OBJ;dig in OBJ with OBJ;dig up OBJ with OBJ;discard/drop/throw OBJ in/into/down OBJ;discard/drop/throw/put OBJ on/onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ to/into/on/onto OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;hone/sharpen OBJ on OBJ;hone/sharpen OBJ with OBJ;insert OBJ in/into OBJ;jimmy/pry OBJ with OBJ;l/look up OBJ in OBJ;lift OBJ with OBJ;lock OBJ with OBJ;mix/stir OBJ with OBJ;move/press/push/shift OBJ OBJ;move/press/push/shift OBJ with OBJ;move/press/push/shift/transfer OBJ to OBJ;oil OBJ with OBJ;pitch/clear OBJ with OBJ;pitch/discard/drop/throw OBJ at/against/on/onto OBJ;plant OBJ in OBJ;poke OBJ with OBJ;put OBJ in/inside/into OBJ;put OBJ over OBJ;remove/get/carry/hold/take OBJ from OBJ;remove/get/carry/hold/take OBJ with OBJ;repair/fix OBJ with OBJ;rotate/screw/turn/twist/unscrew/adjust/set OBJ to OBJ;scrape OBJ with OBJ;scrape off OBJ with OBJ;shoot OBJ with OBJ;tell OBJ about OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

weapon = {
    "name": "weapon",
    "rom": "weapon.z5",
    "seed" : 0,
    "walkthrough" : "touch notch/x studs/x information stud/x powerup stud/touch powerup stud/x project status stud/x generator access/x sequence stud/x forcefield stud/touch information/touch generator/reply/x white pillar/reply/touch panel/reply/x bay/x contact points/touch tool stud/wait/take probe/x probe/ask cheryl for hologram/wear goggles/x generator/x bay/probe contacts/press bottom/wait/touch calibration/take probe/shut panel/press powerup/press project status stud/remove goggles/x status display/x indicator/x studs/press status stud/press bottom/give goggles to cheryl/press sequence stud/x viewscreen/press sequence stud/x studs/x transmit stud/put probe in slab/touch bottom/touch tool stud/touch transmit stud/touch control stud/x rods/cheryl, pull rods/take key/unlock handcuffs with key/remove handcuffs/pull rods/put handcuffs on rods/press information/press forcefield/press ignition/reply/reply/reply/reply/reply/reply/reply/reply/reply/reply/press ignition",
    "grammar" : "about;awake/awaken/wake;awake/awaken/wake up;bother/curses/darn/drat;brief/normal;cackle/chuckle/giggle/laugh/snicker;carry/hold/take inventory;clue/clues/help/hint/hints;clue/clues/help/hint/hints off;damn/fuck/shit/sod;die/q/quit;dive/swim;exit/out/outside/stand;frown/glare;full/fullscore;full/fullscore score;get out/off/up;grin/smile/smirk;hear/listen;hello;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;leave/go/run/walk;long/verbose;lose/win;nap/sleep;no;nod;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;pray;r/reply/respond/answer/say/shout/speak;restart;restore;save;score;script/transcrip;script/transcrip off;script/transcrip on;short/superbrie;sing;smell/sniff;sorry;stand up;t/talk/answer/say/shout/speak;think;verify;version;wait/z;wave;wink;y/yes;activate/trigger OBJ;adjust/set OBJ;approach OBJ;attach/fasten/fix/tie OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;cackle/chuckle/giggle/laugh/snicker at OBJ;carry/hold/take off OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;clear/move/press/push/shift/drag/pull OBJ together;clear/move/press/push/shift/stand by OBJ;clear/move/press/push/shift/stand close to OBJ;clear/move/press/push/shift/stand closer to OBJ;clear/move/press/push/shift/stand near OBJ;clear/move/press/push/shift/stand next to OBJ;climb/scale OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;cross/enter/go/run/walk OBJ;cuff/handcuff OBJ;damn/fuck/shit/sod OBJ;deactivat OBJ;dig OBJ;discard/drop OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;fire/shoot OBJ;frown/glare at OBJ;get in/into/on/onto OBJ;get off OBJ;get/carry/hold/take OBJ;grin/smile/smirk at OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look under OBJ;leave OBJ;leave/go/run/walk into/in/inside/through OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;nod at OBJ;nod to OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;point at OBJ;probe OBJ;put OBJ down;put down OBJ;put on OBJ;r/answer/say/shout/speak OBJ;r/reply/respond to OBJ;read/check/describe/examine/study/watch/x OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;smell/sniff OBJ;squash/squeeze OBJ;stand on OBJ;stand with OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;t OBJ;t/talk/answer/say/shout/speak to OBJ;taste OBJ;throw OBJ;wave OBJ;wink at OBJ;adjust/set OBJ to OBJ;aim/fire/shoot OBJ at OBJ;answer/say/shout/speak OBJ to OBJ;ask OBJ about OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;attach/fasten/fix/tie OBJ with OBJ;burn/light OBJ with OBJ;carry/hold/take OBJ in OBJ;carry/hold/take OBJ near OBJ;carry/hold/take OBJ off OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;consult OBJ about OBJ;consult OBJ on OBJ;dig OBJ with OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ to/into/on/onto OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;feel/fondle/grope/touch OBJ to OBJ;feel/fondle/grope/touch OBJ with OBJ;fire/shoot OBJ with OBJ;insert OBJ in/into OBJ;l/look up OBJ in OBJ;link/drag/pull OBJ with OBJ;lock OBJ with OBJ;point OBJ at OBJ;probe OBJ with OBJ;put OBJ in/inside/into OBJ;read OBJ in OBJ;read about OBJ in OBJ;remove/get/carry/hold/take OBJ from OBJ;tell OBJ about OBJ;throw/discard/drop OBJ at/against/on/onto OBJ;throw/discard/drop OBJ in/into/down OBJ;throw/discard/drop/put OBJ on/onto OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

wishbringer = {
    "name": "wishbringer",
    "rom": "wishbringer.z3",
    "seed" : 0,
    # Walkthrough adapted from http://mirror.ifarchive.org/if-archive/solutions/jgunness.zip
    "walkthrough": "S/WAIT/GET ENVELOPE/N/W/W/YES/N/W/E/D/GET BONE/U/S/E/E/E/GIVE BONE TO POODLE/N/WAIT/GET NOTE/N/LOOK IN FOUNTAIN/GET COIN/N/N/N/N/E/U/W/N/U/E/S/U/OPEN DOOR/IN/WAIT/WAIT/GIVE ENVELOPE TO WOMAN/OPEN ENVELOPE/READ LETTER TO WOMAN/WAIT/GET CAN/WAIT/WAIT/D/N/W/D/S/E/D/BREAK BRANCH/GET IT/W/OPEN CAN/GET CAN/SQUEEZE IT/DROP CAN/GET WISHBRINGER/OPEN GATE/S/S/W/S/LOOK IN PIT/PUT BRANCH IN PIT/GET BRANCH/DROP BRANCH/DIG IN SAND/GET WHISTLE/BLOW IT/W/WAIT/GET HAT/WAIT/BLOW WHISTLE/S/YES/E/D/N/E/PUSH BUNK/DROP ALL/U/GET BLANKET/D/GET ALL/N/E/PUT BLANKET ON GRUE/OPEN FRIDGE/GET WORM/W/W/OPEN STUMP/U/N/E/E/S/OPEN MAILBOX/WAIT/WAIT/WAIT/N/E/GIVE HAT TO PELICAN/W/W/S/Z/Z/S/LOOK IN FOUNTAIN/PUT WORM IN FOUNTAIN/GET TOKEN/E/BUY TICKET/IN/SHOW TICKET TO GRAVEDIGGER/N/EXAMINE FLOOR/GET GLASSES/OUT/OUT/YES/E/WAIT/WAIT/S/PUT TOKEN IN SLOT/PUSH JOYSTICK WEST/AGAIN/PUSH IT SOUTH/AGAIN/PRESS BUTTON/YES/YES/SAY KALUZE/S/WAIT/GIVE NOTE TO MR CRISP/GET COAT/LOOK IN COAT/GET KEY/UNLOCK CHAIN WITH KEY/PULL LEVER/GET NOTE/READ IT/OPEN HATCH/U/U/WEAR GLASSES/GET BROOM/EXAMINE PANEL/PUSH SECOND SWITCH/D/REMOVE GLASSES/PUSH PAINTING/TURN CRANK/N/N/E/ALEXIS, HEEL/OPEN DOOR/IN/GET STEEL KEY/OUT/WAIT/N/UNLOCK DOOR WITH STEEL KEY/IN/WAIT/S/SMASH CASE WITH BROOM/EXAMINE SCULPTURE/INSERT WISHBRINGER IN SCULPTURE/YES/YES/KNOCK ON DOOR",
    "grammar" : "aftern/bye/farewe/goodby/greet/greeti/hello/hi/salute/affirm/aye/naw/nay/negati/no/nope/ok/okay/positi/sure/y/yes/yup;again/g;aid/help/hint/hints/pray;back/advanc/crawl/go/hike/hop/procee/run/skip/step/tramp/trudge/walk;brief;fly;gaze/l/look/peek/peer/stare;heel;i/invent;loiter/wait/z;nap/rest/sleep/snooze;ne/northe/northw/nw/se/southe/southw/sw;q/quit;restar;restor;rise/stand;save;score;script;super/superb;t/time;thank/thanks;unscri;verbos;versio;advanc/crawl/go/hike/hop/procee/run/skip/step/tramp/trudge/walk OBJ;advanc/crawl/go/hike/hop/procee/run/skip/step/tramp/trudge/walk around OBJ;advanc/crawl/go/hike/hop/procee/run/skip/step/tramp/trudge/walk behind OBJ;advanc/crawl/go/hike/hop/procee/run/skip/step/tramp/trudge/walk over OBJ;advanc/crawl/go/hike/hop/procee/run/skip/step/tramp/trudge/walk throug OBJ;advanc/crawl/go/hike/hop/procee/run/skip/step/tramp/trudge/walk to OBJ;advanc/crawl/go/hike/hop/procee/run/skip/step/tramp/trudge/walk under OBJ;affirm/aye/naw/nay/negati/no/nope/ok/okay/positi/sure/y/yes/yup OBJ;aftern/bye/farewe/goodby/greet/greeti/hello/hi/salute OBJ;answer/reply/respon OBJ;answer/reply/respon to OBJ;ask/interr/query/questi/quiz OBJ;assaul/attack/fight/hurt/injure/hit/kill/murder/punch/slap/slay/stab/strike/whack/wound OBJ;awake/awaken/rouse/startl/surpri/wake OBJ;awake/awaken/rouse/startl/surpri/wake up OBJ;bathe/swim/wade OBJ;bathe/swim/wade in OBJ;bathe/swim/wade to OBJ;bite OBJ;blow OBJ;blow in OBJ;blow out OBJ;blow throug OBJ;blow up OBJ;bow/grovel/kneel before OBJ;bow/grovel/kneel to OBJ;break/crack/damage/demoli/destro/erase/smash/trash/wreck OBJ;break/crack/damage/demoli/destro/erase/smash/trash/wreck into OBJ;break/crack/damage/demoli/destro/erase/smash/trash/wreck throug OBJ;brush/clean/sweep OBJ;brush/clean/sweep off OBJ;buy OBJ;call/say/speak/talk/utter OBJ;carry/catch/confis/get/grab/hold/seize/snatch/steal/take OBJ;carry/catch/confis/get/grab/hold/seize/snatch/steal/take off OBJ;carry/catch/confis/get/grab/hold/seize/snatch/steal/take out OBJ;carry/catch/confis/get/grab/hold/seize/snatch/steal/take up OBJ;cavort/fiddle/play/toy OBJ;cavort/fiddle/play/toy with OBJ;chase/follow/pursue OBJ;check/descri/examin/inspec/observ/see/study/survey/watch OBJ;check/descri/examin/inspec/observ/see/study/survey/watch/gaze/l/look/peek/peer/stare in OBJ;check/descri/examin/inspec/observ/see/study/survey/watch/gaze/l/look/peek/peer/stare on OBJ;check/descri/examin/inspec/observ/see/study/survey/watch/gaze/l/look/peek/peer/stare/frisk/ransac/rummag/search for OBJ;climb/scale in OBJ;climb/scale over OBJ;climb/scale under OBJ;climb/scale/advanc/crawl/go/hike/hop/procee/run/skip/step/tramp/trudge/walk down OBJ;climb/scale/advanc/crawl/go/hike/hop/procee/run/skip/step/tramp/trudge/walk up OBJ;climb/scale/ascend OBJ;climb/scale/carry/catch/confis/get/grab/hold/seize/snatch/steal/take on OBJ;climb/scale/dive/jump/leap/advanc/crawl/go/hike/hop/procee/run/skip/step/tramp/trudge/walk out OBJ;close/shut/slam OBJ;concea/hide OBJ;concea/hide behind OBJ;concea/hide under OBJ;consum/devour/eat/gobble/nibble/swallo OBJ;count/tally OBJ;cross/traver OBJ;crush/squash/squeez OBJ;defile/hump/molest/rape/ravish OBJ;depart/exit/scram/withdr OBJ;descen OBJ;detach/free/releas/undo/unfast/unhook/untie OBJ;dig/excava at OBJ;dig/excava in OBJ;dig/excava throug OBJ;dig/excava up OBJ;dig/excava with OBJ;distur/feel/pat/pet/rub/touch OBJ;dive/jump/leap OBJ;dive/jump/leap from OBJ;dive/jump/leap off OBJ;dive/jump/leap over OBJ;dive/jump/leap/advanc/crawl/go/hike/hop/procee/run/skip/step/tramp/trudge/walk in OBJ;dive/jump/leap/rise/stand/advanc/crawl/go/hike/hop/procee/run/skip/step/tramp/trudge/walk on OBJ;don/wear OBJ;douse/exting/quench/snuff OBJ;drag/pull/shove/tug/yank OBJ;drag/pull/shove/tug/yank down OBJ;drag/pull/shove/tug/yank on OBJ;drag/pull/shove/tug/yank up OBJ;drink/guzzle/sip OBJ;drink/guzzle/sip from OBJ;drop/dump OBJ;elevat/hoist/lift/raise OBJ;elevat/hoist/lift/raise up OBJ;employ/exploi/use OBJ;empty OBJ;empty out OBJ;enter OBJ;fill OBJ;find/seek OBJ;flip/set/turn OBJ;flip/set/turn off OBJ;flip/set/turn on OBJ;fly OBJ;fly on OBJ;fly with OBJ;force/insert/lay/place/put/stash/stuff/wedge down OBJ;force/insert/lay/place/put/stash/stuff/wedge on OBJ;force/insert/lay/place/put/stash/stuff/wedge out OBJ;frisk/ransac/rummag/search OBJ;frisk/ransac/rummag/search in OBJ;gaze/l/look/peek/peer/stare OBJ;gaze/l/look/peek/peer/stare around OBJ;gaze/l/look/peek/peer/stare at OBJ;gaze/l/look/peek/peer/stare behind OBJ;gaze/l/look/peek/peer/stare down OBJ;gaze/l/look/peek/peer/stare out OBJ;gaze/l/look/peek/peer/stare throug OBJ;gaze/l/look/peek/peer/stare up OBJ;gaze/l/look/peek/peer/stare/frisk/ransac/rummag/search under OBJ;gestur/point at OBJ;gestur/point to OBJ;grin/laugh/nod/smile/sneer/wave at OBJ;grin/laugh/nod/smile/sneer/wave to OBJ;hear OBJ;howl/scream/shout/yell OBJ;howl/scream/shout/yell at OBJ;howl/scream/shout/yell to OBJ;jostle/rattle/shake OBJ;kick OBJ;kick down OBJ;kick in OBJ;kiss/smooch OBJ;knock/pound/rap at OBJ;knock/pound/rap down OBJ;knock/pound/rap on OBJ;leave OBJ;lie/reclin down OBJ;lie/reclin in OBJ;lie/reclin on OBJ;light OBJ;listen OBJ;listen for OBJ;listen in OBJ;listen to OBJ;loiter/wait/z for OBJ;lower OBJ;move/roll/shift OBJ;nap/rest/sleep/snooze in OBJ;nap/rest/sleep/snooze on OBJ;nudge/press/push/thrust OBJ;nudge/press/push/thrust down OBJ;nudge/press/push/thrust on OBJ;nudge/press/push/thrust up OBJ;open/unseal OBJ;open/unseal up OBJ;pick OBJ;pick up OBJ;pour/spill/sprink OBJ;pour/spill/sprink out OBJ;pray/dream/hope/wish/yearn for OBJ;preser/rescue OBJ;reach in OBJ;read/skim OBJ;remove OBJ;replac OBJ;ride OBJ;ride in OBJ;ride on OBJ;rise/stand under OBJ;rise/stand up OBJ;rotate/spin/whirl OBJ;save/aid/help OBJ;shoot OBJ;sit/squat OBJ;sit/squat at OBJ;sit/squat down OBJ;sit/squat on OBJ;sit/squat/carry/catch/confis/get/grab/hold/seize/snatch/steal/take in OBJ;smell/sniff OBJ;swing OBJ;swing on OBJ;taste OBJ;tell OBJ;thank/thanks OBJ;ask/interr/query/questi/quiz OBJ about OBJ;ask/interr/query/questi/quiz OBJ for OBJ;assaul/attack/fight/hurt/injure OBJ with OBJ;attach/fasten/secure/tie OBJ to OBJ;attach/fasten/secure/tie up OBJ with OBJ;bestow/delive/donate/give/hand/offer/presen/show OBJ OBJ;bestow/delive/donate/give/hand/offer/presen/show OBJ to OBJ;blind/jab/poke OBJ with OBJ;break/crack/damage/demoli/destro/erase/smash/trash/wreck OBJ off OBJ;break/crack/damage/demoli/destro/erase/smash/trash/wreck OBJ with OBJ;break/crack/damage/demoli/destro/erase/smash/trash/wreck down OBJ with OBJ;break/crack/damage/demoli/destro/erase/smash/trash/wreck into OBJ with OBJ;break/crack/damage/demoli/destro/erase/smash/trash/wreck throug OBJ with OBJ;bribe/entice/pay OBJ with OBJ;burn/ignite OBJ with OBJ;burn/ignite down OBJ with OBJ;buy OBJ with OBJ;carry/catch/confis/get/grab/hold/seize/snatch/steal/take OBJ from OBJ;carry/catch/confis/get/grab/hold/seize/snatch/steal/take OBJ in OBJ;carry/catch/confis/get/grab/hold/seize/snatch/steal/take OBJ off OBJ;carry/catch/confis/get/grab/hold/seize/snatch/steal/take OBJ on OBJ;carry/catch/confis/get/grab/hold/seize/snatch/steal/take OBJ out OBJ;check/descri/examin/inspec/observ/see/study/survey/watch OBJ throug OBJ;check/descri/examin/inspec/observ/see/study/survey/watch OBJ with OBJ;chuck/fling/hurl/pitch/throw/toss OBJ at OBJ;chuck/fling/hurl/pitch/throw/toss OBJ down OBJ;chuck/fling/hurl/pitch/throw/toss OBJ in OBJ;chuck/fling/hurl/pitch/throw/toss OBJ off OBJ;chuck/fling/hurl/pitch/throw/toss OBJ on OBJ;chuck/fling/hurl/pitch/throw/toss OBJ over OBJ;chuck/fling/hurl/pitch/throw/toss OBJ throug OBJ;chuck/fling/hurl/pitch/throw/toss OBJ to OBJ;concea/hide OBJ behind OBJ;concea/hide OBJ from OBJ;concea/hide OBJ under OBJ;cover OBJ with OBJ;crush/squash/squeez OBJ on OBJ;cut/rip/slash/tear OBJ with OBJ;cut/rip/slash/tear throug OBJ with OBJ;detach/free/releas/undo/unfast/unhook/untie OBJ from OBJ;detach/free/releas/undo/unfast/unhook/untie OBJ with OBJ;dig/excava OBJ with OBJ;dig/excava in OBJ with OBJ;distur/feel/pat/pet/rub/touch OBJ with OBJ;drag/pull/shove/tug/yank OBJ out OBJ;dream/hope/wish/yearn for OBJ with OBJ;drop/dump OBJ down OBJ;drop/dump OBJ in OBJ;drop/dump OBJ on OBJ;empty OBJ from OBJ;empty OBJ out OBJ;feed OBJ OBJ;feed OBJ to OBJ;feed OBJ with OBJ;fill OBJ at OBJ;fill OBJ with OBJ;flip/set/turn OBJ for OBJ;flip/set/turn OBJ to OBJ;flip/set/turn OBJ with OBJ;force/insert/lay/place/put/stash/stuff/wedge OBJ behind OBJ;force/insert/lay/place/put/stash/stuff/wedge OBJ down OBJ;force/insert/lay/place/put/stash/stuff/wedge OBJ over OBJ;force/insert/lay/place/put/stash/stuff/wedge OBJ under OBJ;gaze/l/look/peek/peer/stare at OBJ throug OBJ;hit/kill/murder/punch/slap/slay/stab/strike/whack/wound OBJ with OBJ;leave/force/insert/lay/place/put/stash/stuff/wedge OBJ in OBJ;leave/force/insert/lay/place/put/stash/stuff/wedge OBJ on OBJ;light OBJ with OBJ;lock OBJ with OBJ;move/roll/shift/nudge/press/push/thrust OBJ OBJ;move/roll/shift/nudge/press/push/thrust OBJ to OBJ;nudge/press/push/thrust OBJ in OBJ;nudge/press/push/thrust OBJ under OBJ;open/unseal OBJ with OBJ;pick OBJ with OBJ;pour/spill/sprink OBJ from OBJ;pour/spill/sprink OBJ in OBJ;pour/spill/sprink OBJ on OBJ;pour/spill/sprink out OBJ into OBJ;read/skim OBJ throug OBJ;read/skim OBJ to OBJ;swing OBJ at OBJ;tell OBJ about OBJ;unlock OBJ with OBJ;",
    "max_word_length" : 6
}

yomomma = {
    "name": "yomomma",
    "rom": "yomomma.z8",
    "seed" : 0,
    "walkthrough" : "d/se/x stranger/sit on chair/insult joe/yes/stand/w/w/insult vincent/norbert/search machines/e/set thermostat to warm/n/ne/x posse/wait/take sweater/remove jacket/wear sweater/wear jacket/sw/w/talk to sleaze/talk to sleaze/talk to sleaze/talk to sleaze/talk to sleaze/point at cola/e/w/take cola/n/give cola to guard/look under sofa/take pass/s/give pass to sleaze/n/search guard/tase sleaze/s/point at cola/point at vodka/pour vodka in cola/n/give cola to britney/talk to britney/se/ne/look under loudspeaker/s/look under jukebox/x knob/turn knob to high/put coin in jukebox/press techno/n/take lens/sw/look under table/n/climb on stage///se/put sweater on table/look at tag through lens/nw/n/climb on stage///norbert/give lens to norbert/sw/insult vincent/sleaze/s/insult vincent/sleaze/n/take card/x card/e/scrape gum with card/e/put gum on ass/put coin in jukebox/push ass/open satchel/x books/x wallet/open wallet/stage//",
    "grammar" : "bother/curses/darn/drat;bust a/some/few move/moves;bust moves/move;carry/hold/take inventory;chat/t/talk;chat/t/talk to;climb/scale down;credits;damn/fuck/shit;eula/terms/copyright/lisence/lisense/licence/license;exit/leave/out/stand;full score;full/score;get out/off/up;go/run/walk;help/info/about;hint/think;hop/jump;i/inv/inventory;jam/dance;l/look;listen;long/verbose;map;no;normal/brief;notify;notify off;notify on;point;point at/to;pronouns/nouns;q/quit;restart;restore;save;short/superbrie;sing;smell/sniff;sorry;stand up;transcrip/script;transcrip/script off;transcrip/script on;verify;version;wait/z;y/yes;abuse/insult/mock/offend/ridicule/slander/taunt OBJ;attack/break/crack/destroy/fight/hit/punch/smash/wreck OBJ;bust a/some/few move/moves with OBJ;bust moves/move with OBJ;buy/order/purchase OBJ;carry/hold/take off OBJ;challenge OBJ;change/switch OBJ;change/switch/rotate/turn/twist OBJ off;change/switch/rotate/turn/twist OBJ on;change/switch/rotate/turn/twist on OBJ;change/switch/rotate/turn/twist/close/shut off OBJ;chat/t/talk OBJ;chat/t/talk to/with OBJ;chew/eat/lick/taste OBJ;chew/eat/lick/taste on OBJ;climb/scale OBJ;climb/scale down/off OBJ;climb/scale down/off from/of OBJ;climb/scale on/up/to OBJ;climb/scale up/over OBJ;close/shut OBJ;close/shut up OBJ;discard/drop/throw OBJ;disrobe/doff/shed/strip/remove OBJ;don/wear OBJ;drink/sip/swallow OBJ;embrace/hug/kiss OBJ;enter/go/run/walk OBJ;feel/touch OBJ;get in/into/on/onto OBJ;get off OBJ;get/carry/hold/take OBJ;go/run/walk into/in/inside/through OBJ;hear OBJ;jam/dance with OBJ;l/look at OBJ;l/look behind OBJ;l/look inside/in/into/through OBJ;l/look thru OBJ;l/look under OBJ;listen to OBJ;move/drag/pull OBJ;open/uncover/unwrap OBJ;pick OBJ up;pick up OBJ;place/put OBJ down;place/put down OBJ;place/put on OBJ;play OBJ;play with OBJ;point OBJ;point at/to OBJ;press/push/shift OBJ;read/check/describe/examine/watch/x OBJ;rotate/turn/twist OBJ;search OBJ;sit on top of OBJ;sit on/in/inside OBJ;smell/sniff OBJ;stand on OBJ;answer/say/shout/speak OBJ to OBJ;ask OBJ about OBJ;ask OBJ for OBJ;ask OBJ for OBJ;carry/hold/take OBJ off OBJ;change/switch/rotate/turn/twist/adjust/set OBJ to OBJ;discard/drop/throw OBJ at/against/on/onto OBJ;discard/drop/throw OBJ in/into/down OBJ;discard/drop/throw/place/put OBJ on/onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;give/offer/pay OBJ OBJ;give/offer/pay OBJ to OBJ;insert OBJ in/into OBJ;jam OBJ with OBJ;l/look at OBJ thru/with/using OBJ;l/look up OBJ in OBJ;lock OBJ with OBJ;mix/pour OBJ into/with/in/to/on/onto OBJ;place/put OBJ in/inside/into OBJ;place/put OBJ under OBJ;read OBJ in OBJ;read about OBJ in OBJ;read/check/describe/examine/watch/x OBJ thru/with/using OBJ;remove/get/carry/hold/take OBJ from OBJ;scrape OBJ off OBJ;scrape/get/carry/hold/take OBJ off with OBJ;scrape/get/carry/hold/take OBJ with OBJ;stun/tase/taze/zap/attack/break/crack/destroy/fight/hit/punch/smash/wreck OBJ with OBJ;tell OBJ about OBJ;unlock/open/uncover/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

zenon = {
    "name": "zenon",
    "rom": "zenon.z5",
    "seed" : 0,
    "walkthrough" : "x bed/look under bed/x key/x gauge/x switch/open guage/push button/push switch/wait/wait/wait/x guard/unlock door with key/open door/s/e/s/x box/open box/take grenade/x grenade/n/w/w/w/s/x panels/x cupboard/open cupboard/pull pin/put grenade in cupboard/wait/wait/x electronics/n/n/x camera/n/d/n/n/x sign/x male/x female/n/ask male about female/ask male about work/ask male about officer/ask male about invitation/ask male about daddy/ask female about male/ask female about bar/e/x sign/x barman/x juke/ask barman about job/x form/w/give form to female/e/give form to barman/w/w/x copier/x table/x officer/ask officer about convention/x invite/open copier/put invite in copier/push button/x copy/e/give copy to male/n/n/e/x button/push button/w/open door/n",
    "grammar" : "awake/awaken/wake;awake/awaken/wake up;bother/curses/darn/drat;brief/normal;carry/hold/take inventory;damn/fuck/shit/sod;die/q/quit;dive/swim;exit/out/outside/stand;full/fullscore;full/fullscore score;get out/off/up;hear/listen;help;hop/jump/skip;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;leave/go/run/walk;long/verbose;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;pray;restart;restore;save;score;script/transcrip;script/transcrip off;script/transcrip on;short/superbrie;sing;smell/sniff;sorry;stand up;think;verify;version;wait/z;wave;y/yes;adjust/set OBJ;attach/fasten/fix/tie OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;blow OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;carry/hold/take off OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale up/over OBJ;close/cover/shut OBJ;close/cover/shut up OBJ;cross/enter/go/run/walk OBJ;damn/fuck/shit/sod OBJ;dig OBJ;discard/drop/throw OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;drag/pull OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;feel/fondle/grope/touch OBJ;fill OBJ;get in/into/on/onto OBJ;get off OBJ;get/carry/hold/take OBJ;hear/listen OBJ;hear/listen to OBJ;hop/jump/skip over OBJ;l/look at OBJ;l/look inside/in/into/through OBJ;l/look under OBJ;leave OBJ;leave/go/run/walk into/in/inside/through OBJ;lie/sit on top of OBJ;lie/sit on/in/inside OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;put OBJ down;put down OBJ;put on OBJ;read/check/describe/examine/watch/x OBJ;rotate/screw/turn/twist/unscrew OBJ;search OBJ;smell/sniff OBJ;squash/squeeze OBJ;stand on OBJ;swing OBJ;swing on OBJ;switch OBJ;switch/rotate/screw/turn/twist/unscrew OBJ off;switch/rotate/screw/turn/twist/unscrew OBJ on;switch/rotate/screw/turn/twist/unscrew on OBJ;switch/rotate/screw/turn/twist/unscrew/close/cover/shut off OBJ;taste OBJ;wave OBJ;adjust/set OBJ to OBJ;answer/say/shout/speak OBJ to OBJ;ask OBJ about OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;burn/light OBJ with OBJ;carry/hold/take OBJ off OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;consult OBJ about OBJ;consult OBJ on OBJ;dig OBJ with OBJ;discard/drop/throw OBJ at/against/on/onto OBJ;discard/drop/throw OBJ in/into/down OBJ;discard/drop/throw/put OBJ on/onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ to/into/on/onto OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;insert OBJ in/into OBJ;l/look up OBJ in OBJ;lock OBJ with OBJ;put OBJ in/inside/into OBJ;read OBJ in OBJ;read about OBJ in OBJ;remove/get/carry/hold/take OBJ from OBJ;tell OBJ about OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}

zork1 = {
    "name": "zork1",
    "rom": "zork1.z5",
    "seed": 12,
    "walkthrough": "N/N/U/Get egg/D/S/E/Open window/W/Open sack/Get garlic/W/Get lamp/E/U/Light lamp/Get rope/Get knife/D/Douse lamp/W/Get sword/Move rug/Open trapdoor/D/Light lamp/N/Kill troll with sword/drop egg/E/E/Se/E/Tie rope to railing/D/Douse lamp/Get torch/D/S/Drop sword/Get candles/Douse candles/Get book/N/Get bell/E/Open coffin/Get sceptre/W/S/Pray/E/S/E/W/W/Read book/Drop all/get torch/get lamp/Open trapdoor/D/N/E/E/Se/E/D/D/D/Get coffin/U/S/Pray/E/S/E/W/W/Open case/Put coffin in case/Get book/Get bell/Get candles/D/S/E/Get painting/W/N/N/E/E/E/Echo/Get bar/U/E/N/Drop painting/Get matchbook/S/S/D/W/S/S/E/D/Ring bell/Get candles/Light match/Light candles with match/Read prayer/Drop matchbook/Drop candles/Drop book/S/get skull/N/U/N/N/N/W/W/S/U/Put skull in case/Put bar in case/D/N/W/W/W/U/Get knife/get bag/Sw/E/S/Se/Odysseus/E/E/Put bag in case/Drop rusty knife/D/N/E/E/N/Ne/E/D/Get pile/U/N/N/Get screwdriver/Get wrench/Press red button/Press yellow button/S/S/Turn bolt with wrench/Drop wrench/W/W/E/Sw/S/S/W/W/S/U/Drop pile/Drop screwdriver/D/N/E/E/S/S/Touch mirror/E/D/Get trident/S/Get pump/S/S/Sw/S/S/W/W/S/U/Put trident in case/Get sceptre/Get pile/D/N/E/E/E/E/E/Drop pile/Inflate pile/Drop pump/Get label/Read label/Drop label/Throw sceptre in boat/Enter boat/Launch/Get sceptre/Wait/Get buoy/Wait/Land/Get out of boat/N/Open buoy/Get emerald/Drop buoy/Get shovel/Ne/Dig sand/Dig sand/Dig sand/Dig sand/Drop shovel/Get scarab/Sw/S/S/Wave sceptre/W/W/Get pot/Sw/U/U/Nw/W/W/W/Put sceptre in case/Put pot in case/Put emerald in case/Put scarab in case/Get rusty knife/Get nasty knife/W/W/U/Kill thief with nasty knife/kill thief with nasty knife/kill thief with nasty knife/attack thief with nasty knife/Get painting/Get egg/Drop rusty knife/Drop nasty knife/Get chalice/D/E/E/Put painting in case/Get canary/Put chalice in case/Put egg in case/E/E/N/N/E/Wind canary/Get bauble/W/S/E/W/W/Put canary in case/Put bauble in case/Get screwdriver/Get garlic/D/N/E/E/S/S/Touch mirror/N/W/N/W/N/E/Put torch in basket/Put screwdriver in basket/Light lamp/N/D/E/Ne/Se/Sw/D/D/S/Get coal/N/U/U/N/E/S/N/U/S/Put coal in basket/Lower basket/N/D/E/Ne/Se/Sw/D/D/W/Drop all/W/Get all from basket/S/Open lid/Put coal in machine/Close lid/Turn switch with screwdriver/Open lid/Get diamond/N/Put diamond in basket/Put torch in basket/Put screwdriver in basket/E/Get lamp/Get garlic/E/U/U/N/E/S/N/Get bracelet/U/S/Raise basket/Get all from basket/W/Get figurine/S/E/S/D/Drop garlic/U/Put diamond in case/Put torch in case/Put bracelet in case/Put figurine in case/W/W/U/take trunk/D/E/E/PUT trunk in case/Look/Get map/Examine map/E/E/N/W/Sw/W",
    "minimal_actions": "Ulysses/wait/pray/inventory/go down/go east/go north/go south/go west/go southeast/go southwest/go northeast/go northwest/launch/leave boat/cross rainbow/drop all/take all/enter house/go up/go up chimney/climb down/climb tree/close lid/dig in sand/drop book/drop buoy/drop coffin/drop garlic/drop knife/drop leaflet/drop pump/drop screwdriver/drop shovel/drop stiletto/drop sword/drop torch/drop wrench/echo/give egg to thief/go in boat/inflate plastic with pump/kill thief with knife/kill troll with sword/light candles with match/light match/look in basket/lower basket/move rug/open bag/open buoy/open case/open coffin/open grate/open lid/open mailbox/open trap door/open window/push yellow button/put bar in case/put bauble in case/put bracelet in case/put canary in case/put chalice in case/put coal in basket/put coal in machine/put coffin in case/put coins in case/put diamond in basket/put diamond in case/put egg in case/put emerald in case/put gold in case/put jade in case/put jewels in case/put painting in case/put scarab in case/put sceptre in case/put screwdriver in basket/put skull in case/put torch in basket/put trident in case/raise basket/read book/read leaflet/ring bell/rub mirror/sand/take bar/take bauble/take bell/take book/take bracelet/take buoy/take canary from egg/take candles/take chalice/take coal/take coffin/take coins/take diamond/take egg/take emerald/take garlic/take gold/take jade/take key/take knife/take lamp/take matches/take painting/take pump/take rope/take scarab/take sceptre/take screwdriver/take shovel/take skull/take sword/take torch/take trident/take trunk/take wrench/tie rope to railing/turn bolt with wrench/turn off lamp/turn on lamp/turn switch with screwdriver/unlock grate/wave sceptre/wind up canary",
    "grammar" : "again/g;answer/reply;back;barf/chomp/lose;bathe/swim/wade;blast;brief;bug;chant/incant;chase/come/follow/pursue;climb/sit;climb/sit;curse/damn/fuck/shit;diagno;dive/jump/leap;echo;enter;exit;froboz;gaze/l/look/stare;hello/hi;hop/skip;i/invent;leave;mumble/sigh;odysse/ulysse;plugh/xyzzy;pray;q/quit;repent;restar;restor;save;say;score;scream/shout/yell;script;stand;stay;super/superb;temple/treasu;unscri;verbos;versio;wait/z;win/winnag;wish;zork;activa OBJ;answer/reply OBJ;ask/tell OBJ;awake/startl/surpri/wake OBJ;awake/startl/surpri/wake up OBJ;banish/begone/cast/drive/exorci OBJ;banish/begone/cast/drive/exorci away OBJ;banish/begone/cast/drive/exorci out OBJ;bathe/swim/wade in OBJ;bite/consum/eat/taste OBJ;block/break/damage/destro/smash in OBJ;blow in OBJ;blow out OBJ;blow up OBJ;board OBJ;brandi/wave OBJ;brush/clean OBJ;carry/catch/get/grab/hold/remove/take OBJ;carry/catch/get/grab/hold/remove/take out OBJ;chase/come/follow/pursue OBJ;climb/sit OBJ;climb/sit/carry/catch/get/grab/hold/remove/take in OBJ;climb/sit/carry/catch/get/grab/hold/remove/take on OBJ;climb/sit/go/procee/run/step/walk down OBJ;climb/sit/go/procee/run/step/walk up OBJ;climb/sit/go/procee/run/step/walk with OBJ;close OBJ;comman OBJ;count OBJ;cross/ford OBJ;curse/damn/fuck/shit OBJ;deflat OBJ;descri/examin/what/whats OBJ;descri/examin/what/whats on OBJ;descri/examin/what/whats/gaze/l/look/stare in OBJ;disemb OBJ;disenc OBJ;dive/jump/leap across OBJ;dive/jump/leap from OBJ;dive/jump/leap in OBJ;dive/jump/leap off OBJ;dive/jump/leap/go/procee/run/step/walk over OBJ;douse/exting OBJ;drink/imbibe/swallo OBJ;drink/imbibe/swallo from OBJ;drop/releas OBJ;enchan OBJ;enter OBJ;exit OBJ;feel/pat/pet/rub/touch OBJ;fill OBJ;find/see/seek/where OBJ;flip/set/shut/turn off OBJ;flip/set/shut/turn on OBJ;free/unatta/unfast/unhook/untie OBJ;gaze/l/look/stare around OBJ;gaze/l/look/stare at OBJ;gaze/l/look/stare behind OBJ;gaze/l/look/stare down OBJ;gaze/l/look/stare on OBJ;gaze/l/look/stare under OBJ;gaze/l/look/stare up OBJ;gaze/l/look/stare with OBJ;gaze/l/look/stare/search for OBJ;go/procee/run/step/walk OBJ;go/procee/run/step/walk around OBJ;go/procee/run/step/walk away OBJ;go/procee/run/step/walk in OBJ;go/procee/run/step/walk on OBJ;go/procee/run/step/walk to OBJ;hatch OBJ;hello/hi OBJ;hide/insert/place/put/stuff down OBJ;hide/insert/place/put/stuff on OBJ;hide/insert/place/put/stuff out OBJ;kick/taunt OBJ;kiss OBJ;knock/rap at OBJ;knock/rap down OBJ;knock/rap on OBJ;launch OBJ;lean on OBJ;leave OBJ;lift/raise OBJ;lift/raise up OBJ;light OBJ;listen for OBJ;listen to OBJ;lower OBJ;make OBJ;molest/rape OBJ;move/roll/pull/tug/yank OBJ;open OBJ;open up OBJ;peal/ring OBJ;pick OBJ;pick up OBJ;play OBJ;pour/spill OBJ;press/push OBJ;press/push on OBJ;pull/tug/yank on OBJ;pump up OBJ;read/skim OBJ;read/skim from OBJ;roll/pull/tug/yank up OBJ;search OBJ;search in OBJ;send for OBJ;shake OBJ;smell/sniff OBJ;spin OBJ;squeez OBJ;stab OBJ;stand/carry/catch/get/grab/hold/remove/take up OBJ;strike OBJ;swing/thrust OBJ;talk to OBJ;wear OBJ;wind OBJ;wind up OBJ;apply OBJ to OBJ;attach/fasten/secure/tie OBJ to OBJ;attach/fasten/secure/tie up OBJ with OBJ;attack/fight/hit/hurt/injure/dispat/kill/murder/slay/stab OBJ with OBJ;block/break/damage/destro/smash OBJ with OBJ;block/break/damage/destro/smash down OBJ with OBJ;blow up OBJ with OBJ;brandi/wave OBJ at OBJ;brush/clean OBJ with OBJ;burn/ignite/incine OBJ with OBJ;burn/ignite/incine down OBJ with OBJ;carry/catch/get/grab/hold/remove/take OBJ from OBJ;carry/catch/get/grab/hold/remove/take OBJ off OBJ;carry/catch/get/grab/hold/remove/take OBJ out OBJ;chuck/hurl/throw/toss OBJ OBJ;chuck/hurl/throw/toss OBJ at OBJ;chuck/hurl/throw/toss OBJ in OBJ;chuck/hurl/throw/toss OBJ off OBJ;chuck/hurl/throw/toss OBJ on OBJ;chuck/hurl/throw/toss OBJ over OBJ;chuck/hurl/throw/toss OBJ with OBJ;cut/pierce/slice OBJ with OBJ;dig OBJ with OBJ;dig in OBJ with OBJ;donate/feed/give/offer/hand OBJ OBJ;donate/feed/give/offer/hand OBJ to OBJ;drop/releas OBJ down OBJ;drop/releas/hide/insert/place/put/stuff OBJ on OBJ;drop/releas/move/hide/insert/place/put/stuff OBJ in OBJ;feel/pat/pet/rub/touch OBJ with OBJ;fill OBJ with OBJ;fix/glue/patch/plug/repair OBJ with OBJ;flip/set/shut/turn OBJ for OBJ;flip/set/shut/turn OBJ to OBJ;flip/set/shut/turn OBJ with OBJ;flip/set/shut/turn on OBJ with OBJ;free/unatta/unfast/unhook/untie OBJ from OBJ;gaze/l/look/stare at OBJ with OBJ;grease/lubric/oil OBJ with OBJ;hide/insert/place/put/stuff OBJ behind OBJ;hide/insert/place/put/stuff OBJ under OBJ;inflat OBJ with OBJ;is OBJ in OBJ;is OBJ on OBJ;light OBJ with OBJ;liquif/melt OBJ with OBJ;lock OBJ with OBJ;move/press/push OBJ with OBJ;open OBJ with OBJ;peal/ring OBJ with OBJ;pick OBJ with OBJ;poke/punctu OBJ with OBJ;pour/spill OBJ from OBJ;pour/spill OBJ in OBJ;pour/spill OBJ on OBJ;press/push/slide OBJ OBJ;press/push/slide OBJ to OBJ;press/push/slide OBJ under OBJ;pump up OBJ with OBJ;read/skim OBJ OBJ;read/skim OBJ with OBJ;spray OBJ on OBJ;spray OBJ with OBJ;squeez OBJ on OBJ;strike OBJ with OBJ;swing/thrust OBJ at OBJ;unlock OBJ with OBJ;",
    "max_word_length" : 6
}

zork2 = {
    "name" : "zork2",
    "rom": "zork2.z5",
    "seed" : 0,
    # Walkthrough adapted from http://mirror.ifarchive.org/if-archive/solutions/jgunness.zip
    "walkthrough": "GET LAMP AND SWORD/S/S/S/S/LIGHT LAMP/SE/ENTER GAZEBO/GET TEAPOT, MAT, LETTER OPENER, MATCHBOOK AND PAPER/OUT/S/W/SW/N/W/N/W/N/W/N/N/FILL POT WITH WATER/N/U/OPEN LID/PUT MAT UNDER DOOR/PUT OPENER IN KEYHOLE/REMOVE OPENER AND DROP IT/PULL MAT/GET KEY/UNLOCK DOOR WITH KEY/OPEN DOOR/DROP KEY/N/GET BLUE SPHERE/S/D/W/N/HIT DRAGON WITH SWORD/S/HIT DRAGON WITH SWORD/S/HIT DRAGON WITH SWORD/W/DROP SWORD/E/N/N/N/OPEN CHEST/OPEN CHEST/GET DRAGON/S/E/E/D/S/WAIT/WAIT/E/E/N/IN/WAIT/WAIT/OUT/S/S/W/SE/S/SE/N/SE/N/SE/SE/SE/ANSWER \"A WELL\"/E/E/DROP DRAGON AND PAPER/GET IN BUCKET/DROP WATER/GET OUT OF BUCKET/E/DROP TEAPOT/GET RED, BLUE AND GREEN CAKE/EAT GREEN/E/PUT RED CAKE IN POOL/GET CANDY/W/EAT BLUE CAKE/NW/ROBOT, EAST AND SOUTH/E/S/GET RED SPHERE/ROBOT, LIFT CAGE/GET RED SPHERE/ROBOT, NORTH AND PRESS TRIANGULAR BUTTON/N/W/SE/W/SE/W/SE/GET TEAPOT/W/GET IN BUCKET/FILL TEAPOT/GET OUT OF BUCKET/W/W/NW/DROP TEAPOT, ROSE, CANDY AND GOLD KEY/SE/E/E/GET DRAGON AND PAPER/W/GET NECKLACE/W/NW/OPEN BOX/DROP NECKLACE AND DRAGON/N/GET BRICK/S/SW/GET STRING/NE/NW/W/W/GET RUBY/S/OPEN RECEPTACLE/PUT PAPER IN RECEPTACLE/GET IN BASKET/STRIKE MATCH/BURN PAPER/WAIT/WAIT/W/TIE WIRE TO HOOK/GET OUT OF BASKET/S/READ WHITE BOOK/DROP IT/OPEN PURPLE BOOK/GET STAMP/N/PUT STRING IN BRICK/GET ZORKMID/GET IN BASKET/UNTIE WIRE/WAIT/WAIT/WAIT/WAIT/DROP ALL/W/TIE WIRE TO HOOK/WAIT/WAIT/WAIT/WAIT/TAKE ALL/GET OUT OF BASKET/S/PUT BRICK IN HOLE/LIGHT MATCH/BURN STRING/N/S/GET CROWN/EXAMINE CARD/N/GET IN BASKET/CLOSE RECEPTACLE/UNTIE WIRE/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/GET OUT OF BASKET/N/E/E/SE/DROP CROWN, STAMP, ZORKMID AND RUBY/NW/N/N/W/W/NW/W/S/GET PORTRAIT/N/GO THROUGH CURTAIN/GO THROUGH SOUTH WALL/GO THROUGH CURTAIN/GET BILLS/GO THROUGH NORTH WALL/DROP PORTRAIT AND BILLS/W/W/GET PORTRAIT AND BILLS/GO THROUGH CURTAIN/S/E/E/S/S/SE/S/S/D/SW/GET CLUB/SE/NE/NW/SW/S/U/N/N/DROP MATCHBOOK/GET CANDY AND GOLD KEY/WAIT/WAIT/WAIT/SW/SW/GIVE CANDY TO LIZARD/UNLOCK DOOR WITH KEY/OPEN DOOR/S/W/PUT BLUE SPHERE IN SAPPHIRE STAND/PUT RED SPHERE IN RUBY STAND/W/TURN OFF LAMP/THROW CLUB AT AQUARIUM/GET CLEAR SPHERE/E/PUT CLEAR SPHERE IN DIAMOND STAND/GET SPHERE/S/PUT SPHERE ON PENTAGRAM/GIVE GOLD KEY, PORTRAIT AND BILLS TO DEMON/N/E/TURN ON LAMP/N/N/NE/GET VIOLIN, NECKLACE, RUBY, ZORKMID, STAMP, CROWN AND DRAGON/SW/SW/S/W/S/GIVE VIOLIN, NECKLACE, RUBY, STAMP, ZORKMID, CROWN AND DRAGON TO DEMON/DEMON, GIVE ME WAND/GET WAND/N/E/N/N/NE/S/POINT WAND AT MENHIR/SAY \"FLOAT\"/SW/GET COLLAR/NE/S/D/D/PUT COLLAR ON DOG/E/OPEN DOOR/S/TURN OFF LAMP/OPEN SECRET DOOR/S",
    "grammar" : "again/g;answer/reply;back;barf/chomp/lose;bathe/swim/wade;blast;brief;bug;chant/incant;chase/come/follow/pursue;climb/sit;curse/damn/fuck/shit;debug;diagno;dive/jump/leap;echo;enter;exit;froboz;gaze/l/look/stare;hello/hi;hop/skip;i/invent;leave;mumble/sigh;odysse/ulysse;plugh/xyzzy;pray;q/quit;repent;restar;restor;save;say;score;scream/shout/yell;script;stand;stay;super/superb;temple/treasu;unscri;verbos;versio;wait/z;win/winnag;wish;zork;activa OBJ;aim/brandi/point/wave OBJ;aim/brandi/point/wave at OBJ;answer/reply OBJ;ask/tell OBJ;attack/fight/hit/hurt/injure/dispat/kill/murder/slay OBJ;awake/startl/surpri/wake OBJ;awake/startl/surpri/wake up OBJ;banish/begone/cast/drive/exorci OBJ;banish/begone/cast/drive/exorci away OBJ;banish/begone/cast/drive/exorci out OBJ;bathe/swim/wade in OBJ;bite/consum/eat/taste OBJ;block/break/damage/destro/smash in OBJ;blow in OBJ;blow out OBJ;blow up OBJ;board OBJ;brush/clean OBJ;carry/catch/get/grab/hold/remove/take OBJ;carry/catch/get/grab/hold/remove/take out OBJ;chase/come/follow/pursue OBJ;climb/sit OBJ;climb/sit/carry/catch/get/grab/hold/remove/take in OBJ;climb/sit/carry/catch/get/grab/hold/remove/take on OBJ;climb/sit/go/procee/run/step/walk down OBJ;climb/sit/go/procee/run/step/walk up OBJ;climb/sit/go/procee/run/step/walk with OBJ;close OBJ;comman OBJ;count OBJ;cross/ford OBJ;curse/damn/fuck/shit OBJ;deflat OBJ;descri/examin/what/whats OBJ;descri/examin/what/whats on OBJ;descri/examin/what/whats/gaze/l/look/stare in OBJ;dig in OBJ;disemb OBJ;disenc OBJ;dive/jump/leap across OBJ;dive/jump/leap from OBJ;dive/jump/leap in OBJ;dive/jump/leap off OBJ;dive/jump/leap/go/procee/run/step/walk over OBJ;douse/exting OBJ;drink/imbibe/swallo OBJ;drink/imbibe/swallo from OBJ;drop/releas OBJ;enchan OBJ;enter OBJ;exit OBJ;feel/pat/pet/rub/touch OBJ;fill OBJ;find/see/seek/where OBJ;flip/set/shut/turn off OBJ;flip/set/shut/turn on OBJ;free/unatta/unfast/unhook/untie OBJ;gaze/l/look/stare around OBJ;gaze/l/look/stare at OBJ;gaze/l/look/stare behind OBJ;gaze/l/look/stare down OBJ;gaze/l/look/stare on OBJ;gaze/l/look/stare under OBJ;gaze/l/look/stare up OBJ;gaze/l/look/stare with OBJ;gaze/l/look/stare/search for OBJ;go/procee/run/step/walk OBJ;go/procee/run/step/walk around OBJ;go/procee/run/step/walk away OBJ;go/procee/run/step/walk in OBJ;go/procee/run/step/walk on OBJ;go/procee/run/step/walk to OBJ;hatch OBJ;hello/hi OBJ;hide/insert/place/put/stuff down OBJ;hide/insert/place/put/stuff on OBJ;hide/insert/place/put/stuff out OBJ;kick/taunt OBJ;kiss OBJ;knock/rap at OBJ;knock/rap down OBJ;knock/rap on OBJ;launch OBJ;lean on OBJ;leave OBJ;lift/raise OBJ;lift/raise up OBJ;light OBJ;listen for OBJ;listen to OBJ;lower OBJ;make OBJ;molest/rape OBJ;move/pull/tug/yank OBJ;open OBJ;open up OBJ;peal/ring OBJ;pick OBJ;pick up OBJ;play OBJ;pour/spill OBJ;press/push OBJ;press/push on OBJ;pull/tug/yank on OBJ;pump up OBJ;read/skim OBJ;read/skim from OBJ;roll/pull/tug/yank up OBJ;search OBJ;search in OBJ;send for OBJ;shake OBJ;smell/sniff OBJ;spin OBJ;squeez OBJ;stab OBJ;stand/carry/catch/get/grab/hold/remove/take up OBJ;strike OBJ;swing/thrust OBJ;talk to OBJ;wear OBJ;wind OBJ;wind up OBJ;aim/brandi/point/wave OBJ at OBJ;apply OBJ to OBJ;ask/tell OBJ about OBJ;attach/fasten/secure/tie OBJ to OBJ;attach/fasten/secure/tie up OBJ with OBJ;attack/fight/hit/hurt/injure/dispat/kill/murder/slay/stab OBJ with OBJ;block/break/damage/destro/smash OBJ with OBJ;block/break/damage/destro/smash down OBJ with OBJ;blow up OBJ with OBJ;brush/clean OBJ with OBJ;burn/ignite/incine OBJ with OBJ;burn/ignite/incine down OBJ with OBJ;carry/catch/get/grab/hold/remove/take OBJ from OBJ;carry/catch/get/grab/hold/remove/take OBJ off OBJ;carry/catch/get/grab/hold/remove/take OBJ out OBJ;chuck/hurl/throw/toss OBJ OBJ;chuck/hurl/throw/toss OBJ at OBJ;chuck/hurl/throw/toss OBJ in OBJ;chuck/hurl/throw/toss OBJ off OBJ;chuck/hurl/throw/toss OBJ on OBJ;chuck/hurl/throw/toss OBJ over OBJ;chuck/hurl/throw/toss OBJ with OBJ;cut/pierce/slice OBJ with OBJ;dig OBJ with OBJ;dig in OBJ with OBJ;donate/feed/give/offer/hand OBJ OBJ;donate/feed/give/offer/hand OBJ to OBJ;drop/releas OBJ down OBJ;drop/releas/hide/insert/place/put/stuff OBJ on OBJ;drop/releas/move/hide/insert/place/put/stuff OBJ in OBJ;feel/pat/pet/rub/touch OBJ with OBJ;fill OBJ with OBJ;fix/glue/patch/plug/repair OBJ with OBJ;flip/set/shut/turn OBJ for OBJ;flip/set/shut/turn OBJ to OBJ;flip/set/shut/turn OBJ with OBJ;flip/set/shut/turn on OBJ with OBJ;free/unatta/unfast/unhook/untie OBJ from OBJ;gaze/l/look/stare at OBJ with OBJ;grease/lubric/oil OBJ with OBJ;hide/insert/place/put/stuff OBJ behind OBJ;hide/insert/place/put/stuff OBJ under OBJ;inflat OBJ with OBJ;is OBJ in OBJ;is OBJ on OBJ;light OBJ with OBJ;liquif/melt OBJ with OBJ;lock OBJ with OBJ;move/press/push OBJ with OBJ;open OBJ with OBJ;peal/ring OBJ with OBJ;pick OBJ with OBJ;poke/punctu OBJ with OBJ;pour/spill OBJ from OBJ;pour/spill OBJ in OBJ;pour/spill OBJ on OBJ;press/push/slide OBJ OBJ;press/push/slide OBJ to OBJ;press/push/slide OBJ under OBJ;pump up OBJ with OBJ;read/skim OBJ OBJ;read/skim OBJ with OBJ;spray OBJ on OBJ;spray OBJ with OBJ;squeez OBJ on OBJ;strike OBJ with OBJ;swing/thrust OBJ at OBJ;unlock OBJ with OBJ;",
    "max_word_length" : 6
}

zork3 = {
    "name" : "zork3",
    "rom": "zork3.z5",
    "seed" : 0,
    # Walkthrough adapted from http://mirror.ifarchive.org/if-archive/solutions/jgunness.zip
    "walkthrough": "GET LAMP/S/LIGHT LAMP/W/W/GET BREAD/E/E/E/NE/SE/W/NE/WAKE UP OLD MAN/GIVE BREAD TO OLD MAN/SW/W/S/S/S/TURN OFF LAMP/DROP LAMP/JUMP LAKE/D/GET AMULET/GET AMULET/W/S/GET TORCH/WAIT/WAIT/WAIT/TOUCH TABLE/GET CAN/WAIT/WAIT/TOUCH TABLE/DROP TORCH/WAIT/N/JUMP LAKE/D/GET CAN/GET CAN/S/S/SPRAY REPELLANT ON MYSELF/S/E/GET KEY/MOVE COVER/D/N/N/N/GET TORCH/W/W/W/D/WAIT/WAIT/TIE CHEST TO ROPE/WAIT/WAIT/WAIT/WAIT/GRAB ROPE/GET CHEST/D/D/S/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/HELLO SAILOR/GET VIAL/E/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/WAIT/KILL FIGURE WITH SWORD/KILL FIGURE WITH SWORD/KILL FIGURE WITH SWORD/KILL FIGURE WITH SWORD/KILL FIGURE WITH SWORD/KILL FIGURE WITH SWORD/REMOVE HOOD/DROP SWORD/GET CLOAK/NE/E/E/N/E/NE/OPEN DOOR/N/N/DROP CHEST/S/S/SW/W/S/E/E/S/S/E/N/PUSH GOLDEN MACHINE SOUTH/OPEN STONE DOOR/PUSH GOLDEN MACHINE EAST/EXAMINE MACHINE/READ PLAQUE/GET IN MACHINE/SET DIAL TO 776/PRESS BUTTON/WAIT/WAIT/WAIT/WAIT/WAIT/GET RING/OPEN DOOR/W/OPEN WOODEN DOOR/N/LIFT SEAT/HIDE RING UNDER SEAT/GET IN GOLDEN MACHINE/SET DIAL TO 948/PRESS BUTTON/GET OUT OF GOLDEN MACHINE/LIFT SEAT/OPEN WOODEN DOOR/S/OPEN STONE DOOR/E/GET ALL/W/S/D/PRESS SOUTH WALL/E/S/E/E/PRESS SOUTH WALL/GET BOOK/PRESS SOUTH WALL/PRESS WEST WALL/AGAIN/E/E/N/N/N/N/PRESS EAST WALL/W/S/S/S/S/E/E/N/N/N/PRESS WEST WALL/N/W/PRESS SOUTH WALL/E/E/S/S/S/W/W/N/PRESS EAST WALL/W/W/W/N/N/W/N/PRESS EAST WALL/AGAIN/AGAIN/S/PRESS SOUTH WALL/N/E/E/S/PRESS SOUTH WALL/W/PRESS WEST WALL/AGAIN/S/W/PRESS NORTH WALL/AGAIN/AGAIN/W/N/U/N/W/N/N/W/W/N/E/NE/N/PRESS BUTTON/N/N/N/RAISE SHORT POLE/PRESS WHITE PANEL/AGAIN/LOWER SHORT POLE/PUSH PINE PANEL/N/OPEN VIAL/DRINK LIQUID/N/N/N/KNOCK ON DOOR/N/E/N/N/READ BOOK/TURN DIAL TO 4/PRESS BUTTON/DUNGEON MASTER, WAIT/S/OPEN CELL DOOR/S/DUNGEON MASTER, TURN DIAL TO 8 AND PRESS BUTTON/UNLOCK BRONZE DOOR WITH KEY/OPEN IT/S",
    "grammar" : "again/g;answer/reply;back;barf/chomp/lose;bathe/swim/wade;blast;brief;bug;chant/incant;chase/come/follow/pursue;curse/damn;diagno;dive/jump/leap;enter;exit;gaze/l/look/stare;hello/hi;hop/skip;i/invent;leave;mumble/sigh;plugh/xyzzy;pray;q/quit;repent;restar;restor;save;say/talk;score;scream/shout/yell;script;stand;stay;super/superb;unscri;verbos;versio;wait/z;win/winnag;zork;answer/reply OBJ;ask/tell OBJ;awake/startl/surpri/wake OBJ;awake/startl/surpri/wake up OBJ;banish/begone/cast/drive/exorci OBJ;banish/begone/cast/drive/exorci away OBJ;banish/begone/cast/drive/exorci out OBJ;bathe/swim/wade in OBJ;bite/kick/taunt OBJ;blow out OBJ;blow up OBJ;board OBJ;brandi/wave OBJ;carry/get/grab/hold/remove/take OBJ;carry/get/grab/hold/remove/take out OBJ;chase/come/follow/pursue OBJ;climb/sit OBJ;climb/sit/carry/get/grab/hold/remove/take in OBJ;climb/sit/carry/get/grab/hold/remove/take on OBJ;climb/sit/go/procee/run/step/walk down OBJ;climb/sit/go/procee/run/step/walk up OBJ;close OBJ;consum/eat/taste OBJ;count OBJ;cross/ford OBJ;curse/damn OBJ;deflat OBJ;descri/examin/what/whats OBJ;descri/examin/what/whats on OBJ;descri/examin/what/whats/gaze/l/look/stare in OBJ;dig in OBJ;disemb OBJ;dive/jump/leap across OBJ;dive/jump/leap from OBJ;dive/jump/leap in OBJ;dive/jump/leap off OBJ;dive/jump/leap/go/procee/run/step/walk over OBJ;douse/exting OBJ;drink/imbibe/swallo OBJ;drink/imbibe/swallo from OBJ;drop/releas OBJ;enter OBJ;exit OBJ;feel/pat/pet/rub/touch OBJ;fill OBJ;find/see/seek/where OBJ;flip/set/shut/turn OBJ;flip/set/shut/turn off OBJ;flip/set/shut/turn on OBJ;free/unatta/unfast/unhook/untie OBJ;gaze/l/look/stare around OBJ;gaze/l/look/stare at OBJ;gaze/l/look/stare behind OBJ;gaze/l/look/stare throug OBJ;gaze/l/look/stare under OBJ;gaze/l/look/stare with OBJ;gaze/l/look/stare/search for OBJ;go/procee/run/step/walk OBJ;go/procee/run/step/walk around OBJ;go/procee/run/step/walk in OBJ;go/procee/run/step/walk on OBJ;go/procee/run/step/walk to OBJ;go/procee/run/step/walk with OBJ;hello/hi OBJ;hide/insert/place/put/stuff down OBJ;hide/insert/place/put/stuff on OBJ;kiss OBJ;knock/rap at OBJ;knock/rap down OBJ;knock/rap on OBJ;launch OBJ;lean on OBJ;leave OBJ;lift/raise OBJ;lift/raise up OBJ;light OBJ;listen for OBJ;listen to OBJ;lower OBJ;make OBJ;molest/rape OBJ;move/pull/tug OBJ;open OBJ;open up OBJ;pick OBJ;pick up OBJ;play OBJ;pour/spill OBJ;press/push OBJ;press/push on OBJ;pull/tug on OBJ;pump up OBJ;read/skim OBJ;roll up OBJ;say/talk to OBJ;search OBJ;search in OBJ;send for OBJ;shake OBJ;slide OBJ;smell/sniff OBJ;spin OBJ;squeez OBJ;stand/carry/get/grab/hold/remove/take up OBJ;strike OBJ;swing/thrust OBJ;wear OBJ;wind OBJ;wind up OBJ;apply OBJ to OBJ;attach/fasten/secure/tie OBJ to OBJ;attach/fasten/secure/tie up OBJ with OBJ;attack/fight/hit/hurt/injure OBJ with OBJ;blind/jab/poke OBJ with OBJ;block/break/damage/destro/smash OBJ with OBJ;block/break/damage/destro/smash down OBJ with OBJ;blow up OBJ with OBJ;brandi/wave OBJ at OBJ;burn/ignite/incine OBJ with OBJ;burn/ignite/incine down OBJ with OBJ;carry/get/grab/hold/remove/take OBJ from OBJ;carry/get/grab/hold/remove/take OBJ off OBJ;carry/get/grab/hold/remove/take OBJ out OBJ;chuck/hurl/throw/toss OBJ at OBJ;chuck/hurl/throw/toss OBJ in OBJ;chuck/hurl/throw/toss OBJ off OBJ;chuck/hurl/throw/toss OBJ on OBJ;chuck/hurl/throw/toss OBJ over OBJ;chuck/hurl/throw/toss OBJ with OBJ;cut/pierce/slice OBJ with OBJ;dig OBJ with OBJ;dig in OBJ with OBJ;dispat/kill/murder/slay/stab OBJ with OBJ;donate/feed/give/hand/offer OBJ OBJ;donate/feed/give/hand/offer OBJ to OBJ;drop/releas OBJ down OBJ;drop/releas OBJ on OBJ;drop/releas/hide/insert/place/put/stuff OBJ in OBJ;feel/pat/pet/rub/touch OBJ with OBJ;fill OBJ with OBJ;fix/glue/patch/plug/repair OBJ with OBJ;flip/set/shut/turn OBJ for OBJ;flip/set/shut/turn OBJ to OBJ;flip/set/shut/turn OBJ with OBJ;free/unatta/unfast/unhook/untie OBJ from OBJ;gaze/l/look/stare at OBJ with OBJ;grease/lubric/oil OBJ with OBJ;hide/insert/place/put/stuff OBJ behind OBJ;hide/insert/place/put/stuff OBJ on OBJ;hide/insert/place/put/stuff OBJ under OBJ;inflat OBJ with OBJ;is OBJ in OBJ;is OBJ on OBJ;light OBJ with OBJ;liquif/melt OBJ with OBJ;lock OBJ with OBJ;open OBJ with OBJ;pick OBJ with OBJ;pour/spill OBJ from OBJ;pour/spill OBJ in OBJ;pour/spill OBJ on OBJ;press/push/slide OBJ OBJ;press/push/slide OBJ to OBJ;press/push/slide OBJ under OBJ;pump up OBJ with OBJ;read/skim OBJ with OBJ;spray OBJ on OBJ;spray OBJ with OBJ;squeez OBJ on OBJ;strike OBJ with OBJ;swing/thrust OBJ at OBJ;unlock OBJ with OBJ;",
    "max_word_length" : 6
}

ztuu = {
    "name" : "ztuu",
    "rom": "ztuu.z5",
    "walkthrough": 'ne/examine boulders/ne/n/nw/talk to man/take mask/n/wear fish/wear fur/wear razor/s/take rune/take gores/take implementeers/take zm$100000/se/drop lamp/n/take glasses/s/remove mask/remove suit/drop mask/drop suit/take lamp/s/e/e/take blue/take red/hit lamp/put blue in glasses/put red in glasses/east/open trunk/take coin/w/w/w/s/n/drop rune/s/drop gores/s/examine tree/examine ball/take tinsel/examine coin/tie tinsel to coin/n/e/put coin in slot/pull tinsel/put coin in slot/w/w/pry sixth rib with sword/sw/take can/ne/e/s/shake lamp/wear glasses/drop all/open lid/push button/examine symbols/take all/put flathead on circle/put tree on square/put house on triangle/put balloon on pentagon/drop zm$100000/se/drop multi/nw/n/n/sw/wait/sw',
    "seed" : 0,
    "grammar" : "awake/awaken/wake;awake/awaken/wake up;bother/curses/darn/drat;brief/normal;carry/get/take inventory;carry/get/take off;carry/get/take out;close/cover/shut up;damn/fuck/shit/sod;diagnose;die/q/quit;dive/swim;exit/out/outside/stand;full/fullscore;full/fullscore score;go/leave/run/walk;hear/listen;hello/hi;hello/hi sailor;help;hop/jump/skip;hum/sing;i/inv/inventory;i/inv/inventory tall;i/inv/inventory wide;in/inside/cross/enter;l/look;long/verbose;nap/sleep;no;noscript/unscript;notify off;notify on;nouns/pronouns;objects;places;pray;restart;restore;save;score;script;script off;script on;short/superbrie;smell/sniff;sorry;stand/carry/get/take up;think;time;verify;version;wait/z;wave;xyzzy;y/yes;zork;adjust/set OBJ;arrange/rearrange/sort/vandalize OBJ;attach/fasten/fix/tie OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck/kick/shake/stab OBJ;awake/awaken/wake OBJ;awake/awaken/wake OBJ up;awake/awaken/wake up OBJ;bend OBJ;blow out OBJ;bother/curses/darn/drat OBJ;burn/light OBJ;buy/purchase OBJ;carry/get/take OBJ;carry/get/take off OBJ;chop/cut/prune/slice OBJ;clean/dust/polish/rub/scrub/shine/sweep/wipe OBJ;clear/move/press/push/shift OBJ;climb/scale OBJ;climb/scale over OBJ;climb/scale up OBJ;climb/scale up OBJ;climb/scale/go/leave/run/walk/carry/get/take into OBJ;climb/scale/lie/sit/go/leave/run/walk/carry/get/take in OBJ;climb/scale/lie/sit/stand/carry/get/take on OBJ;close/cover/shut OBJ;consult OBJ;consult with OBJ;cross/enter/go/leave/run/walk OBJ;damn/fuck/shit/sod OBJ;detach/untie OBJ;dig OBJ;discard/drop OBJ;disrobe/doff/shed/remove OBJ;don/wear OBJ;douse/extinguis OBJ;drink/sip/swallow OBJ;eat OBJ;embrace/hug/kiss OBJ;empty OBJ;empty OBJ out;empty out OBJ;exit/out/outside OBJ;feel/fondle/grope/touch OBJ;fill OBJ;find/locate OBJ;go/leave/run/walk down OBJ;go/leave/run/walk through OBJ;hear/listen OBJ;hear/listen to OBJ;hold OBJ;hop/jump/skip over OBJ;l/look at OBJ;l/look in OBJ;l/look inside OBJ;l/look into OBJ;l/look through OBJ;l/look under OBJ;let OBJ go;let go OBJ;let go of OBJ;lick/taste OBJ;lie/sit/go/leave/run/walk inside OBJ;lift/raise OBJ;lower OBJ;open/uncover/undo/unwrap OBJ;peel OBJ;peel off OBJ;pick OBJ up;pick up OBJ;put OBJ down;put down OBJ;put on OBJ;read/check/describe/examine/watch/x OBJ;release OBJ;rotate/screw/turn/twist/unscrew OBJ;rotate/screw/turn/twist/unscrew OBJ off;rotate/screw/turn/twist/unscrew off OBJ;rotate/screw/turn/twist/unscrew/switch OBJ on;rotate/screw/turn/twist/unscrew/switch on OBJ;search OBJ;smell/sniff OBJ;speak/talk to OBJ;spray OBJ;squash/squeeze OBJ;swing OBJ;swing on OBJ;switch OBJ;switch OBJ off;switch/close/cover/shut off OBJ;throw OBJ;use OBJ;wave OBJ;yank/drag/pull OBJ;adjust/set OBJ to OBJ;ask OBJ for OBJ;attach/fasten/fix/tie OBJ to OBJ;attack/break/crack/destroy/fight/hit/kill/murder/punch/smash/thump/torture/wreck OBJ with OBJ;burn/light OBJ with OBJ;clear/move/press/push/shift OBJ OBJ;clear/move/press/push/shift/transfer OBJ to OBJ;detach/untie OBJ from OBJ;dig OBJ with OBJ;discard/drop OBJ down OBJ;discard/drop/insert/put OBJ in OBJ;discard/drop/insert/put OBJ into OBJ;discard/drop/put OBJ on OBJ;discard/drop/put OBJ onto OBJ;display/present/show OBJ OBJ;display/present/show OBJ to OBJ;empty OBJ into OBJ;empty OBJ on OBJ;empty OBJ onto OBJ;empty OBJ to OBJ;feed/give/offer/pay OBJ OBJ;feed/give/offer/pay OBJ to OBJ;feed/give/offer/pay over OBJ to OBJ;lock OBJ with OBJ;pry OBJ with OBJ;put OBJ inside OBJ;spray OBJ at OBJ;spray OBJ on OBJ;throw OBJ on OBJ;throw OBJ onto OBJ;throw/discard/drop OBJ against OBJ;throw/discard/drop OBJ at OBJ;unlock/open/uncover/undo/unwrap OBJ with OBJ;",
    "max_word_length" : 9
}