#!/bin/bash
# example usage:
# bash sh/test_and_score_models.sh  --dirs=en2fr_iwslt16_wmt14_han/* --datadir=wmt14 --src=en --tgt=fr --cuda=0


# Read script arguments and assign them to variables
for argument in "$@" 
do

    key=$(echo $argument | cut -f1 -d=)
    value=$(echo $argument | cut -f2 -d=)   
    if [[ $key == *"--"* ]]; then
        v="${key/--/}"
        declare $v="${value}" 
   fi
done

# Set correct scripts to run tests and scoring
run_han_script=sh/run_han_transformer_iwslt16_wmt14_fr.sh
run_transfo_script=sh/run_transformer_iwslt16_fr.sh
echo "Using $run_transfo_script to test and score k=0 model"
echo "Using $run_han_script to test and score k>0 models"

for subdir in checkpoints/$dirs; do
    # retrieve name for every subdirectory in the main directory
    subdirk=$(echo "$subdir" | grep -o ".$")
    echo "Testing and scoring $subdir, k=$subdirk"
    if [ "$subdirk" -gt 0 ]
    then
        bash $run_han_script \
            --sdir=$subdir \
            --datadir=$datadir \
            --t=test --k=$subdirk --src=$src --tgt=$tgt --cuda=$cuda
        
        bash $run_han_script \
            --sdir=$subdir \
            --datadir=$datadir \
            --t=score --k=$subdirk --src=$src --tgt=$tgt --cuda=$cuda
    else
        bash $run_transfo_script \
            --sdir=$subdir \
            --datadir=$datadir \
            --t=test --src=$src --tgt=$tgt --cuda=$cuda
        
        bash $run_transfo_script \
            --sdir=$subdir \
            --datadir=$datadir \
            --t=score --src=$src --tgt=$tgt --cuda=$cuda     
    fi
done

for subdir in checkpoints/$dirs; do
    # retrieve name for every subdirectory in the main directory
    subdirk=$(echo "$subdir" | grep -o ".$")
    bleu=$(tail -n 1 $subdir/logs/test.log | grep -o "BLEU.........")
    valid_best=$(grep -o "valid_best_loss.........." $subdir/logs/train.log | tail -n 1)
    echo "k$subdirk : $bleu", $valid_best
done