#!/bin/bash
tgt=$1
model=$2
size=$3
proj=path/to/Unambiguous-gender-bias
echo 'rerun cmd:' sbatch run_grid.sh $tgt $model
mkdir -p $proj/generated/$size
src_file="$proj/generated/$size/source"
cmd="python gen.py $proj/grammars/$size/grammar $src_file"
echo 'cmd:' $cmd
eval $cmd
mkdir -p $proj/generated/$size/$model
tgt_file="$proj/generated/$size/$model/target"
cmd="python translate.py ${src_file}.en $tgt $model > ${tgt_file}.$tgt"
echo 'cmd:' $cmd
eval $cmd
cmd="python tag.py ${tgt_file}.$tgt $tgt"
echo 'cmd:' $cmd
eval $cmd
cmd="python align.py ${src_file}.en ${src_file}.ans ${tgt_file}.$tgt.tok ${tgt_file}.$tgt.tag $proj/grammars/occupation_list.txt"
echo 'cmd:' $cmd
eval $cmd
cmd="python score.py $proj/grammars/occupation_list.txt ${src_file}.en ${src_file}.ans ${tgt_file}.$tgt.tok.result > ${tgt_file}.$tgt.tok.scores"
echo 'cmd:' $cmd
eval $cmd
echo "done"