/*
 * Decompiled with CFR 0.152.
 */
package nlp_files;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import utils_bk.FileUtils;

public abstract class NLPFile {
    public static int MAX_CHARS_4_CATEGORIZE = 200;
    protected File f;
    protected String language;
    protected String encoding;
    protected String extension;

    public abstract Boolean isWellFormed();

    public abstract String getStats(String var1);

    public abstract String detectLanguage();

    public abstract String toPlain();

    public abstract String pair2plain(String var1);

    public void loadFile(File f) {
        try {
            if (!f.exists()) {
                throw new FileNotFoundException("File does not exist: " + f);
            }
            if (!f.isFile()) {
                throw new IllegalArgumentException("Should be a file (not directory, etc): " + f);
            }
            this.f = f;
            this.extension = FileUtils.getExtension((String)this.f.getName());
        }
        catch (Exception e) {
            System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
            if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equalsIgnoreCase("true")) {
                e.printStackTrace(System.err);
            }
            this.f = null;
        }
    }

    public File getFile() {
        return this.f;
    }

    public String getFileDirectory() throws IOException {
        return this.f.getCanonicalPath().substring(0, this.f.getCanonicalPath().lastIndexOf(47) + 1);
    }

    public Boolean saveAs(String dest_file) {
        if (this.f != null) {
            System.out.println("hola");
            return true;
        }
        return false;
    }

    public Boolean isLoaded() {
        if (this.f == null) {
            return false;
        }
        return true;
    }

    public void setEncoding(String e) {
        this.encoding = e;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setLanguage(String lang) {
        this.language = lang;
    }

    public String getLanguage() {
        if (this.language == null) {
            this.language = "en";
        }
        return this.language;
    }

    public String getExtension() {
        if (this.extension == null) {
            this.extension = "unknown";
        }
        return this.extension;
    }

    public void overrideExtension(String newext) {
        this.extension = newext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Subclasses {
        PipesFile,
        PlainFile,
        TreebankFile,
        XMLFile;

    }
}

