# Data Schemas

- [Card](#card)
- [MultiLabel](#multilabel)

##  Card

#### Sample

```json
// annotations.data
{
    "text": "This is a pen.",
    "show_ambiguous_button": true,
    "hidden_data": {
        "desc": "This is the data for aggregation.", 
        "type": "It can be dict, or it can be str"
    }
}
// users_annotations.result_data
{
    "result": "Yes"
}
```

#### Detail

| table.param       | key                   | type                         | *required | default | comment                                      |
| ----------------- | --------------------- | ---------------------------- | --------- | ------- | -------------------------------------------- |
| annotations.data  | text                  | string                       | *         |         | Text in card                                 |
|                   | baseline_text         | string                       |           |         | Base (comparator) text                       |
|                   | show_ambiguous_button | boolean                      |           | true    | Whether or not to show the ambiguous button. |
|                   | question_overwrite    | string                       |           |         | Text to override tasks.question              |
|                   | hidden_data           | string \|Dict                |           |         | Data for aggregation                         |
| users_annotations | result_data           | "Yes" \| "No" \| "Ambiguous" | *         |         |                                              |

## MultiLabel

#### Sample

```json
// annotations.data
{
    "text": "This is a pen.", 
    "choices": ["ChoiceA", "ChoiceB", "ChoiceC", "ChoiceD"],
    "hidden_data": {
        "desc": "This is the data for aggregation.", 
        "type": "It can be dict, or it can be str"
    }
}
// users_annotations.result_data
{
    "result": ["ChoiceB", "ChoiceD"]
}
```

#### Detail

| table.param      | key            | type     | *required | default | comment                        |
| ---------------- | -------------- | -------- | --------- | ------- | ------------------------------ |
| annotations.data | text           | string   | *         |         | Text to be annotated |
|                  | choices        | string[] | *         |         |                          |
|                  | max_select_num | int      |           | inf     | Maximum number of choices |
|                  | baseline_text  | string   |           |         | Base (comparator) text |
|                  | hidden_data    | string \| Dict      |           |         | Data for aggregation |
| users_annotation | result_data    | string[] | *         |         |      |


