-- This module will transliterate Mansi language text.
-- Language code: mns

local export = {}

local tt = {
	["а"]="a", ["а̄"]="ā", ["б"]="b", ["в"]="v", ["г"]="g", ["д"]="d", ["е"]="e",
	["е̄"]="ē", ["ё"]="ë", ["ё̄"]="ë̄", ["ж"]="ž", ["з"]="z", ["и"]="i", ["ӣ"]="ī",
	["й"]="j", ["к"]="k", ["л"]="l", ["м"]="m", ["н"]="n", ["ӈ"]="ň", ["о"]="o",
	["о̄"]="ō", ["п"]="p", ["р"]="r", ["с"]="s", ["т"]="t", ["у"]="u", ["ӯ"]="ū",
	["ф"]="f", ["х"]="h", ["ц"]="c", ["ч"]="č", ["ш"]="š", ["щ"]="ŝ", ["ъ"]="ʺ",
	["ы"]="y", ["ы̄"]="ȳ", ["ь"]="ʹ", ["э"]="è", ["э̄"]="è̄", ["ю"]="û", ["ю̄"]="û̄",
	["я"]="â", ["я̄"]="â̄",
	["А"]="A", ["А̄"]="Ā", ["Б"]="B", ["В"]="V", ["Г"]="G", ["Д"]="D", ["Е"]="E",
	["Е̄"]="Ē", ["Ё"]="Ë", ["Ё̄"]="Ë̄", ["Ж"]="Ž", ["З"]="Z", ["И"]="I", ["Ӣ"]="Ī",
	["Й"]="J", ["К"]="K", ["Л"]="L", ["М"]="M", ["Н"]="N", ["Ӈ"]="Ň", ["О"]="O",
	["О̄"]="Ō", ["П"]="P", ["Р"]="R", ["С"]="S", ["Т"]="T", ["У"]="U", ["Ӯ"]="Ū",
	["Ф"]="F", ["Х"]="H", ["Ц"]="C", ["Ч"]="Č", ["Ш"]="Š", ["Щ"]="Ŝ", ["Ъ"]="ʺ",
	["Ы"]="Y", ["Ы̄"]="Ȳ", ["Ь"]="ʹ", ["Э"]="È", ["Э̄"]="È̄", ["Ю"]="Û", ["Ю̄"]="Û̄",
	["Я"]="Â", ["Я̄"]="Â̄",
};
 
function export.tr(text)
	return (mw.ustring.gsub(text, '.', tt))
end
 
return export